/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.event;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.RoutingTable;
import com.ibm.ws.management.event.NotificationService;
import com.ibm.ws.management.event.PushNotificationListener;
import java.io.Serializable;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class PushUpstreamServerSender
implements PushNotificationListener,
Serializable {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$event$PushUpstreamServerSender == null ? (class$com$ibm$ws$management$event$PushUpstreamServerSender = PushUpstreamServerSender.class$("com.ibm.ws.management.event.PushUpstreamServerSender")) : class$com$ibm$ws$management$event$PushUpstreamServerSender), (String)"Admin", (String)"com.ibm.ws.management.resources.event");
    private static final String[] PROPAGATE_METHOD_PARAMS = new String[]{"[Ljavax.management.Notification;"};
    static final long serialVersionUID = 4175751728101288881L;
    private transient AdminClient adminClient;
    private transient String serverName;
    private transient String nodeName;
    private transient ObjectName notifServiceMBean;
    private transient String pid;
    static /* synthetic */ Class class$com$ibm$ws$management$event$PushUpstreamServerSender;

    private void initialize() throws ConnectorException {
        this.adminClient = RoutingTable.getInstance().getParent();
        this.serverName = this.adminClient.getServerMBean().getKeyProperty("process");
        this.nodeName = this.adminClient.getServerMBean().getKeyProperty("node");
        this.pid = RoutingTable.getInstance().getPid(this.serverName);
        try {
            this.notifServiceMBean = (ObjectName)this.adminClient.queryNames(new ObjectName("WebSphere:*,type=NotificationService,process=" + this.serverName + ",node=" + this.nodeName), null).iterator().next();
        }
        catch (ConnectorException connectorException) {
            FFDCFilter.processException((Throwable)((Object)connectorException), (String)"com.ibm.ws.management.event.PushUpstreamServerSender.initialize", (String)"65", (Object)this);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("sending notifications to node=" + this.nodeName + ",server=" + this.serverName + ",pid=" + this.pid));
        }
    }

    public void handleNotifications(Notification[] notificationArray) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handleNotifications", (Object)NotificationService.getInfo(notificationArray));
        }
        if (this.notifServiceMBean == null) {
            this.initialize();
            if (this.notifServiceMBean == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"handleNotifications");
                }
                return;
            }
        }
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Propagating notifs to " + this.serverName + " on node " + this.nodeName));
            }
            this.adminClient.invoke(this.notifServiceMBean, "propagateNotifications", new Object[]{notificationArray}, PROPAGATE_METHOD_PARAMS);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            FFDCFilter.processException((Throwable)instanceNotFoundException, (String)"com.ibm.ws.management.event.PushUpstreamServerSender.handleNotifications", (String)"107", (Object)this);
        }
        catch (MBeanException mBeanException) {
            FFDCFilter.processException((Throwable)mBeanException, (String)"com.ibm.ws.management.event.PushUpstreamServerSender.handleNotifications", (String)"109", (Object)this);
        }
        catch (ReflectionException reflectionException) {
            FFDCFilter.processException((Throwable)reflectionException, (String)"com.ibm.ws.management.event.PushUpstreamServerSender.handleNotifications", (String)"111", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleNotifications");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

