/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.event;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.event.ConsolidatedFilter;
import com.ibm.ws.management.event.ListenerIdentifier;
import com.ibm.ws.management.event.ReceiverPermanentlyUnavailableException;
import com.ibm.ws.management.event.WsNotifListener;
import java.util.ArrayList;
import java.util.List;
import javax.management.Notification;

abstract class RemoteSender
implements WsNotifListener {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$event$RemoteSender == null ? (class$com$ibm$ws$management$event$RemoteSender = RemoteSender.class$("com.ibm.ws.management.event.RemoteSender")) : class$com$ibm$ws$management$event$RemoteSender), (String)"Admin", (String)"com.ibm.ws.management.resources.event");
    private static final int MAX_NOTIFICATIONS = 10000;
    private ListenerIdentifier id = new ListenerIdentifier();
    private List eventQueue = new ArrayList();
    private ConsolidatedFilter filter;
    private boolean receiverUnavailable = false;
    private boolean isActive = true;
    static /* synthetic */ Class class$com$ibm$ws$management$event$RemoteSender;

    RemoteSender() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotification(Notification notification) {
        if (this.filter == null || this.filter.isNotificationEnabled(notification)) {
            if (this.receiverUnavailable) {
                throw new ReceiverPermanentlyUnavailableException();
            }
            boolean bl = false;
            List list = this.eventQueue;
            synchronized (list) {
                if (this.eventQueue.size() > 10000) {
                    bl = true;
                } else if (this.isActive) {
                    this.eventQueue.add(notification);
                }
            }
            if (bl) {
                FFDCFilter.processException((Throwable)((Object)new AdminException("Maximum number of notifications exceeded")), (String)"com.ibm.ws.management.event.RemoteSender.handleNotification", (String)"72", (Object)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requeueNotifications(Notification[] notificationArray) {
        List list = this.eventQueue;
        synchronized (list) {
            if (this.isActive) {
                for (int i = notificationArray.length - 1; i >= 0; --i) {
                    this.eventQueue.add(0, notificationArray[i]);
                }
            }
        }
    }

    protected void receiverPermanentlyUnavailable() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"receiverPermanentlyUnavailable", (Object)this.id);
        }
        this.receiverUnavailable = true;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"receiverPermanentlyUnavailable");
        }
    }

    public ListenerIdentifier getIdentifier() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumNotifications() {
        List list = this.eventQueue;
        synchronized (list) {
            return this.eventQueue.size();
        }
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"stop");
        }
        this.isActive = false;
        this.discardNotifications();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discardNotifications() {
        List list = this.eventQueue;
        synchronized (list) {
            this.eventQueue.clear();
        }
    }

    public void restart() {
        this.isActive = true;
    }

    public boolean isActive() {
        return this.isActive;
    }

    protected Notification[] getNotifications() {
        return this.getNotifications(this.getNumNotifications());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Notification[] getNotifications(int n) {
        Notification[] notificationArray = null;
        List list = this.eventQueue;
        synchronized (list) {
            if (this.eventQueue.size() > n) {
                notificationArray = this.getFirstNotifications(n);
            } else {
                notificationArray = new Notification[this.eventQueue.size()];
                notificationArray = this.eventQueue.toArray(notificationArray);
                this.eventQueue.clear();
            }
        }
        return notificationArray;
    }

    private Notification[] getFirstNotifications(int n) {
        Notification[] notificationArray = new Notification[n];
        for (int i = 0; !this.eventQueue.isEmpty() && i < n; ++i) {
            notificationArray[i] = (Notification)this.eventQueue.remove(0);
        }
        return notificationArray;
    }

    public ConsolidatedFilter getFilter() {
        return this.filter;
    }

    public void setFilter(ConsolidatedFilter consolidatedFilter) {
        this.filter = consolidatedFilter;
    }

    public String toString() {
        return this.getClass().getName() + ": [listenerId=" + this.id + ";filter=" + this.filter + "]";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

