/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.fileservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.fileservice.FileBrowser;
import com.ibm.websphere.management.fileservice.FileServiceException;
import com.ibm.websphere.management.fileservice.RemoteFile;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.VariableMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;

public class FileBrowserImpl
implements FileBrowser {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$fileservice$FileBrowserImpl == null ? (class$com$ibm$ws$management$fileservice$FileBrowserImpl = FileBrowserImpl.class$("com.ibm.ws.management.fileservice.FileBrowserImpl")) : class$com$ibm$ws$management$fileservice$FileBrowserImpl), (String)"Admin", (String)"com.ibm.ws.management.resources.fileservice");
    private static Properties fileSystemProperties = null;
    private VariableMap vMap = null;
    static /* synthetic */ Class class$com$ibm$ws$management$fileservice$FileBrowserImpl;

    public FileBrowserImpl() {
    }

    public FileBrowserImpl(VariableMap variableMap) {
        this.vMap = variableMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteFile mkdir(String string) throws FileServiceException {
        RemoteFile remoteFile;
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"mkdir");
            }
            RemoteFile remoteFile2 = null;
            boolean bl = false;
            File file = null;
            file = new File(string = this.expand(string));
            bl = file.mkdir();
            if (bl) {
                remoteFile2 = this.getFileProperties(file);
            } else {
                Tr.service((TraceComponent)tc, (String)"ADFS0103", (Object)new Object[]{string});
            }
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("create directory : " + string));
            }
            remoteFile = remoteFile2;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            block7: {
                Object var7_7 = null;
                if (!tc.isEntryEnabled()) break block7;
                Tr.exit((TraceComponent)tc, (String)"mkdir");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"mkdir");
        }
        return remoteFile;
    }

    public String getPathSeparator() {
        return System.getProperty("path.separator");
    }

    public String getFileSeparator() {
        return System.getProperty("file.separator");
    }

    public String getWASHome() {
        return System.getProperty("server.root");
    }

    public Properties getRemoteFileSystemProperties() {
        if (fileSystemProperties == null) {
            fileSystemProperties = new Properties();
        }
        fileSystemProperties.put("file.separator", this.getFileSeparator());
        fileSystemProperties.put("path.separator", this.getPathSeparator());
        if (this.getWASHome() != null) {
            fileSystemProperties.put("server.root", this.getWASHome());
        }
        return fileSystemProperties;
    }

    public Boolean exists(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"exists", (Object)string);
        }
        string = this.expand(string);
        File file = new File(string);
        boolean bl = file.exists();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"exists", (Object)string);
        }
        return new Boolean(bl);
    }

    public Boolean rename(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("rename " + string + " to " + string2));
        }
        string = this.expand(string);
        string2 = this.expand(string2);
        File file = new File(string);
        boolean bl = file.renameTo(new File(string2));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("rename " + string + " to " + string2));
        }
        return new Boolean(bl);
    }

    public synchronized RemoteFile[] listRoots() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"listRoots");
        }
        File[] fileArray = File.listRoots();
        ArrayList<RemoteFile> arrayList = new ArrayList<RemoteFile>(fileArray.length);
        RemoteFile remoteFile = null;
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                remoteFile = this.getFileProperties(fileArray[i]);
                if (remoteFile == null) continue;
                arrayList.add(remoteFile);
                continue;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.fileservice.FileBrowserImpl.listRoots", (String)"213", (Object)this);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"Exception trying to get file properties");
            }
        }
        RemoteFile[] remoteFileArray = new RemoteFile[arrayList.size()];
        arrayList.toArray(remoteFileArray);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"listRoots", (Object)remoteFileArray);
        }
        return remoteFileArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteFile[] listRemoteFiles(String string) throws FileServiceException {
        RemoteFile[] remoteFileArray;
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"listRemoteFiles", (Object)(" Dir : " + string));
            }
            string = this.expand(string);
            RemoteFile[] remoteFileArray2 = null;
            File file = new File(string);
            Vector<File> vector = new Vector<File>();
            if (!file.exists()) {
                throw new FileServiceException("Directory " + file + " does not exist");
            }
            File[] fileArray = file.listFiles();
            int n = fileArray == null ? 0 : fileArray.length;
            for (int i = 0; i < n; ++i) {
                File file2 = fileArray[i];
                if (!file2.isFile() && !file2.isDirectory() || file2.isHidden()) continue;
                vector.addElement(file2);
            }
            remoteFileArray = remoteFileArray2 = this.filesToRemoteFileArray(vector);
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            block6: {
                Object var10_11 = null;
                if (!tc.isEntryEnabled()) break block6;
                Tr.exit((TraceComponent)tc, (String)"listRemoteFiles");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"listRemoteFiles");
        }
        return remoteFileArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized RemoteFile getRemoteFileProperties(String string, String string2) throws FileServiceException {
        RemoteFile remoteFile;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRemoteFileProperties1", (Object)(string + File.separator + string2));
        }
        string = this.expand(string);
        string2 = this.expand(string2);
        RemoteFile remoteFile2 = null;
        try {
            File file = new File(string, string2);
            if (file.exists()) {
                remoteFile2 = this.getFileProperties(file);
            }
            remoteFile = remoteFile2;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            block5: {
                Object var7_7 = null;
                if (!tc.isEntryEnabled()) break block5;
                Tr.exit((TraceComponent)tc, (String)"getRemoteFileProperties1", remoteFile2);
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRemoteFileProperties1", (Object)remoteFile2);
        }
        return remoteFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized RemoteFile getRemoteFileProperties(String string) throws FileServiceException {
        RemoteFile remoteFile;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRemoteFileProperties2", (Object)string);
        }
        string = this.expand(string);
        RemoteFile remoteFile2 = null;
        try {
            string = string.equals("HOME_DIR") ? System.getProperty("user.home") : string;
            File file = new File(string);
            if (file.exists()) {
                remoteFile2 = this.getFileProperties(file);
            }
            remoteFile = remoteFile2;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            block5: {
                Object var6_6 = null;
                if (!tc.isEntryEnabled()) break block5;
                Tr.exit((TraceComponent)tc, (String)"getRemoteFileProperties2", remoteFile2);
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRemoteFileProperties2", (Object)remoteFile2);
        }
        return remoteFile;
    }

    private RemoteFile getFileProperties(File file) throws FileServiceException {
        RemoteFile remoteFile;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getFileProperties", (Object)file);
        }
        if (file.getPath().equals("A:\\") || file.getPath().equals("B:\\")) {
            throw new FileServiceException(file.getPath() + " is not a valid selection.");
        }
        try {
            RemoteFile remoteFile2 = new RemoteFile();
            remoteFile2.setName(file.getName());
            remoteFile2.setAbsolutePath(file.getAbsolutePath());
            if (file.isDirectory()) {
                remoteFile2.setType("Directory");
            } else {
                remoteFile2.setType("NormalFile");
            }
            String string = file.getParent();
            if (string != null) {
                remoteFile2.setParentDirectory(string);
            }
            remoteFile2.setSeparator(File.separator);
            remoteFile = remoteFile2;
            Object var6_6 = null;
        }
        catch (Exception exception) {
            try {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.fileservice.FileBrowserImpl.getFileProperties", (String)"383", (Object)this);
                Tr.service((TraceComponent)tc, (String)"ADFS0104", (Object)new Object[]{exception.getMessage()});
                throw new FileServiceException(exception, "");
            }
            catch (Throwable throwable) {
                block10: {
                    Object var6_7 = null;
                    if (!tc.isEntryEnabled()) break block10;
                    Tr.exit((TraceComponent)tc, (String)"getFileProperties:");
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getFileProperties:");
        }
        return remoteFile;
    }

    private RemoteFile[] filesToRemoteFileArray(Vector vector) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"filesToRemoteFileArray", (Object)vector);
        }
        ArrayList<RemoteFile> arrayList = new ArrayList<RemoteFile>(vector.size());
        for (int i = 0; i < vector.size(); ++i) {
            try {
                arrayList.add(this.getFileProperties((File)vector.elementAt(i)));
                continue;
            }
            catch (FileServiceException fileServiceException) {
                FFDCFilter.processException((Throwable)((Object)fileServiceException), (String)"com.ibm.ws.management.fileservice.FileBrowserImpl.filesToRemoteFileArray", (String)"411", (Object)this);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"Exception: ", (Object)((Object)fileServiceException));
            }
        }
        RemoteFile[] remoteFileArray = new RemoteFile[arrayList.size()];
        arrayList.toArray(remoteFileArray);
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"filesToRemoteFileArray", (Object)remoteFileArray);
        }
        return remoteFileArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFileLength(String string) throws FileServiceException {
        long l;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getFileLength", (Object)string);
        }
        try {
            long l2;
            string = this.expand(string);
            File file = new File(string);
            if (!file.exists()) {
                throw new FileServiceException(new FileNotFoundException(string), string + " not found.");
            }
            l = l2 = file.length();
            Object var8_5 = null;
        }
        catch (Throwable throwable) {
            block5: {
                Object var8_6 = null;
                if (!tc.isEntryEnabled()) break block5;
                Tr.exit((TraceComponent)tc, (String)"getLineCount");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getLineCount");
        }
        return l;
    }

    /*
     * Loose catch block
     */
    public long getLineCount(String string) throws FileServiceException {
        long l;
        BufferedReader bufferedReader;
        block13: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getLineCount", (Object)string);
            }
            string = this.expand(string);
            bufferedReader = null;
            String string2 = null;
            long l2 = 0L;
            bufferedReader = new BufferedReader(new FileReader(string));
            string2 = bufferedReader.readLine();
            while (string2 != null) {
                ++l2;
                string2 = bufferedReader.readLine();
            }
            l = l2;
            Object var9_7 = null;
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                if (!tc.isDebugEnabled()) break block13;
                Tr.debug((TraceComponent)tc, (String)"error closing input file", (Object)iOException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getLineCount");
        }
        return l;
        catch (Exception exception) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"getLineCount failed", (Object)exception);
                }
                throw new FileServiceException(exception, "getLineCount failed with an exception");
            }
            catch (Throwable throwable) {
                block15: {
                    block14: {
                        Object var9_8 = null;
                        try {
                            if (bufferedReader != null) {
                                bufferedReader.close();
                            }
                        }
                        catch (IOException iOException) {
                            if (!tc.isDebugEnabled()) break block14;
                            Tr.debug((TraceComponent)tc, (String)"error closing input file", (Object)iOException);
                        }
                    }
                    if (!tc.isEntryEnabled()) break block15;
                    Tr.exit((TraceComponent)tc, (String)"getLineCount");
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public long[] translateLineNumbersToOffsets(String string, long[] lArray) throws FileServiceException {
        long[] lArray2;
        RandomAccessFile randomAccessFile;
        block19: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"convertLineNumbersToBytes", (Object)string);
            }
            if (lArray == null || lArray.length == 0) {
                throw new FileServiceException("lineNumbers array is empty");
            }
            int n = 0;
            for (n = 0; n < lArray.length - 1; ++n) {
                if (lArray[n] <= lArray[n + 1]) continue;
                throw new FileServiceException("The lineNumbers input are not ascending");
            }
            string = this.expand(string);
            String string2 = null;
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            long[] lArray3 = new long[lArray.length];
            n = 0;
            randomAccessFile = null;
            randomAccessFile = new RandomAccessFile(string, "r");
            string2 = randomAccessFile.readLine();
            for (n = 0; n < lArray.length && (lArray[n] == 0L || lArray[n] == 1L); ++n) {
                lArray3[n] = 0L;
            }
            while (string2 != null && n < lArray.length) {
                if (lArray[n] == ++l + 1L) {
                    lArray3[n] = randomAccessFile.getFilePointer();
                    if (++n < lArray.length && lArray[n] == lArray[n - 1]) {
                        lArray3[n] = lArray3[n - 1];
                        ++n;
                    }
                }
                string2 = randomAccessFile.readLine();
            }
            while (n < lArray.length) {
                lArray3[n] = randomAccessFile.length();
                ++n;
            }
            randomAccessFile.close();
            lArray2 = lArray3;
            Object var15_12 = null;
            try {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
            }
            catch (IOException iOException) {
                if (!tc.isDebugEnabled()) break block19;
                Tr.debug((TraceComponent)tc, (String)"error closing input file", (Object)iOException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getLineCount");
        }
        return lArray2;
        catch (Exception exception) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"convertLineNumbersToBytes failed", (Object)exception);
                }
                throw new FileServiceException(exception, "convertLineNumbersToBytes failed with an exception");
            }
            catch (Throwable throwable) {
                block21: {
                    block20: {
                        Object var15_13 = null;
                        try {
                            if (randomAccessFile != null) {
                                randomAccessFile.close();
                            }
                        }
                        catch (IOException iOException) {
                            if (!tc.isDebugEnabled()) break block20;
                            Tr.debug((TraceComponent)tc, (String)"error closing input file", (Object)iOException);
                        }
                    }
                    if (!tc.isEntryEnabled()) break block21;
                    Tr.exit((TraceComponent)tc, (String)"getLineCount");
                }
                throw throwable;
            }
        }
    }

    public String getName() {
        return "FileBrowser";
    }

    private String expand(String string) {
        if (this.vMap != null) {
            string = this.vMap.expand(string);
        }
        string = string.replace('\\', File.separatorChar);
        string = string.replace('/', File.separatorChar);
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

