/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.launcher;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.management.launcher.LaunchPlatformHelper;
import com.ibm.ws.management.tools.LaunchUtils;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class DefaultLaunchPlatformHelper
implements LaunchPlatformHelper {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$launcher$DefaultLaunchPlatformHelper == null ? (class$com$ibm$ws$management$launcher$DefaultLaunchPlatformHelper = DefaultLaunchPlatformHelper.class$("com.ibm.ws.management.launcher.DefaultLaunchPlatformHelper")) : class$com$ibm$ws$management$launcher$DefaultLaunchPlatformHelper), (String)"Launcher", (String)"com.ibm.ws.management.resources.launcher");
    private Properties defaultSettings = null;
    private static final String[] KEYS = new String[]{"com.ibm.websphere.management.launcher.defaultExecutableName", "com.ibm.websphere.management.launcher.defaultMinHeapSize", "com.ibm.websphere.management.launcher.defaultMaxHeapSize"};
    static /* synthetic */ Class class$com$ibm$ws$management$launcher$DefaultLaunchPlatformHelper;

    public DefaultLaunchPlatformHelper() throws Exception {
        try {
            String string;
            this.defaultSettings = new Properties();
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = (class$com$ibm$ws$management$launcher$DefaultLaunchPlatformHelper == null ? (class$com$ibm$ws$management$launcher$DefaultLaunchPlatformHelper = DefaultLaunchPlatformHelper.class$("com.ibm.ws.management.launcher.DefaultLaunchPlatformHelper")) : class$com$ibm$ws$management$launcher$DefaultLaunchPlatformHelper).getClassLoader();
            }
            if ((string = System.getProperty("os.name").toLowerCase()).startsWith("hp")) {
                string = string.substring(0, 2);
            } else if (string.length() > 3) {
                string = string.substring(0, 3);
            }
            String string2 = "properties/systemlaunch.properties";
            String string3 = "properties/" + string + ".systemlaunch.properties";
            InputStream inputStream = classLoader.getResourceAsStream(string2);
            this.defaultSettings.load(inputStream);
            inputStream = classLoader.getResourceAsStream(string3);
            if (inputStream != null) {
                this.defaultSettings.load(inputStream);
            }
            for (int i = 0; i < KEYS.length; ++i) {
                if (this.defaultSettings.getProperty(KEYS[i]) == null) continue;
                System.setProperty(KEYS[i], this.defaultSettings.getProperty(KEYS[i]));
            }
        }
        catch (Throwable throwable) {
            Tr.warning((TraceComponent)tc, (String)"ADML3000E", (Object)throwable);
        }
    }

    public Vector getDefaultBootclasspath(boolean bl) throws Exception {
        Vector<String> vector = new Vector<String>();
        String string = null;
        if (bl) {
            string = this.defaultSettings.getProperty("com.ibm.websphere.management.launcher.debugJar");
            if (string != null) {
                vector.add(string);
            } else {
                Tr.info((TraceComponent)tc, (String)"ADML3001W", (Object)new Object[]{"debugJar"});
                throw new AdminException(LaunchUtils.getFormattedMessage("ADML3001W", new Object[]{"debugJar"}, null));
            }
        }
        if ((string = this.defaultSettings.getProperty("com.ibm.websphere.management.launcher.orbBootstrapJar")) == null) {
            Tr.info((TraceComponent)tc, (String)"ADML3001W", (Object)new Object[]{"orbBootstrapJar"});
            throw new AdminException(LaunchUtils.getFormattedMessage("ADML3001W", new Object[]{"orbBootstrapJar"}, null));
        }
        vector.add(string);
        string = this.defaultSettings.getProperty("com.ibm.websphere.management.launcher.extBootstrapJar");
        if (string == null) {
            Tr.info((TraceComponent)tc, (String)"ADML3001W", (Object)new Object[]{"extBootstrapJar"});
            throw new AdminException(LaunchUtils.getFormattedMessage("ADML3001W", new Object[]{"extBootstrapJar"}, null));
        }
        vector.add(string);
        return vector;
    }

    public Vector getDefaultClasspath() throws Exception {
        Vector<String> vector = new Vector<String>();
        String string = this.defaultSettings.getProperty("com.ibm.websphere.management.launcher.defaultClasspath");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            while (stringTokenizer.hasMoreElements()) {
                vector.add(stringTokenizer.nextToken());
            }
        } else {
            Tr.info((TraceComponent)tc, (String)"ADML3001W", (Object)new Object[]{"defaultClasspath"});
            throw new AdminException(LaunchUtils.getFormattedMessage("ADML3001W", new Object[]{"defaultClasspath"}, null));
        }
        return vector;
    }

    public Properties getDefaultEnvironment() throws Exception {
        Properties properties = new Properties();
        String string = this.defaultSettings.getProperty("com.ibm.websphere.management.launcher.defaultEnvironment");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            while (stringTokenizer.hasMoreElements()) {
                String string2 = stringTokenizer.nextToken();
                String string3 = string2.substring(0, string2.indexOf("="));
                String string4 = string2.substring(string2.indexOf("=") + 1, string2.length());
                properties.put(string3, string4);
            }
        } else {
            Tr.info((TraceComponent)tc, (String)"ADML3001W", (Object)new Object[]{"defaultEnvironment"});
        }
        return properties;
    }

    public Vector getDisableJitc(boolean bl, String string) {
        Vector<String> vector = new Vector<String>();
        vector.add("-Djava.compiler=NONE");
        if (string.equals("HOTSPOT")) {
            if (!bl && System.getProperty("os.name").toLowerCase().startsWith("sun")) {
                vector.add("-Xint");
            }
        } else if (System.getProperty("os.name").toLowerCase().startsWith("hp")) {
            vector.add("-Xnojit");
        }
        return vector;
    }

    public Properties getDefaultSystemProperties() throws Exception {
        Properties properties = new Properties();
        Enumeration<Object> enumeration = this.defaultSettings.keys();
        String string = null;
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (string.startsWith("com.ibm.websphere.management.launcher.")) continue;
            properties.put(string, this.defaultSettings.getProperty(string));
        }
        return properties;
    }

    public Vector getDefaultWsExtDirs() throws Exception {
        Vector<String> vector = new Vector<String>();
        String string = this.defaultSettings.getProperty("com.ibm.websphere.management.launcher.defaultWsExtDirs");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            while (stringTokenizer.hasMoreElements()) {
                vector.add(stringTokenizer.nextToken());
            }
        } else {
            Tr.info((TraceComponent)tc, (String)"ADML3001W", (Object)new Object[]{"defaultWsExtDirs"});
            throw new AdminException(LaunchUtils.getFormattedMessage("ADML3001W", new Object[]{"defaultWsExtDirs"}, null));
        }
        return vector;
    }

    public Vector getDefaultJVMOptions() {
        Vector<String> vector = new Vector<String>();
        String string = this.defaultSettings.getProperty("com.ibm.websphere.management.launcher.defaultJvmOptions");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            while (stringTokenizer.hasMoreElements()) {
                vector.add(stringTokenizer.nextToken());
            }
        }
        return vector;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

