/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.nodeagent;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.client.ConfigRepositoryClientFactory;
import com.ibm.websphere.models.config.adminservice.AdminService;
import com.ibm.websphere.models.config.adminservice.JMXConnector;
import com.ibm.websphere.models.config.adminservice.SOAPConnector;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.processexec.JavaProcessDef;
import com.ibm.websphere.models.config.processexec.MonitoringPolicy;
import com.ibm.websphere.models.config.processexec.ProcessDef;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.RoutingTable;
import com.ibm.ws.management.launcher.LaunchCommand;
import com.ibm.ws.management.launcher.ServerIdentifiers;
import com.ibm.ws.management.nodeagent.MonitorConfig;
import com.ibm.ws.management.nodeagent.PidWaiter;
import com.ibm.ws.management.repository.ConfigStructureHelper;
import com.ibm.ws.management.sync.NodeSync;
import com.ibm.ws.process.Process;
import com.ibm.ws.process.ProcessFactory;
import com.ibm.ws.process.exception.ProcessOpException;
import com.ibm.ws.process.exception.ProcessStillActiveException;
import com.ibm.ws.runtime.component.VariableMapImpl;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.RepositoryImpl;
import com.ibm.ws.runtime.service.ThreadPoolMgr;
import com.ibm.ws.runtime.service.VariableMap;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.beancontext.BeanContextServiceProvider;
import java.beans.beancontext.BeanContextServicesSupport;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.management.Descriptor;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.Notification;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBean;
import javax.management.modelmbean.ModelMBeanInfo;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class NodeAgent
extends RuntimeCollaborator
implements NotificationListener,
PropertyChangeListener {
    private static final String resBundleName = "com.ibm.ws.management.resources.launcher";
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.management.resources.launcher");
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$nodeagent$NodeAgent == null ? (class$com$ibm$ws$management$nodeagent$NodeAgent = NodeAgent.class$("com.ibm.ws.management.nodeagent.NodeAgent")) : class$com$ibm$ws$management$nodeagent$NodeAgent), (String)"Admin", (String)"com.ibm.ws.management.resources.launcher");
    private static final String monitorFile = "${LOG_ROOT}/nodeagent/monitor.state";
    private static final Integer DISCOVERY_LISTENER = new Integer(0);
    private static final Integer STOPPING_LISTENER = new Integer(1);
    private static final String DEFAULT_LAUNCH_TIMEOUT = "1200";
    private static final Integer DEFAULT_LAUNCH_TIMEOUT_INTEGER = new Integer("1200");
    private static final String WSSERVER_CLASS = "com.ibm.ws.runtime.WsServer";
    private static NodeAgent instance;
    private boolean isInitialized = false;
    private MBeanFactory mbeanFactory;
    private com.ibm.websphere.management.AdminService adminService = null;
    private VariableMap variableMap;
    private Repository repository;
    private String repositoryRootURI;
    private String cellName;
    private String nodeName;
    private long ntfySeqNum = 0L;
    private Set adoptedChildren = new HashSet();
    private Set launchedChildren = new HashSet();
    private HashMap processHandlers = new HashMap();
    private HashMap monitoringPolicies = new HashMap();
    private boolean isRipple = false;
    private String ownPid = null;
    private HashMap serverConnectorType = new HashMap();
    private boolean isRestartingAllServers = false;
    static /* synthetic */ Class class$com$ibm$ws$management$nodeagent$NodeAgent;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$Repository;

    NodeAgent() {
    }

    void initialize(Repository repository2, VariableMap variableMap, ThreadPoolMgr threadPoolMgr) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize");
        }
        if (this.isInitialized) {
            Tr.exit((TraceComponent)tc, (String)"initialize - done");
            return;
        }
        this.repository = repository2;
        this.variableMap = variableMap;
        this.repositoryRootURI = repository2.getRootURI();
        this.cellName = AdminServiceFactory.getAdminService().getCellName();
        this.nodeName = AdminServiceFactory.getAdminService().getNodeName();
        this.mbeanFactory = AdminServiceFactory.getMBeanFactory();
        try {
            this.mbeanFactory.activateMBean("NodeAgent", this, "NodeAgent", null);
        }
        catch (AdminException adminException) {
            FFDCFilter.processException((Throwable)((Object)adminException), (String)"com.ibm.ws.management.nodeagent.NodeAgent.initialize", (String)"171", (Object)this);
        }
        this.discoveryMBeanListenerRegistration();
        this.listenForJ2EEStateStoppingNotifications();
        this.loadMonitoringPolicies();
        this.isInitialized = true;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"constructor");
        }
    }

    private String getPid(String string) {
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getPid", (Object)string);
        }
        String string3 = null;
        String string4 = string + ":";
        Tr.debug((TraceComponent)tc, (String)("server key: " + string4));
        Iterator iterator = this.adoptedChildren.iterator();
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            if (!string2.startsWith(string4)) continue;
            string3 = string2.substring(string4.length());
            if (!tc.isEntryEnabled()) break;
            Tr.debug((TraceComponent)tc, (String)("adopted child pid =  " + string3));
            break;
        }
        if (string3 == null) {
            iterator = this.launchedChildren.iterator();
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                if (!string2.startsWith(string4)) continue;
                string3 = string2.substring(string4.length());
                if (!tc.isEntryEnabled()) break;
                Tr.debug((TraceComponent)tc, (String)("launched child pid =  " + string3));
                break;
            }
            if (string3 == null) {
                string3 = this.getFilePid(string);
                if (tc.isEntryEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("file pid =  " + string3));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getPid", string3);
        }
        return string3;
    }

    public boolean terminate(String string) throws AdminException {
        Tr.entry((TraceComponent)tc, (String)"terminate", (Object)string);
        if (this.getProcessStatus(string).equals("STOPPED")) {
            return true;
        }
        boolean bl = false;
        Process process = null;
        ServerIdentifiers serverIdentifiers = new ServerIdentifiers();
        serverIdentifiers.setConfigRoot(this.repositoryRootURI);
        serverIdentifiers.setServerName(string);
        serverIdentifiers.setNodeName(this.nodeName);
        serverIdentifiers.setCellName(this.cellName);
        try {
            String string2 = this.getPid(string);
            if (string2 == null) {
                return false;
            }
            process = ProcessFactory.bindTo((String)string2);
            if (tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("send stopping notification for server " + string + "for pid: " + string2));
            }
            this.sendNotification("websphere.process.stopping", string);
            boolean bl2 = this.shouldWeWaitForServerInit(serverIdentifiers);
            if (!bl2) {
                process.stop();
                if (tc.isEntryEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("process exit code: " + process.getExitCode() + " for server: " + string + " pid: " + string2));
                }
                if (this.getProcessStatus(string).equals("STOPPED")) {
                    if (tc.isEntryEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("send stopped notification for server " + string + "for pid: " + string2));
                    }
                    this.removeLaunchedChild(string, string2);
                    this.sendNotification("websphere.process.stopped", string);
                    this.removeFilePid(string);
                    bl = true;
                }
            }
        }
        catch (ProcessOpException processOpException) {
            throw new AdminException(processOpException);
        }
        catch (Exception exception) {
            throw new AdminException(exception);
        }
        Tr.exit((TraceComponent)tc, (String)"terminate", (Object)string);
        return bl;
    }

    public boolean launchProcess(String string) throws AdminException {
        Integer n = null;
        String string2 = System.getProperty("com.ibm.websphere.management.nodeAgentLaunchTimeout");
        if (string2 == null || string2.length() < 0) {
            string2 = DEFAULT_LAUNCH_TIMEOUT;
        }
        try {
            n = new Integer(string2);
        }
        catch (Throwable throwable) {
            n = DEFAULT_LAUNCH_TIMEOUT_INTEGER;
        }
        return this.launchProcess(string, n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean launchProcess(String string, Integer n) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"launchProcess", (Object)string);
        }
        if (this.getProcessStatus(string).equals("RUNNING")) {
            return true;
        }
        AdminHelper.getInstance().audit("ADMN1000I", "ADMN1001I", new Object[]{string, this.nodeName, null});
        if (!this.serverExists(this.cellName, this.nodeName, string)) {
            throw new AdminException("Server, " + string + ", not found.");
        }
        boolean bl2 = false;
        try {
            bl2 = NodeSync.getNodeSync().syncForServerStartup();
        }
        catch (Exception exception) {
            Tr.error((TraceComponent)tc, (String)exception.getMessage());
        }
        if (!bl2) {
            String string2 = NodeAgent.getFormattedMessage("ADML0061E", null, null);
            throw new AdminException(string2);
        }
        int n2 = n;
        boolean bl = false;
        Integer n3 = null;
        boolean bl3 = true;
        String string3 = null;
        String string4 = this.repositoryRootURI;
        ServerIdentifiers serverIdentifiers = new ServerIdentifiers();
        serverIdentifiers.setConfigRoot(this.repositoryRootURI);
        serverIdentifiers.setServerName(string);
        serverIdentifiers.setNodeName(this.nodeName);
        serverIdentifiers.setCellName(this.cellName);
        try {
            block31: {
                try {
                    int n4;
                    BeanContextServicesSupport beanContextServicesSupport = new BeanContextServicesSupport();
                    RepositoryImpl repositoryImpl = new RepositoryImpl("ws-server", serverIdentifiers.getConfigRoot(), serverIdentifiers.getCellName(), serverIdentifiers.getNodeName(), serverIdentifiers.getServerName());
                    beanContextServicesSupport.addService(class$com$ibm$ws$runtime$service$Repository == null ? (class$com$ibm$ws$runtime$service$Repository = NodeAgent.class$("com.ibm.ws.runtime.service.Repository")) : class$com$ibm$ws$runtime$service$Repository, (BeanContextServiceProvider)repositoryImpl);
                    VariableMapImpl variableMapImpl = new VariableMapImpl();
                    beanContextServicesSupport.add(variableMapImpl);
                    variableMapImpl.initialize(null);
                    if (tc.isEntryEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("sid = " + serverIdentifiers.toString()));
                    }
                    LaunchCommand launchCommand = new LaunchCommand((Repository)repositoryImpl, (VariableMap)variableMapImpl, serverIdentifiers);
                    Tr.debug((TraceComponent)tc, (String)("Launching a new server process: " + serverIdentifiers.getServerName()));
                    this.sendNotification("websphere.process.starting", string);
                    ServerSocket serverSocket = null;
                    bl3 = this.shouldWeWaitForServerInit(serverIdentifiers);
                    if (tc.isEntryEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("wait for server init = " + bl3));
                    }
                    if (bl3 && (serverSocket = this.getFreePort(n2 * 1000)) != null) {
                        n3 = new Integer(serverSocket.getLocalPort());
                        launchCommand.setStatusSocketPort(n3);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("status socket = " + n3.toString()));
                        }
                    }
                    Process process = launchCommand.launchProcess();
                    string3 = process.id();
                    if (tc.isEntryEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("pid = " + string3));
                    }
                    this.addLaunchedChild(string, string3);
                    int n5 = 1;
                    if (bl3) {
                        n5 = serverSocket.getLocalPort();
                        if (tc.isEntryEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Local port = " + n5));
                        }
                    } else {
                        int n6 = 5;
                        for (n4 = 0; this.getProcessStatus(string).equals("STOPPED") && n4 < n6; ++n4) {
                            Tr.debug((TraceComponent)tc, (String)("Generic Server " + string + " not yet started, wait(ms): " + n2));
                            Thread.sleep(n2);
                        }
                        Tr.debug((TraceComponent)tc, (String)"Processing as generic server. ");
                    }
                    new ProcessWatcher(process, n5, n2);
                    n4 = -2;
                    if (serverSocket != null) {
                        n4 = this.waitForServerInit(serverSocket);
                    } else if (this.getProcessStatus(string).equals("RUNNING") && !bl3) {
                        this.sendNotification("websphere.process.running", string);
                        this.setFilePid(string, string3);
                        n4 = 0;
                    } else if (this.getProcessStatus(string).equals("STOPPED") && !bl3) {
                        this.sendNotification("websphere.process.stopped", string);
                    }
                    if (n4 == 0) {
                        Tr.audit((TraceComponent)tc, (String)"ADML0000I", (Object)new Object[]{string3});
                        bl = true;
                    } else {
                        if (n4 == -1) {
                            this.sendNotification("websphere.process.failed", string);
                            Tr.warning((TraceComponent)tc, (String)"ADML0011E");
                            throw new AdminException(NodeAgent.getFormattedMessage("ADML0011E", null, null));
                        }
                        if (n4 == 0) {
                            Tr.warning((TraceComponent)tc, (String)"ADML0011E");
                            throw new AdminException(NodeAgent.getFormattedMessage("ADML0011E", null, null));
                        }
                        String string5 = new Integer(n2).toString();
                        Tr.warning((TraceComponent)tc, (String)"ADML0040E", (Object)new Object[]{string, string5});
                    }
                    if (bl) {
                        this.addProcessHandler(string, string3, process);
                    } else {
                        this.removeLaunchedChild(string, string3);
                    }
                    if (!tc.isEntryEnabled()) break block31;
                    Tr.debug((TraceComponent)tc, (String)("processName = " + string + " pid = " + string3 + " status = " + n4 + " - started = " + bl + " wait = " + bl3));
                }
                catch (Exception exception) {
                    if (string3 != null) {
                        this.removeLaunchedChild(string, string3);
                    }
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.nodeagent.NodeAgent.launchProcess", (String)"298", (Object)this);
                    if (!tc.isDebugEnabled()) throw new AdminException("Process failed to launch: " + string);
                    Tr.debug((TraceComponent)tc, (String)"Exception in LaunchCommand.launchProcess():", (Object)exception);
                    throw new AdminException("Process failed to launch: " + string);
                }
            }
            Object var21_24 = null;
            if (!tc.isEntryEnabled()) return bl;
            Tr.exit((TraceComponent)tc, (String)"launchProcess", (Object)new Boolean(bl));
            return bl;
        }
        catch (Throwable throwable) {
            Object var21_25 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"launchProcess", (Object)new Boolean(bl));
            throw throwable;
        }
    }

    public String getProcessStatus(String string) throws AdminException {
        String string2;
        block15: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"server name: ", (Object)string);
            }
            String string3 = null;
            string2 = null;
            boolean bl = true;
            Process process = null;
            String string4 = this.getPid(string);
            if (tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("serverName: " + string + " pid: " + string4));
            }
            if (string4 != null) {
                block14: {
                    try {
                        process = ProcessFactory.bindTo((String)string4);
                        bl = process.isAlive();
                        if (tc.isEntryEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Is process " + string4 + " alive: " + bl));
                        }
                        string2 = bl ? "RUNNING" : "STOPPED";
                    }
                    catch (ProcessOpException processOpException) {
                        string3 = this.getFilePid(string);
                        if (string3 == null || string4 == string3) {
                            string2 = "STOPPED";
                        }
                        if (!tc.isEntryEnabled()) break block14;
                        Tr.debug((TraceComponent)tc, (String)"getProcessStatus", (Object)("launch child pid is possibly out of synch with file pid value, child pid: " + string4 + " file pid: " + string3));
                    }
                }
                if (string2 == null) {
                    try {
                        process = ProcessFactory.bindTo((String)string3);
                        bl = process.isAlive();
                        if (tc.isEntryEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Is process " + string3 + " alive: " + bl));
                        }
                        if (bl) {
                            string2 = "RUNNING";
                            break block15;
                        }
                        string2 = "STOPPED";
                    }
                    catch (ProcessOpException processOpException) {
                        string2 = "STOPPED";
                    }
                }
            } else {
                string2 = "STOPPED";
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getProcessStatus ", (Object)string2);
        }
        return string2;
    }

    private boolean shouldWeWaitForServerInit(ServerIdentifiers serverIdentifiers) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"shouldWeWaitForServerInitsid = ", (Object)serverIdentifiers.toString());
        }
        boolean bl = true;
        Resource resource = null;
        String string = "/servers/" + serverIdentifiers.getServerName() + "/server.xml";
        Tr.debug((TraceComponent)tc, (String)("server path = " + string));
        try {
            resource = this.repository.getConfigRoot().getResource(3, string);
        }
        catch (Exception exception) {
            throw new AdminException(serverIdentifiers.getServerName());
        }
        EList eList = resource.getContents();
        Server server = (Server)eList.get(0);
        if (!server.getName().equals(serverIdentifiers.getServerName())) {
            throw new AdminException(serverIdentifiers.getServerName());
        }
        ProcessDef processDef = server.getProcessDefinition();
        if (tc.isEntryEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("server process definition: " + processDef.toString()));
        }
        if (processDef.getExecutableName() != null) {
            if (processDef.getExecutableName().indexOf("java") < 0) {
                return false;
            }
            if (processDef instanceof JavaProcessDef) {
                JavaProcessDef javaProcessDef = (JavaProcessDef)processDef;
                String string2 = javaProcessDef.getExecutableTarget();
                if (tc.isEntryEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("javaProcessDef = " + javaProcessDef.toString()));
                }
                if (string2 != null && !string2.equals(WSSERVER_CLASS)) {
                    return false;
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void setFilePid(String var1_1, String var2_2) {
        block16: {
            if (NodeAgent.tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)NodeAgent.tc, (String)"setFilePid", (Object)var2_2);
            }
            var3_3 = this.variableMap.expand("${LOG_ROOT}/" + var1_1 + "/" + var1_1 + ".pid");
            if (NodeAgent.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)NodeAgent.tc, (String)("Pid = " + var2_2 + " to be saved in " + var3_3));
            }
            if (var2_2 != null) {
                var4_4 = new File(var3_3);
                var4_4.getParentFile().mkdirs();
                var5_5 = null;
                try {
                    if (!var4_4.exists()) {
                        var4_4.createNewFile();
                    }
                    var5_5 = new FileOutputStream(var4_4);
                    var5_5.write(var2_2.getBytes());
                    var8_6 = null;
                    ** if (var5_5 == null) goto lbl-1000
                }
                catch (Throwable var7_13) {
                    var8_8 = null;
                    if (var5_5 != null) {
                        try {
                            var5_5.flush();
                            var5_5.close();
                        }
                        catch (IOException var9_11) {
                            FFDCFilter.processException((Throwable)var9_11, (String)"com.ibm.ws.management.repository.FileDocument.writeFile", (String)"744", (Object)this);
                        }
                    }
                    throw var7_13;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        var5_5.flush();
                        var5_5.close();
                    }
                    catch (IOException var9_9) {
                        FFDCFilter.processException((Throwable)var9_9, (String)"com.ibm.ws.management.repository.FileDocument.writeFile", (String)"744", (Object)this);
                    }
                }
lbl-1000:
                // 2 sources

                {
                    break block16;
                    catch (IOException var6_12) {
                        FFDCFilter.processException((Throwable)var6_12, (String)"com.ibm.ws.management.repository.FileDocument.writeFile", (String)"732", (Object)this);
                        var8_7 = null;
                        if (var5_5 != null) {
                            try {
                                var5_5.flush();
                                var5_5.close();
                            }
                            catch (IOException var9_10) {
                                FFDCFilter.processException((Throwable)var9_10, (String)"com.ibm.ws.management.repository.FileDocument.writeFile", (String)"744", (Object)this);
                            }
                        }
                    }
                }
            }
        }
        if (NodeAgent.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)NodeAgent.tc, (String)"setFilePid");
        }
    }

    String getFilePid(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getFilePid", (Object)string);
        }
        String string2 = this.getCurrentPid(string);
        Tr.debug((TraceComponent)tc, (String)("Pid from file found: " + string2));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getFilePid", (Object)string2);
        }
        return string2;
    }

    void removeFilePid(String string) {
        File file;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeFilePid", (Object)string);
        }
        String string2 = this.variableMap.expand("${LOG_ROOT}/" + string + "/" + string + ".pid");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Pid file to be deleted: " + string2));
        }
        if ((file = new File(string2)).exists()) {
            file.delete();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeFilePid");
        }
    }

    private boolean isGenericServer(ProcessDef processDef) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isGenericServer");
        }
        boolean bl = false;
        String string = processDef.getExecutableName();
        if (string != null) {
            JavaProcessDef javaProcessDef;
            if ((string = string.trim()).indexOf("java") < 0) {
                return true;
            }
            if (processDef instanceof JavaProcessDef && (javaProcessDef = (JavaProcessDef)processDef).getExecutableTarget() != null && !javaProcessDef.getExecutableTarget().equals(WSSERVER_CLASS)) {
                return true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isGenericServer");
        }
        return bl;
    }

    private boolean serverExists(String string, String string2, String string3) throws AdminException {
        String string4;
        ConfigRepository configRepository = this.getLocalRepository();
        String[] stringArray = configRepository.listResourceNames(string4 = ConfigStructureHelper.getURI(string, string2, string3, "server.xml"), 1, 0);
        return stringArray.length != 0;
    }

    private synchronized ConfigRepository getLocalRepository() throws AdminException {
        ConfigRepository configRepository;
        Properties properties = new Properties();
        properties.setProperty("location", "local");
        try {
            configRepository = ConfigRepositoryClientFactory.getConfigRepositoryClient(properties);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.nodeagent.NodeAgent.getLocalRepository", (String)"427", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception in ConfigRepositoryClientFactory.getConfigRepositoryClient():", (Object)exception);
            }
            throw new AdminException(exception, "Unable to create repository client: " + exception);
        }
        return configRepository;
    }

    private Notification createNotification(String string, String string2) {
        Notification notification = new Notification(string, this.getObjectName(), this.ntfySeqNum++);
        Properties properties = new Properties();
        properties.setProperty("processName", string2);
        notification.setUserData(properties);
        return notification;
    }

    public void bindMBean(ModelMBeanInfo modelMBeanInfo, ModelMBean modelMBean) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"bindMBean");
        }
        super.bindMBean(modelMBeanInfo, modelMBean);
        if (modelMBeanInfo != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"info:", (Object)modelMBeanInfo);
            }
            Descriptor descriptor = modelMBeanInfo.getMBeanDescriptor();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"mBeanDescriptor", (Object)descriptor);
            }
            String string = "NodeAgent";
            descriptor.setField("displayName", string);
            String string2 = (String)descriptor.getFieldValue("type");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("type:" + string2));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"bindMBean");
        }
    }

    private ServerSocket getFreePort(int n) {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(0);
            serverSocket.setSoTimeout(n);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.management.nodeagent.NodeAgent.getFreePort", (String)"349", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADML0012E", (Object)iOException);
        }
        return serverSocket;
    }

    private int waitForServerInit(ServerSocket serverSocket) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"waitForServerInit");
        }
        Socket socket = null;
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (!bl && !bl2) {
            try {
                socket = serverSocket.accept();
            }
            catch (InterruptedIOException interruptedIOException) {
                FFDCFilter.processException((Throwable)interruptedIOException, (String)"com.ibm.ws.management.nodeagent.NodeAgent.waitForServerInit", (String)"368", (Object)this);
                socket = null;
                bl2 = true;
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.management.nodeagent.NodeAgent.waitForServerInit", (String)"374", (Object)this);
                Tr.error((TraceComponent)tc, (String)"ADML0009E", (Object)iOException);
                socket = null;
                bl = true;
                n = -1;
            }
            if (socket == null || (n = this.getStatus(socket)) != 0 && n != 0 && n != -1) continue;
            bl = true;
        }
        if (!bl) {
            n = -2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"waitForServerInit");
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private int getStatus(Socket socket) {
        FilterInputStream filterInputStream;
        InputStream inputStream;
        int n;
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getStatus");
            }
            n = -1;
            inputStream = null;
            filterInputStream = null;
            inputStream = socket.getInputStream();
            filterInputStream = new DataInputStream(inputStream);
            n = ((DataInputStream)filterInputStream).readInt();
            Object var8_5 = null;
            try {
                filterInputStream.close();
                inputStream.close();
                break block10;
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.management.nodeagent.NodeAgent.getStatus", (String)"425", (Object)this);
                Tr.error((TraceComponent)tc, (String)"ADML0009E", (Object)iOException);
            }
            {
                break block10;
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.management.nodeagent.NodeAgent.getStatus", (String)"414", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"ADML0009E", (Object)iOException);
                    int n2 = -1;
                    Object var8_6 = null;
                    try {
                        filterInputStream.close();
                        inputStream.close();
                    }
                    catch (IOException iOException2) {
                        FFDCFilter.processException((Throwable)iOException2, (String)"com.ibm.ws.management.nodeagent.NodeAgent.getStatus", (String)"425", (Object)this);
                        Tr.error((TraceComponent)tc, (String)"ADML0009E", (Object)iOException2);
                    }
                    filterInputStream = null;
                    inputStream = null;
                    return n2;
                }
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                try {
                    filterInputStream.close();
                    inputStream.close();
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.management.nodeagent.NodeAgent.getStatus", (String)"425", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"ADML0009E", (Object)iOException);
                }
                filterInputStream = null;
                inputStream = null;
                throw throwable;
            }
        }
        filterInputStream = null;
        inputStream = null;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getStatus");
        }
        return n;
    }

    private static String getFormattedMessage(String string, Object[] objectArray, String string2) {
        try {
            String string3 = nls.getString(string);
            if (string3 == null) {
                return string2;
            }
            return MessageFormat.format(string3, objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            if (string2 == null) {
                return string2;
            }
            return MessageFormat.format(string2, objectArray);
        }
        catch (NullPointerException nullPointerException) {
            FFDCFilter.processException((Throwable)nullPointerException, (String)"com.ibm.ws.management.nodeagent.NodeAgent.getFormattedMessage", (String)"449");
            return string2;
        }
    }

    public void stopNode() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"stopNode");
        }
        AdminHelper.getInstance().audit("ADMN1002I", "ADMN1003I", new Object[]{this.nodeName, null});
        boolean bl = true;
        Object var2_2 = null;
        Vector vector = null;
        try {
            vector = this.getServers();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.nodeagent.NodeAgent.stopNode", (String)"471", (Object)this);
            throw new AdminException(exception, "An problem occurred during stopNode processing: ");
        }
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                String string = (String)vector.get(i);
                this.sendStop(string, false);
            }
        }
        this.sendStop(AdminHelper.getInstance().getNodeAgentName(), true);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"stopNode");
        }
    }

    private boolean sendStop(String string, boolean bl) {
        boolean bl2;
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"sendStop", (Object)string);
            }
            bl2 = true;
            try {
                ObjectName objectName = this.getServerObjectName(string);
                if (objectName == null) break block10;
                if (bl && objectName.getKeyProperty("processType").equalsIgnoreCase("NodeAgent") || !bl && !objectName.getKeyProperty("processType").equalsIgnoreCase("NodeAgent")) {
                    String string2 = "stop";
                    try {
                        Object[] objectArray = null;
                        String[] stringArray = null;
                        int n = 600;
                        ServerSocket serverSocket = this.getFreePort(n * 1000);
                        Integer n2 = null;
                        if (serverSocket != null) {
                            n2 = new Integer(serverSocket.getLocalPort());
                            objectArray = new Object[]{Boolean.TRUE, n2};
                            stringArray = new String[]{"java.lang.Boolean", "java.lang.Integer"};
                        }
                        Object object = this.getAdminService().invoke(objectName, string2, objectArray, stringArray);
                        if (bl) break block10;
                        int n3 = -2;
                        if (serverSocket != null) {
                            n3 = this.waitForServerInit(serverSocket);
                        }
                        if (n3 != 0) {
                            Tr.warning((TraceComponent)tc, (String)"ADML0111E");
                        }
                        break block10;
                    }
                    catch (Exception exception) {
                        Tr.error((TraceComponent)tc, (String)"ADML0019E", (Object)exception);
                    }
                    break block10;
                }
                bl2 = false;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.nodeagent.NodeAgent.sendStop", (String)"557", (Object)this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"sendStop", (Object)string);
        }
        return bl2;
    }

    private ObjectName getServerObjectName(String string) {
        ObjectName objectName = null;
        ObjectName objectName2 = null;
        try {
            objectName2 = new ObjectName("WebSphere:*,type=Server,process=" + string + ",node=" + this.nodeName);
            Set set = this.getAdminService().queryNames(objectName2, null);
            if (set.size() != 1 && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("There are " + set.size() + " Servers! queryName=" + objectName2));
            }
            if (set.size() > 0) {
                Object[] objectArray = set.toArray();
                objectName = (ObjectName)objectArray[0];
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Server handle is ==> " + objectName.getCanonicalName()));
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.nodeagent.NodeAgent.getServerObjectName", (String)"593", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADML0523E", (Object)new Object[]{objectName2, exception});
        }
        return objectName;
    }

    private Vector getServers() throws Exception {
        Vector<String> vector = new Vector<String>();
        String string = this.repositoryRootURI + "/cells/" + this.cellName + "/nodes/" + this.nodeName + "/servers";
        File file = new File(string);
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].isDirectory()) continue;
            String string2 = fileArray[i].getName();
            vector.add(string2);
        }
        return vector;
    }

    private com.ibm.websphere.management.AdminService getAdminService() {
        if (this.adminService == null) {
            this.adminService = AdminServiceFactory.getAdminService();
        }
        return this.adminService;
    }

    private void discoveryMBeanListenerRegistration() {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"discoveryMBeanListenerRegistration");
            }
            try {
                String string = "WebSphere:type=Discovery,process=" + this.getAdminService().getProcessName() + ",*";
                ObjectName objectName = new ObjectName(string);
                Set set = this.adminService.queryNames(objectName, null);
                Iterator iterator = set.iterator();
                objectName = (ObjectName)iterator.next();
                this.adminService.addNotificationListener(objectName, this, null, DISCOVERY_LISTENER);
            }
            catch (JMException jMException) {
                FFDCFilter.processException((Throwable)jMException, (String)"com.ibm.ws.management.nodeagent.NodeAgent.registerToDiscoveryMBean", (String)"646", (Object)this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)"can not register as a listener to DiscoveryMBean", (Object)jMException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"discoveryMBeanListenerRegistration");
        }
    }

    private void listenForJ2EEStateStoppingNotifications() {
        try {
            com.ibm.websphere.management.AdminService adminService = AdminServiceFactory.getAdminService();
            ObjectName objectName = new ObjectName("WebSphere:*,type=Server,processType=ManagedProcess");
            NotificationFilterSupport notificationFilterSupport = new NotificationFilterSupport();
            notificationFilterSupport.enableType("j2ee.state.stopping");
            adminService.addNotificationListenerExtended(objectName, this, notificationFilterSupport, STOPPING_LISTENER);
        }
        catch (JMException jMException) {
            FFDCFilter.processException((Throwable)jMException, (String)"com.ibm.ws.management.nodeagent.NodeAgent.listenForJ2EEStateStoppingNotifications", (String)"666", (Object)this);
        }
    }

    public void handleNotification(Notification notification, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handleNotification");
        }
        String string = notification.getType();
        if (object.equals(DISCOVERY_LISTENER)) {
            if (string.equals("websphere.discovery.process.found")) {
                Properties properties = (Properties)notification.getUserData();
                String string2 = properties.getProperty("processName");
                String string3 = properties.getProperty("processId");
                this.sendNotification("websphere.process.running", string2);
                boolean bl = this.containLaunchedChild(string2, string3);
                try {
                    this.monitorProcess(string2, string3, !bl);
                }
                catch (ProcessOpException processOpException) {
                    Tr.error((TraceComponent)tc, (String)"ADML0056E", (Object)new Object[]{string2, string3, processOpException.getMessage()});
                }
            }
        } else if (object.equals(STOPPING_LISTENER) && string.equals("j2ee.state.stopping")) {
            this.sendNotification("websphere.process.stopping", ((ObjectName)notification.getSource()).getKeyProperty("name"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleNotification");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adoptChildProcess(String string, String string2) throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"adoptChildProcess", (Object)new Object[]{string, string2});
        }
        Set set = this.adoptedChildren;
        synchronized (set) {
            if (this.containAdoptedChild(string, string2)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"already adopted", (Object)string);
                }
                return;
            }
        }
        set = null;
        set = ProcessFactory.bindTo((String)string2);
        this.addProcessHandler(string, string2, (Process)set);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"adoptChildProcess", (Object)new Object[]{string, string2});
        }
    }

    private void monitorProcess(String string, String string2, boolean bl) throws ProcessOpException {
        Process process;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"monitorProcess", (Object)new Object[]{string, string2, new Boolean(bl)});
        }
        if ((process = this.removeProcessHandler(string, string2)) != null) {
            try {
                process.isAlive();
            }
            catch (ProcessOpException processOpException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"process not alive", (Object)((Object)processOpException));
                }
                process = null;
            }
        }
        if (process == null) {
            try {
                process = ProcessFactory.bindTo((String)string2);
                bl = true;
            }
            catch (ProcessOpException processOpException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"can not bind to process", (Object)((Object)processOpException));
                }
                throw processOpException;
            }
            if (bl) {
                this.addAdoptedChild(string, string2);
            }
        }
        if (process != null) {
            String string3 = System.getProperty("com.ibm.websphere.management.nodeAgentLaunchTimeout");
            if (string3 == null || string3.length() < 0) {
                string3 = DEFAULT_LAUNCH_TIMEOUT;
            }
            int n = Integer.parseInt(string3);
            new Thread(new PidWaiter(this, process, string2, this.variableMap, string, n, bl)).start();
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"monitorProcess");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addProcessHandler(String string, String string2, Process process) {
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"addProcessHandler", (Object)new Object[]{string, string2});
        }
        String string3 = string + ":" + string2;
        HashMap hashMap = this.processHandlers;
        synchronized (hashMap) {
            this.processHandlers.put(string3, process);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Process removeProcessHandler(String string, String string2) {
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"removeProcessHandler", (Object)new Object[]{string, string2});
        }
        String string3 = string + ":" + string2;
        Process process = null;
        HashMap hashMap = this.processHandlers;
        synchronized (hashMap) {
            process = (Process)this.processHandlers.remove(string3);
        }
        return process;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLaunchedChild(String string, String string2) {
        String string3;
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"addLaunchedChild", (Object)new Object[]{string, string2});
        }
        String string4 = null;
        String string5 = string + ":";
        Tr.debug((TraceComponent)tc, (String)("server key: " + string5));
        Iterator iterator = this.launchedChildren.iterator();
        while (iterator.hasNext()) {
            string3 = (String)iterator.next();
            if (!string3.startsWith(string5)) continue;
            string4 = string3.substring(string5.length());
            if (tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Removed old launched child key:  " + string5 + string4));
            }
            this.removeLaunchedChild(string, string4);
        }
        string3 = string + ":" + string2;
        Set set = this.launchedChildren;
        synchronized (set) {
            this.launchedChildren.add(string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addAdoptedChild(String string, String string2) {
        String string3;
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"addAdoptedChild", (Object)new Object[]{string, string2});
        }
        String string4 = null;
        String string5 = string + ":";
        Tr.debug((TraceComponent)tc, (String)("server key: " + string5));
        Iterator iterator = this.adoptedChildren.iterator();
        while (iterator.hasNext()) {
            string3 = (String)iterator.next();
            if (!string3.startsWith(string5)) continue;
            string4 = string3.substring(string5.length());
            if (tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Removed old adopted child key:  " + string5 + string4));
            }
            this.removeAdoptedChild(string, string4);
        }
        string3 = string + ":" + string2;
        Set set = this.adoptedChildren;
        synchronized (set) {
            this.adoptedChildren.add(string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeLaunchedChild(String string, String string2) {
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"removeLaunchedChild", (Object)new Object[]{string, string2});
        }
        String string3 = string + ":" + string2;
        Set set = this.launchedChildren;
        synchronized (set) {
            this.launchedChildren.remove(string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAdoptedChild(String string, String string2) {
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"removeLaunchedChild", (Object)new Object[]{string, string2});
        }
        String string3 = string + ":" + string2;
        Set set = this.adoptedChildren;
        synchronized (set) {
            this.adoptedChildren.remove(string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean containAdoptedChild(String string, String string2) {
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"containAdoptedChild", (Object)new Object[]{string, string2});
        }
        String string3 = string + ":" + string2;
        Set set = this.adoptedChildren;
        synchronized (set) {
            return this.adoptedChildren.contains(string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean containLaunchedChild(String string, String string2) {
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"containLaunchedChild", (Object)new Object[]{string, string2});
        }
        String string3 = string + ":" + string2;
        Set set = this.launchedChildren;
        synchronized (set) {
            return this.launchedChildren.contains(string3);
        }
    }

    private void loadMonitoringPolicies() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"loadMonitoringPolicies");
        }
        Vector vector = null;
        try {
            vector = this.getServers();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.nodeagent.NodeAgent.loadMonitoringPolicies", (String)"838", (Object)this);
        }
        if (vector == null) {
            return;
        }
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            MonitorConfig monitorConfig;
            String string = (String)iterator.next();
            if (string.equals(AdminHelper.getInstance().getNodeAgentName())) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"load monitoring policy for server:", (Object)string);
            }
            if ((monitorConfig = this.loadServerMonitoringPolicy(string)) == null) continue;
            this.monitoringPolicies.put(string, monitorConfig);
        }
        this.loadNodeState();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"loadMonitoringPolicies");
        }
    }

    HashMap getMonitoringPolicies() {
        return this.monitoringPolicies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    MonitorConfig loadServerMonitoringPolicy(String string) {
        String string2;
        ConfigRoot configRoot;
        MonitorConfig monitorConfig;
        block10: {
            Resource resource = null;
            monitorConfig = null;
            configRoot = this.repository.getConfigRoot();
            string2 = configRoot.setValue(4, string);
            try {
                try {
                    resource = configRoot.getResource(4, "server.xml");
                    Server server = this.getServer(resource);
                    this.retrieveConnectorType(string, server);
                    ProcessDef processDef = server.getProcessDefinition();
                    MonitoringPolicy monitoringPolicy = processDef.getMonitoringPolicy();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("MonitoringPolicy: " + monitoringPolicy));
                    }
                    monitorConfig = new MonitorConfig(monitoringPolicy);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    FFDCFilter.processException((Throwable)fileNotFoundException, (String)"com.ibm.ws.management.nodeagent.NodeAgent.loadServerMonitoringPolicy", (String)"896", (Object)this);
                    Tr.service((TraceComponent)tc, (String)"ADML0062W", (Object)string);
                    Object var10_12 = null;
                    if (resource != null) {
                        configRoot.remove(resource);
                    }
                    configRoot.setValue(4, string2);
                    return monitorConfig;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.nodeagent.NodeAgent.loadServerMonitoringPolicy", (String)"901", (Object)this);
                    Object var10_13 = null;
                    if (resource != null) {
                        configRoot.remove(resource);
                    }
                    configRoot.setValue(4, string2);
                    return monitorConfig;
                }
                Object var10_11 = null;
                if (resource == null) break block10;
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                if (resource != null) {
                    configRoot.remove(resource);
                }
                configRoot.setValue(4, string2);
                throw throwable;
            }
            configRoot.remove(resource);
        }
        configRoot.setValue(4, string2);
        return monitorConfig;
    }

    private Server getServer(Resource resource) throws Exception {
        Server server = null;
        EList eList = resource.getContents();
        for (int i = 0; i < eList.size(); ++i) {
            Object e = eList.get(i);
            if (!(e instanceof Server)) continue;
            server = (Server)e;
        }
        return server;
    }

    private void retrieveConnectorType(String string, Server server) {
        EList eList = server.getServices();
        String string2 = "SOAP";
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof AdminService)) continue;
            AdminService adminService = (AdminService)e;
            JMXConnector jMXConnector = adminService.getPreferredConnector();
            if (jMXConnector instanceof SOAPConnector) {
                string2 = "SOAP";
                break;
            }
            if (!(jMXConnector instanceof SOAPConnector)) break;
            string2 = "RMI";
            break;
        }
        this.serverConnectorType.put(string, string2);
    }

    String getServerConnectorType(String string) {
        return (String)this.serverConnectorType.get(string);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = (String)propertyChangeEvent.getNewValue();
        if (string.equals("STARTED")) {
            this.bootstrapNode();
        } else if (string.equals("DESTROYED")) {
            if (this.isRipple) {
                try {
                    this.reLaunchSelf();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.nodeagent.NodeAgent.loadServerMonitoringPolicy", (String)"944", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"ADML0059E", (Object)exception.getMessage());
                }
            } else {
                this.saveNodeState(false);
            }
        }
    }

    public void restart(Boolean bl, Boolean bl2) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"restart", (Object)new Object[]{bl, bl2});
        }
        AdminHelper.getInstance().audit("ADMN1004I", "ADMN1005I", new Object[]{this.nodeName, null});
        this.isRipple = true;
        this.saveNodeState(bl2);
        if (bl.booleanValue()) {
            Boolean bl3;
            try {
                bl3 = NodeSync.getNodeSync().sync();
            }
            catch (Throwable throwable) {
                this.isRipple = false;
                this.saveNodeState(false);
                if (throwable instanceof AdminException) {
                    throw (AdminException)((Object)throwable);
                }
                throw new AdminException(throwable, nls.getString("ADML0057E"));
            }
            if (bl3 == null || !bl3.booleanValue()) {
                this.saveNodeState(false);
                this.isRipple = false;
                throw new AdminException(nls.getString("ADML0057E"));
            }
        }
        try {
            if (bl2.booleanValue()) {
                this.stopNode();
            } else {
                this.sendStop(AdminHelper.getInstance().getNodeAgentName(), true);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.nodeagent.NodeAgent.restart", (String)"1002", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADML0058E");
            this.isRipple = false;
            this.saveNodeState(false);
            if (throwable instanceof AdminException) {
                throw (AdminException)((Object)throwable);
            }
            throw new AdminException(throwable, nls.getString("ADML0058E"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"restart");
        }
    }

    private void reLaunchSelf() throws Exception {
        ServerIdentifiers serverIdentifiers = new ServerIdentifiers();
        serverIdentifiers.setConfigRoot(this.repositoryRootURI);
        serverIdentifiers.setServerName(AdminHelper.getInstance().getNodeAgentName());
        serverIdentifiers.setNodeName(this.nodeName);
        serverIdentifiers.setCellName(this.cellName);
        LaunchCommand launchCommand = new LaunchCommand(this.repository, this.variableMap, serverIdentifiers);
        launchCommand.launchProcess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void loadNodeState() {
        block15: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"loadNodeState");
            }
            String string = this.variableMap.expand(monitorFile);
            BufferedReader bufferedReader = null;
            File file = new File(string);
            if (file.exists()) {
                String string2;
                bufferedReader = new BufferedReader(new FileReader(file));
                while ((string2 = bufferedReader.readLine()) != null) {
                    if ((string2 = string2.trim()).length() <= 0) continue;
                    int n = string2.indexOf(58);
                    int n2 = string2.lastIndexOf(58);
                    String string3 = string2.substring(0, n);
                    String string4 = string2.substring(n + 1, n2);
                    String string5 = string2.substring(n2 + 1);
                    this.isRestartingAllServers = Boolean.valueOf(string5);
                    MonitorConfig monitorConfig = (MonitorConfig)this.monitoringPolicies.get(string3);
                    if (monitorConfig == null) continue;
                    monitorConfig.setPreviousState(1);
                    monitorConfig.setPid(string4);
                }
            }
            Object var12_12 = null;
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                break block15;
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.management.nodeagent.NodeAgent.loadMonitoringPolicies", (String)"1065", (Object)this);
            }
            break block15;
            {
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.management.nodeagent.NodeAgent.loadMonitoringPolicies", (String)"1058", (Object)this);
                    Object var12_13 = null;
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        break block15;
                    }
                    catch (IOException iOException2) {
                        FFDCFilter.processException((Throwable)iOException2, (String)"com.ibm.ws.management.nodeagent.NodeAgent.loadMonitoringPolicies", (String)"1065", (Object)this);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.management.nodeagent.NodeAgent.loadMonitoringPolicies", (String)"1065", (Object)this);
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"loadNodeState");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveNodeState(boolean var1_1) {
        block19: {
            if (NodeAgent.tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)NodeAgent.tc, (String)"saveNodeState");
            }
            var2_2 = this.variableMap.expand("${LOG_ROOT}/nodeagent/monitor.state");
            var3_3 = null;
            try {
                var4_4 = new File(var2_2);
                if (!var4_4.exists()) {
                    var4_4.createNewFile();
                }
                var3_3 = new BufferedWriter(new FileWriter(var4_4));
                var3_3.write(AdminHelper.getInstance().getNodeAgentName() + ":" + this.getOwnPid());
                if (var1_1) {
                    var3_3.write(":true");
                } else {
                    var3_3.write(":false");
                }
                var3_3.newLine();
                var5_6 = this.launchedChildren.iterator();
                while (var5_6.hasNext()) {
                    var6_7 = (String)var5_6.next();
                    if (var6_7 == null) continue;
                    var3_3.write(var6_7);
                    if (var1_1) {
                        var3_3.write(":true");
                    } else {
                        var3_3.write(":false");
                    }
                    var3_3.newLine();
                }
                var5_6 = this.adoptedChildren.iterator();
                while (var5_6.hasNext()) {
                    var6_7 = (String)var5_6.next();
                    if (var6_7 == null) continue;
                    var3_3.write(var6_7);
                    if (var1_1) {
                        var3_3.write(":true");
                    } else {
                        var3_3.write(":false");
                    }
                    var3_3.newLine();
                }
                var8_8 = null;
                if (var3_3 == null) break block19;
                ** GOTO lbl66
            }
            catch (IOException var4_5) {
                FFDCFilter.processException((Throwable)var4_5, (String)"com.ibm.ws.management.nodeagent.propertyChange", (String)"1109", (Object)this);
                var8_9 = null;
                if (var3_3 != null) {
                    try {
                        var3_3.flush();
                        var3_3.close();
                    }
                    catch (IOException var9_12) {
                        FFDCFilter.processException((Throwable)var9_12, (String)"com.ibm.ws.management.nodeagent.propertyChange", (String)"1119", (Object)this);
                    }
                }
                break block19;
            }
            {
                catch (Throwable var7_14) {
                    var8_10 = null;
                    if (var3_3 == null) throw var7_14;
                    ** try [egrp 2[TRYBLOCK] [4 : 318->329)] { 
lbl60:
                    // 1 sources

                    var3_3.flush();
                    var3_3.close();
                    throw var7_14;
lbl63:
                    // 1 sources

                    catch (IOException var9_13) {
                        FFDCFilter.processException((Throwable)var9_13, (String)"com.ibm.ws.management.nodeagent.propertyChange", (String)"1119", (Object)this);
                    }
                    throw var7_14;
                }
lbl66:
                // 1 sources

                ** try [egrp 2[TRYBLOCK] [4 : 318->329)] { 
lbl67:
                // 1 sources

                var3_3.flush();
                var3_3.close();
lbl70:
                // 1 sources

                catch (IOException var9_11) {}
                FFDCFilter.processException((Throwable)var9_11, (String)"com.ibm.ws.management.nodeagent.propertyChange", (String)"1119", (Object)this);
            }
        }
        if (NodeAgent.tc.isEntryEnabled() == false) return;
        Tr.exit((TraceComponent)NodeAgent.tc, (String)"saveNodeState");
    }

    private String getSavedPid(String string) {
        MonitorConfig monitorConfig = (MonitorConfig)this.monitoringPolicies.get(string);
        if (monitorConfig != null) {
            return monitorConfig.getPid();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String getCurrentPid(String string) {
        String string2;
        block12: {
            string2 = null;
            String string3 = this.variableMap.expand("${LOG_ROOT}/" + string + "/" + string + ".pid");
            File file = new File(string3);
            if (file.exists()) {
                BufferedReader bufferedReader = null;
                bufferedReader = new BufferedReader(new FileReader(file));
                string2 = bufferedReader.readLine();
                Object var8_6 = null;
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    break block12;
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.management.nodeagent.NodeAgent.getCurrentPid", (String)"1162", (Object)this);
                }
                break block12;
                {
                    catch (IOException iOException) {
                        FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.management.nodeagent.NodeAgent.getCurrentPid", (String)"1155", (Object)this);
                        Object var8_7 = null;
                        try {
                            if (bufferedReader != null) {
                                bufferedReader.close();
                            }
                            break block12;
                        }
                        catch (IOException iOException2) {
                            FFDCFilter.processException((Throwable)iOException2, (String)"com.ibm.ws.management.nodeagent.NodeAgent.getCurrentPid", (String)"1162", (Object)this);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                    }
                    catch (IOException iOException) {
                        FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.management.nodeagent.NodeAgent.getCurrentPid", (String)"1162", (Object)this);
                    }
                    throw throwable;
                }
            }
        }
        return string2;
    }

    private void bootstrapNode() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"bootstrapNode");
        }
        RoutingTable.getInstance().connectedToParent(30000L);
        Set set = this.monitoringPolicies.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string;
            Map.Entry entry = iterator.next();
            String string2 = (String)entry.getKey();
            MonitorConfig monitorConfig = (MonitorConfig)entry.getValue();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"process monitor policy: ", (Object)new Object[]{string2, monitorConfig});
            }
            if ((string = this.getCurrentPid(string2)) != null && !string.equals(this.getOwnPid())) {
                try {
                    this.adoptChildProcess(string2, string);
                }
                catch (ProcessOpException processOpException) {
                    string = null;
                }
            } else {
                string = null;
            }
            if (string != null) continue;
            String string3 = this.getSavedPid(string2);
            if (string3 != null && !string3.equals(this.getOwnPid())) {
                try {
                    this.adoptChildProcess(string2, string3);
                }
                catch (ProcessOpException processOpException) {
                    string3 = null;
                }
            } else {
                string3 = null;
            }
            if (string3 != null) continue;
            boolean bl = false;
            if (this.isRestartingAllServers) {
                if (monitorConfig.getPreviousState() == 1) {
                    bl = true;
                }
            } else {
                int n = monitorConfig.getNodeRestartState();
                switch (n) {
                    case 1: {
                        bl = true;
                        break;
                    }
                    case 0: {
                        break;
                    }
                    case 2: {
                        int n2 = monitorConfig.getPreviousState();
                        if (n2 != 1) break;
                        bl = true;
                    }
                }
            }
            if (!bl) continue;
            try {
                this.launchProcess(string2);
            }
            catch (AdminException adminException) {
                FFDCFilter.processException((Throwable)((Object)adminException), (String)"com.ibm.ws.management.nodeagent.NodeAgent.nodeRestart", (String)"1615", (Object)this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"bootstrapNode");
        }
    }

    private String getOwnPid() {
        if (this.ownPid == null) {
            try {
                Process process = ProcessFactory.createSelf();
                String string = process.id();
            }
            catch (ProcessOpException processOpException) {
                FFDCFilter.processException((Throwable)processOpException, (String)"com.ibm.ws.management.nodeagent.NodeAgent.getownPid", (String)"1269", (Object)this);
            }
        }
        return this.ownPid;
    }

    void sendNotification(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"sendNotification", (Object)new Object[]{string, string2});
        }
        try {
            this.sendNotification(this.createNotification(string, string2));
        }
        catch (MBeanException mBeanException) {
            FFDCFilter.processException((Throwable)mBeanException, (String)"com.ibm.ws.management.nodeagent.sendNotification", (String)"1284", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"sendNotification");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ProcessWatcher
    extends Thread {
        Process process;
        int statusSocketPort;
        int timeout;

        public ProcessWatcher(Process process, int n, int n2) {
            this.process = process;
            this.statusSocketPort = n;
            this.timeout = n2;
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block26: {
                boolean bl;
                block25: {
                    if (tc.isEntryEnabled()) {
                        Tr.entry((TraceComponent)tc, (String)"run");
                    }
                    bl = false;
                    try {
                        if (this.process.isAlive()) {
                            block24: {
                                try {
                                    this.process.waitForTermination(this.timeout);
                                }
                                catch (ProcessStillActiveException processStillActiveException) {
                                    if (!tc.isDebugEnabled()) break block24;
                                    Tr.debug((TraceComponent)tc, (String)"process is still running", (Object)((Object)processStillActiveException));
                                }
                            }
                            if (!this.process.isAlive()) {
                                bl = true;
                            }
                            break block25;
                        }
                        bl = true;
                    }
                    catch (Exception exception) {
                        if (!tc.isDebugEnabled()) break block25;
                        Tr.debug((TraceComponent)tc, (String)"can not determine whether process is alive", (Object)exception);
                    }
                }
                if (bl) {
                    FilterOutputStream filterOutputStream = null;
                    Socket socket = null;
                    socket = new Socket("localhost", this.statusSocketPort);
                    filterOutputStream = new DataOutputStream(socket.getOutputStream());
                    ((DataOutputStream)filterOutputStream).writeInt(-1);
                    Object var6_6 = null;
                    try {
                        if (filterOutputStream != null) {
                            filterOutputStream.close();
                        }
                        if (socket != null) {
                            socket.close();
                        }
                        break block26;
                    }
                    catch (Exception exception) {}
                    break block26;
                    {
                        catch (Exception exception) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"failed to write back INIT_FAILED", (Object)exception);
                            }
                            Object var6_7 = null;
                            try {
                                if (filterOutputStream != null) {
                                    filterOutputStream.close();
                                }
                                if (socket != null) {
                                    socket.close();
                                }
                                break block26;
                            }
                            catch (Exception exception2) {}
                        }
                    }
                    catch (Throwable throwable) {
                        Object var6_8 = null;
                        try {
                            if (filterOutputStream != null) {
                                filterOutputStream.close();
                            }
                            if (socket != null) {
                                socket.close();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"run");
            }
        }
    }
}

