/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.nodeagent;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.RoutingTable;
import com.ibm.ws.management.nodeagent.MonitorConfig;
import com.ibm.ws.management.nodeagent.NodeAgent;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.process.Process;
import com.ibm.ws.process.exception.ProcessOpException;
import com.ibm.ws.process.exception.ProcessStillActiveException;
import com.ibm.ws.runtime.service.VariableMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.management.JMException;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.security.auth.Subject;

class PidWaiter
implements Runnable,
NotificationListener {
    private static final String resBundleName = "com.ibm.ws.management.resources.launcher";
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.management.resources.launcher");
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$nodeagent$PidWaiter == null ? (class$com$ibm$ws$management$nodeagent$PidWaiter = PidWaiter.class$("com.ibm.ws.management.nodeagent.PidWaiter")) : class$com$ibm$ws$management$nodeagent$PidWaiter), (String)"Admin", (String)"com.ibm.ws.management.resources.launcher");
    private Process p = null;
    private String pid;
    private String processName = null;
    private int timeout = 0;
    private NodeAgent agent;
    private HashMap monitoringPolicies;
    private static VariableMap variableMap;
    private MonitorConfig cfg;
    private boolean processStopping;
    private Session session;
    static /* synthetic */ Class class$com$ibm$ws$management$nodeagent$PidWaiter;

    PidWaiter(NodeAgent nodeAgent, Process process, String string, VariableMap variableMap, String string2, int n, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"PidWaiter");
        }
        this.agent = nodeAgent;
        this.p = process;
        this.pid = string;
        PidWaiter.variableMap = variableMap;
        this.processName = string2;
        this.timeout = n;
        this.monitoringPolicies = nodeAgent.getMonitoringPolicies();
        if (bl) {
            nodeAgent.addAdoptedChild(string2, string);
        } else {
            nodeAgent.addLaunchedChild(string2, string);
        }
        this.listenForJ2EEStateStoppingNotifications();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"PidWaiter");
        }
    }

    private void listenForJ2EEStateStoppingNotifications() {
        AdminService adminService = AdminServiceFactory.getAdminService();
        NotificationFilterSupport notificationFilterSupport = new NotificationFilterSupport();
        notificationFilterSupport.enableType("j2ee.state.stopping");
        adminService.addNotificationListenerExtended(this.createServerObjectName(), this, notificationFilterSupport, null);
    }

    private void removeJ2EEStateStoppingListener() {
        try {
            AdminService adminService = AdminServiceFactory.getAdminService();
            adminService.removeNotificationListenerExtended(this.createServerObjectName(), this);
        }
        catch (JMException jMException) {
            FFDCFilter.processException((Throwable)jMException, (String)"com.ibm.ws.management.nodeagent.PidWaiter.removeJ2EEStateStoppingListener", (String)"116", (Object)this);
        }
    }

    private ObjectName createServerObjectName() {
        ObjectName objectName = null;
        try {
            objectName = new ObjectName("WebSphere:*,type=Server,processType=ManagedProcess,name=" + this.processName);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
        return objectName;
    }

    public void handleNotification(Notification notification, Object object) {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handleNotification", (Object)notification.getType());
        }
        if ((string = notification.getType()).equals("j2ee.state.stopping")) {
            this.processStopping();
            this.removeJ2EEStateStoppingListener();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleNotification");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() {
        block64: {
            block67: {
                block65: {
                    block66: {
                        if (PidWaiter.tc.isEntryEnabled()) {
                            Tr.entry((TraceComponent)PidWaiter.tc, (String)"run");
                        }
                        this.cfg = (MonitorConfig)this.monitoringPolicies.get(this.processName);
                        if (this.cfg == null) {
                            this.cfg = this.agent.loadServerMonitoringPolicy(this.processName);
                            if (this.cfg != null) {
                                this.monitoringPolicies.put(this.processName, this.cfg);
                            }
                        }
                        if (this.cfg == null) {
                            if (PidWaiter.tc.isEntryEnabled()) {
                                Tr.exit((TraceComponent)PidWaiter.tc, (String)"run - no monitoring policy set, quit");
                            }
                            return;
                        }
                        this.cfg.setPid(this.pid);
                        var1_1 = this.cfg.getPingInterval();
                        this.session = RoutingTable.getInstance().getSession(this.processName);
                        block31: while (true) lbl-1000:
                        // 3 sources

                        {
                            try {
                                this.p.waitForTermination(var1_1);
                                break;
                            }
                            catch (ProcessStillActiveException var2_2) {
                                if (this.contact() || this.isProcessStopping()) continue;
                                try {
                                    if (this.cfg.getAutoRestart()) {
                                        Tr.warning((TraceComponent)PidWaiter.tc, (String)"ADML0063W", (Object)this.processName);
                                        this.p.stop();
                                        while (true) {
                                            try {
                                                this.p.waitForTermination(var1_1);
                                                break block31;
                                            }
                                            catch (ProcessStillActiveException var3_5) {
                                                continue;
                                            }
                                            break;
                                        }
                                    }
                                    Tr.warning((TraceComponent)PidWaiter.tc, (String)"ADML0060W", (Object)this.processName);
                                    continue;
                                }
                                catch (ProcessOpException var3_6) {
                                    FFDCFilter.processException((Throwable)var3_6, (String)"com.ibm.ws.management.nodeagent.PidWaiter.run", (String)"124", (Object)this);
                                    break;
                                }
                            }
                            ** while (true)
                            catch (ProcessOpException var2_3) {
                                FFDCFilter.processException((Throwable)var2_3, (String)"com.ibm.ws.management.nodeagent.PidWaiter.run", (String)"132", (Object)this);
                            }
                            break;
                        }
                        if (PidWaiter.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)PidWaiter.tc, (String)("Process " + this.pid + " terminated"));
                        }
                        if ((var2_4 = RoutingTable.getInstance().getPid(this.processName)) != null && var2_4.equals(this.pid)) {
                            var3_8 = true;
                            if (this.session != null && (var4_13 = RoutingTable.getInstance().getSession(this.processName)) != null && !var4_13.equals(this.session)) {
                                var3_8 = false;
                            }
                            if (var3_8) {
                                RoutingTable.getInstance().removeChild(this.processName);
                            }
                        }
                        if (this.isProcessStopping()) {
                            if (this.agent.containAdoptedChild(this.processName, this.pid)) {
                                this.agent.removeAdoptedChild(this.processName, this.pid);
                            } else {
                                this.agent.removeLaunchedChild(this.processName, this.pid);
                            }
                            try {
                                this.p.release();
                            }
                            catch (ProcessOpException var3_9) {
                                FFDCFilter.processException((Throwable)var3_9, (String)"com.ibm.ws.management.nodeagent.PidWaiter.run", (String)"230", (Object)this);
                            }
                            this.agent.sendNotification("websphere.process.stopped", this.processName);
                            if (PidWaiter.tc.isEntryEnabled()) {
                                Tr.exit((TraceComponent)PidWaiter.tc, (String)"run", (Object)"<got j2ee.state.stopped>");
                            }
                            return;
                        }
                        this.removeJ2EEStateStoppingListener();
                        if (!this.agent.containAdoptedChild(this.processName, this.pid)) break block66;
                        try {
                            this.p.release();
                        }
                        catch (ProcessOpException var3_10) {
                            FFDCFilter.processException((Throwable)var3_10, (String)"com.ibm.ws.management.nodeagent.PidWaiter.run", (String)"148", (Object)this);
                        }
                        this.agent.removeAdoptedChild(this.processName, this.pid);
                        var3_11 = PidWaiter.variableMap.expand("${LOG_ROOT}/" + this.processName);
                        var4_13 = this.processName + ".pid";
                        var5_16 = new File(var3_11, (String)var4_13);
                        if (var5_16.exists()) {
                            block62: {
                                this.agent.sendNotification("websphere.process.failed", this.processName);
                                var6_17 = null;
                                var7_18 = true;
                                try {
                                    block61: {
                                        var6_17 = new BufferedReader(new FileReader(var5_16));
                                        var8_19 = var6_17.readLine();
                                        if (var8_19 == null || var8_19.equals(this.pid)) break block61;
                                        var7_18 = false;
                                    }
                                    var10_22 = null;
                                    ** if (var6_17 == null) goto lbl-1000
                                }
                                catch (Throwable var9_28) {
                                    block63: {
                                        var10_24 = null;
                                        if (var6_17 != null) {
                                            try {
                                                var6_17.close();
                                            }
                                            catch (IOException var11_27) {
                                                if (!PidWaiter.tc.isDebugEnabled()) break block63;
                                                Tr.debug((TraceComponent)PidWaiter.tc, (String)"failed to close pid file", (Object)var11_27);
                                            }
                                        }
                                    }
                                    throw var9_28;
                                }
lbl-1000:
                                // 1 sources

                                {
                                    try {
                                        var6_17.close();
                                    }
                                    catch (IOException var11_25) {
                                        if (PidWaiter.tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)PidWaiter.tc, (String)"failed to close pid file", (Object)var11_25);
                                        }
                                    }
                                }
lbl-1000:
                                // 4 sources

                                {
                                    break block62;
                                    catch (IOException var8_20) {
                                        FFDCFilter.processException((Throwable)var8_20, (String)"com.ibm.ws.management.nodeagent.PidWaiter.run", (String)"176", (Object)this);
                                        var10_23 = null;
                                        if (var6_17 != null) {
                                            try {
                                                var6_17.close();
                                            }
                                            catch (IOException var11_26) {
                                                if (PidWaiter.tc.isDebugEnabled()) {
                                                    Tr.debug((TraceComponent)PidWaiter.tc, (String)"failed to close pid file", (Object)var11_26);
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            if (var7_18) {
                                try {
                                    if (this.cfg != null && this.cfg.getAutoRestart()) {
                                        var5_16.delete();
                                        this.reLaunchProcess();
                                    }
                                    break block64;
                                }
                                catch (Exception var8_21) {
                                    FFDCFilter.processException((Throwable)var8_21, (String)"com.ibm.ws.management.nodeagent.PidWaiter.run", (String)"200", (Object)this);
                                }
                            }
                        } else {
                            if (PidWaiter.tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)PidWaiter.tc, (String)"pid file not found");
                            }
                            this.agent.sendNotification("websphere.process.stopped", this.processName);
                        }
                        break block64;
                    }
                    var3_12 = -2147483648;
                    var3_12 = this.p.getExitCode();
                    if (!PidWaiter.tc.isDebugEnabled()) break block65;
                    Tr.debug((TraceComponent)PidWaiter.tc, (String)("exit code: " + var3_12));
                }
                var13_29 = null;
                try {
                    this.p.release();
                }
                catch (ProcessOpException var14_32) {
                    FFDCFilter.processException((Throwable)var14_32, (String)"com.ibm.ws.management.nodeagent.PidWaiter.run", (String)"229", (Object)this);
                }
                break block67;
                {
                    catch (ProcessOpException var4_14) {
                        FFDCFilter.processException((Throwable)var4_14, (String)"com.ibm.ws.management.nodeagent.PidWaiter.run", (String)"222", (Object)this);
                        var13_30 = null;
                        try {
                            this.p.release();
                        }
                        catch (ProcessOpException var14_33) {
                            FFDCFilter.processException((Throwable)var14_33, (String)"com.ibm.ws.management.nodeagent.PidWaiter.run", (String)"229", (Object)this);
                        }
                    }
                }
                catch (Throwable var12_35) {
                    var13_31 = null;
                    try {
                        this.p.release();
                    }
                    catch (ProcessOpException var14_34) {
                        FFDCFilter.processException((Throwable)var14_34, (String)"com.ibm.ws.management.nodeagent.PidWaiter.run", (String)"229", (Object)this);
                    }
                    throw var12_35;
                }
            }
            this.agent.removeLaunchedChild(this.processName, this.pid);
            if (var3_12 == 0) {
                this.agent.sendNotification("websphere.process.stopped", this.processName);
            } else {
                this.agent.sendNotification("websphere.process.failed", this.processName);
                try {
                    if (this.cfg != null && this.cfg.getAutoRestart()) {
                        this.reLaunchProcess();
                    }
                }
                catch (Exception var4_15) {
                    FFDCFilter.processException((Throwable)var4_15, (String)"com.ibm.ws.management.nodeagent.PidWaiter.run", (String)"250", (Object)this);
                }
            }
        }
        if (PidWaiter.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)PidWaiter.tc, (String)"run");
        }
    }

    private boolean contact() {
        Subject subject;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"contact");
        }
        if ((subject = SecurityHelper.getOwnedSubject()) != null) {
            SecurityHelper.pushInvocationSubject(subject);
        }
        String string = "WebSphere:*,type=Server,process=" + this.processName;
        ObjectName objectName = null;
        boolean bl = true;
        for (int i = 0; i < 2; ++i) {
            block12: {
                block11: {
                    bl = true;
                    try {
                        Set set = AdminServiceFactory.getAdminService().queryNames(new ObjectName(string), null);
                        Iterator iterator = set.iterator();
                        objectName = iterator.hasNext() ? iterator.next() : null;
                    }
                    catch (MalformedObjectNameException malformedObjectNameException) {
                        FFDCFilter.processException((Throwable)malformedObjectNameException, (String)"com.ibm.ws.management.nodeagent.PidWaiter.contact", (String)"284", (Object)this);
                        if (!tc.isDebugEnabled()) break block11;
                        Tr.debug((TraceComponent)tc, (String)"wrong object name format", (Object)malformedObjectNameException);
                    }
                }
                if (objectName != null) {
                    try {
                        AdminServiceFactory.getAdminService().invoke(objectName, "getState", null, null);
                        bl = false;
                    }
                    catch (Exception exception) {
                        if (!tc.isDebugEnabled()) break block12;
                        Tr.debug((TraceComponent)tc, (String)"contact failed", (Object)exception);
                    }
                }
            }
            if (!bl || this.isProcessStopping()) break;
            try {
                Thread.sleep(60000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.management.nodeagent.PidWaiter.contact", (String)"309", (Object)this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"contact", (Object)new Boolean(!bl));
        }
        return !bl;
    }

    private void reLaunchProcess() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"reLaunchProcess");
        }
        boolean bl = false;
        int n = this.cfg.getMaximumStartupAttempts();
        while (!bl && n > 0) {
            --n;
            try {
                Tr.audit((TraceComponent)tc, (String)"ADML0064I", (Object)this.processName);
                bl = this.agent.launchProcess(this.processName, new Integer(this.timeout));
            }
            catch (AdminException adminException) {
                FFDCFilter.processException((Throwable)((Object)adminException), (String)"com.ibm.ws.management.nodeagent.PidWaiter.reLaunchProcess", (String)"334", (Object)this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"reLaunchProcess");
        }
    }

    synchronized void processStopping() {
        this.processStopping = true;
    }

    synchronized boolean isProcessStopping() {
        return this.processStopping;
    }

    public static String getServerPidFile(String string) {
        String string2 = variableMap.expand("${LOG_ROOT}");
        String string3 = string2 + "/" + string + "/" + string + ".pid";
        return string3;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

