/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.repository;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.repository.DocumentDigest;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DocumentDigestImpl
implements DocumentDigest,
Serializable {
    static final long serialVersionUID = 3015221028590796750L;
    private byte[] digest = null;
    private transient MessageDigest messageDigest = null;
    private transient DigestInputStream inputFilter = null;
    private transient DigestOutputStream outputFilter = null;
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$repository$DocumentDigestImpl == null ? (class$com$ibm$ws$management$repository$DocumentDigestImpl = DocumentDigestImpl.class$("com.ibm.ws.management.repository.DocumentDigestImpl")) : class$com$ibm$ws$management$repository$DocumentDigestImpl), (String)"ConfigRepository", (String)"com.ibm.ws.management.resources.repository");
    static /* synthetic */ Class class$com$ibm$ws$management$repository$DocumentDigestImpl;

    DocumentDigestImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"DocumentDigestImpl");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"DocumentDigestImpl");
        }
    }

    DocumentDigestImpl(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"DocumentDigestImpl(data)");
        }
        this.calc(byArray);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"DocumentDigestImpl(data)");
        }
    }

    DocumentDigestImpl(InputStream inputStream) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"DocumentDigestImpl(stream)");
        }
        this.calc(inputStream);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"DocumentDigestImpl(stream)");
        }
    }

    DocumentDigestImpl(MessageDigest messageDigest) {
        this.digest = messageDigest.digest();
    }

    protected byte[] getDigest() {
        return this.digest;
    }

    protected void calc(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"calc(byte[])");
        }
        MessageDigest messageDigest = null;
        messageDigest = this.getMessageDigest();
        if (messageDigest != null) {
            messageDigest.update(byArray);
            this.digest = messageDigest.digest();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"calc(byte[])", (Object)this.digest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void calc(InputStream inputStream) {
        block12: {
            block11: {
                int n;
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)"calc(stream)");
                }
                byte[] byArray = new byte[4096];
                MessageDigest messageDigest = null;
                messageDigest = this.getMessageDigest();
                if (messageDigest == null) break block11;
                while ((n = inputStream.read(byArray)) > 0) {
                    messageDigest.update(byArray, 0, n);
                }
                this.digest = messageDigest.digest();
            }
            Object var6_6 = null;
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.management.repository.DocumentDigestImpl.calc", (String)"114", (Object)this);
            }
            break block12;
            {
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.management.repository.DocumentDigestImpl.calc", (String)"113", (Object)this);
                    Tr.service((TraceComponent)tc, (String)"ADMR0200E", (Object)iOException);
                    Object var6_7 = null;
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException2) {
                        FFDCFilter.processException((Throwable)iOException2, (String)"com.ibm.ws.management.repository.DocumentDigestImpl.calc", (String)"114", (Object)this);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.management.repository.DocumentDigestImpl.calc", (String)"114", (Object)this);
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"calc(stream)", (Object)this.digest);
        }
    }

    public boolean equals(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"equals(digest)");
        }
        boolean bl = false;
        if (object != null && this.getClass().isInstance(object)) {
            DocumentDigestImpl documentDigestImpl = (DocumentDigestImpl)object;
            bl = this.compareDigestBytes(documentDigestImpl.getDigest());
        } else if (object == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"arg is null");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("arg is of type " + object.getClass().getName()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("equals(digest): " + bl));
        }
        return bl;
    }

    public boolean equals(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"equals(byte[])");
        }
        boolean bl = this.equals(new DocumentDigestImpl(byArray));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("equals(byte[]): " + bl));
        }
        return bl;
    }

    public boolean equals(InputStream inputStream) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"equals(stream)");
        }
        boolean bl = this.equals(new DocumentDigestImpl(inputStream));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("equals(stream): " + bl));
        }
        return bl;
    }

    public String toString() {
        int n = 0;
        String string = new String();
        if (this.digest != null) {
            for (int i = 0; i < this.digest.length; ++i) {
                n = this.digest[i] < 0 ? this.digest[i] + 256 : this.digest[i];
                string = string + Integer.toString(n / 16, 16) + Integer.toString(n % 16, 16);
            }
        }
        return string;
    }

    private boolean compareDigestBytes(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"compareDigestBytes");
        }
        boolean bl = true;
        if (this.digest.length == byArray.length) {
            for (int i = 0; i < this.digest.length; ++i) {
                if (this.digest[i] == byArray[i]) continue;
                bl = false;
                break;
            }
        } else {
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("compareDigestBytes: " + bl));
        }
        return bl;
    }

    private MessageDigest getMessageDigest() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getMessageDigest");
        }
        if (this.messageDigest == null) {
            try {
                this.messageDigest = MessageDigest.getInstance("SHA");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                FFDCFilter.processException((Throwable)noSuchAlgorithmException, (String)"com.ibm.ws.management.repository.DocumentDigestImpl.getMessageDigest", (String)"227", (Object)this);
                Tr.error((TraceComponent)tc, (String)"ADMR0201E");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getMessageDigest");
        }
        return this.messageDigest;
    }

    protected InputStream startInputFilter(InputStream inputStream) {
        this.inputFilter = new DigestInputStream(inputStream, this.getMessageDigest());
        return this.inputFilter;
    }

    protected void stopInputFilter() {
        if (this.messageDigest != null) {
            this.digest = this.messageDigest.digest();
        }
        try {
            if (this.inputFilter != null) {
                this.inputFilter.close();
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.management.repository.DocumentDigestImpl.calc", (String)"284", (Object)this);
        }
    }

    protected OutputStream startOutputFilter(OutputStream outputStream) {
        this.outputFilter = new DigestOutputStream(outputStream, this.getMessageDigest());
        return this.outputFilter;
    }

    protected void stopOutputFilter() {
        if (this.messageDigest != null) {
            this.digest = this.messageDigest.digest();
        }
        try {
            if (this.outputFilter != null) {
                this.outputFilter.close();
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.management.repository.DocumentDigestImpl.calc", (String)"310", (Object)this);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

