/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.repository;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.DocumentIOException;
import com.ibm.websphere.management.filetransfer.FileTransferConfig;
import com.ibm.websphere.management.filetransfer.client.FileDownloadInputStream;
import com.ibm.websphere.management.filetransfer.client.FileTransferOptions;
import com.ibm.websphere.management.repository.Document;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.management.repository.DocumentDigest;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.repository.DocumentDigestImpl;
import com.ibm.ws.management.repository.FileRepository;
import com.ibm.ws.util.lock.WriterPriorityReadersWriterLock;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;

public class FileDocument {
    private static String repositoryRoot;
    private static String repositoryTemp;
    private static String repositoryBackup;
    private static FileTransferConfig repositoryFTConfig;
    private static FileTransferOptions repositoryFTOptions;
    private static HashMap locks;
    private static Integer mkdirsLock;
    private static TraceComponent tc;
    static /* synthetic */ Class class$com$ibm$ws$management$repository$FileDocument;

    protected static Object getDirLock() {
        return mkdirsLock;
    }

    protected static void setRepository(FileRepository fileRepository) {
        repositoryRoot = fileRepository.getRepositoryDir();
        repositoryTemp = fileRepository.getTempDir();
        repositoryBackup = fileRepository.getBackupDir();
        repositoryFTOptions = fileRepository.getFileTransferOptions();
        repositoryFTConfig = fileRepository.getFileTransferConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static DocumentDigest create(DocumentContentSource documentContentSource) throws DocumentIOException {
        DocumentDigestImpl documentDigestImpl = null;
        boolean bl = false;
        try {
            File file = FileDocument.getFileForURI(documentContentSource.getDocument().getURI());
            Object object = mkdirsLock;
            synchronized (object) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            object = new FileOutputStream(file);
            FileDocument.lockForWriting(documentContentSource.getDocument().getURI());
            bl = true;
            documentDigestImpl = FileDocument.copyDocument(documentContentSource.getSource(), (OutputStream)object, true);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.repository.FileDocument.create", (String)"88", (Object)(class$com$ibm$ws$management$repository$FileDocument == null ? (class$com$ibm$ws$management$repository$FileDocument = FileDocument.class$("com.ibm.ws.management.repository.FileDocument")) : class$com$ibm$ws$management$repository$FileDocument));
            Tr.error((TraceComponent)tc, (String)"ADMR0100E", (Object)new Object[]{documentContentSource.getDocument().getURI(), exception});
            throw FileDocument.getDocumentIOException(exception, documentContentSource.getDocument().getURI());
        }
        finally {
            if (bl) {
                FileDocument.unlockForWriting(documentContentSource.getDocument().getURI());
            }
        }
        return documentDigestImpl;
    }

    protected static void delete(String string) throws DocumentIOException {
        FileDocument.delete(string, false);
    }

    private static void delete(String string, boolean bl) throws DocumentIOException {
        Object object;
        if (!bl) {
            object = string + ".digest";
            File file = FileDocument.getFileForURI((String)object);
            FileDocument.lockForWriting((String)object);
            if (file.exists() && !file.delete()) {
                FileDocument.unlockForWriting((String)object);
                Tr.error((TraceComponent)tc, (String)"ADMR0111E", (Object)object);
                throw new DocumentIOException((String)object);
            }
            FileDocument.unlockForWriting((String)object);
        }
        object = FileDocument.getFileForURI(string);
        FileDocument.lockForWriting(string);
        if (((File)object).exists() && !((File)object).delete()) {
            FileDocument.unlockForWriting(string);
            Tr.error((TraceComponent)tc, (String)"ADMR0111E", (Object)string);
            throw new DocumentIOException(string);
        }
        FileDocument.deleteEmptyParents((File)object, repositoryRoot);
        FileDocument.unlockForWriting(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteEmptyParents(File file, String string) {
        File file2 = file.getParentFile();
        Integer n = mkdirsLock;
        synchronized (n) {
            if (file2.getPath().length() > string.length() && file2.delete()) {
                FileDocument.deleteEmptyParents(file2, string);
            }
        }
    }

    protected static DocumentDigestImpl getDigest(String string) throws DocumentIOException {
        DocumentDigestImpl documentDigestImpl = null;
        File file = FileDocument.getFileForURI(string + ".digest");
        documentDigestImpl = file.exists() ? FileDocument.readDigest(string + ".digest", file) : FileDocument.calcDigest(string);
        return documentDigestImpl;
    }

    protected static DocumentDigestImpl calcDigest(String string) throws DocumentIOException {
        DocumentDigestImpl documentDigestImpl;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("calcDigest: " + string));
        }
        File file = FileDocument.getFileForURI(string);
        boolean bl = false;
        try {
            documentDigestImpl = new DocumentDigestImpl();
            FileDocument.lockForReading(string);
            bl = true;
            documentDigestImpl.calc(new FileInputStream(file));
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.management.repository.FileDocument.getDigest", (String)"146", (Object)(class$com$ibm$ws$management$repository$FileDocument == null ? (class$com$ibm$ws$management$repository$FileDocument = FileDocument.class$("com.ibm.ws.management.repository.FileDocument")) : class$com$ibm$ws$management$repository$FileDocument));
            Tr.error((TraceComponent)tc, (String)"ADMR0104E", (Object)new Object[]{string, iOException});
            throw new DocumentIOException(iOException, string);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.repository.FileDocument.getDigest", (String)"152", (Object)(class$com$ibm$ws$management$repository$FileDocument == null ? (class$com$ibm$ws$management$repository$FileDocument = FileDocument.class$("com.ibm.ws.management.repository.FileDocument")) : class$com$ibm$ws$management$repository$FileDocument));
            Tr.error((TraceComponent)tc, (String)"ADMR0104E", (Object)new Object[]{string, exception});
            throw FileDocument.getDocumentIOException(exception, string);
        }
        finally {
            if (bl) {
                FileDocument.unlockForReading(string);
            }
        }
        return documentDigestImpl;
    }

    /*
     * Loose catch block
     */
    private static DocumentDigestImpl readDigest(String string, File file) throws DocumentIOException {
        DocumentDigestImpl documentDigestImpl;
        block17: {
            boolean bl;
            ObjectInputStream objectInputStream;
            FileInputStream fileInputStream;
            block14: {
                IOException iOException2222;
                block13: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("readDigest: " + string));
                    }
                    documentDigestImpl = null;
                    fileInputStream = null;
                    objectInputStream = null;
                    bl = true;
                    FileDocument.lockForReading(string);
                    bl = true;
                    fileInputStream = new FileInputStream(repositoryRoot + File.separator + string);
                    objectInputStream = new ObjectInputStream(fileInputStream);
                    documentDigestImpl = (DocumentDigestImpl)objectInputStream.readObject();
                    Object var8_6 = null;
                    try {
                        objectInputStream.close();
                    }
                    catch (IOException iOException2222) {
                        FFDCFilter.processException((Throwable)iOException2222, (String)"com.ibm.ws.management.repository.FileDocument.readDigest", (String)"214", null);
                        if (!tc.isDebugEnabled()) break block13;
                        Tr.debug((TraceComponent)tc, (String)("Error while closing object stream: " + iOException2222));
                    }
                }
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException2222) {
                    FFDCFilter.processException((Throwable)iOException2222, (String)"com.ibm.ws.management.repository.FileDocument.readDigest", (String)"223", null);
                    if (!tc.isDebugEnabled()) break block14;
                    Tr.debug((TraceComponent)tc, (String)("Error while closing file input stream: " + iOException2222));
                }
            }
            if (bl) {
                FileDocument.unlockForReading(string);
            }
            break block17;
            {
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.repository.FileDocument.getDigest", (String)"152", (Object)(class$com$ibm$ws$management$repository$FileDocument == null ? (class$com$ibm$ws$management$repository$FileDocument = FileDocument.class$("com.ibm.ws.management.repository.FileDocument")) : class$com$ibm$ws$management$repository$FileDocument));
                    Tr.error((TraceComponent)tc, (String)"ADMR0104E", (Object)new Object[]{string, throwable});
                    throw FileDocument.getDocumentIOException(throwable, string);
                }
            }
            catch (Throwable throwable) {
                block16: {
                    IOException iOException3222;
                    block15: {
                        Object var8_7 = null;
                        try {
                            objectInputStream.close();
                        }
                        catch (IOException iOException3222) {
                            FFDCFilter.processException((Throwable)iOException3222, (String)"com.ibm.ws.management.repository.FileDocument.readDigest", (String)"214", null);
                            if (!tc.isDebugEnabled()) break block15;
                            Tr.debug((TraceComponent)tc, (String)("Error while closing object stream: " + iOException3222));
                        }
                    }
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException3222) {
                        FFDCFilter.processException((Throwable)iOException3222, (String)"com.ibm.ws.management.repository.FileDocument.readDigest", (String)"223", null);
                        if (!tc.isDebugEnabled()) break block16;
                        Tr.debug((TraceComponent)tc, (String)("Error while closing file input stream: " + iOException3222));
                    }
                }
                if (bl) {
                    FileDocument.unlockForReading(string);
                }
                throw throwable;
            }
        }
        return documentDigestImpl;
    }

    protected static DocumentDigestImpl write(DocumentContentSource documentContentSource) throws DocumentIOException {
        DocumentDigestImpl documentDigestImpl = null;
        String string = documentContentSource.getDocument().getURI();
        boolean bl = false;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("writing " + string));
        }
        try {
            File file = FileDocument.getFileForURI(string);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            FileDocument.lockForWriting(string);
            bl = true;
            documentDigestImpl = FileDocument.copyDocument(documentContentSource.getSource(), fileOutputStream, true);
            long l = documentContentSource.getLastModified();
            if (l > 0L) {
                file.setLastModified(l);
            }
            FileDocument.writeDigest(string, documentDigestImpl);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.repository.FileDocument.write", (String)"175", (Object)(class$com$ibm$ws$management$repository$FileDocument == null ? (class$com$ibm$ws$management$repository$FileDocument = FileDocument.class$("com.ibm.ws.management.repository.FileDocument")) : class$com$ibm$ws$management$repository$FileDocument));
            Tr.error((TraceComponent)tc, (String)"ADMR0105E", (Object)new Object[]{documentContentSource.getDocument().getURI(), exception});
            throw FileDocument.getDocumentIOException(exception, documentContentSource.getDocument().getURI());
        }
        finally {
            if (bl) {
                FileDocument.unlockForWriting(string);
            }
        }
        return documentDigestImpl;
    }

    protected static void backup(String string) throws DocumentIOException {
        String string2;
        File file;
        boolean bl = false;
        File file2 = FileDocument.getFileForURI(string);
        if (file2.exists()) {
            FileDocument.backup(string, file2);
            bl = true;
        }
        if ((file = FileDocument.getFileForURI(string2 = string + ".digest")).exists()) {
            FileDocument.backup(string2, file);
            bl = true;
        }
        if (!bl) {
            DocumentIOException documentIOException = new DocumentIOException("Document does not exist: " + string);
            Tr.error((TraceComponent)tc, (String)"ADMR0108E", (Object)new Object[]{string, documentIOException});
            throw documentIOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void backup(String string, File file) throws DocumentIOException {
        boolean bl = false;
        try {
            File file2 = new File(repositoryBackup + File.separator + string);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("backupFile: " + file2.getPath()));
            }
            Integer n = mkdirsLock;
            synchronized (n) {
                file2.getParentFile().mkdirs();
                FileDocument.lockForReading(string);
                bl = true;
                FileDocument.copyDocument(new FileInputStream(file), new FileOutputStream(file2), false);
            }
            file2.setLastModified(file.lastModified());
        }
        catch (FileNotFoundException fileNotFoundException) {
            FFDCFilter.processException((Throwable)fileNotFoundException, (String)"com.ibm.ws.management.repository.FileDocument.backup", (String)"211", (Object)(class$com$ibm$ws$management$repository$FileDocument == null ? (class$com$ibm$ws$management$repository$FileDocument = FileDocument.class$("com.ibm.ws.management.repository.FileDocument")) : class$com$ibm$ws$management$repository$FileDocument));
            Tr.error((TraceComponent)tc, (String)"ADMR0108E", (Object)new Object[]{string, fileNotFoundException});
            throw new DocumentIOException(fileNotFoundException, "Unable to backup document: " + string);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.repository.FileDocument.backup", (String)"212", (Object)(class$com$ibm$ws$management$repository$FileDocument == null ? (class$com$ibm$ws$management$repository$FileDocument = FileDocument.class$("com.ibm.ws.management.repository.FileDocument")) : class$com$ibm$ws$management$repository$FileDocument));
            Tr.error((TraceComponent)tc, (String)"ADMR0108E", (Object)new Object[]{string, exception});
            throw FileDocument.getDocumentIOException(exception, "Unable to backup document: " + string);
        }
        finally {
            if (bl) {
                FileDocument.unlockForReading(string);
            }
        }
    }

    protected static void removeBackup(String string) {
        File file = new File(repositoryBackup + File.separator + string);
        if (!file.delete() && file.exists()) {
            Tr.warning((TraceComponent)tc, (String)"ADMR0110W", (Object)new Object[]{string, ""});
        }
        if ((file = new File(repositoryBackup + File.separator + string + ".digest")).exists() && !file.delete()) {
            Tr.warning((TraceComponent)tc, (String)"ADMR0110W", (Object)new Object[]{string + ".digest", ""});
        }
        FileDocument.deleteEmptyParents(file, repositoryBackup);
    }

    protected static void restore(String string) throws DocumentIOException {
        boolean bl = false;
        File file = new File(repositoryBackup + File.separator + string);
        if (file.exists()) {
            FileDocument.restore(string, file);
            bl = true;
        }
        String string2 = string + ".digest";
        file = new File(repositoryBackup + File.separator + string2);
        if (file.exists()) {
            FileDocument.restore(string2, file);
            bl = true;
        }
        if (!bl) {
            DocumentIOException documentIOException = new DocumentIOException("Document backup does not exist: " + string);
            Tr.error((TraceComponent)tc, (String)"ADMR0109E", (Object)new Object[]{string, documentIOException});
            throw documentIOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void restore(String string, File file) throws DocumentIOException {
        boolean bl = false;
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("restoring " + string));
            }
            File file2 = FileDocument.getFileForURI(string);
            FileDocument.lockForWriting(string);
            bl = true;
            FileOutputStream fileOutputStream = null;
            if (!file2.getParentFile().exists()) {
                Integer n = mkdirsLock;
                synchronized (n) {
                    file2.getParentFile().mkdirs();
                    fileOutputStream = new FileOutputStream(file2);
                }
            } else {
                fileOutputStream = new FileOutputStream(file2);
            }
            FileDocument.copyDocument(new FileInputStream(file), fileOutputStream, false);
            file2.setLastModified(file.lastModified());
        }
        catch (FileNotFoundException fileNotFoundException) {
            FFDCFilter.processException((Throwable)fileNotFoundException, (String)"com.ibm.ws.management.repository.FileDocument.restore", (String)"245", (Object)(class$com$ibm$ws$management$repository$FileDocument == null ? (class$com$ibm$ws$management$repository$FileDocument = FileDocument.class$("com.ibm.ws.management.repository.FileDocument")) : class$com$ibm$ws$management$repository$FileDocument));
            Tr.error((TraceComponent)tc, (String)"ADMR0109E", (Object)new Object[]{string, fileNotFoundException});
            throw new DocumentIOException(fileNotFoundException, "Unable to restore document from backup: " + string);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.repository.FileDocument.restore", (String)"251", (Object)(class$com$ibm$ws$management$repository$FileDocument == null ? (class$com$ibm$ws$management$repository$FileDocument = FileDocument.class$("com.ibm.ws.management.repository.FileDocument")) : class$com$ibm$ws$management$repository$FileDocument));
            Tr.error((TraceComponent)tc, (String)"ADMR0109E", (Object)new Object[]{string, exception});
            throw FileDocument.getDocumentIOException(exception, "Unable to restore document from backup: " + string);
        }
        finally {
            if (bl) {
                FileDocument.unlockForWriting(string);
            }
        }
    }

    /*
     * Loose catch block
     */
    private static DocumentDigestImpl copyDocument(InputStream inputStream, OutputStream outputStream, boolean bl) throws IOException {
        DocumentDigestImpl documentDigestImpl;
        block18: {
            Exception exception2222;
            block17: {
                block16: {
                    if (tc.isEntryEnabled()) {
                        Tr.entry((TraceComponent)tc, (String)"copyDocument");
                    }
                    InputStream inputStream2 = null;
                    documentDigestImpl = null;
                    if (bl) {
                        documentDigestImpl = new DocumentDigestImpl();
                        inputStream2 = documentDigestImpl.startInputFilter(inputStream);
                    } else {
                        inputStream2 = inputStream;
                    }
                    byte[] byArray = new byte[4096];
                    int n = inputStream2.read(byArray);
                    while (n != -1) {
                        outputStream.write(byArray, 0, n);
                        n = inputStream2.read(byArray);
                    }
                    if (!bl) break block16;
                    documentDigestImpl.stopInputFilter();
                }
                Object var8_8 = null;
                try {
                    outputStream.close();
                }
                catch (Exception exception2222) {
                    FFDCFilter.processException((Throwable)exception2222, (String)"com.ibm.ws.management.repository.FileDocument.copyDocument", (String)"866", null);
                    if (!tc.isDebugEnabled()) break block17;
                    Tr.debug((TraceComponent)tc, (String)("Error while closing to stream: " + exception2222));
                }
            }
            try {
                inputStream.close();
            }
            catch (Exception exception2222) {
                FFDCFilter.processException((Throwable)exception2222, (String)"com.ibm.ws.management.repository.FileDocument.copyDocument", (String)"866", null);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Error while closing from stream: " + exception2222));
                }
                break block18;
            }
            {
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.management.repository.FileDocument.copyDocument", (String)"851", (Object)(class$com$ibm$ws$management$repository$FileDocument == null ? (class$com$ibm$ws$management$repository$FileDocument = FileDocument.class$("com.ibm.ws.management.repository.FileDocument")) : class$com$ibm$ws$management$repository$FileDocument));
                    throw iOException;
                }
            }
            catch (Throwable throwable) {
                block20: {
                    Exception exception32222;
                    block19: {
                        Object var8_9 = null;
                        try {
                            outputStream.close();
                        }
                        catch (Exception exception32222) {
                            FFDCFilter.processException((Throwable)exception32222, (String)"com.ibm.ws.management.repository.FileDocument.copyDocument", (String)"866", null);
                            if (!tc.isDebugEnabled()) break block19;
                            Tr.debug((TraceComponent)tc, (String)("Error while closing to stream: " + exception32222));
                        }
                    }
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception32222) {
                        FFDCFilter.processException((Throwable)exception32222, (String)"com.ibm.ws.management.repository.FileDocument.copyDocument", (String)"866", null);
                        if (!tc.isDebugEnabled()) break block20;
                        Tr.debug((TraceComponent)tc, (String)("Error while closing from stream: " + exception32222));
                    }
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"copyDocument");
        }
        return documentDigestImpl;
    }

    protected static DocumentContentSource read(String string) throws DocumentIOException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("reading " + string));
        }
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        FileDownloadInputStream fileDownloadInputStream = null;
        DocumentDigestImpl documentDigestImpl = null;
        File file = FileDocument.getFileForURI(string);
        File file2 = FileDocument.createTempFile(string);
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.management.repository.FileDocument.read", (String)"351", (Object)(class$com$ibm$ws$management$repository$FileDocument == null ? (class$com$ibm$ws$management$repository$FileDocument = FileDocument.class$("com.ibm.ws.management.repository.FileDocument")) : class$com$ibm$ws$management$repository$FileDocument));
            Tr.error((TraceComponent)tc, (String)"ADMR0104E", (Object)new Object[]{string, iOException});
            throw new DocumentIOException(iOException, "Unable to create input stream on document file: " + string);
        }
        try {
            fileOutputStream = new FileOutputStream(file2);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.management.repository.FileDocument.read", (String)"363", (Object)(class$com$ibm$ws$management$repository$FileDocument == null ? (class$com$ibm$ws$management$repository$FileDocument = FileDocument.class$("com.ibm.ws.management.repository.FileDocument")) : class$com$ibm$ws$management$repository$FileDocument));
            Tr.error((TraceComponent)tc, (String)"ADMR0104E", (Object)new Object[]{string, iOException});
            throw new DocumentIOException(iOException, "Unable to create output stream on temp file: " + file2.getPath());
        }
        long l = 0L;
        boolean bl = false;
        try {
            FileDocument.lockForReading(string);
            bl = true;
            documentDigestImpl = FileDocument.copyDocument(fileInputStream, fileOutputStream, true);
            l = file.lastModified();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.repository.FileDocument.read", (String)"375", (Object)(class$com$ibm$ws$management$repository$FileDocument == null ? (class$com$ibm$ws$management$repository$FileDocument = FileDocument.class$("com.ibm.ws.management.repository.FileDocument")) : class$com$ibm$ws$management$repository$FileDocument));
            Tr.error((TraceComponent)tc, (String)"ADMR0104E", (Object)new Object[]{string, exception});
            throw FileDocument.getDocumentIOException(exception, "Unable to copy document to temp file: " + string);
        }
        finally {
            if (bl) {
                FileDocument.unlockForReading(string);
            }
        }
        fileDownloadInputStream = new FileDownloadInputStream(file2);
        fileDownloadInputStream.setFileTransferConfig(repositoryFTConfig);
        fileDownloadInputStream.setOptions(repositoryFTOptions);
        fileDownloadInputStream.setSrcPath(file2.getAbsolutePath().substring(repositoryTemp.length()));
        Document document = new Document(string, documentDigestImpl);
        DocumentContentSource documentContentSource = new DocumentContentSource(document, fileDownloadInputStream);
        documentContentSource.setLastModified(l);
        return documentContentSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File createTempFile(String string) throws DocumentIOException {
        File file = new File(repositoryTemp + string);
        String string2 = file.getName().replace('%', '_');
        if (string2.length() < 3) {
            string2 = new String(string2 + "__");
        }
        File file2 = file.getParentFile();
        File file3 = null;
        try {
            Integer n = mkdirsLock;
            synchronized (n) {
                file2.mkdirs();
                file3 = File.createTempFile(string2, null, file2);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.repository.FileDocument.createTempFile", (String)"404", (Object)(class$com$ibm$ws$management$repository$FileDocument == null ? (class$com$ibm$ws$management$repository$FileDocument = FileDocument.class$("com.ibm.ws.management.repository.FileDocument")) : class$com$ibm$ws$management$repository$FileDocument));
            Tr.error((TraceComponent)tc, (String)"ADMR0104E", (Object)new Object[]{string, throwable});
            throw new DocumentIOException(throwable, "Unable to create temp file for document: " + string);
        }
        return file3;
    }

    private static void lockForReading(String string) throws DocumentIOException {
        try {
            FileDocument.getLock(string).startReading();
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.management.repository.FileDocument.lockForWriting", (String)"640", (Object)(class$com$ibm$ws$management$repository$FileDocument == null ? (class$com$ibm$ws$management$repository$FileDocument = FileDocument.class$("com.ibm.ws.management.repository.FileDocument")) : class$com$ibm$ws$management$repository$FileDocument));
            throw new DocumentIOException(interruptedException, "Unable to get read lock for document " + string);
        }
    }

    private static void unlockForReading(String string) {
        WriterPriorityReadersWriterLock writerPriorityReadersWriterLock = FileDocument.getLock(string);
        writerPriorityReadersWriterLock.stopReading();
        FileDocument.releaseLock(string, writerPriorityReadersWriterLock);
    }

    private static void lockForWriting(String string) throws DocumentIOException {
        try {
            FileDocument.getLock(string).startWriting();
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.management.repository.FileDocument.lockForWriting", (String)"640", (Object)(class$com$ibm$ws$management$repository$FileDocument == null ? (class$com$ibm$ws$management$repository$FileDocument = FileDocument.class$("com.ibm.ws.management.repository.FileDocument")) : class$com$ibm$ws$management$repository$FileDocument));
            throw new DocumentIOException(interruptedException, "Unable to get write lock for document " + string);
        }
    }

    private static void unlockForWriting(String string) {
        WriterPriorityReadersWriterLock writerPriorityReadersWriterLock = FileDocument.getLock(string);
        writerPriorityReadersWriterLock.stopWriting();
        FileDocument.releaseLock(string, writerPriorityReadersWriterLock);
    }

    private static synchronized WriterPriorityReadersWriterLock getLock(String string) {
        WriterPriorityReadersWriterLock writerPriorityReadersWriterLock = (WriterPriorityReadersWriterLock)locks.get(string);
        if (writerPriorityReadersWriterLock == null) {
            writerPriorityReadersWriterLock = new WriterPriorityReadersWriterLock();
            locks.put(string, writerPriorityReadersWriterLock);
        }
        return writerPriorityReadersWriterLock;
    }

    private static synchronized void releaseLock(String string, WriterPriorityReadersWriterLock writerPriorityReadersWriterLock) {
        if (!writerPriorityReadersWriterLock.hasReaderOrWriter()) {
            locks.remove(string);
        }
    }

    protected static void createDigestFile(String string, boolean bl) throws DocumentIOException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("creating digest file for " + string + "; deleteDoc = " + bl));
        }
        DocumentDigestImpl documentDigestImpl = FileDocument.getDigest(string);
        File file = FileDocument.getFileForURI(string + ".digest");
        try {
            file.createNewFile();
            FileDocument.writeDigest(string, documentDigestImpl);
            if (bl) {
                FileDocument.delete(string, true);
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.management.repository.FileDocument.createDigestFile", (String)"524", (Object)(class$com$ibm$ws$management$repository$FileDocument == null ? (class$com$ibm$ws$management$repository$FileDocument = FileDocument.class$("com.ibm.ws.management.repository.FileDocument")) : class$com$ibm$ws$management$repository$FileDocument));
            throw new DocumentIOException(iOException, "Unable to create digest file for document " + string);
        }
    }

    /*
     * Loose catch block
     */
    protected static void writeDigest(String string, DocumentDigestImpl documentDigestImpl) throws DocumentIOException {
        block18: {
            String string2 = string + ".digest";
            File file = FileDocument.getFileForURI(string2);
            if (file.exists()) {
                boolean bl;
                ObjectOutputStream objectOutputStream;
                FileOutputStream fileOutputStream;
                block15: {
                    IOException iOException2222;
                    block14: {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Updating digest file for " + string));
                        }
                        fileOutputStream = null;
                        objectOutputStream = null;
                        bl = false;
                        FileDocument.lockForWriting(string2);
                        bl = true;
                        fileOutputStream = new FileOutputStream(file);
                        objectOutputStream = new ObjectOutputStream(fileOutputStream);
                        objectOutputStream.writeObject(documentDigestImpl);
                        Object var9_7 = null;
                        try {
                            objectOutputStream.close();
                        }
                        catch (IOException iOException2222) {
                            FFDCFilter.processException((Throwable)iOException2222, (String)"com.ibm.ws.management.repository.FileDocument.writeDigest", (String)"605", null);
                            if (!tc.isDebugEnabled()) break block14;
                            Tr.debug((TraceComponent)tc, (String)("Error while closing object stream: " + iOException2222));
                        }
                    }
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException2222) {
                        FFDCFilter.processException((Throwable)iOException2222, (String)"com.ibm.ws.management.repository.FileDocument.writeDigest", (String)"615", null);
                        if (!tc.isDebugEnabled()) break block15;
                        Tr.debug((TraceComponent)tc, (String)("Error while closing file output stream: " + iOException2222));
                    }
                }
                if (bl) {
                    FileDocument.unlockForWriting(string2);
                }
                break block18;
                {
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.repository.FileDocument.writeDigest", (String)"478", (Object)(class$com$ibm$ws$management$repository$FileDocument == null ? (class$com$ibm$ws$management$repository$FileDocument = FileDocument.class$("com.ibm.ws.management.repository.FileDocument")) : class$com$ibm$ws$management$repository$FileDocument));
                        throw FileDocument.getDocumentIOException(exception, "Unable to write digest file for document " + string);
                    }
                }
                catch (Throwable throwable) {
                    block17: {
                        IOException iOException3222;
                        block16: {
                            Object var9_8 = null;
                            try {
                                objectOutputStream.close();
                            }
                            catch (IOException iOException3222) {
                                FFDCFilter.processException((Throwable)iOException3222, (String)"com.ibm.ws.management.repository.FileDocument.writeDigest", (String)"605", null);
                                if (!tc.isDebugEnabled()) break block16;
                                Tr.debug((TraceComponent)tc, (String)("Error while closing object stream: " + iOException3222));
                            }
                        }
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException iOException3222) {
                            FFDCFilter.processException((Throwable)iOException3222, (String)"com.ibm.ws.management.repository.FileDocument.writeDigest", (String)"615", null);
                            if (!tc.isDebugEnabled()) break block17;
                            Tr.debug((TraceComponent)tc, (String)("Error while closing file output stream: " + iOException3222));
                        }
                    }
                    if (bl) {
                        FileDocument.unlockForWriting(string2);
                    }
                    throw throwable;
                }
            }
        }
    }

    private static File getFileForURI(String string) {
        return new File(repositoryRoot + File.separator + string);
    }

    private static DocumentIOException getDocumentIOException(Throwable throwable, String string) {
        if (throwable instanceof DocumentIOException) {
            return (DocumentIOException)((Object)throwable);
        }
        return new DocumentIOException(throwable, string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        locks = new HashMap();
        mkdirsLock = new Integer(0);
        tc = Tr.register((Class)(class$com$ibm$ws$management$repository$FileDocument == null ? (class$com$ibm$ws$management$repository$FileDocument = FileDocument.class$("com.ibm.ws.management.repository.FileDocument")) : class$com$ibm$ws$management$repository$FileDocument), (String)"ConfigRepository", (String)"com.ibm.ws.management.resources.repository");
    }
}

