/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.repository;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.DocumentAlreadyExistsException;
import com.ibm.websphere.management.exception.DocumentChangedException;
import com.ibm.websphere.management.exception.DocumentIOException;
import com.ibm.websphere.management.exception.DocumentLockedException;
import com.ibm.websphere.management.exception.DocumentNotFoundException;
import com.ibm.websphere.management.exception.DocumentUnavailableException;
import com.ibm.websphere.management.exception.RepositoryException;
import com.ibm.websphere.management.exception.RepositoryLockedException;
import com.ibm.websphere.management.filetransfer.FileTransferConfig;
import com.ibm.websphere.management.filetransfer.client.FileTransferOptions;
import com.ibm.websphere.management.repository.ConfigChangeNotifier;
import com.ibm.websphere.management.repository.ConfigEpoch;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryEvent;
import com.ibm.websphere.management.repository.ConfigRepositoryListener;
import com.ibm.websphere.management.repository.Document;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.management.repository.DocumentDigest;
import com.ibm.websphere.management.repository.ResourceNameFilter;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.filetransfer.FileTransferConfigImpl;
import com.ibm.ws.management.repository.DocumentDigestImpl;
import com.ibm.ws.management.repository.FileDocument;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.security.role.RoleBasedAuthorizer;
import com.ibm.ws.security.util.RestrictedAccess;
import com.ibm.ws.util.ImplFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import javax.management.Notification;

public class FileRepository
extends RuntimeCollaborator
implements ConfigRepository,
ResourceNameFilter,
ConfigRepositoryListener {
    private static FileRepository repository = new FileRepository();
    private Class digestImplClass;
    private String repositoryDir;
    private String backupDir;
    private File backupDirectory;
    private String tempDir;
    private File tempDirectory;
    private HashSet locks;
    private boolean initialized = false;
    private String processType = null;
    private boolean inServer = false;
    private boolean repositoryLocked = false;
    private ConfigEpoch repositoryEpoch;
    private boolean auditingEnabled = true;
    private ArrayList listeners;
    private boolean allowOverwrites = true;
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$repository$FileRepository == null ? (class$com$ibm$ws$management$repository$FileRepository = FileRepository.class$("com.ibm.ws.management.repository.FileRepository")) : class$com$ibm$ws$management$repository$FileRepository), (String)"ConfigRepository", (String)"com.ibm.ws.management.resources.repository");
    private FileTransferOptions ftOptions = (FileTransferOptions)ImplFactory.loadImplFromKey((Class)(class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions == null ? (class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions = FileRepository.class$("com.ibm.websphere.management.filetransfer.client.FileTransferOptions")) : class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions));
    private FileTransferConfig ftConfig = null;
    private Properties configProperties = null;
    private static final int AVAILABLE = 0;
    private static final int UNAVAILABLE = 1;
    private static final int INVALID = 2;
    private static final int READ = 0;
    private static final int WRITE = 1;
    static /* synthetic */ Class class$com$ibm$ws$management$repository$FileRepository;
    static /* synthetic */ Class class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$com$ibm$websphere$management$repository$ConfigRepository;

    private FileRepository() {
    }

    public static FileRepository getRepository() {
        return repository;
    }

    public synchronized void initialize(Properties properties) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize");
        }
        if (this.initialized) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Config repository already initialized");
            }
            return;
        }
        String string = System.getProperty("com.ibm.ws.management.standalone");
        if (string != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Standalone system property set.");
            }
            this.processType = "UnManagedProcess";
            this.inServer = false;
        } else {
            try {
                AdminServiceFactory.getMBeanFactory().activateMBean("ConfigRepository", this, "repository", null);
            }
            catch (AdminException adminException) {
                FFDCFilter.processException((Throwable)((Object)adminException), (String)"com.ibm.ws.management.repository.FileRepository.initialize", (String)"149", (Object)this);
                Tr.error((TraceComponent)tc, (String)"ADMR0006E", (Object)((Object)adminException));
                throw adminException;
            }
            this.processType = AdminServiceFactory.getAdminService().getProcessType();
            this.inServer = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("processType = " + this.processType));
        }
        this.processProps(properties);
        this.initialized = true;
        this.repositoryEpoch = new ConfigEpoch();
        this.listeners = new ArrayList();
        this.addListener(this);
        try {
            Class<?> clazz = Class.forName("com.ibm.ws.management.application.sync.AppBinaryProcessor");
            Constructor<?> constructor = clazz.getConstructor(class$java$lang$Boolean == null ? (class$java$lang$Boolean = FileRepository.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$com$ibm$websphere$management$repository$ConfigRepository == null ? (class$com$ibm$websphere$management$repository$ConfigRepository = FileRepository.class$("com.ibm.websphere.management.repository.ConfigRepository")) : class$com$ibm$websphere$management$repository$ConfigRepository);
            Boolean bl = new Boolean(string != null);
            Object obj = constructor.newInstance(bl, this);
            this.addListener((ConfigRepositoryListener)obj);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.repository.FileRepository.initialize", (String)"225", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMR0118E", (Object)throwable);
        }
        this.locks = new HashSet();
        FileDocument.setRepository(this);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    public Properties getConfig() {
        return (Properties)this.configProperties.clone();
    }

    private void processProps(Properties properties) throws AdminException {
        String string;
        String string2;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processProps");
        }
        properties = properties == null ? new Properties() : (Properties)properties.clone();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"repository props:", (Object)properties);
        }
        this.configProperties = properties;
        this.repositoryDir = System.getProperty("was.repository.root");
        if (this.repositoryDir == null) {
            this.repositoryDir = properties.getProperty("was.repository.root");
            if (this.repositoryDir == null) {
                object = System.getProperty("user.install.root");
                if (object != null && !((String)object).equals("")) {
                    this.repositoryDir = (String)object + File.separator + "config";
                } else {
                    object = properties.getProperty("user.install.root");
                    if (object != null && !((String)object).equals("")) {
                        this.repositoryDir = (String)object + File.separator + "config";
                    }
                }
                if (this.repositoryDir == null) {
                    object = System.getProperty("was.install.root");
                    if (object != null && !((String)object).equals("")) {
                        this.repositoryDir = (String)object + File.separator + "config";
                    } else {
                        object = properties.getProperty("was.install.root");
                        if (object != null && !((String)object).equals("")) {
                            this.repositoryDir = (String)object + File.separator + "config";
                        }
                    }
                }
            }
        }
        if (this.repositoryDir == null) {
            Tr.error((TraceComponent)tc, (String)"ADMR0001E");
            throw new AdminException("Neither was.repository.root nor was.install.root are set");
        }
        object = new File(this.repositoryDir);
        if (!((File)object).isDirectory()) {
            Tr.error((TraceComponent)tc, (String)"ADMR0001E");
            throw new AdminException("repositoryDir " + this.repositoryDir + " is not a valid directory");
        }
        try {
            this.repositoryDir = ((File)object).getCanonicalPath();
        }
        catch (IOException iOException) {
            Tr.error((TraceComponent)tc, (String)"ADMR0001E");
            throw new AdminException("repositoryDir " + this.repositoryDir + " is not a valid directory");
        }
        String string3 = System.getProperty("was.repository.temp");
        if (string3 == null) {
            string3 = properties.getProperty("was.repository.temp");
        }
        if (string3 != null) {
            object = new File(string3);
            try {
                string2 = ((File)object).getCanonicalPath();
                if (string2.startsWith(this.repositoryDir + File.separator) && !string2.equals(this.repositoryDir + File.separator + "temp")) {
                    Tr.warning((TraceComponent)tc, (String)"ADMR0014W", (Object)string3);
                    string3 = null;
                }
            }
            catch (IOException iOException) {
                Tr.warning((TraceComponent)tc, (String)"ADMR0014W", (Object)string3);
                string3 = null;
            }
        }
        this.tempDir = string3 != null ? string3 : this.repositoryDir + File.separator + "temp";
        object = new File(this.tempDir);
        if (((File)object).exists()) {
            if (!((File)object).isDirectory()) {
                Tr.warning((TraceComponent)tc, (String)"ADMR0014W", (Object)this.tempDir);
                this.tempDir = this.repositoryDir + File.separator + "temp";
            }
        } else if (!((File)object).mkdirs()) {
            Tr.warning((TraceComponent)tc, (String)"ADMR0014W", (Object)this.tempDir);
            this.tempDir = this.repositoryDir + File.separator + "temp";
        }
        try {
            object = new File(this.tempDir);
            this.tempDir = ((File)object).getCanonicalPath();
        }
        catch (IOException iOException) {
            this.tempDir = this.repositoryDir + File.separator + "temp";
        }
        string2 = System.getProperty("was.repository.backup");
        if (string2 == null) {
            string2 = properties.getProperty("was.repository.backup");
        }
        if (string2 != null) {
            object = new File(string2);
            try {
                String string4 = ((File)object).getCanonicalPath();
                if (string4.startsWith(this.repositoryDir + File.separator) && !string4.equals(this.repositoryDir + File.separator + "backup")) {
                    Tr.warning((TraceComponent)tc, (String)"ADMR0013W", (Object)string2);
                    string2 = null;
                }
            }
            catch (IOException iOException) {
                Tr.warning((TraceComponent)tc, (String)"ADMR0013W", (Object)string2);
                string2 = null;
            }
        }
        this.backupDir = string2 != null ? string2 : this.repositoryDir + File.separator + "backup";
        object = new File(this.backupDir);
        if (((File)object).exists()) {
            if (!((File)object).isDirectory()) {
                this.backupDir = this.repositoryDir + File.separator + "backup";
            }
        } else if (!((File)object).mkdirs()) {
            this.backupDir = this.repositoryDir + File.separator + "backup";
        }
        try {
            object = new File(this.backupDir);
            this.backupDir = ((File)object).getCanonicalPath();
        }
        catch (IOException iOException) {
            this.backupDir = this.repositoryDir + File.separator + "backup";
        }
        this.tempDirectory = new File(this.tempDir);
        this.backupDirectory = new File(this.backupDir);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("repositoryDir = " + this.repositoryDir));
            Tr.debug((TraceComponent)tc, (String)("tempDir = " + this.tempDir));
            Tr.debug((TraceComponent)tc, (String)("backupDir = " + this.backupDir));
        }
        this.tempDir = this.tempDir + File.separator;
        System.setProperty("was.repository.temp", this.tempDir);
        this.configProperties.setProperty("was.repository.root", this.repositoryDir);
        this.configProperties.setProperty("was.repository.temp", this.tempDir);
        this.configProperties.setProperty("was.repository.backup", this.backupDir);
        if (properties.containsKey("transfer.compression")) {
            boolean bl = false;
            try {
                bl = Boolean.valueOf((String)properties.get("transfer.compression"));
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.repository.FileRepository.initialize", (String)"236", (Object)this);
            }
            this.ftOptions.setCompress(bl);
        }
        this.ftOptions.setDeleteSourceOnCompletion(true);
        this.ftOptions.setOverwrite(true);
        try {
            this.ftConfig = (FileTransferConfig)this.configProperties.get("fileTransferConfig");
            if (this.ftConfig == null) {
                this.ftConfig = new FileTransferConfigImpl();
                this.ftConfig.getProperties().setProperty("port", "9090");
                this.ftConfig.getProperties().setProperty("secure_port", "9043");
                this.ftConfig.setSecurityEnabled(false);
                if (this.inServer) {
                    this.ftConfig.getProperties().setProperty("host", AdminHelper.getInstance().getLocalHost().getHostAddress());
                } else {
                    this.ftConfig.getProperties().setProperty("host", InetAddress.getLocalHost().getHostAddress());
                }
            }
        }
        catch (UnknownHostException unknownHostException) {
            FFDCFilter.processException((Throwable)unknownHostException, (String)"com.ibm.ws.management.repository.FileRepository.initialize", (String)"252", (Object)this);
            this.ftConfig.getProperties().setProperty("host", "localhost");
        }
        String string5 = properties.getProperty("auditingEnabled");
        if (string5 != null) {
            this.auditingEnabled = string5.equalsIgnoreCase("true");
        }
        if ((string = System.getProperty("allowConfigOverwrites")) != null && string.equals("false")) {
            if (!this.processType.equals("NodeAgent")) {
                this.allowOverwrites = false;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Overwrites are disabled.");
                }
            } else {
                Tr.warning((TraceComponent)tc, (String)"The document overwrite feature may not be disabled in the node agent process.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processProps");
        }
    }

    public FileTransferOptions getFileTransferOptions() {
        return this.ftOptions;
    }

    public FileTransferConfig getFileTransferConfig() {
        return this.ftConfig;
    }

    public void setFileTransferConfig(FileTransferConfig fileTransferConfig) {
        this.ftConfig = fileTransferConfig;
        FileDocument.setRepository(this);
    }

    public String getTempDir() {
        return this.tempDir;
    }

    public String getBackupDir() {
        return this.backupDir;
    }

    public DocumentDigest create(DocumentContentSource documentContentSource) throws RepositoryException {
        DocumentContentSource[] documentContentSourceArray = new DocumentContentSource[]{documentContentSource};
        DocumentDigest[] documentDigestArray = this.create(documentContentSourceArray);
        return documentDigestArray[0];
    }

    public DocumentDigest[] create(DocumentContentSource[] documentContentSourceArray) throws RepositoryException {
        HashMap hashMap = this.update(documentContentSourceArray, null, null);
        DocumentDigest[] documentDigestArray = new DocumentDigest[documentContentSourceArray.length];
        for (int i = 0; i < documentContentSourceArray.length; ++i) {
            documentDigestArray[i] = (DocumentDigest)hashMap.get(documentContentSourceArray[i].getDocument().getURI());
        }
        return documentDigestArray;
    }

    private synchronized void preCreate(DocumentContentSource[] documentContentSourceArray) throws RepositoryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"preCreate", (Object)documentContentSourceArray);
        }
        int n = 0;
        try {
            for (n = 0; n < documentContentSourceArray.length; ++n) {
                String string = documentContentSourceArray[n].getDocument().getURI();
                this.checkAccessPermission(string, 1);
                this.lockDocument(string);
                if (this.status(string) == 2) continue;
                this.clearSource(documentContentSourceArray);
                this.unlockDocument(string);
                Tr.service((TraceComponent)tc, (String)"ADMR0000E", (Object)string);
                throw new DocumentAlreadyExistsException(string);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.repository.FileRepository.preCreate", (String)"536", (Object)this);
            for (int i = 0; i < n; ++i) {
                try {
                    this.unlockDocument(documentContentSourceArray[i].getDocument().getURI());
                    continue;
                }
                catch (Throwable throwable2) {
                    Tr.warning((TraceComponent)tc, (String)"ADMR0107E", (Object)new Object[]{documentContentSourceArray[i].getDocument().getURI(), throwable2});
                }
            }
            throw this.getRepositoryException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"preCreate", (Object)documentContentSourceArray);
        }
    }

    private DocumentDigest[] createInternal(DocumentContentSource[] documentContentSourceArray) throws RepositoryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createInternal");
        }
        DocumentDigest[] documentDigestArray = new DocumentDigest[documentContentSourceArray.length];
        int n = 0;
        try {
            for (n = 0; n < documentContentSourceArray.length; ++n) {
                String string = documentContentSourceArray[n].getDocument().getURI();
                documentDigestArray[n] = FileDocument.create(documentContentSourceArray[n]);
            }
        }
        catch (Throwable throwable) {
            int n2;
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.repository.FileRepository.createInternal", (String)"579", (Object)this);
            for (n2 = 0; n2 < n; ++n2) {
                try {
                    FileDocument.delete(documentContentSourceArray[n2].getDocument().getURI());
                    continue;
                }
                catch (Throwable throwable2) {
                    Tr.warning((TraceComponent)tc, (String)"ADMR0113E", (Object)new Object[]{documentContentSourceArray[n2].getDocument().getURI(), throwable2});
                }
            }
            while (n2 < documentContentSourceArray.length) {
                this.clearSource(documentContentSourceArray[n2]);
                ++n2;
            }
            throw this.getRepositoryException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createInternal");
        }
        return documentDigestArray;
    }

    private void postCreate(DocumentContentSource[] documentContentSourceArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"postCreate");
        }
        for (int i = 0; i < documentContentSourceArray.length; ++i) {
            String string = documentContentSourceArray[i].getDocument().getURI();
            try {
                this.unlockDocument(string);
                continue;
            }
            catch (Throwable throwable) {
                Tr.warning((TraceComponent)tc, (String)"ADMR0107E", (Object)new Object[]{string, throwable});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"postCreate");
        }
    }

    private void undoCreate(DocumentContentSource[] documentContentSourceArray) {
        for (int i = 0; i < documentContentSourceArray.length; ++i) {
            try {
                FileDocument.delete(documentContentSourceArray[i].getDocument().getURI());
                continue;
            }
            catch (Throwable throwable) {
                Tr.warning((TraceComponent)tc, (String)"ADMR0113E", (Object)new Object[]{documentContentSourceArray[i].getDocument().getURI(), throwable});
            }
        }
    }

    public void delete(Document document) throws RepositoryException {
        Document[] documentArray = new Document[]{document};
        this.delete(documentArray);
    }

    public void delete(String string) throws RepositoryException {
        this.delete(new Document(string));
    }

    public void delete(Document[] documentArray) throws RepositoryException {
        this.update(null, null, documentArray);
    }

    public void delete(String[] stringArray) throws RepositoryException {
        Document[] documentArray = new Document[stringArray.length];
        for (int i = 0; i < documentArray.length; ++i) {
            documentArray[i] = new Document(stringArray[i]);
        }
        this.delete(documentArray);
    }

    private synchronized void preDelete(Document[] documentArray) throws RepositoryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"preDelete");
        }
        int n = 0;
        try {
            for (n = 0; n < documentArray.length; ++n) {
                this.checkAccessPermission(documentArray[n].getURI(), 1);
                this.lockDocument(documentArray[n].getURI());
                int n2 = this.status(documentArray[n].getURI());
                if (n2 == 2) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("invalid URI " + documentArray[n].getURI()));
                    }
                    this.unlockDocument(documentArray[n].getURI());
                    throw new DocumentNotFoundException(documentArray[n].getURI());
                }
                try {
                    FileDocument.backup(documentArray[n].getURI());
                    continue;
                }
                catch (Throwable throwable) {
                    this.unlockDocument(documentArray[n].getURI());
                    throw throwable;
                }
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.repository.FileRepository.preDelete", (String)"711", (Object)this);
            for (int i = 0; i < n; ++i) {
                try {
                    FileDocument.removeBackup(documentArray[i].getURI());
                }
                catch (Throwable throwable2) {
                    Tr.warning((TraceComponent)tc, (String)"ADMR0110W", (Object)new Object[]{documentArray[i].getURI(), throwable2});
                }
                try {
                    this.unlockDocument(documentArray[i].getURI());
                    continue;
                }
                catch (Throwable throwable3) {
                    Tr.warning((TraceComponent)tc, (String)"ADMR0107E", (Object)new Object[]{documentArray[i].getURI(), throwable3});
                }
            }
            throw this.getRepositoryException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkExistenceAndLock");
        }
    }

    private void deleteInternal(Document[] documentArray) throws RepositoryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"deleteInternal");
        }
        int n = 0;
        try {
            for (n = 0; n < documentArray.length; ++n) {
                FileDocument.delete(documentArray[n].getURI());
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.repository.FileRepository.deleteInternal", (String)"852", (Object)this);
            for (int i = 0; i < n; ++i) {
                try {
                    FileDocument.restore(documentArray[i].getURI());
                    continue;
                }
                catch (Throwable throwable2) {
                    Tr.error((TraceComponent)tc, (String)"ADMR0109E", (Object)new Object[]{documentArray[i].getURI(), throwable2});
                }
            }
            Tr.error((TraceComponent)tc, (String)"ADMR0111E", (Object)documentArray[n].getURI());
            throw this.getRepositoryException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"deleteInternal");
        }
    }

    private void postDelete(Document[] documentArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"postDelete");
        }
        for (int i = 0; i < documentArray.length; ++i) {
            try {
                FileDocument.removeBackup(documentArray[i].getURI());
            }
            catch (Throwable throwable) {
                Tr.warning((TraceComponent)tc, (String)"ADMR0110W", (Object)new Object[]{documentArray[i].getURI(), throwable});
            }
            try {
                this.unlockDocument(documentArray[i].getURI());
                continue;
            }
            catch (Throwable throwable) {
                Tr.warning((TraceComponent)tc, (String)"ADMR0107E", (Object)new Object[]{documentArray[i].getURI(), throwable});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"postDelete");
        }
    }

    public void rename(String string, String string2) throws RepositoryException {
        this.rename(new Document(string), new Document(string2));
    }

    public void rename(Document document, Document document2) throws RepositoryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"rename");
        }
        DocumentContentSource[] documentContentSourceArray = new DocumentContentSource[]{this.extract(document)};
        documentContentSourceArray[0].getDocument().setURI(document2.getURI());
        Document[] documentArray = new Document[]{document};
        this.update(documentContentSourceArray, null, documentArray);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"rename");
        }
    }

    public DocumentContentSource extract(String string) throws RepositoryException {
        return this.extract(new Document(string));
    }

    public DocumentContentSource extract(Document document) throws RepositoryException {
        Document[] documentArray = new Document[]{document};
        DocumentContentSource[] documentContentSourceArray = this.extract(documentArray);
        return documentContentSourceArray[0];
    }

    public DocumentContentSource[] extract(String[] stringArray) throws RepositoryException {
        Document[] documentArray = new Document[stringArray.length];
        for (int i = 0; i < documentArray.length; ++i) {
            documentArray[i] = new Document(stringArray[i]);
        }
        return this.extract(documentArray);
    }

    public DocumentContentSource[] extract(Document[] documentArray) throws RepositoryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"extract[]");
        }
        if (documentArray == null) {
            return new DocumentContentSource[0];
        }
        this.fixURIs(documentArray);
        this.checkInvocationPermission(0);
        DocumentContentSource[] documentContentSourceArray = this.extractInternal(documentArray);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"extract[]");
        }
        return documentContentSourceArray;
    }

    private DocumentContentSource[] extractInternal(Document[] documentArray) throws RepositoryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"extractInternal");
        }
        DocumentContentSource[] documentContentSourceArray = new DocumentContentSource[documentArray.length];
        for (int i = 0; i < documentArray.length; ++i) {
            this.checkAccessPermission(documentArray[i].getURI(), 0);
            int n = this.status(documentArray[i].getURI());
            if (n == 2) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("extract: invalid URI; " + documentArray[i].getURI()));
                }
                throw new DocumentNotFoundException(documentArray[i].getURI());
            }
            if (n == 1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("extract: unavailable URI; " + documentArray[i].getURI()));
                }
                throw new DocumentUnavailableException(documentArray[i].getURI());
            }
            documentContentSourceArray[i] = FileDocument.read(documentArray[i].getURI());
            if (!tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("Extracted " + documentArray[i].getURI() + "; digest is " + documentContentSourceArray[i].getDocument().getDigest()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"extractInternal");
        }
        return documentContentSourceArray;
    }

    public DocumentContentSource extract(String string, String string2) {
        throw new UnsupportedOperationException();
    }

    public DocumentContentSource[] extract(String[] stringArray, String[] stringArray2) {
        throw new UnsupportedOperationException();
    }

    public DocumentDigest modify(DocumentContentSource documentContentSource) throws RepositoryException {
        DocumentContentSource[] documentContentSourceArray = new DocumentContentSource[]{documentContentSource};
        DocumentDigest[] documentDigestArray = this.modify(documentContentSourceArray);
        return documentDigestArray[0];
    }

    public DocumentDigest[] modify(DocumentContentSource[] documentContentSourceArray) throws RepositoryException {
        HashMap hashMap = this.update(null, documentContentSourceArray, null);
        DocumentDigest[] documentDigestArray = new DocumentDigest[documentContentSourceArray.length];
        for (int i = 0; i < documentContentSourceArray.length; ++i) {
            documentDigestArray[i] = (DocumentDigest)hashMap.get(documentContentSourceArray[i].getDocument().getURI());
        }
        return documentDigestArray;
    }

    private synchronized void preModify(DocumentContentSource[] documentContentSourceArray) throws RepositoryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"preModify");
        }
        int n = 0;
        try {
            for (n = 0; n < documentContentSourceArray.length; ++n) {
                Document document = documentContentSourceArray[n].getDocument();
                this.checkAccessPermission(document.getURI(), 1);
                this.lockDocument(document.getURI());
                int n2 = this.status(document.getURI());
                if (n2 == 2) {
                    this.clearSource(documentContentSourceArray);
                    this.unlockDocument(document.getURI());
                    throw new DocumentNotFoundException(document.getURI());
                }
                try {
                    this.checkDigest(document);
                    FileDocument.backup(document.getURI());
                    continue;
                }
                catch (Throwable throwable) {
                    this.unlockDocument(document.getURI());
                    throw throwable;
                }
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.repository.FileRepository.preModify", (String)"1009", (Object)this);
            for (int i = 0; i < n; ++i) {
                try {
                    FileDocument.removeBackup(documentContentSourceArray[i].getDocument().getURI());
                }
                catch (Throwable throwable2) {
                    Tr.warning((TraceComponent)tc, (String)"ADMR0110W", (Object)new Object[]{documentContentSourceArray[i].getDocument().getURI(), throwable2});
                }
                try {
                    this.unlockDocument(documentContentSourceArray[i].getDocument().getURI());
                    continue;
                }
                catch (Throwable throwable3) {
                    Tr.warning((TraceComponent)tc, (String)"ADMR0107E", (Object)new Object[]{documentContentSourceArray[i].getDocument().getURI(), throwable3});
                }
            }
            throw this.getRepositoryException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"preModify");
        }
    }

    private DocumentDigest[] modifyInternal(DocumentContentSource[] documentContentSourceArray) throws RepositoryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"modifyInternal");
        }
        DocumentDigest[] documentDigestArray = new DocumentDigest[documentContentSourceArray.length];
        int n = 0;
        try {
            for (n = 0; n < documentContentSourceArray.length; ++n) {
                documentDigestArray[n] = FileDocument.write(documentContentSourceArray[n]);
            }
        }
        catch (Throwable throwable) {
            int n2;
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.repository.FileRepository.modifyInternal", (String)"1061", (Object)this);
            for (n2 = 0; n2 < n; ++n2) {
                try {
                    FileDocument.restore(documentContentSourceArray[n2].getDocument().getURI());
                    continue;
                }
                catch (Throwable throwable2) {
                    Tr.error((TraceComponent)tc, (String)"ADMR0109E", (Object)new Object[]{documentContentSourceArray[n2].getDocument().getURI(), throwable2});
                }
            }
            while (n2 < documentContentSourceArray.length) {
                this.clearSource(documentContentSourceArray[n2]);
                ++n2;
            }
            throw this.getRepositoryException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"modifyInternal");
        }
        return documentDigestArray;
    }

    private void postModify(DocumentContentSource[] documentContentSourceArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"postModify");
        }
        for (int i = 0; i < documentContentSourceArray.length; ++i) {
            String string = documentContentSourceArray[i].getDocument().getURI();
            try {
                FileDocument.removeBackup(string);
            }
            catch (Throwable throwable) {
                Tr.warning((TraceComponent)tc, (String)"ADMR0110W", (Object)new Object[]{string, throwable});
            }
            try {
                this.unlockDocument(string);
                continue;
            }
            catch (Throwable throwable) {
                Tr.warning((TraceComponent)tc, (String)"ADMR0107E", (Object)new Object[]{string, throwable});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"postModify");
        }
    }

    private void undoModify(DocumentContentSource[] documentContentSourceArray) {
        for (int i = 0; i < documentContentSourceArray.length; ++i) {
            try {
                FileDocument.restore(documentContentSourceArray[i].getDocument().getURI());
                continue;
            }
            catch (Throwable throwable) {
                Tr.warning((TraceComponent)tc, (String)"ADMR0109E", (Object)new Object[]{documentContentSourceArray[i].getDocument().getURI(), throwable});
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap update(DocumentContentSource[] documentContentSourceArray, DocumentContentSource[] documentContentSourceArray2, Document[] documentArray) throws RepositoryException {
        ConfigRepositoryEvent configRepositoryEvent;
        HashMap hashMap;
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"update");
            }
            if (documentContentSourceArray == null) {
                documentContentSourceArray = new DocumentContentSource[]{};
            }
            if (documentContentSourceArray2 == null) {
                documentContentSourceArray2 = new DocumentContentSource[]{};
            }
            if (documentArray == null) {
                documentArray = new Document[]{};
            }
            this.fixURIs(documentContentSourceArray);
            this.fixURIs(documentContentSourceArray2);
            this.fixURIs(documentArray);
            hashMap = null;
            this.checkInvocationPermission(1);
            this.preUpdate(documentContentSourceArray, documentContentSourceArray2, documentArray);
            configRepositoryEvent = this.preNotify(documentContentSourceArray, documentContentSourceArray2, documentArray);
            try {
                hashMap = this.updateInternal(documentContentSourceArray, documentContentSourceArray2, documentArray);
                Object var8_6 = null;
                this.postUpdate(documentContentSourceArray, documentContentSourceArray2, documentArray);
                if (hashMap == null) break block12;
                this.updateRepositoryEpoch();
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                this.postUpdate(documentContentSourceArray, documentContentSourceArray2, documentArray);
                if (hashMap != null) {
                    this.updateRepositoryEpoch();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Repository epoch updated");
                    }
                }
                this.postNotify(configRepositoryEvent, hashMap != null);
                throw throwable;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Repository epoch updated");
            }
        }
        this.postNotify(configRepositoryEvent, hashMap != null);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"update", (Object)hashMap);
        }
        return hashMap;
    }

    private synchronized void preUpdate(DocumentContentSource[] documentContentSourceArray, DocumentContentSource[] documentContentSourceArray2, Document[] documentArray) throws RepositoryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"preUpdate");
        }
        this.preCreate(documentContentSourceArray);
        try {
            this.preModify(documentContentSourceArray2);
            try {
                this.preDelete(documentArray);
            }
            catch (RepositoryException repositoryException) {
                this.postModify(documentContentSourceArray2);
                throw repositoryException;
            }
        }
        catch (RepositoryException repositoryException) {
            this.postCreate(documentContentSourceArray);
            throw repositoryException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"preUpdate");
        }
    }

    private HashMap updateInternal(DocumentContentSource[] documentContentSourceArray, DocumentContentSource[] documentContentSourceArray2, Document[] documentArray) throws RepositoryException {
        HashMap<String, DocumentDigest> hashMap = null;
        DocumentDigest[] documentDigestArray = null;
        DocumentDigest[] documentDigestArray2 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            int n;
            documentDigestArray = this.createInternal(documentContentSourceArray);
            bl = true;
            documentDigestArray2 = this.modifyInternal(documentContentSourceArray2);
            bl2 = true;
            this.deleteInternal(documentArray);
            hashMap = new HashMap<String, DocumentDigest>();
            for (n = 0; n < documentContentSourceArray.length; ++n) {
                hashMap.put(documentContentSourceArray[n].getDocument().getURI(), documentDigestArray[n]);
            }
            for (n = 0; n < documentContentSourceArray2.length; ++n) {
                hashMap.put(documentContentSourceArray2[n].getDocument().getURI(), documentDigestArray2[n]);
            }
        }
        catch (RepositoryException repositoryException) {
            if (bl) {
                this.undoCreate(documentContentSourceArray);
            }
            if (bl2) {
                this.undoModify(documentContentSourceArray2);
            }
            throw repositoryException;
        }
        return hashMap;
    }

    private void postUpdate(DocumentContentSource[] documentContentSourceArray, DocumentContentSource[] documentContentSourceArray2, Document[] documentArray) {
        this.postCreate(documentContentSourceArray);
        this.postModify(documentContentSourceArray2);
        this.postDelete(documentArray);
    }

    public DocumentDigest getDigest(String string) throws DocumentNotFoundException, DocumentIOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getDigest: " + string));
        }
        if (this.status(string) == 2) {
            throw new DocumentNotFoundException(string);
        }
        DocumentDigestImpl documentDigestImpl = FileDocument.getDigest(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getDigest");
        }
        return documentDigestImpl;
    }

    public DocumentDigest[] getDigest(String[] stringArray) throws DocumentNotFoundException, DocumentIOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getDigest[]");
        }
        DocumentDigest[] documentDigestArray = new DocumentDigest[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            documentDigestArray[i] = this.getDigest(stringArray[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getDigest[]");
        }
        return documentDigestArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean lockRepository(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"lockRepository");
        }
        if (this.repositoryLocked) {
            return Boolean.FALSE;
        }
        boolean bl = false;
        for (int i = 0; !bl && i < 20; ++i) {
            bl = this.lockRepository();
            if (bl) continue;
            this.sleep(500L);
        }
        if (bl) {
            Tr.service((TraceComponent)tc, (String)"ADMR0007I", (Object)string);
            ArrayList arrayList = this.listeners;
            synchronized (arrayList) {
                for (int i = 0; i < this.listeners.size(); ++i) {
                    ConfigRepositoryListener configRepositoryListener = (ConfigRepositoryListener)this.listeners.get(i);
                    try {
                        configRepositoryListener.onRepositoryLock();
                        continue;
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.repository.FileRepository.lockRepository", (String)"1519", (Object)this);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"lockRepository", (Object)(bl ? Boolean.TRUE : Boolean.FALSE));
        }
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean lockRepository() {
        boolean bl = false;
        HashSet hashSet = this.locks;
        synchronized (hashSet) {
            if (this.locks.isEmpty() && !this.repositoryLocked) {
                this.repositoryLocked = true;
                bl = true;
            }
        }
        return bl;
    }

    private void sleep(long l) {
        try {
            Thread.currentThread();
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean unlockRepository(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"unlockRepository");
        }
        boolean bl = false;
        AbstractCollection abstractCollection = this.locks;
        synchronized (abstractCollection) {
            if (this.repositoryLocked) {
                this.repositoryLocked = false;
                bl = true;
            }
        }
        if (bl) {
            Tr.service((TraceComponent)tc, (String)"ADMR0008I", (Object)string);
            abstractCollection = this.listeners;
            synchronized (abstractCollection) {
                for (int i = 0; i < this.listeners.size(); ++i) {
                    ConfigRepositoryListener configRepositoryListener = (ConfigRepositoryListener)this.listeners.get(i);
                    try {
                        configRepositoryListener.onRepositoryUnlock();
                        continue;
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.repository.FileRepository.unlockRepository", (String)"1594", (Object)this);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"unlockRepository", (Object)(bl ? Boolean.TRUE : Boolean.FALSE));
        }
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public String getRepositoryDir() {
        return this.repositoryDir;
    }

    private boolean exists(String string) {
        File file = new File(this.getRepositoryDir() + "/" + string.replace('\\', '/'));
        return file.exists();
    }

    private int status(String string) {
        int n = 2;
        if (this.exists(string)) {
            n = 0;
        } else if (this.exists(string + ".digest")) {
            n = 1;
        }
        return n;
    }

    private void clearSource(DocumentContentSource documentContentSource) {
        block3: {
            try {
                if (documentContentSource != null && documentContentSource.getSource() != null) {
                    documentContentSource.getSource().close();
                    documentContentSource.setSource((InputStream)null);
                }
            }
            catch (IOException iOException) {
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)("clearSource error " + iOException.getMessage()));
            }
        }
    }

    private void clearSource(DocumentContentSource[] documentContentSourceArray) {
        if (documentContentSourceArray != null) {
            for (int i = 0; i < documentContentSourceArray.length; ++i) {
                this.clearSource(documentContentSourceArray[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockDocument(String string) throws DocumentLockedException, RepositoryLockedException {
        if (this.repositoryLocked) {
            throw new RepositoryLockedException();
        }
        boolean bl = false;
        for (int i = 0; !bl && i < 20; ++i) {
            HashSet hashSet = this.locks;
            synchronized (hashSet) {
                bl = this.locks.add(string);
            }
            if (bl) continue;
            this.sleep(500L);
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Locked " + string));
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(string + " already locked"));
            }
            throw new DocumentLockedException(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlockDocument(String string) {
        boolean bl;
        HashSet hashSet = this.locks;
        synchronized (hashSet) {
            bl = this.locks.remove(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Unlocked " + string + "; " + bl));
        }
    }

    private void unlockDocument(Document document) {
        this.unlockDocument(document.getURI());
    }

    private void checkDigest(Document document) throws DocumentIOException, DocumentChangedException {
        DocumentDigestImpl documentDigestImpl = FileDocument.getDigest(document.getURI());
        if (!((Object)documentDigestImpl).equals(document.getDigest())) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Digest check failed.  Given digest is " + document.getDigest() + "; current digest is " + documentDigestImpl));
            }
            if (!this.allowOverwrites || !document.getOverwrite()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("modify " + document.getURI() + "; digest check"));
                }
                throw new DocumentChangedException(document.getURI());
            }
            if (!this.processType.equals("NodeAgent")) {
                Tr.warning((TraceComponent)tc, (String)"ADMR0114W", (Object)document.getURI());
            }
        }
    }

    private RepositoryException getRepositoryException(Throwable throwable) {
        RepositoryException repositoryException = null;
        repositoryException = throwable instanceof RepositoryException ? (RepositoryException)((Object)throwable) : new RepositoryException(throwable);
        return repositoryException;
    }

    private void fixURIs(DocumentContentSource[] documentContentSourceArray) {
        for (int i = 0; i < documentContentSourceArray.length; ++i) {
            documentContentSourceArray[i].getDocument().setURI(documentContentSourceArray[i].getDocument().getURI().replace('\\', '/'));
        }
    }

    private void fixURIs(Document[] documentArray) {
        for (int i = 0; i < documentArray.length; ++i) {
            documentArray[i].setURI(documentArray[i].getURI().replace('\\', '/'));
        }
    }

    private void audit(ConfigRepositoryEvent configRepositoryEvent) {
        String string = null;
        String string2 = null;
        Object[] objectArray = null;
        if (this.auditingEnabled) {
            string2 = SecurityHelper.getUserName();
            ConfigChangeNotifier[] configChangeNotifierArray = configRepositoryEvent.getChanges();
            for (int i = 0; i < configChangeNotifierArray.length; ++i) {
                string = configChangeNotifierArray[i].getChangeType() == 0 ? (string2 == null ? "ADMR0009I" : "ADMR0015I") : (configChangeNotifierArray[i].getChangeType() == 2 ? (string2 == null ? "ADMR0010I" : "ADMR0016I") : (string2 == null ? "ADMR0011I" : "ADMR0017I"));
                objectArray = string2 == null ? new Object[]{configChangeNotifierArray[i].getUri()} : new Object[]{configChangeNotifierArray[i].getUri(), string2};
                Tr.audit((TraceComponent)tc, (String)string, (Object)objectArray);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigRepositoryEvent preNotify(DocumentContentSource[] documentContentSourceArray, DocumentContentSource[] documentContentSourceArray2, Document[] documentArray) {
        int n;
        ConfigChangeNotifier[] configChangeNotifierArray = new ConfigChangeNotifier[documentContentSourceArray.length + documentContentSourceArray2.length + documentArray.length];
        int n2 = 0;
        for (n = 0; n < documentContentSourceArray.length; ++n) {
            configChangeNotifierArray[n2++] = new ConfigChangeNotifier(documentContentSourceArray[n].getDocument().getURI(), 0);
        }
        for (n = 0; n < documentContentSourceArray2.length; ++n) {
            configChangeNotifierArray[n2++] = new ConfigChangeNotifier(documentContentSourceArray2[n].getDocument().getURI(), 2);
        }
        for (n = 0; n < documentArray.length; ++n) {
            configChangeNotifierArray[n2++] = new ConfigChangeNotifier(documentArray[n].getURI(), 1);
        }
        ConfigRepositoryEvent configRepositoryEvent = new ConfigRepositoryEvent(this, ConfigRepositoryEvent.generateId(), configChangeNotifierArray);
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ConfigRepositoryListener configRepositoryListener = (ConfigRepositoryListener)this.listeners.get(i);
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Calling listener onChangeStart: " + configRepositoryListener));
                    }
                    configRepositoryListener.onChangeStart(configRepositoryEvent);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Back from listener onChangeStart: " + configRepositoryListener));
                    continue;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.repository.FileRepository.preNotify", (String)"1836", (Object)this);
                }
            }
        }
        return configRepositoryEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postNotify(ConfigRepositoryEvent configRepositoryEvent, boolean bl) {
        Object object;
        ConfigChangeNotifier[] configChangeNotifierArray;
        if (!bl) {
            configChangeNotifierArray = new ConfigChangeNotifier[]{};
            object = new ConfigRepositoryEvent(this, configRepositoryEvent.getId(), configChangeNotifierArray);
            configRepositoryEvent = object;
        }
        configChangeNotifierArray = this.listeners;
        synchronized (configChangeNotifierArray) {
            object = null;
            for (int i = 0; i < this.listeners.size(); ++i) {
                ConfigRepositoryListener configRepositoryListener = (ConfigRepositoryListener)this.listeners.get(i);
                try {
                    if (!configRepositoryListener.equals(this)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Calling listener onChangeCompletion: " + configRepositoryListener));
                        }
                        configRepositoryListener.onChangeCompletion(configRepositoryEvent);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("Back from listener onChangeCompletion: " + configRepositoryListener));
                        continue;
                    }
                    object = configRepositoryListener;
                    continue;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.repository.FileRepository.postNotify", (String)"1870", (Object)this);
                }
            }
            if (object != null) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Calling JMX listener onChangeCompletion: " + object));
                    }
                    object.onChangeCompletion(configRepositoryEvent);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Back from JMX listener onChangeCompletion: " + object));
                    }
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.repository.FileRepository.postNotify", (String)"1926", (Object)this);
                }
            }
        }
    }

    public String[] listResourceNames(String string, int n, int n2, ResourceNameFilter resourceNameFilter) {
        ResourceNameFilter resourceNameFilter2 = resourceNameFilter;
        if (resourceNameFilter2 == null) {
            resourceNameFilter2 = this;
        }
        File file = new File(this.getRepositoryDir() + "/" + string);
        if (this.status(string) == 2) {
            return new String[0];
        }
        if (n2 == 0) {
            if (resourceNameFilter2 == this) {
                if (resourceNameFilter2.accept(string, "") && this.isMatchingType(file, n)) {
                    return new String[]{string};
                }
                return new String[0];
            }
            if (this.accept(string, "") && resourceNameFilter2.accept(string, "") && this.isMatchingType(file, n)) {
                return new String[]{string};
            }
            return new String[0];
        }
        this.eliminateEmptyFolders(file);
        ArrayList arrayList = new ArrayList();
        if (file.list() != null) {
            this.addResourceNames(arrayList, file, n, n2 - 1, resourceNameFilter2);
        }
        if (arrayList.size() > 0) {
            String[] stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
            return stringArray;
        }
        return new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean eliminateEmptyFolders(File file) {
        boolean bl = true;
        if (file != null && file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray != null && fileArray.length > 0) {
                for (int i = 0; i < fileArray.length; ++i) {
                    if (this.eliminateEmptyFolders(fileArray[i])) continue;
                    bl = false;
                }
            }
            if (bl && !file.equals(this.tempDirectory) && !file.equals(this.backupDirectory)) {
                Object object = FileDocument.getDirLock();
                synchronized (object) {
                    if (file.delete()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Deleted empty folder " + this.getUri(file)));
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Unable to delete empty folder" + this.getUri(file)));
                    }
                }
            }
        } else {
            bl = false;
        }
        return bl;
    }

    protected void addResourceNames(ArrayList arrayList, File file, int n, int n2, ResourceNameFilter resourceNameFilter) {
        File[] fileArray = this.getFiles(file);
        if (fileArray != null && fileArray.length > 0) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (resourceNameFilter == this) {
                    if (resourceNameFilter.accept(this.getUri(file), fileArray[i].getName()) && this.isMatchingType(fileArray[i], n)) {
                        arrayList.add(this.getUri(fileArray[i]));
                    }
                } else if (this.accept(this.getUri(file), fileArray[i].getName()) && resourceNameFilter.accept(this.getUri(file), fileArray[i].getName()) && this.isMatchingType(fileArray[i], n)) {
                    arrayList.add(this.getUri(fileArray[i]));
                }
                if (n2 <= 0 || !fileArray[i].isDirectory()) continue;
                this.addResourceNames(arrayList, fileArray[i], n, n2 - 1, resourceNameFilter);
            }
        } else {
            this.removeEmptyFolder(arrayList, file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeEmptyFolder(ArrayList arrayList, File file) {
        if (!file.equals(this.tempDirectory) && !file.equals(this.backupDirectory)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Removing " + this.getUri(file)));
            }
            arrayList.remove(this.getUri(file));
            Object object = FileDocument.getDirLock();
            synchronized (object) {
                if (file.delete()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Deleted " + this.getUri(file)));
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Unable to delete " + this.getUri(file)));
                }
            }
            object = file.getParentFile();
            File[] fileArray = ((File)object).listFiles();
            if (fileArray.length <= 1) {
                this.removeEmptyFolder(arrayList, (File)object);
            }
        }
    }

    private File[] getFiles(File file) {
        Object object;
        File[] fileArray = file.listFiles();
        HashMap<Object, File> hashMap = new HashMap<Object, File>();
        for (int i = 0; i < fileArray.length; ++i) {
            String string = fileArray[i].getName();
            if (string.endsWith(".digest")) {
                object = string.substring(0, string.lastIndexOf(".digest"));
                hashMap.put(object, new File(file, (String)object));
                continue;
            }
            hashMap.put(string, fileArray[i]);
        }
        File[] fileArray2 = new File[hashMap.size()];
        int n = 0;
        object = hashMap.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry entry = object.next();
            fileArray2[n++] = (File)entry.getValue();
        }
        return fileArray2;
    }

    public String[] listResourceNames(String string, int n, int n2) {
        return this.listResourceNames(string, n, n2, this);
    }

    protected int getType(File file) {
        if (file.isDirectory()) {
            return 2;
        }
        return 1;
    }

    protected boolean isMatchingType(int n, int n2) {
        return (n & n2) != 0;
    }

    protected boolean isMatchingType(File file, int n) {
        int n2 = this.getType(file);
        return (n2 & n) != 0;
    }

    protected String getUri(File file) {
        String string = file.getAbsolutePath();
        if (string.length() <= this.getRepositoryDir().length()) {
            return "/";
        }
        return string.substring(this.getRepositoryDir().length() + 1).replace('\\', '/');
    }

    public boolean accept(String string, String string2) {
        boolean bl = true;
        if (string.equals("/")) {
            bl = !string2.equals("backup") && !string2.equals("temp");
        } else if (string.equals("backup") || string.startsWith("backup/") || string.equals("temp") || string.startsWith("temp/")) {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ConfigRepositoryListener configRepositoryListener) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Adding listener: " + configRepositoryListener));
        }
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            if (!this.listeners.contains(configRepositoryListener)) {
                this.listeners.add(configRepositoryListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ConfigRepositoryListener configRepositoryListener) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Removing listener: " + configRepositoryListener));
        }
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(configRepositoryListener);
        }
    }

    public ConfigEpoch getRepositoryEpoch() {
        return this.repositoryEpoch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigEpoch refreshRepositoryEpoch() {
        this.repositoryEpoch.refresh();
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ConfigRepositoryListener configRepositoryListener = (ConfigRepositoryListener)this.listeners.get(i);
                try {
                    configRepositoryListener.onRepositoryEpochRefresh();
                    continue;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.repository.FileRepository.refreshRepositoryEpoch", (String)"2091", (Object)this);
                }
            }
        }
        return this.repositoryEpoch;
    }

    private void updateRepositoryEpoch() {
        this.repositoryEpoch.update();
    }

    public void createDigestFile(String string, boolean bl) throws RepositoryException {
        string = string.replace('\\', '/');
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("createDigestFile: " + string));
        }
        this.lockDocument(string);
        String string2 = string + ".digest";
        try {
            this.lockDocument(string2);
        }
        catch (DocumentLockedException documentLockedException) {
            this.unlockDocument(string);
            throw documentLockedException;
        }
        try {
            int n = this.status(string);
            if (n == 2) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("createDigestFile: invalid URI " + string));
                }
                throw new DocumentNotFoundException(string);
            }
            if (n == 1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("createDigestFile: unavailable URI; " + string));
                }
                throw new DocumentUnavailableException(string);
            }
            FileDocument.createDigestFile(string, bl);
        }
        catch (RepositoryException repositoryException) {
            throw repositoryException;
        }
        finally {
            this.unlockDocument(string2);
            this.unlockDocument(string);
        }
    }

    public void onChangeCompletion(ConfigRepositoryEvent configRepositoryEvent) {
        if (this.inServer) {
            try {
                Notification notification = new Notification("websphere.repository.change", this.getObjectName(), System.currentTimeMillis());
                notification.setUserData(configRepositoryEvent);
                this.sendNotification(notification);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.repository.FileRepository.onChangeCompletion", (String)"1705", (Object)this);
            }
        }
        this.audit(configRepositoryEvent);
    }

    public void onChangeStart(ConfigRepositoryEvent configRepositoryEvent) {
    }

    public void onRepositoryLock() {
        if (this.inServer) {
            try {
                Notification notification = new Notification("websphere.repository.lock", this.getObjectName(), System.currentTimeMillis());
                this.sendNotification(notification);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.repository.FileRepository.onRepositoryLock", (String)"1742", (Object)this);
            }
        }
    }

    public void onRepositoryUnlock() {
        if (this.inServer) {
            try {
                Notification notification = new Notification("websphere.repository.unlock", this.getObjectName(), System.currentTimeMillis());
                this.sendNotification(notification);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.repository.FileRepository.onRepositoryUnlock", (String)"1762", (Object)this);
            }
        }
    }

    public void onRepositoryEpochRefresh() {
        if (this.inServer) {
            try {
                Notification notification = new Notification("websphere.repository.epoch.refresh", this.getObjectName(), System.currentTimeMillis());
                this.sendNotification(notification);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.repository.FileRepository.onRepositoryEpochRefresh", (String)"1954", (Object)this);
            }
        }
        Tr.audit((TraceComponent)tc, (String)"ADMR0012I");
    }

    private void checkAccessPermission(String string, int n) throws RepositoryException {
        RoleBasedAuthorizer roleBasedAuthorizer;
        boolean bl = n == 0 ? !RestrictedAccess.isReadable((String)string) : RestrictedAccess.isRestricted((String)string);
        if (this.inServer && bl && !(roleBasedAuthorizer = this.getAuthorizer()).isCallerInRole("administrator")) {
            Tr.audit((TraceComponent)tc, (String)"ADMR0021E", (Object)new Object[]{SecurityHelper.getUserName(), string});
            throw new RepositoryException("Caller is not in the required role to access restricted document: " + string);
        }
    }

    private void checkInvocationPermission(int n) throws RepositoryException {
        if (this.inServer && SecurityHelper.getHelper().isSecurityEnabled()) {
            String string = n == 0 ? "extract:java.lang.String" : "modify:com.ibm.websphere.management.repository.DocumentContentSource";
            RoleBasedAuthorizer roleBasedAuthorizer = this.getAuthorizer();
            if (!roleBasedAuthorizer.checkAccess("ConfigRepository", "ConfigRepository", string)) {
                String string2 = SecurityHelper.getUserName() + " is not in required role to ";
                string2 = n == 0 ? string2 + "read configuration data" : string2 + "update configuration data";
                throw new RepositoryException(string2);
            }
        }
    }

    private RoleBasedAuthorizer getAuthorizer() throws RepositoryException {
        RoleBasedAuthorizer roleBasedAuthorizer = null;
        try {
            roleBasedAuthorizer = SecurityHelper.getHelper().getConfigurator().getRoleBasedAuthorizer("admin-authz", "scope");
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.repository.FileRepository.getAuthorizer", (String)"2200", (Object)this);
            throw new RepositoryException(throwable, "Unable to get caller's security role");
        }
        return roleBasedAuthorizer;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

