/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.repository.client;

import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.exception.RepositoryException;
import com.ibm.websphere.management.filetransfer.FileTransferConfig;
import com.ibm.websphere.management.filetransfer.client.FileTransferClient;
import com.ibm.websphere.management.filetransfer.client.FileTransferOptions;
import com.ibm.websphere.management.filetransfer.client.FileUploadInputStream;
import com.ibm.websphere.management.filetransfer.client.TransferFailedException;
import com.ibm.websphere.management.repository.ConfigEpoch;
import com.ibm.websphere.management.repository.ConfigRepositoryListener;
import com.ibm.websphere.management.repository.Document;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.management.repository.DocumentDigest;
import com.ibm.websphere.management.repository.ResourceNameFilter;
import com.ibm.websphere.management.repository.client.ConfigRepositoryClient;
import com.ibm.ws.management.filetransfer.FileTransferConfigImpl;
import com.ibm.ws.management.util.Utils;
import com.ibm.ws.util.ImplFactory;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class JMXRemoteConfigRepositoryClient
implements ConfigRepositoryClient {
    AdminClient client = null;
    ObjectName repositoryObjectName = null;
    FileTransferClient ftclient;
    FileTransferOptions options;
    static /* synthetic */ Class class$com$ibm$websphere$management$filetransfer$client$FileTransferClient;
    static /* synthetic */ Class class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions;

    public void connect(Properties properties) throws ConnectorException {
        try {
            this.client = AdminClientFactory.createAdminClient(properties);
            this.repositoryObjectName = this.getRepositoryName();
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new ConnectorException(malformedObjectNameException);
        }
        catch (AdminException adminException) {
            throw new ConnectorException((Throwable)((Object)adminException));
        }
    }

    protected Object invoke(String string, String[] stringArray, Object[] objectArray) throws RepositoryException {
        return this.invokeMBean(this.repositoryObjectName, string, stringArray, objectArray);
    }

    protected Object invokeMBean(ObjectName objectName, String string, String[] stringArray, Object[] objectArray) throws RepositoryException {
        try {
            return this.client.invoke(objectName, string, objectArray, stringArray);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new RepositoryException(instanceNotFoundException);
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof RepositoryException) {
                throw (RepositoryException)((Object)exception);
            }
            throw new RepositoryException(mBeanException);
        }
        catch (ReflectionException reflectionException) {
            throw new RepositoryException(reflectionException);
        }
        catch (ConnectorException connectorException) {
            throw new RepositoryException((Throwable)((Object)connectorException));
        }
    }

    protected InputStream getUploadStream(Document document) {
        FileUploadInputStream fileUploadInputStream = new FileUploadInputStream();
        fileUploadInputStream.setDelete(true);
        fileUploadInputStream.setSrcPath(document.getTempName());
        return fileUploadInputStream;
    }

    public void initialize(Properties properties) throws AdminException {
        this.ftclient = (FileTransferClient)ImplFactory.loadImplFromKey((Class)(class$com$ibm$websphere$management$filetransfer$client$FileTransferClient == null ? (class$com$ibm$websphere$management$filetransfer$client$FileTransferClient = JMXRemoteConfigRepositoryClient.class$("com.ibm.websphere.management.filetransfer.client.FileTransferClient")) : class$com$ibm$websphere$management$filetransfer$client$FileTransferClient));
        FileTransferConfig fileTransferConfig = (FileTransferConfig)properties.get("fileTransferConfig");
        if (fileTransferConfig == null) {
            fileTransferConfig = this.getFileTransferConfig();
        }
        if (fileTransferConfig != null) {
            this.ftclient.setFileTransferConfig(fileTransferConfig);
        } else {
            fileTransferConfig = new FileTransferConfigImpl();
            Properties properties2 = fileTransferConfig.getProperties();
            properties2.setProperty("host", "localhost");
            properties2.setProperty("port", "9090");
            this.ftclient.setFileTransferConfig(fileTransferConfig);
        }
        this.options = (FileTransferOptions)ImplFactory.loadImplFromKey((Class)(class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions == null ? (class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions = JMXRemoteConfigRepositoryClient.class$("com.ibm.websphere.management.filetransfer.client.FileTransferOptions")) : class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions));
        this.options.setCompress(true);
        this.options.setOverwrite(true);
    }

    public DocumentDigest create(DocumentContentSource documentContentSource) throws RepositoryException {
        try {
            this.ftclient.uploadFile(documentContentSource.getSource(), documentContentSource.getDocument().getTempName(), this.options);
            documentContentSource.setSource(this.getUploadStream(documentContentSource.getDocument()));
        }
        catch (TransferFailedException transferFailedException) {
            throw new RepositoryException((Throwable)((Object)transferFailedException));
        }
        String string = "create";
        String[] stringArray = new String[]{"com.ibm.websphere.management.repository.DocumentContentSource"};
        Object[] objectArray = new Object[]{documentContentSource};
        return (DocumentDigest)this.invoke(string, stringArray, objectArray);
    }

    public DocumentDigest[] create(DocumentContentSource[] documentContentSourceArray) throws RepositoryException {
        for (int i = 0; i < documentContentSourceArray.length; ++i) {
            try {
                this.ftclient.uploadFile(documentContentSourceArray[i].getSource(), documentContentSourceArray[i].getDocument().getTempName(), this.options);
                documentContentSourceArray[i].setSource(this.getUploadStream(documentContentSourceArray[i].getDocument()));
                continue;
            }
            catch (TransferFailedException transferFailedException) {
                throw new RepositoryException((Throwable)((Object)transferFailedException));
            }
        }
        String string = "create";
        String[] stringArray = new String[]{"[Lcom.ibm.websphere.management.repository.DocumentContentSource;"};
        Object[] objectArray = new Object[]{documentContentSourceArray};
        return (DocumentDigest[])this.invoke(string, stringArray, objectArray);
    }

    public void delete(String string) throws RepositoryException {
        String string2 = "delete";
        String[] stringArray = new String[]{"java.lang.String"};
        Object[] objectArray = new Object[]{string};
        this.invoke(string2, stringArray, objectArray);
    }

    public void delete(Document document) throws RepositoryException {
        String string = "delete";
        String[] stringArray = new String[]{"com.ibm.websphere.management.repository.Document"};
        Object[] objectArray = new Object[]{document};
        this.invoke(string, stringArray, objectArray);
    }

    public void delete(String[] stringArray) throws RepositoryException {
        String string = "delete";
        String[] stringArray2 = new String[]{"[Ljava.lang.String;"};
        Object[] objectArray = new Object[]{stringArray};
        this.invoke(string, stringArray2, objectArray);
    }

    public void delete(Document[] documentArray) throws RepositoryException {
        String string = "delete";
        String[] stringArray = new String[]{"[Lcom.ibm.websphere.management.repository.Document;"};
        Object[] objectArray = new Object[]{documentArray};
        this.invoke(string, stringArray, objectArray);
    }

    public void rename(String string, String string2) throws RepositoryException {
        String string3 = "rename";
        String[] stringArray = new String[]{"java.lang.String", "java.lang.String"};
        Object[] objectArray = new Object[]{string, string2};
        this.invoke(string3, stringArray, objectArray);
    }

    public void rename(Document document, Document document2) throws RepositoryException {
        String string = "rename";
        String[] stringArray = new String[]{"com.ibm.websphere.management.repository.DocumentContentSource", "com.ibm.websphere.management.repository.DocumentContentSource"};
        Object[] objectArray = new Object[]{document, document2};
        this.invoke(string, stringArray, objectArray);
    }

    public DocumentContentSource extract(String string) throws RepositoryException {
        String string2 = "extract";
        String[] stringArray = new String[]{"java.lang.String"};
        Object[] objectArray = new Object[]{string};
        DocumentContentSource documentContentSource = (DocumentContentSource)this.invoke(string2, stringArray, objectArray);
        return documentContentSource;
    }

    public DocumentContentSource extract(Document document) throws RepositoryException {
        String string = "extract";
        String[] stringArray = new String[]{"com.ibm.websphere.management.repository.Document"};
        Object[] objectArray = new Object[]{document};
        return (DocumentContentSource)this.invoke(string, stringArray, objectArray);
    }

    public DocumentContentSource[] extract(String[] stringArray) throws RepositoryException {
        String string = "extract";
        String[] stringArray2 = new String[]{"[Ljava.lang.String;"};
        Object[] objectArray = new Object[]{stringArray};
        return (DocumentContentSource[])this.invoke(string, stringArray2, objectArray);
    }

    public DocumentContentSource[] extract(Document[] documentArray) throws RepositoryException {
        String string = "extract";
        String[] stringArray = new String[]{"[Lcom.ibm.websphere.management.repository.Document;"};
        Object[] objectArray = new Object[]{documentArray};
        return (DocumentContentSource[])this.invoke(string, stringArray, objectArray);
    }

    public DocumentDigest modify(DocumentContentSource documentContentSource) throws RepositoryException {
        try {
            this.ftclient.uploadFile(documentContentSource.getSource(), documentContentSource.getDocument().getTempName(), this.options);
            documentContentSource.setSource(this.getUploadStream(documentContentSource.getDocument()));
        }
        catch (TransferFailedException transferFailedException) {
            throw new RepositoryException((Throwable)((Object)transferFailedException));
        }
        String string = "modify";
        String[] stringArray = new String[]{"com.ibm.websphere.management.repository.DocumentContentSource"};
        Object[] objectArray = new Object[]{documentContentSource};
        return (DocumentDigest)this.invoke(string, stringArray, objectArray);
    }

    public DocumentDigest[] modify(DocumentContentSource[] documentContentSourceArray) throws RepositoryException {
        for (int i = 0; i < documentContentSourceArray.length; ++i) {
            try {
                this.ftclient.uploadFile(documentContentSourceArray[i].getSource(), documentContentSourceArray[i].getDocument().getTempName(), this.options);
                documentContentSourceArray[i].setSource(this.getUploadStream(documentContentSourceArray[i].getDocument()));
                continue;
            }
            catch (TransferFailedException transferFailedException) {
                throw new RepositoryException((Throwable)((Object)transferFailedException));
            }
        }
        String string = "modify";
        String[] stringArray = new String[]{"[Lcom.ibm.websphere.management.repository.DocumentContentSource;"};
        Object[] objectArray = new Object[]{documentContentSourceArray};
        return (DocumentDigest[])this.invoke(string, stringArray, objectArray);
    }

    public HashMap update(DocumentContentSource[] documentContentSourceArray, DocumentContentSource[] documentContentSourceArray2, Document[] documentArray) throws RepositoryException {
        int n;
        for (n = 0; n < documentContentSourceArray.length; ++n) {
            try {
                this.ftclient.uploadFile(documentContentSourceArray[n].getSource(), documentContentSourceArray[n].getDocument().getTempName(), this.options);
                documentContentSourceArray[n].setSource(this.getUploadStream(documentContentSourceArray[n].getDocument()));
                continue;
            }
            catch (TransferFailedException transferFailedException) {
                throw new RepositoryException((Throwable)((Object)transferFailedException));
            }
        }
        for (n = 0; n < documentContentSourceArray2.length; ++n) {
            try {
                this.ftclient.uploadFile(documentContentSourceArray2[n].getSource(), documentContentSourceArray2[n].getDocument().getTempName(), this.options);
                documentContentSourceArray2[n].setSource(this.getUploadStream(documentContentSourceArray2[n].getDocument()));
                continue;
            }
            catch (TransferFailedException transferFailedException) {
                throw new RepositoryException((Throwable)((Object)transferFailedException));
            }
        }
        String string = "update";
        String[] stringArray = new String[]{"[Lcom.ibm.websphere.management.repository.DocumentContentSource;", "[Lcom.ibm.websphere.management.repository.DocumentContentSource;", "[Lcom.ibm.websphere.management.repository.Document;"};
        Object[] objectArray = new Object[]{documentContentSourceArray, documentContentSourceArray2, documentArray};
        return (HashMap)this.invoke(string, stringArray, objectArray);
    }

    public DocumentDigest getDigest(String string) throws RepositoryException {
        String string2 = "getDigest";
        String[] stringArray = new String[]{"java.lang.String"};
        Object[] objectArray = new Object[]{string};
        return (DocumentDigest)this.invoke(string2, stringArray, objectArray);
    }

    public DocumentDigest[] getDigest(String[] stringArray) throws RepositoryException {
        String string = "getDigest";
        String[] stringArray2 = new String[]{"[Ljava.lang.String;"};
        Object[] objectArray = new Object[]{stringArray};
        return (DocumentDigest[])this.invoke(string, stringArray2, objectArray);
    }

    public Boolean lockRepository(String string) throws RepositoryException {
        String string2 = "lockRepository";
        String[] stringArray = new String[]{"java.lang.String"};
        Object[] objectArray = new Object[]{string};
        return (Boolean)this.invoke(string2, stringArray, objectArray);
    }

    public Boolean unlockRepository(String string) throws RepositoryException {
        String string2 = "unlockRepository";
        String[] stringArray = new String[]{"java.lang.String"};
        Object[] objectArray = new Object[]{string};
        return (Boolean)this.invoke(string2, stringArray, objectArray);
    }

    public Properties getConfig() {
        String string = "getConfig";
        String[] stringArray = new String[]{};
        Object[] objectArray = new Object[]{};
        try {
            return (Properties)this.invoke(string, stringArray, objectArray);
        }
        catch (RepositoryException repositoryException) {
            return null;
        }
    }

    public String[] listResourceNames(String string, int n, int n2) {
        String string2 = "listResourceNames";
        String[] stringArray = new String[]{"java.lang.String", "int", "int"};
        Object[] objectArray = new Object[]{string, new Integer(n), new Integer(n2)};
        try {
            return (String[])this.invoke(string2, stringArray, objectArray);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String[] listResourceNames(String string, int n, int n2, ResourceNameFilter resourceNameFilter) {
        String string2 = "listResourceNames";
        String[] stringArray = new String[]{"java.lang.String", "int", "int", "com.ibm.websphere.management.repository.ResourceNameFilter"};
        Object[] objectArray = new Object[]{string, new Integer(n), new Integer(n2)};
        try {
            return (String[])this.invoke(string2, stringArray, objectArray);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private ObjectName getRepositoryName() throws MalformedObjectNameException, ConnectorException, AdminException {
        String string = Utils.getNetmgrName(this.client);
        String string2 = "WebSphere:process=" + string + ",type=" + "ConfigRepository" + ",*";
        ObjectName objectName = new ObjectName(string2);
        Set set = this.client.queryNames(objectName, null);
        if (set.size() != 1) {
            throw new AdminException("There are " + set.size() + " repositories!");
        }
        Object[] objectArray = set.toArray();
        return (ObjectName)objectArray[0];
    }

    private ObjectName getFileTransferName() throws MalformedObjectNameException, ConnectorException, AdminException {
        String string = "WebSphere:process=" + Utils.getNetmgrName(this.client) + ",type=" + "FileTransferServer" + ",*";
        ObjectName objectName = new ObjectName(string);
        Set set = this.client.queryNames(objectName, null);
        if (set.size() != 1) {
            throw new AdminException("There are " + set.size() + " file transfer servers.");
        }
        Object[] objectArray = set.toArray();
        return (ObjectName)objectArray[0];
    }

    private FileTransferConfig getFileTransferConfig() throws AdminException {
        FileTransferConfig fileTransferConfig = null;
        ObjectName objectName = null;
        try {
            objectName = this.getFileTransferName();
        }
        catch (Exception exception) {
            throw new AdminException(exception);
        }
        if (objectName != null) {
            fileTransferConfig = (FileTransferConfig)this.invokeMBean(objectName, "getServerConfig", null, null);
        }
        return fileTransferConfig;
    }

    public void addListener(ConfigRepositoryListener configRepositoryListener) {
        throw new UnsupportedOperationException();
    }

    public void removeListener(ConfigRepositoryListener configRepositoryListener) {
        throw new UnsupportedOperationException();
    }

    public ConfigEpoch getRepositoryEpoch() {
        String string = "getRepositoryEpoch";
        String[] stringArray = new String[]{"com.ibm.websphere.management.repository.ConfigEpoch"};
        Object[] objectArray = new Object[]{};
        try {
            return (ConfigEpoch)this.invoke(string, stringArray, objectArray);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public ConfigEpoch refreshRepositoryEpoch() {
        String string = "refreshRepositoryEpoch";
        String[] stringArray = new String[]{"com.ibm.websphere.management.repository.ConfigEpoch"};
        Object[] objectArray = new Object[]{};
        try {
            return (ConfigEpoch)this.invoke(string, stringArray, objectArray);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void createDigestFile(String string, boolean bl) throws RepositoryException {
        String string2 = "createDigestFile";
        String[] stringArray = new String[]{"java.lang.String", "boolean"};
        Object[] objectArray = new Object[]{string, bl ? Boolean.TRUE : Boolean.FALSE};
        this.invoke(string2, stringArray, objectArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

