/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.sync;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.repository.ConfigChangeNotifier;
import com.ibm.websphere.management.repository.ConfigEpoch;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryEvent;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.websphere.management.repository.ConfigRepositoryListener;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.sync.FolderCompareTask;
import com.ibm.ws.management.sync.FolderSyncRequest;
import com.ibm.ws.management.sync.FolderSyncTask;
import com.ibm.ws.management.sync.FolderSyncUpdate;
import com.ibm.ws.management.sync.SyncElement;
import com.ibm.ws.runtime.service.VariableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.management.ObjectName;

public class CellSync
extends RuntimeCollaborator
implements ConfigRepositoryListener {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$sync$CellSync == null ? (class$com$ibm$ws$management$sync$CellSync = CellSync.class$("com.ibm.ws.management.sync.CellSync")) : class$com$ibm$ws$management$sync$CellSync), (String)"Sync", (String)"com.ibm.ws.management.resources.sync");
    private static CellSync cellSync = new CellSync();
    HashMap nameMap = null;
    private ConfigRepository repository = null;
    String cellName = null;
    HashMap epochs = null;
    private Set distributionDisabledApps = null;
    static /* synthetic */ Class class$com$ibm$ws$management$sync$CellSync;

    protected void addDisabledApp(String string) {
        this.distributionDisabledApps.add(string);
    }

    protected void removeDisabledApp(String string) {
        this.distributionDisabledApps.remove(string);
    }

    protected boolean isDisabledApp(String string) {
        return this.distributionDisabledApps.contains(string);
    }

    protected int disabledAppsCount() {
        int n = 0;
        if (this.distributionDisabledApps != null) {
            n = this.distributionDisabledApps.size();
        }
        return n;
    }

    private CellSync() {
    }

    public static CellSync getCellSync() {
        return cellSync;
    }

    public void initialize(VariableMap variableMap) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize");
        }
        this.distributionDisabledApps = new HashSet();
        try {
            AdminServiceFactory.getMBeanFactory().activateMBean("CellSync", this, "cellSync", null);
        }
        catch (AdminException adminException) {
            FFDCFilter.processException((Throwable)((Object)adminException), (String)"com.ibm.ws.management.sync.CellSync.initialize", (String)"91", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMS0100E", (Object)((Object)adminException));
            throw adminException;
        }
        this.repository = ConfigRepositoryFactory.getConfigRepository();
        if (this.repository == null) {
            Tr.error((TraceComponent)tc, (String)"ADMS0101E");
            throw new AdminException("Unable to get the configuration repository");
        }
        this.repository.addListener(this);
        this.cellName = AdminServiceFactory.getAdminService().getCellName();
        this.epochs = new HashMap();
        this.nameMap = new HashMap();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    public Boolean syncNode(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"syncNode");
        }
        boolean bl = false;
        ObjectName objectName = this.getObjectName(string);
        if (objectName != null) {
            AdminHelper.getInstance().audit("ADMN1006I", "ADMN1007I", new Object[]{string, null});
            bl = this.invokeRequestSync(objectName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"syncNode", (Object)(bl ? Boolean.TRUE : Boolean.FALSE));
        }
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    private ObjectName getObjectName(String string) {
        ObjectName objectName;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getObjectName", (Object)string);
        }
        if ((objectName = (ObjectName)this.nameMap.get(string)) == null) {
            try {
                String string2 = "WebSphere:type=NodeSync,node=" + string + ",*";
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("query string is " + string2));
                }
                ObjectName objectName2 = new ObjectName(string2);
                Set set = AdminServiceFactory.getAdminService().queryNames(objectName2, null);
                if (set.size() != 0) {
                    if (set.size() > 1) {
                        Tr.service((TraceComponent)tc, (String)"ADMS0109I", (Object)new Object[]{new Integer(set.size()), string});
                    }
                    Object[] objectArray = set.toArray();
                    objectName = (ObjectName)objectArray[0];
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Object name is " + objectName.getCanonicalName()));
                    }
                    this.nameMap.put(string, objectName);
                } else {
                    Tr.service((TraceComponent)tc, (String)"ADMS0111I", (Object)string);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.sync.CellSync.getObjectName", (String)"173", (Object)this);
                Tr.service((TraceComponent)tc, (String)"ADMS0107E", (Object)new Object[]{string, exception});
                objectName = null;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getObjectName");
        }
        return objectName;
    }

    private boolean invokeRequestSync(ObjectName objectName) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"invokeRequestSync");
        }
        boolean bl = false;
        try {
            Object object = AdminServiceFactory.getAdminService().invoke(objectName, "requestSync", null, null);
            bl = (Boolean)object;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.sync.CellSync.invokeRequestSync", (String)"360", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMS0104I", (Object)new Object[]{objectName, exception});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"invokeRequestSync", (Object)(bl ? Boolean.TRUE : Boolean.FALSE));
        }
        return bl;
    }

    protected String getCellName() {
        return this.cellName;
    }

    public ConfigChangeNotifier[] getModifiedFolders(String string, HashMap hashMap, Properties properties) {
        FolderCompareTask folderCompareTask = new FolderCompareTask();
        folderCompareTask.setNodeName(string);
        folderCompareTask.setCellName(this.getCellName());
        folderCompareTask.setNodeEpochTable(hashMap);
        folderCompareTask.setCellEpochTable(this.epochs);
        folderCompareTask.setRepository(this.repository);
        folderCompareTask.setProperties(properties);
        folderCompareTask.execute();
        ArrayList arrayList = folderCompareTask.getResults();
        ConfigChangeNotifier[] configChangeNotifierArray = new ConfigChangeNotifier[arrayList.size()];
        arrayList.toArray(configChangeNotifierArray);
        return configChangeNotifierArray;
    }

    public ConfigChangeNotifier[] getModifiedFolders(String string, HashMap hashMap) {
        return this.getModifiedFolders(string, hashMap, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FolderSyncUpdate[] getFolderSyncUpdates(String string, List list, FolderSyncRequest[] folderSyncRequestArray, Properties properties) {
        FolderSyncTask folderSyncTask = new FolderSyncTask();
        folderSyncTask.setNodeName(string);
        folderSyncTask.setCellName(this.getCellName());
        folderSyncTask.setExclusionList(list);
        folderSyncTask.setRepository(this.repository);
        folderSyncTask.setProperties(properties);
        FolderSyncUpdate[] folderSyncUpdateArray = new FolderSyncUpdate[folderSyncRequestArray.length];
        for (int i = 0; i < folderSyncRequestArray.length; ++i) {
            folderSyncTask.setRequest(folderSyncRequestArray[i]);
            folderSyncTask.execute();
            ArrayList arrayList = folderSyncTask.getResults();
            SyncElement[] syncElementArray = new SyncElement[arrayList.size()];
            arrayList.toArray(syncElementArray);
            ConfigEpoch configEpoch = null;
            HashMap hashMap = this.epochs;
            synchronized (hashMap) {
                configEpoch = (ConfigEpoch)this.epochs.get(folderSyncRequestArray[i].getFolderUri());
                if (configEpoch == null) {
                    configEpoch = new ConfigEpoch();
                    this.epochs.put(folderSyncRequestArray[i].getFolderUri(), configEpoch);
                }
            }
            folderSyncUpdateArray[i] = new FolderSyncUpdate(folderSyncRequestArray[i].getFolderUri(), configEpoch, syncElementArray);
        }
        return folderSyncUpdateArray;
    }

    public FolderSyncUpdate[] getFolderSyncUpdates(String string, List list, FolderSyncRequest[] folderSyncRequestArray) {
        return this.getFolderSyncUpdates(string, list, folderSyncRequestArray, null);
    }

    public void onRepositoryLock() {
    }

    public void onRepositoryUnlock() {
    }

    public void onChangeStart(ConfigRepositoryEvent configRepositoryEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRepositoryEpochRefresh() {
        HashMap hashMap = this.epochs;
        synchronized (hashMap) {
            this.epochs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChangeCompletion(ConfigRepositoryEvent configRepositoryEvent) {
        ConfigChangeNotifier[] configChangeNotifierArray = configRepositoryEvent.getChanges();
        for (int i = 0; i < configChangeNotifierArray.length; ++i) {
            String string = configChangeNotifierArray[i].getUri().substring(0, configChangeNotifierArray[i].getUri().lastIndexOf("/"));
            HashMap hashMap = this.epochs;
            synchronized (hashMap) {
                ConfigEpoch configEpoch = (ConfigEpoch)this.epochs.get(string);
                if (configEpoch != null) {
                    configEpoch.update();
                } else {
                    this.epochs.put(string, new ConfigEpoch());
                }
                continue;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

