/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.sync;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.RepositoryException;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.Document;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.management.repository.ResourceNameFilter;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.sync.CellSync;
import com.ibm.ws.management.sync.FolderSyncRequest;
import com.ibm.ws.management.sync.SyncElement;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class FolderSyncTask
implements ResourceNameFilter {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$sync$FolderSyncTask == null ? (class$com$ibm$ws$management$sync$FolderSyncTask = FolderSyncTask.class$("com.ibm.ws.management.sync.FolderSyncTask")) : class$com$ibm$ws$management$sync$FolderSyncTask), (String)"Sync", (String)"com.ibm.ws.management.resources.sync");
    String nodeName;
    FolderSyncRequest request;
    ConfigRepository repository;
    ArrayList results = new ArrayList();
    List exclusionList;
    String nodesPath;
    String cellName;
    Properties taskProps;
    boolean recoveryNode;
    static /* synthetic */ Class class$com$ibm$ws$management$sync$FolderSyncTask;

    public ArrayList getResults() {
        return this.results;
    }

    public void setNodeName(String string) {
        this.nodeName = string;
    }

    public void setRepository(ConfigRepository configRepository) {
        this.repository = configRepository;
    }

    public void setRequest(FolderSyncRequest folderSyncRequest) {
        this.request = folderSyncRequest;
    }

    public void setExclusionList(List list) {
        this.exclusionList = list;
    }

    public void setProperties(Properties properties) {
        String string;
        this.taskProps = properties;
        if (this.taskProps != null && (string = this.taskProps.getProperty("recoveryNode")) != null && !string.equals("")) {
            this.recoveryNode = Boolean.valueOf(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        Object object;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Beginning FolderSyncTask for node/folder: " + this.nodeName + ", " + this.request.getFolderUri()));
        }
        this.setupStaticMetadata();
        this.results.clear();
        String[] stringArray = this.repository.listResourceNames(this.request.getFolderUri(), 1, 1, this);
        stringArray = this.filterDocs(this.request.getFolderUri(), stringArray);
        HashMap hashMap = this.request.getDocuments();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                if (this.request.getDocumentDigest(stringArray[i]) == null) {
                    this.results.add(new SyncElement(this.repository.extract(stringArray[i]), 2));
                    continue;
                }
                try {
                    object = this.repository.getDigest(stringArray[i]);
                    if (object.equals(this.request.getDocumentDigest(stringArray[i]))) continue;
                    this.results.add(new SyncElement(this.repository.extract(stringArray[i]), 1));
                    continue;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.sync.FolderSyncTask.execute", (String)"132", (Object)this);
                    continue;
                }
                finally {
                    hashMap.remove(stringArray[i]);
                }
            }
            catch (RepositoryException repositoryException) {
                FFDCFilter.processException((Throwable)((Object)repositoryException), (String)"com.ibm.ws.management.sync.FolderSyncTask.execute", (String)"145", (Object)this);
            }
        }
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            if (this.accept(null, (String)object)) {
                DocumentContentSource documentContentSource = new DocumentContentSource(new Document((String)object), (InputStream)null);
                this.results.add(new SyncElement(documentContentSource, 3));
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("Excluding " + (String)object));
        }
    }

    protected void setupStaticMetadata() {
        this.nodesPath = "cells/" + this.cellName + "/nodes/";
    }

    protected String[] filterDocs(String string, String[] stringArray) {
        if (stringArray.length < 1) {
            return stringArray;
        }
        if (!this.recoveryNode && string.startsWith(this.nodesPath)) {
            String string2 = string.substring(this.nodesPath.length());
            if (string2.indexOf("/") != -1) {
                return stringArray;
            }
            if (string2.equals(this.nodeName)) {
                return stringArray;
            }
            String[] stringArray2 = new String[1];
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].endsWith("serverindex.xml")) continue;
                stringArray2[0] = stringArray[i];
                return stringArray2;
            }
            return stringArray;
        }
        if (CellSync.getCellSync().disabledAppsCount() > 0) {
            boolean bl = false;
            ArrayList<String> arrayList = new ArrayList<String>();
            boolean bl2 = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (CellSync.getCellSync().isDisabledApp(string) && stringArray[i].endsWith(".ear")) {
                    bl = true;
                    continue;
                }
                arrayList.add(stringArray[i]);
            }
            if (bl) {
                String[] stringArray3 = new String[arrayList.size()];
                arrayList.toArray(stringArray3);
                return stringArray3;
            }
        }
        return stringArray;
    }

    public boolean accept(String string, String string2) {
        String string3 = null;
        string3 = string == null ? string2 : (string.endsWith("/") ? string + string2 : string + "/" + string2);
        if (this.exclusionList != null) {
            Iterator iterator = this.exclusionList.iterator();
            while (iterator.hasNext()) {
                String string4 = (String)iterator.next();
                if (!(string4.endsWith("*") && string3.startsWith(string4.substring(0, string4.length() - 1)) || string4.startsWith("*") && string3.endsWith(string4.substring(1))) && !string3.equalsIgnoreCase(string4)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Excluding " + string3));
                }
                return false;
            }
        }
        return true;
    }

    public void setCellName(String string) {
        this.cellName = string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

