/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.sync;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorNotAvailableException;
import com.ibm.websphere.management.repository.ConfigChangeNotifier;
import com.ibm.websphere.management.repository.ConfigEpoch;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.RoutingListener;
import com.ibm.ws.management.RoutingTable;
import com.ibm.ws.management.discovery.ServerInfo;
import com.ibm.ws.management.sync.FolderSyncRequest;
import com.ibm.ws.management.sync.FolderSyncUpdate;
import com.ibm.ws.management.sync.NodeSyncTask;
import com.ibm.ws.management.sync.SyncResult;
import com.ibm.ws.management.util.Utils;
import com.ibm.ws.runtime.service.VariableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class NodeSync
extends RuntimeCollaborator
implements RoutingListener {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$sync$NodeSync == null ? (class$com$ibm$ws$management$sync$NodeSync = NodeSync.class$("com.ibm.ws.management.sync.NodeSync")) : class$com$ibm$ws$management$sync$NodeSync), (String)"Sync", (String)"com.ibm.ws.management.resources.sync");
    private static NodeSync nodeSync = null;
    private boolean autoSyncEnabled = true;
    private int syncInterval = 1;
    private NodeSyncTask nodeSyncTask = null;
    private boolean serverStartupSyncEnabled = false;
    ArrayList exclusionList = null;
    private Properties serviceProps = null;
    private Properties connProps = null;
    private AdminClient adminClient = null;
    private ObjectName cellSyncObjName = null;
    private ObjectName cellRepositoryObjName = null;
    private String nodeName = null;
    private String cellName = null;
    boolean inServer = false;
    private SyncHandler syncHandler = new SyncHandler();
    private ServerInfo netmgr;
    private boolean connected = false;
    private static List localListeners = new ArrayList(2);
    private long notifSeq = 0L;
    public static final String AUTOSYNC_ENABLED = "was.sync.autoSyncEnabled";
    public static final String SYNC_INTERVAL = "was.sync.syncInterval";
    public static final String SERVER_STARTUP_SYNC_ENABLED = "was.sync.serverStartupSyncEnabled";
    public static final String EXCLUSION_LIST = "was.sync.exclusionList";
    public static final String PROCESS_TYPE = "was.sync.processType";
    static /* synthetic */ Class class$com$ibm$ws$management$sync$NodeSync;

    private NodeSync() {
        this.connProps = new Properties();
    }

    public static synchronized NodeSync createNodeSync() throws AdminException {
        if (nodeSync != null) {
            throw new AdminException("NodeSync component is initialzied already");
        }
        nodeSync = new NodeSync();
        return nodeSync;
    }

    public static NodeSync getNodeSync() {
        return nodeSync;
    }

    public String getCellName() {
        return this.cellName;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public boolean isInServer() {
        return this.inServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addLocalSyncEventListener(NotificationListener notificationListener) {
        List list = localListeners;
        synchronized (list) {
            localListeners.add(notificationListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLocalSyncEeventListener(NotificationListener notificationListener) {
        List list = localListeners;
        synchronized (list) {
            localListeners.remove(notificationListener);
        }
    }

    public void initialize(Properties properties, List list, VariableMap variableMap) throws AdminException {
        Object object;
        Object object2;
        Properties properties2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize");
        }
        if ((properties2 = (Properties)properties.clone()) != null) {
            String string;
            String string2;
            object2 = properties2.getProperty(AUTOSYNC_ENABLED);
            if (object2 != null && !((String)object2).equals("")) {
                this.autoSyncEnabled = Boolean.valueOf((String)object2);
                properties2.remove(AUTOSYNC_ENABLED);
            }
            if ((object = properties2.getProperty(SYNC_INTERVAL)) != null && !((String)object).equals("")) {
                int n = Integer.parseInt((String)object);
                if (n > 0) {
                    this.syncInterval = n;
                }
                properties2.remove(SYNC_INTERVAL);
            }
            if ((string2 = properties2.getProperty(SERVER_STARTUP_SYNC_ENABLED)) != null && !string2.equals("")) {
                this.serverStartupSyncEnabled = Boolean.valueOf(string2);
                properties2.remove(SERVER_STARTUP_SYNC_ENABLED);
            }
            if ((string = properties2.getProperty(PROCESS_TYPE)) != null && !string.equals("")) {
                if (string.equalsIgnoreCase("NodeAgent")) {
                    this.inServer = true;
                }
                properties2.remove(PROCESS_TYPE);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("autoSyncEnabled = " + this.autoSyncEnabled));
                Tr.debug((TraceComponent)tc, (String)("syncInterval = " + this.syncInterval));
                Tr.debug((TraceComponent)tc, (String)("serverStartupSyncEnabled = " + this.serverStartupSyncEnabled));
                Tr.debug((TraceComponent)tc, (String)("processType = " + string));
            }
            this.serviceProps = properties2;
        }
        if (this.inServer) {
            try {
                AdminServiceFactory.getMBeanFactory().activateMBean("NodeSync", this, "nodeSync", null);
            }
            catch (AdminException adminException) {
                FFDCFilter.processException((Throwable)((Object)adminException), (String)"com.ibm.ws.management.sync.NodeSync.initialize", (String)"179", (Object)this);
                Tr.error((TraceComponent)tc, (String)"ADMS0100E", (Object)((Object)adminException));
                throw adminException;
            }
            object2 = AdminServiceFactory.getAdminService();
            this.nodeName = object2.getNodeName();
            this.cellName = object2.getCellName();
            object = RoutingTable.getInstance();
            ((RoutingTable)object).addRoutingListener(this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Registering as RoutingListener");
            }
        } else {
            this.getConnectionProps(properties2);
            try {
                object2 = ConfigRepositoryFactory.getConfigRepository();
                if (object2 != null) {
                    object2.initialize(properties2);
                } else {
                    ConfigRepositoryFactory.createConfigRepository(true).initialize(properties2);
                }
            }
            catch (AdminException adminException) {
                FFDCFilter.processException((Throwable)((Object)adminException), (String)"com.ibm.ws.management.sync.NodeSync.initialize", (String)"194", (Object)this);
                throw adminException;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("nodeName = " + this.nodeName));
            Tr.debug((TraceComponent)tc, (String)("cellName = " + this.cellName));
        }
        this.nodeSyncTask = new NodeSyncTask(this);
        this.initializeExclusions(list);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    public Boolean requestSync() {
        return this.nodeSyncTask.initiate(false);
    }

    public Boolean sync() throws AdminException {
        Boolean bl = new Boolean(this.syncHandler.sync());
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("sync result is " + bl));
        }
        return bl;
    }

    public Boolean isNodeSynchronized() throws AdminException {
        Boolean bl = new Boolean(this.syncHandler.isNodeSynchronized());
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("sync result is " + bl));
        }
        return bl;
    }

    ConfigEpoch getCellRepositoryEpoch() throws AdminException {
        ConfigEpoch configEpoch;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getCellRepositoryEpoch");
        }
        try {
            AdminClient adminClient = this.getAdminClient();
            ObjectName objectName = this.getCellRepositoryObjName();
            String string = "getRepositoryEpoch";
            configEpoch = (ConfigEpoch)adminClient.invoke(objectName, string, null, null);
        }
        catch (ConnectorNotAvailableException connectorNotAvailableException) {
            Tr.error((TraceComponent)tc, (String)"ADMS0015E");
            throw new AdminException((Throwable)((Object)connectorNotAvailableException));
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.sync.NodeSync.getCellRepositoryEpoch", (String)"320", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMS0005E", (Object)exception);
            throw AdminException.getAdminException(exception);
        }
        return configEpoch;
    }

    public ConfigChangeNotifier[] invokeGetModifiedFolders(HashMap hashMap) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"invokeGetModifiedFolders");
        }
        ConfigChangeNotifier[] configChangeNotifierArray = null;
        try {
            Object[] objectArray;
            String[] stringArray;
            Object object;
            AdminClient adminClient = this.getAdminClient();
            ObjectName objectName = this.getCellSyncName();
            String string = "getModifiedFolders";
            if (objectName.getKeyProperty("version").equals("5.0")) {
                object = new String[]{"java.lang.String", "java.util.HashMap"};
                Object[] objectArray2 = new Object[]{this.nodeName, hashMap};
                stringArray = object;
                objectArray = objectArray2;
            } else {
                object = new String[]{"java.lang.String", "java.util.HashMap", "java.util.Properties"};
                Object[] objectArray3 = new Object[]{this.nodeName, hashMap, this.serviceProps};
                stringArray = object;
                objectArray = objectArray3;
            }
            object = adminClient.invoke(objectName, string, objectArray, stringArray);
            configChangeNotifierArray = (ConfigChangeNotifier[])object;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"modifiedFolders", (Object)configChangeNotifierArray);
            }
        }
        catch (ConnectorNotAvailableException connectorNotAvailableException) {
            Tr.error((TraceComponent)tc, (String)"ADMS0015E");
            throw new AdminException((Throwable)((Object)connectorNotAvailableException));
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.sync.NodeSync.invokeGetModifiedFolders", (String)"418", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMS0005E", (Object)exception);
            throw AdminException.getAdminException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"invokeGetModifiedFolders");
        }
        return configChangeNotifierArray;
    }

    FolderSyncUpdate[] invokeGetFolderSyncUpdate(FolderSyncRequest[] folderSyncRequestArray) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"invokeGetFolderSyncUpdate");
        }
        FolderSyncUpdate[] folderSyncUpdateArray = null;
        try {
            Object[] objectArray;
            String[] stringArray;
            AdminClient adminClient = this.getAdminClient();
            ObjectName objectName = this.getCellSyncName();
            String string = "getFolderSyncUpdates";
            if (objectName.getKeyProperty("version").equals("5.0")) {
                String[] stringArray2 = new String[]{"java.lang.String", "java.util.List", "[Lcom.ibm.ws.management.sync.FolderSyncRequest;"};
                Object[] objectArray2 = new Object[]{this.nodeName, this.exclusionList, folderSyncRequestArray};
                stringArray = stringArray2;
                objectArray = objectArray2;
            } else {
                String[] stringArray3 = new String[]{"java.lang.String", "java.util.List", "[Lcom.ibm.ws.management.sync.FolderSyncRequest;", "java.util.Properties"};
                Object[] objectArray3 = new Object[]{this.nodeName, this.exclusionList, folderSyncRequestArray, this.serviceProps};
                stringArray = stringArray3;
                objectArray = objectArray3;
            }
            folderSyncUpdateArray = (FolderSyncUpdate[])adminClient.invoke(objectName, string, objectArray, stringArray);
        }
        catch (ConnectorNotAvailableException connectorNotAvailableException) {
            Tr.error((TraceComponent)tc, (String)"ADMS0015E");
            throw new AdminException((Throwable)((Object)connectorNotAvailableException));
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.sync.NodeSync.invokeGetFolderSyncUpdate", (String)"453", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMS0005E", (Object)exception);
            throw AdminException.getAdminException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"invokeGetFolderSyncUpdate", (Object)folderSyncUpdateArray);
        }
        return folderSyncUpdateArray;
    }

    public SyncResult getSyncResult() {
        return this.nodeSyncTask.getCurrentResult();
    }

    private AdminClient getAdminClient() throws AdminException {
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getAdminClient");
            }
            if (this.adminClient == null) {
                try {
                    if (this.inServer) {
                        try {
                            this.adminClient = this.netmgr.getAdminClient();
                            break block8;
                        }
                        catch (Exception exception) {
                            throw new AdminException(exception, "Admin client connection to deployment manager is unavailable");
                        }
                    }
                    this.adminClient = AdminClientFactory.createAdminClient(this.connProps);
                }
                catch (Exception exception) {
                    Tr.error((TraceComponent)tc, (String)"ADMS0012E", (Object)exception);
                    throw AdminException.getAdminException(exception);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAdminClient");
        }
        return this.adminClient;
    }

    private void getConnectionProps(Properties properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getConnectionProps", (Object)properties);
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        if (properties != null) {
            string = properties.getProperty("type");
            string2 = properties.getProperty("host");
            string3 = properties.getProperty("port");
            string4 = properties.getProperty("username");
            string5 = properties.getProperty("password");
            string6 = properties.getProperty("securityEnabled");
        }
        if (string != null && string2 != null && string3 != null) {
            this.connProps.setProperty("type", string);
            this.connProps.setProperty("host", string2);
            this.connProps.setProperty("port", string3);
            if (string4 != null) {
                this.connProps.setProperty("username", string4);
            }
            if (string5 != null) {
                this.connProps.setProperty("password", string5);
            }
            if (new Boolean(string6).booleanValue()) {
                this.connProps.setProperty("securityEnabled", "true");
            }
            this.nodeName = properties.getProperty("nodeName");
            this.cellName = properties.getProperty("cellName");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getConnectionProps", (Object)this.connProps);
        }
    }

    private ObjectName getCellSyncName() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getCellSyncName");
        }
        if (this.cellSyncObjName == null) {
            try {
                String string = Utils.getNetmgrName(this.adminClient);
                String string2 = "WebSphere:type=CellSync,process=" + string + ",*";
                ObjectName objectName = new ObjectName(string2);
                Set set = this.getAdminClient().queryNames(objectName, null);
                if (set != null && set.size() != 0) {
                    if (set.size() != 1) {
                        Tr.service((TraceComponent)tc, (String)"ADMS0013I", (Object)new Integer(set.size()));
                    }
                    Object[] objectArray = set.toArray();
                    this.cellSyncObjName = (ObjectName)objectArray[0];
                    String string3 = this.cellSyncObjName.getKeyProperty("version");
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("CellSync name is " + this.cellSyncObjName.getCanonicalName()));
                    }
                }
            }
            catch (ConnectorNotAvailableException connectorNotAvailableException) {
                Tr.error((TraceComponent)tc, (String)"ADMS0015E");
                throw new AdminException((Throwable)((Object)connectorNotAvailableException));
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.sync.NodeSync.getCellSyncName", (String)"740", (Object)this);
                Tr.error((TraceComponent)tc, (String)"ADMS0005E", (Object)exception);
                throw AdminException.getAdminException(exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getCellSyncName");
        }
        return this.cellSyncObjName;
    }

    private ObjectName getCellRepositoryObjName() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getCellRepositoryObjName");
        }
        if (this.cellRepositoryObjName == null) {
            try {
                String string = Utils.getNetmgrName(this.adminClient);
                String string2 = "WebSphere:type=ConfigRepository,process=" + string + ",*";
                ObjectName objectName = new ObjectName(string2);
                Set set = this.getAdminClient().queryNames(objectName, null);
                if (set != null && set.size() != 0) {
                    if (set.size() != 1) {
                        Tr.service((TraceComponent)tc, (String)"ADMS0021I", (Object)new Integer(set.size()));
                    }
                    Object[] objectArray = set.toArray();
                    this.cellRepositoryObjName = (ObjectName)objectArray[0];
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("cell repository name is " + this.cellRepositoryObjName.getCanonicalName()));
                    }
                }
            }
            catch (ConnectorNotAvailableException connectorNotAvailableException) {
                Tr.error((TraceComponent)tc, (String)"ADMS0015E");
                throw new AdminException((Throwable)((Object)connectorNotAvailableException));
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.sync.NodeSync.getCellRepositoryObjName", (String)"740", (Object)this);
                Tr.error((TraceComponent)tc, (String)"ADMS0005E", (Object)exception);
                throw AdminException.getAdminException(exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getCellRepositoryObjName");
        }
        return this.cellRepositoryObjName;
    }

    public void childAdded(ServerInfo serverInfo) {
    }

    public void childRemoved(ServerInfo serverInfo) {
    }

    public void parentAdded(ServerInfo serverInfo) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"parentAdded");
        }
        this.cellSyncObjName = null;
        this.netmgr = serverInfo;
        try {
            this.adminClient = this.netmgr.getAdminClient();
        }
        catch (Exception exception) {
            Tr.error((TraceComponent)tc, (String)"ADMR0012E", (Object)exception);
        }
        this.connected = true;
        this.nodeSyncTask.triggerAutoSync();
    }

    public void parentRemoved(ServerInfo serverInfo) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"parentRemoved");
        }
        this.connected = false;
    }

    private void initializeExclusions(List list) {
        this.exclusionList = new ArrayList();
        this.exclusionList.add("cells/" + this.cellName + "/nodes/" + this.nodeName + "/namestore.xml");
        this.exclusionList.add("*/namestore-cell.xml");
        this.exclusionList.add("*/namestore-node.xml");
        if (AdminHelper.getPlatformHelper().isControlJvm()) {
            this.exclusionList.add("*/current.env");
            this.exclusionList.add("*/control.jvm.options");
            this.exclusionList.add("*/servant.jvm.options");
        }
        if (list != null) {
            this.exclusionList.addAll(list);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"exclusionList = ", (Object)this.exclusionList);
        }
    }

    public Boolean getAutoSyncEnabled() {
        return this.autoSyncEnabled ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setAutoSyncEnabled(Boolean bl) {
        if (this.autoSyncEnabled != bl) {
            this.autoSyncEnabled = bl;
            if (this.autoSyncEnabled) {
                Tr.audit((TraceComponent)tc, (String)"ADMS0018I");
            } else {
                Tr.audit((TraceComponent)tc, (String)"ADMS0019I");
            }
            if (this.autoSyncEnabled) {
                this.nodeSyncTask.triggerAutoSync();
            }
        }
    }

    public Integer getSyncInterval() {
        return new Integer(this.syncInterval);
    }

    public void setSyncInterval(Integer n) {
        int n2 = n;
        if (n2 > 0) {
            Tr.audit((TraceComponent)tc, (String)"ADMS0001I", (Object)n);
            this.syncInterval = n2;
        } else {
            Tr.warning((TraceComponent)tc, (String)"ADMS0002W", (Object)n);
        }
    }

    public Boolean getServerStartupSyncEnabled() {
        return this.serverStartupSyncEnabled ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setServerStartupSyncEnabled(Boolean bl) {
        this.serverStartupSyncEnabled = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendLocalEvent(Notification notification) {
        List list = localListeners;
        synchronized (list) {
            for (int i = 0; i < localListeners.size(); ++i) {
                try {
                    ((NotificationListener)localListeners.get(i)).handleNotification(notification, null);
                    continue;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.sync.NodeSync.sendLocalEvent", (String)"671", (Object)this);
                }
            }
        }
    }

    void sendCompletionEvent(boolean bl) {
        ObjectName objectName = null;
        if (this.inServer) {
            objectName = this.getObjectName();
        } else {
            try {
                objectName = new ObjectName("WebSphere:type=NodeSync,cell=" + this.cellName + ",node=" + this.nodeName);
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                FFDCFilter.processException((Throwable)malformedObjectNameException, (String)"com.ibm.ws.management.sync.NodeSync.sendCompletionEvent", (String)"717", (Object)this);
            }
        }
        long l = this.notifSeq++;
        Notification notification = new Notification("websphere.nodesync.complete", objectName, l);
        notification.setUserData(bl ? Boolean.TRUE : Boolean.FALSE);
        this.sendLocalEvent(notification);
        if (this.inServer) {
            try {
                this.sendNotification(notification);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.sync.NodeSync.sendCompletionEvent", (String)"737", (Object)this);
                Tr.warning((TraceComponent)tc, (String)"ADMS0014W", (Object)throwable);
            }
        }
    }

    void sendStartEvent() {
        ObjectName objectName = null;
        if (this.inServer) {
            objectName = this.getObjectName();
        } else {
            try {
                objectName = new ObjectName("WebSphere:type=NodeSync,cell=" + this.cellName + ",node=" + this.nodeName);
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                FFDCFilter.processException((Throwable)malformedObjectNameException, (String)"com.ibm.ws.management.sync.NodeSync.sendStartEvent", (String)"760", (Object)this);
            }
        }
        long l = this.notifSeq++;
        Notification notification = new Notification("websphere.nodesync.initiated", objectName, l);
        this.sendLocalEvent(notification);
        if (this.inServer) {
            try {
                this.sendNotification(notification);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.sync.NodeSync.sendStartEvent", (String)"766", (Object)this);
                Tr.warning((TraceComponent)tc, (String)"ADMS0022W", (Object)throwable);
            }
        }
    }

    public boolean syncForServerStartup() throws AdminException {
        boolean bl = true;
        if (this.serverStartupSyncEnabled) {
            bl = this.syncHandler.sync();
        }
        return bl;
    }

    protected boolean isConnected() {
        return this.connected;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class SyncHandler {
        private SyncHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean sync() {
            boolean bl;
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"sync");
            }
            NodeSyncTask nodeSyncTask = NodeSync.this.nodeSyncTask;
            synchronized (nodeSyncTask) {
                if (NodeSync.this.nodeSyncTask.isIdle()) {
                    NodeSync.this.requestSync();
                    this.waitForCurrentSync();
                    bl = NodeSync.this.getSyncResult().isSuccessful();
                } else {
                    boolean bl2 = this.waitForNextCompareFolder();
                    if (!bl2) {
                        NodeSync.this.requestSync();
                    }
                    this.waitForCurrentSync();
                    bl = NodeSync.this.getSyncResult().isSuccessful();
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"sync", (Object)(bl ? Boolean.TRUE : Boolean.FALSE));
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isNodeSynchronized() {
            boolean bl;
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"isNodeSynchronized");
            }
            NodeSyncTask nodeSyncTask = NodeSync.this.nodeSyncTask;
            synchronized (nodeSyncTask) {
                if (NodeSync.this.nodeSyncTask.isIdle()) {
                    NodeSync.this.nodeSyncTask.initiate(true);
                    this.waitForCurrentSync();
                    bl = NodeSync.this.getSyncResult().getResult() == 1;
                } else {
                    boolean bl2 = this.waitForNextCompareFolder();
                    if (!bl2) {
                        NodeSync.this.nodeSyncTask.initiate(true);
                    }
                    this.waitForCurrentSync();
                    bl = NodeSync.this.getSyncResult().getResult() == 1;
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"isNodeSynchronized", (Object)(bl ? Boolean.TRUE : Boolean.FALSE));
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitForCurrentSync() {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"waitForCurrentSync");
            }
            NodeSyncTask nodeSyncTask = NodeSync.this.nodeSyncTask;
            synchronized (nodeSyncTask) {
                while (!NodeSync.this.nodeSyncTask.isIdle()) {
                    try {
                        NodeSync.this.nodeSyncTask.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"waitForCurrentSync");
            }
        }

        private boolean waitForNextCompareFolder() {
            NodeSyncTask nodeSyncTask = NodeSync.this.nodeSyncTask;
            synchronized (nodeSyncTask) {
                while (true) {
                    try {
                        NodeSync.this.nodeSyncTask.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    switch (NodeSync.this.nodeSyncTask.getCurrentState()) {
                        case 0: {
                            return false;
                        }
                        case 1: {
                            return true;
                        }
                    }
                }
            }
        }
    }
}

