/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.sync;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.repository.ConfigChangeNotifier;
import com.ibm.websphere.management.repository.ConfigEpoch;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryEvent;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.websphere.management.repository.ConfigRepositoryListener;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.sync.FolderSyncRequest;
import com.ibm.ws.management.sync.FolderSyncUpdate;
import com.ibm.ws.management.sync.NodeSync;
import com.ibm.ws.management.sync.SyncElement;
import com.ibm.ws.management.sync.SyncResult;
import com.ibm.ws.management.util.SecurityHelper;
import java.util.ArrayList;
import java.util.HashMap;
import javax.security.auth.Subject;

class NodeSyncTask
implements AlarmListener,
Runnable,
ConfigRepositoryListener {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$sync$NodeSyncTask == null ? (class$com$ibm$ws$management$sync$NodeSyncTask = NodeSyncTask.class$("com.ibm.ws.management.sync.NodeSyncTask")) : class$com$ibm$ws$management$sync$NodeSyncTask), (String)"Sync", (String)"com.ibm.ws.management.resources.sync");
    public static final int IDLE = 0;
    public static final int COMPARE_FOLDERS = 1;
    public static final int PROCESSING_UPDATE = 2;
    public static final int PROCESSING_UPDATE_WITH_ERROR = 3;
    public static final int VERIFY_SYNC_RESULT = 4;
    private static final int SYNC_ITERATION_LIMIT = 3;
    private int state = 0;
    private NodeSync nodeSync;
    private boolean syncStatusOnly = false;
    private SyncResult currentResult = null;
    private ConfigEpoch nodeGlobalEpoch = null;
    private ConfigRepository repository;
    private HashMap folderEpoch = null;
    private boolean folderEpochInvalid = false;
    private boolean alarmSet = false;
    static /* synthetic */ Class class$com$ibm$ws$management$sync$NodeSyncTask;

    public NodeSyncTask(NodeSync nodeSync) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Creating NodeSyncTask");
        }
        this.nodeSync = nodeSync;
        this.state = 0;
        this.repository = ConfigRepositoryFactory.getConfigRepository();
        this.repository.addListener(this);
    }

    synchronized Boolean initiate(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("initiate: " + bl));
        }
        boolean bl2 = false;
        if (this.state == 0) {
            this.syncStatusOnly = bl;
            if (this.currentResult == null) {
                this.currentResult = new SyncResult();
            } else {
                this.currentResult.initialize();
            }
            if (this.folderEpochInvalid) {
                this.nodeGlobalEpoch = null;
                this.folderEpoch = null;
                this.folderEpochInvalid = false;
            }
            this.setState(1);
            this.nodeSync.sendStartEvent();
            new Thread(this).start();
            bl2 = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("initiate," + bl2));
        }
        return new Boolean(bl2);
    }

    boolean isIdle() {
        return this.state == 0;
    }

    SyncResult getCurrentResult() {
        return this.currentResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"run");
        }
        try {
            this.doSync();
        }
        catch (AdminException adminException) {
            FFDCFilter.processException((Throwable)((Object)adminException), (String)"com.ibm.ws.management.sync.NodeSyncTask.run", (String)"157", (Object)this);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.sync.NodeSyncTask.run", (String)"162", (Object)this);
        }
        finally {
            this.setState(0);
        }
    }

    public void alarm(Object object) {
        this.alarmSet = false;
        this.triggerAutoSync();
    }

    void triggerAutoSync() {
        if (this.nodeSync.getAutoSyncEnabled().booleanValue()) {
            if (this.nodeSync.isConnected()) {
                try {
                    this.initiate(false);
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.sync.NodeSyncTask.triggerAutoSync", (String)"174", (Object)this);
                    Tr.service((TraceComponent)tc, (String)"ADMS0017I");
                }
                if (!this.alarmSet) {
                    AlarmManager.create((long)(this.nodeSync.getSyncInterval() * 60000), (AlarmListener)this);
                    this.alarmSet = true;
                }
            } else {
                Tr.error((TraceComponent)tc, (String)"ADMS0015E");
            }
        }
    }

    int getCurrentState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doSync() throws AdminException {
        block40: {
            boolean bl;
            block41: {
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)"doSync");
                }
                boolean bl2 = false;
                int n = 0;
                ConfigEpoch configEpoch = null;
                bl = false;
                try {
                    do {
                        Subject subject;
                        if ((subject = SecurityHelper.getOwnedSubject()) != null) {
                            SecurityHelper.pushInvocationSubject(subject);
                        }
                        configEpoch = this.nodeSync.getCellRepositoryEpoch();
                        boolean bl3 = bl2 = this.nodeGlobalEpoch != null && this.nodeGlobalEpoch.equals(configEpoch);
                        if (bl2) break;
                        this.setState(1);
                        ConfigChangeNotifier[] configChangeNotifierArray = this.nodeSync.invokeGetModifiedFolders(this.getFolderEpoch());
                        this.setState(2);
                        if (this.syncStatusOnly) {
                            bl2 = configChangeNotifierArray.length == 0;
                            break;
                        }
                        this.setState(2);
                        int n2 = 10;
                        ArrayList<FolderSyncUpdate[]> arrayList = new ArrayList<FolderSyncUpdate[]>(n2);
                        int n3 = 0;
                        while (n3 < configChangeNotifierArray.length) {
                            FolderSyncUpdate[] folderSyncUpdateArray;
                            arrayList.clear();
                            for (int i = 0; i < n2 && n3 < configChangeNotifierArray.length; ++n3, ++i) {
                                folderSyncUpdateArray = this.createFolderSyncRequest(configChangeNotifierArray[n3]);
                                if (folderSyncUpdateArray == null) continue;
                                arrayList.add(folderSyncUpdateArray);
                            }
                            if (arrayList.size() <= 0) continue;
                            FolderSyncRequest[] folderSyncRequestArray = new FolderSyncRequest[arrayList.size()];
                            arrayList.toArray(folderSyncRequestArray);
                            folderSyncUpdateArray = this.nodeSync.invokeGetFolderSyncUpdate(folderSyncRequestArray);
                            for (int i = 0; i < folderSyncUpdateArray.length; ++i) {
                                this.processFolderSyncUpdate(folderSyncUpdateArray[i]);
                            }
                        }
                        if (this.state == 3) {
                            bl2 = false;
                            break;
                        }
                        this.setState(4);
                        this.nodeGlobalEpoch = configEpoch;
                        bl = true;
                    } while (!bl2 && n++ < 3);
                    if (n == 3) {
                        Tr.audit((TraceComponent)tc, (String)"ADMS0023I");
                    }
                    Object var14_14 = null;
                    if (bl2) {
                        this.currentResult.setResult(1);
                        break block40;
                    }
                    if (!this.syncStatusOnly) break block41;
                }
                catch (Throwable throwable) {
                    Object var14_15 = null;
                    if (bl2) {
                        this.currentResult.setResult(1);
                    } else if (this.syncStatusOnly) {
                        switch (this.state) {
                            case 1: {
                                this.currentResult.setResult(4);
                                break;
                            }
                            case 2: {
                                this.currentResult.setResult(3);
                                break;
                            }
                        }
                    } else {
                        switch (this.state) {
                            case 1: {
                                if (bl) {
                                    this.currentResult.setResult(2);
                                    break;
                                }
                                this.currentResult.setResult(4);
                                break;
                            }
                            case 2: 
                            case 3: {
                                this.currentResult.setResult(4);
                                break;
                            }
                            case 4: {
                                this.currentResult.setResult(2);
                                break;
                            }
                        }
                    }
                    if (this.syncStatusOnly) throw throwable;
                    this.nodeSync.sendCompletionEvent(this.currentResult.isSuccessful());
                    if (this.currentResult.isSuccessful()) {
                        Tr.audit((TraceComponent)tc, (String)"ADMS0003I");
                        throw throwable;
                    }
                    Tr.audit((TraceComponent)tc, (String)"ADMS0016I");
                    throw throwable;
                }
                switch (this.state) {
                    case 1: {
                        this.currentResult.setResult(4);
                        break;
                    }
                    case 2: {
                        this.currentResult.setResult(3);
                        break;
                    }
                }
                break block40;
            }
            switch (this.state) {
                case 1: {
                    if (bl) {
                        this.currentResult.setResult(2);
                        break;
                    }
                    this.currentResult.setResult(4);
                    break;
                }
                case 2: 
                case 3: {
                    this.currentResult.setResult(4);
                    break;
                }
                case 4: {
                    this.currentResult.setResult(2);
                    break;
                }
            }
        }
        if (!this.syncStatusOnly) {
            this.nodeSync.sendCompletionEvent(this.currentResult.isSuccessful());
            if (this.currentResult.isSuccessful()) {
                Tr.audit((TraceComponent)tc, (String)"ADMS0003I");
            } else {
                Tr.audit((TraceComponent)tc, (String)"ADMS0016I");
            }
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"doSync");
    }

    private FolderSyncRequest createFolderSyncRequest(ConfigChangeNotifier configChangeNotifier) throws AdminException {
        if (configChangeNotifier.getChangeType() == 1) {
            this.currentResult.updated();
            this.deleteFolder(configChangeNotifier.getUri());
            return null;
        }
        return this.generateFolderSyncRequest(configChangeNotifier);
    }

    private void deleteFolder(String string) throws AdminException {
        String[] stringArray = this.repository.listResourceNames(string, 1, Integer.MAX_VALUE);
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                this.repository.delete(stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.sync.NodeSyncTask.deleteFolder", (String)"357", (Object)this);
                this.setState(3);
            }
        }
        if (this.state == 2) {
            this.folderEpoch.remove(string);
        }
    }

    private void processFolderSyncUpdate(FolderSyncUpdate folderSyncUpdate) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("processFolderSyncUpdate: " + folderSyncUpdate.getFolderUri()));
        }
        boolean bl = false;
        SyncElement[] syncElementArray = folderSyncUpdate.getFolderSyncElements();
        if (syncElementArray.length > 0) {
            this.currentResult.updated();
        }
        for (int i = 0; i < syncElementArray.length; ++i) {
            SyncElement syncElement = syncElementArray[i];
            int n = syncElement.getStatus();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(syncElement.getDocumentContentSource().getDocument().getURI() + ": " + n));
            }
            try {
                if (n == 2) {
                    this.repository.create(syncElement.getDocumentContentSource());
                    continue;
                }
                if (n == 1) {
                    syncElement.getDocumentContentSource().getDocument().setOverwrite(true);
                    this.repository.modify(syncElement.getDocumentContentSource());
                    continue;
                }
                if (n == 3) {
                    this.repository.delete(syncElement.getDocumentContentSource().getDocument().getURI());
                    continue;
                }
                Tr.warning((TraceComponent)tc, (String)"ADMS0009W", (Object)syncElement);
                continue;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.sync.NodeSyncTask.processFolderSyncUpdate", (String)"405", (Object)this);
                Tr.service((TraceComponent)tc, (String)"ADMS0020E", (Object)new Object[]{syncElement.getDocumentContentSource().getDocument().getURI(), exception});
                bl = true;
                this.setState(3);
            }
        }
        if (!bl) {
            this.getFolderEpoch().put(folderSyncUpdate.getFolderUri(), folderSyncUpdate.getFolderEpoch());
        }
    }

    private FolderSyncRequest generateFolderSyncRequest(ConfigChangeNotifier configChangeNotifier) throws AdminException {
        FolderSyncRequest folderSyncRequest = new FolderSyncRequest(configChangeNotifier.getUri());
        if (configChangeNotifier.getChangeType() == 2) {
            String[] stringArray = this.repository.listResourceNames(configChangeNotifier.getUri(), 1, 1);
            for (int i = 0; i < stringArray.length; ++i) {
                folderSyncRequest.setDocumentDigest(stringArray[i], this.repository.getDigest(stringArray[i]));
            }
        }
        return folderSyncRequest;
    }

    private HashMap getFolderEpoch() {
        if (this.folderEpoch == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Creating new folder epoch map");
            }
            this.folderEpoch = new HashMap();
            String[] stringArray = this.repository.listResourceNames("/", 2, Integer.MAX_VALUE);
            this.folderEpoch.put("/", null);
            for (int i = 0; i < stringArray.length; ++i) {
                this.folderEpoch.put(stringArray[i], null);
            }
        }
        return this.folderEpoch;
    }

    private synchronized void setState(int n) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setState: " + n));
        }
        this.state = n;
        this.notifyAll();
    }

    public void onRepositoryLock() {
    }

    public void onRepositoryUnlock() {
    }

    public void onChangeStart(ConfigRepositoryEvent configRepositoryEvent) {
    }

    public void onChangeCompletion(ConfigRepositoryEvent configRepositoryEvent) {
    }

    public void onRepositoryEpochRefresh() {
        this.folderEpochInvalid = true;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Received repository epoch refresh notification");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

