/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.sync;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SyncResult
implements Serializable {
    static final long serialVersionUID = 3288474355450479721L;
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$sync$SyncResult == null ? (class$com$ibm$ws$management$sync$SyncResult = SyncResult.class$("com.ibm.ws.management.sync.SyncResult")) : class$com$ibm$ws$management$sync$SyncResult), (String)"Sync", (String)"com.ibm.ws.management.resources.sync");
    private long initTime = 0L;
    private long completeTime = 0L;
    public static final int IN_PROGRESS = 0;
    public static final int COMPLETE = 1;
    public static final int NOT_VERIFIED = 2;
    public static final int OUT_OF_SYNC = 3;
    public static final int ERROR = 4;
    private int result;
    private boolean updated;
    static /* synthetic */ Class class$com$ibm$ws$management$sync$SyncResult;

    SyncResult() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SyncResult");
        }
        this.initialize();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SyncResult");
        }
    }

    public int getResult() {
        return this.result;
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public long getInitTime() {
        return this.initTime;
    }

    public long getCompleteTime() {
        return this.completeTime;
    }

    public boolean isSuccessful() {
        return this.result == 1 || this.result == 2;
    }

    void initialize() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize");
        }
        this.initTime = System.currentTimeMillis();
        this.completeTime = 0L;
        this.updated = false;
        this.result = 0;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    void updated() {
        this.updated = true;
    }

    void setResult(int n) {
        this.result = n;
        this.completeTime = System.currentTimeMillis();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy.MM.dd 'at' hh:mm:ss:SSS zzz");
        stringBuffer.append("initiate time: ").append(simpleDateFormat.format(new Date(this.initTime))).append('\n');
        if (this.completeTime > 0L) {
            stringBuffer.append("complete time: ").append(simpleDateFormat.format(new Date(this.completeTime))).append('\n');
        }
        stringBuffer.append("result: ");
        switch (this.result) {
            case 0: {
                stringBuffer.append("In Progress");
                break;
            }
            case 1: {
                stringBuffer.append("Complete");
                break;
            }
            case 4: {
                stringBuffer.append("Error");
                break;
            }
            case 2: {
                stringBuffer.append("Not Verfied");
                break;
            }
            case 3: {
                stringBuffer.append("Out of Sync");
            }
        }
        stringBuffer.append("\n");
        if (this.updated) {
            stringBuffer.append("Update occurred\n");
        } else {
            stringBuffer.append("No update occurred.\n");
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

