/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.tools;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.EarUtils;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.configservice.ConfigServiceProxy;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.adminservice.AdminService;
import com.ibm.websphere.models.config.adminservice.RepositoryService;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.process.Service;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.topology.cell.Cell;
import com.ibm.websphere.models.config.topology.cell.CellType;
import com.ibm.websphere.product.WASProduct;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.launcher.LaunchScriptCollaboratorFactory;
import com.ibm.ws.management.launcher.LaunchScriptPlatformCollaborator;
import com.ibm.ws.management.tools.AdminTool;
import com.ibm.ws.management.tools.ExtensionChecker;
import com.ibm.ws.management.util.Utils;
import com.ibm.ws.process.Process;
import com.ibm.ws.process.ProcessFactory;
import com.ibm.ws.runtime.component.VariableMapImpl;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.RepositoryImpl;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.util.ImplFactory;
import java.beans.beancontext.BeanContextServiceProvider;
import java.beans.beancontext.BeanContextServicesSupport;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;

public abstract class AbstractNodeConfigUtility
extends AdminTool {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$tools$AbstractNodeConfigUtility == null ? (class$com$ibm$ws$management$tools$AbstractNodeConfigUtility = AbstractNodeConfigUtility.class$("com.ibm.ws.management.tools.AbstractNodeConfigUtility")) : class$com$ibm$ws$management$tools$AbstractNodeConfigUtility), (String)"Admin", (String)"com.ibm.ws.management.resources.nodeutils");
    protected static final String[] NTFY_PARAMS = new String[]{"java.lang.String", "java.lang.String", "java.lang.Object"};
    protected String connType = "SOAP";
    protected String connHost = null;
    protected String connPort = null;
    protected AdminClient adminClient = null;
    protected ObjectName notificationService = null;
    protected Properties notificationUserData = null;
    protected String netmgrName = null;
    private ConfigServiceProxy configService = null;
    private WASProduct wasProduct = null;
    private Object addOrRemoveNodeToken = null;
    static /* synthetic */ Class class$com$ibm$ws$management$tools$AbstractNodeConfigUtility;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$Repository;

    protected abstract VariableMapImpl getVariableMap() throws Exception;

    protected abstract RepositoryImpl getLocalRepository() throws Exception;

    protected void toolFailed() {
        try {
            this.completeAddOrRemoveNode();
        }
        catch (Exception exception) {
            this.issueMessage("ADMU0042E", null, null);
        }
    }

    protected boolean isMemberOfCell() throws Exception {
        Resource resource = this.getResource("cells/" + this.cellName + "/cell.xml", "cell.xml");
        Cell cell = (Cell)resource.getContents().get(0);
        return cell.getCellType().equals(CellType.DISTRIBUTED_LITERAL);
    }

    private Resource getResource(String string, String string2) throws Exception {
        ConfigRoot configRoot = this.getLocalRepository().getConfigRoot();
        Resource resource = configRoot.getResource(0, string2);
        return resource;
    }

    protected Properties getClientProperties() throws Exception {
        Properties properties = new Properties();
        properties.setProperty("type", this.connType);
        properties.setProperty("host", this.connHost);
        properties.setProperty("port", this.connPort);
        properties.setProperty("nodeName", this.nodeName);
        properties.setProperty("cellName", this.cellName);
        properties.setProperty("was.install.root", System.getProperty("was.install.root"));
        properties.setProperty("user.install.root", this.getUserInstallRootIfSetElseGetWasInstallRoot());
        properties.setProperty("location", "remote");
        if (this.userid != null) {
            properties.setProperty("username", this.userid);
        }
        if (this.pwd != null) {
            properties.setProperty("password", this.pwd);
        }
        return properties;
    }

    protected String getUserInstallRootIfSetElseGetWasInstallRoot() {
        return System.getProperty("user.install.root", System.getProperty("was.install.root"));
    }

    protected AdminClient getAdminClient(Properties properties) throws Exception {
        AdminClient adminClient = null;
        try {
            adminClient = AdminClientFactory.createAdminClient(properties);
        }
        catch (Exception exception) {
            Tr.error((TraceComponent)tc, (String)"ADMU0006E", (Object)exception);
            throw exception;
        }
        return adminClient;
    }

    protected ObjectName getMBeanByType(String string) throws Exception {
        return this.getMBeanByType(string, this.getNetmgrName());
    }

    protected ObjectName getMBeanByType(String string, String string2) throws Exception {
        if (this.adminClient == null) {
            return null;
        }
        ObjectName objectName = null;
        try {
            Iterator iterator;
            String string3 = "WebSphere:*,process=" + string2 + ",type=" + string;
            ObjectName objectName2 = new ObjectName(string3);
            Set set = this.adminClient.queryNames(objectName2, null);
            if (set.size() != 1) {
                Tr.debug((TraceComponent)tc, (String)("There are " + set.size() + " " + string + "s!"));
            }
            if ((iterator = set.iterator()).hasNext()) {
                objectName = (ObjectName)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(string + " handle is ==> " + objectName.getCanonicalName()));
                }
            } else {
                Tr.warning((TraceComponent)tc, (String)"ADMU0008E", (Object)new Object[]{string, "No ObjectName found."});
            }
        }
        catch (Exception exception) {
            Tr.error((TraceComponent)tc, (String)"ADMU0008E", (Object)new Object[]{string, exception});
            throw exception;
        }
        return objectName;
    }

    protected Object invokeMBean(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws Exception {
        Object object = null;
        if (objectName != null) {
            try {
                object = this.adminClient.invoke(objectName, string, objectArray, stringArray);
            }
            catch (Exception exception) {
                Tr.error((TraceComponent)tc, (String)"ADMU0040E", (Object)new Object[]{objectName, string, exception});
                throw exception;
            }
        }
        return object;
    }

    protected boolean beginAddOrRemoveNode() throws Exception {
        ObjectName objectName = this.getMBeanByType("AdminOperations");
        if (objectName != null) {
            this.addOrRemoveNodeToken = this.invokeMBean(objectName, "getTokenForNodeFederationOrRemoval", null, null);
            if (this.addOrRemoveNodeToken == null) {
                return false;
            }
        }
        return true;
    }

    protected void completeAddOrRemoveNode() throws Exception {
        ObjectName objectName;
        if (this.addOrRemoveNodeToken != null && (objectName = this.getMBeanByType("AdminOperations")) != null) {
            this.invokeMBean(objectName, "completeNodeFederationOrRemoval", new Object[]{this.addOrRemoveNodeToken}, new String[]{"java.lang.Object"});
            this.addOrRemoveNodeToken = null;
        }
    }

    protected ObjectName getNotificationServiceMBean() throws Exception {
        String string = "WebSphere:*,type=NotificationService,process=" + this.getNetmgrName();
        try {
            Set set = this.adminClient.queryNames(new ObjectName(string), null);
            if (set.isEmpty()) {
                Tr.error((TraceComponent)tc, (String)"ADMU0008E", (Object)new Object[]{string, "none"});
                return null;
            }
            this.notificationUserData = new Properties();
            this.notificationUserData.setProperty("nodeName", this.nodeName);
            return (ObjectName)set.iterator().next();
        }
        catch (Exception exception) {
            Tr.error((TraceComponent)tc, (String)"ADMU0008E", (Object)new Object[]{string, exception});
            return null;
        }
    }

    protected void copyDocuments(String string, String string2) throws Exception {
        File file = new File(string);
        File file2 = new File(string2);
        file2.mkdirs();
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                this.copyDocuments(string + File.separator + fileArray[i].getName(), string2 + File.separator + fileArray[i].getName());
                continue;
            }
            File file3 = new File(string2 + File.separator + fileArray[i].getName());
            this.copyDocument(fileArray[i], file3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void copyDocument(File file, File file2) throws Exception {
        if (file == null || file2 == null) {
            return;
        }
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            file2.createNewFile();
            fileOutputStream = new FileOutputStream(file2);
            int n = (int)file.length();
            byte[] byArray = new byte[n];
            for (int i = 0; i < n; i += fileInputStream.read(byArray, i, n - i)) {
            }
            fileOutputStream.write(byArray);
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            try {
                if (fileInputStream == null) throw throwable;
                fileInputStream.close();
                throw throwable;
            }
            finally {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
        }
        try {
            if (fileInputStream == null) return;
            fileInputStream.close();
            return;
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    protected void fixSetupCmdLine(String string, Properties properties) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"fixSetupCmdLine", (Object)new Object[]{string, properties});
        }
        String string2 = System.getProperty("os.name").toLowerCase();
        LaunchScriptPlatformCollaborator launchScriptPlatformCollaborator = LaunchScriptCollaboratorFactory.getCollaborator(string2);
        Tr.debug((TraceComponent)tc, (String)("LaunchScriptCollaborator: " + launchScriptPlatformCollaborator.getClass()));
        String string3 = properties.getProperty("user.install.root") + "/bin/setupCmdLine";
        string3 = launchScriptPlatformCollaborator.customizeScriptFilename(string3);
        File file = new File(string3);
        if (file.exists()) {
            Vector<String> vector = new Vector<String>();
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
            boolean bl = false;
            String string4 = null;
            long l = randomAccessFile.getFilePointer();
            while (l < randomAccessFile.length()) {
                try {
                    string4 = randomAccessFile.readLine();
                    l = randomAccessFile.getFilePointer();
                }
                catch (EOFException eOFException) {
                    bl = true;
                    break;
                }
                if (string4 != null && string4.indexOf("WAS_CELL=") >= 0 && !string4.startsWith(launchScriptPlatformCollaborator.getPlatformComment())) {
                    string4 = string4.substring(0, string4.indexOf("=") + 1) + string;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("modified line in setupCmdLine: " + string4));
                    }
                }
                vector.add(string4);
            }
            randomAccessFile.close();
            FileWriter fileWriter = new FileWriter(file);
            for (int i = 0; i < vector.size(); ++i) {
                string4 = (String)vector.get(i);
                fileWriter.write(string4 + launchScriptPlatformCollaborator.getPlatformLineEnd());
            }
            fileWriter.flush();
            fileWriter.close();
        } else {
            Tr.error((TraceComponent)tc, (String)"ADMU2003E", (Object)new Object[]{string3});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"fixSetupCmdLine");
        }
    }

    protected void removeFromCell(AdminClient adminClient) throws Exception {
        if (adminClient != null) {
            ObjectName objectName;
            Session session;
            ConfigServiceProxy configServiceProxy = this.getConfigService(adminClient);
            ObjectName[] objectNameArray = configServiceProxy.queryConfigObjects(session = new Session("removeNode", false), null, objectName = ConfigServiceHelper.createObjectName(null, "Node", this.nodeName), null);
            if (objectNameArray == null || objectNameArray.length < 1) {
                throw new AdminException(this.getFormattedMessage("ADMU0521E", new Object[]{this.nodeName}, null));
            }
            ObjectName objectName2 = objectNameArray[0];
            configServiceProxy.deleteConfigData(session, objectName2);
            configServiceProxy.save(session, true);
            configServiceProxy.discard(session);
            this.issueMessage("ADMU2018I", new Object[]{this.nodeName}, null);
        }
    }

    protected ConfigServiceProxy getConfigService(AdminClient adminClient) throws Exception {
        if (this.configService == null) {
            this.configService = new ConfigServiceProxy(adminClient);
        }
        return this.configService;
    }

    protected void deleteDirs(String string) throws Exception {
        File file = new File(string);
        if (!file.exists()) {
            return;
        }
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    this.deleteDirs(string + File.separator + fileArray[i].getName());
                }
                fileArray[i].delete();
            }
        }
        file.delete();
    }

    protected void fixWsadminProps(Properties properties) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"fixWsadminProps", (Object)properties);
        }
        String string = System.getProperty("os.name").toLowerCase();
        LaunchScriptPlatformCollaborator launchScriptPlatformCollaborator = LaunchScriptCollaboratorFactory.getCollaborator(string);
        String string2 = null;
        String string3 = System.getProperty("user.install.root");
        string2 = string3 != null ? string3 : properties.getProperty("was.install.root");
        File file = new File(string2 = string2 + "/properties/wsadmin.properties");
        if (file.exists()) {
            Vector vector = new Vector();
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
            long l = randomAccessFile.getFilePointer();
            while (l < randomAccessFile.length()) {
                try {
                    this.fixWsadminLine(randomAccessFile.readLine(), properties, vector);
                }
                catch (EOFException eOFException) {
                    break;
                }
                l = randomAccessFile.getFilePointer();
            }
            randomAccessFile.close();
            FileWriter fileWriter = new FileWriter(file);
            for (int i = 0; i < vector.size(); ++i) {
                fileWriter.write((String)vector.get(i) + launchScriptPlatformCollaborator.getPlatformLineEnd());
            }
            fileWriter.flush();
            fileWriter.close();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"fixWsadminProps");
        }
    }

    private void fixWsadminLine(String string, Properties properties, Vector vector) throws IOException {
        if (string != null) {
            if (string.startsWith("com.ibm.ws.scripting.connectionType=")) {
                string = this.makeCorrectLine(string, vector, properties.getProperty("type"));
            } else if (string.startsWith("com.ibm.ws.scripting.port=")) {
                string = this.makeCorrectLine(string, vector, properties.getProperty("port"));
            } else if (string.startsWith("com.ibm.ws.scripting.host=")) {
                string = this.makeCorrectLine(string, vector, properties.getProperty("host"));
            }
        }
        vector.add(string);
    }

    private String makeCorrectLine(String string, Vector vector, String string2) {
        String string3 = string;
        String string4 = string.substring(string.indexOf(61) + 1).trim();
        if (!string4.equals(string2)) {
            this.commentOutLine(string, vector);
            string = string.substring(0, string.indexOf(61) + 1) + string2;
        }
        return string;
    }

    private void commentOutLine(String string, Vector vector) {
        vector.add("#" + string);
    }

    protected void checkExpressProduct() throws Exception {
        boolean bl = this.getWASProduct().productPresent("EXPRESS");
        if (bl) {
            this.issueMessage("ADMU0035E", null, null);
            throw new AdminException(this.getFormattedMessage("ADMU0035E", null, null));
        }
    }

    protected WASProduct getWASProduct() {
        if (this.wasProduct == null) {
            this.wasProduct = new WASProduct();
        }
        return this.wasProduct;
    }

    protected void checkProductExtensions(WASProduct wASProduct, AdminClient adminClient) throws Exception {
        ExtensionChecker extensionChecker = (ExtensionChecker)ImplFactory.loadImplFromKey((String)"com.ibm.ws.management.tools.ExtensionChecker");
        extensionChecker.checkExtension(wASProduct, adminClient);
    }

    public String getNetmgrName() {
        if (this.netmgrName == null) {
            this.netmgrName = Utils.getNetmgrName(this.adminClient);
        }
        return this.netmgrName;
    }

    protected String getBackupRoot(RepositoryImpl repositoryImpl, VariableMapImpl variableMapImpl) {
        String string = null;
        try {
            block9: {
                block8: {
                    string = System.getProperty("was.repository.backup");
                    if (string == null) break block8;
                    if (!(string = string.replace('\\', '/')).endsWith("/")) break block9;
                    string = string.substring(0, string.length() - 1);
                    break block9;
                }
                Resource resource = repositoryImpl.getConfigRoot().getResource(4, "server.xml");
                Server server = (Server)resource.getContents().get(0);
                EList eList = server.getServices();
                for (int i = 0; i < eList.size(); ++i) {
                    Service service = (Service)eList.get(i);
                    if (!(service instanceof AdminService)) continue;
                    AdminService adminService = (AdminService)service;
                    RepositoryService repositoryService = adminService.getConfigRepository();
                    EList eList2 = repositoryService.getProperties();
                    for (int j = 0; j < eList2.size(); ++j) {
                        Property property = (Property)eList2.get(j);
                        String string2 = property.getName();
                        String string3 = property.getValue();
                        if (string2 == null || !string2.equals("was.repository.backup") || string3 == null) continue;
                        try {
                            string = variableMapImpl.expand(string3);
                            continue;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ws.management.tools.NodeRemoveUtility.getBackupRoot", (String)"300", (Object)this);
                        }
                    }
                    break;
                }
            }
            if (string == null) {
                string = this.configRoot + "/backup";
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.component.CellManagerImpl.start", (String)"190", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Error occurred initializing config: " + exception.getMessage()));
            }
            string = this.configRoot + "/backup";
        }
        return string;
    }

    protected VariableMap getVarMap(String string, String string2, String string3) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getVarMap: " + string + ", " + string2 + ", " + string3));
        }
        try {
            BeanContextServicesSupport beanContextServicesSupport = new BeanContextServicesSupport();
            RepositoryImpl repositoryImpl = new RepositoryImpl("ws-server", string, string2, string3, null);
            beanContextServicesSupport.addService(class$com$ibm$ws$runtime$service$Repository == null ? (class$com$ibm$ws$runtime$service$Repository = AbstractNodeConfigUtility.class$("com.ibm.ws.runtime.service.Repository")) : class$com$ibm$ws$runtime$service$Repository, (BeanContextServiceProvider)repositoryImpl);
            VariableMapImpl variableMapImpl = new VariableMapImpl();
            beanContextServicesSupport.add(variableMapImpl);
            variableMapImpl.initialize(null);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getVarMap: " + variableMapImpl));
            }
            return variableMapImpl;
        }
        catch (Throwable throwable) {
            this.issueMessage("ADMU2027E", new Object[]{throwable, string, string2, string3}, null);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getVarMap: NULL returned");
            }
            return null;
        }
    }

    protected void expandEar(String string, Vector vector, VariableMap variableMap) {
        Vector<String> vector2 = new Vector<String>();
        for (int i = 0; i < vector.size(); ++i) {
            vector2.addElement(variableMap.expand((String)vector.elementAt(i)));
        }
        this.expandEar(string, vector2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void expandEar(String string, Vector vector) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("expandEar: " + string + ", " + vector));
        }
        if (vector == null) return;
        if (vector.size() == 0) {
            return;
        }
        EARFile eARFile = null;
        try {
            try {
                eARFile = EarUtils.getEarFile(string, false, true);
                for (int i = 0; i < vector.size(); ++i) {
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Expanding at: " + vector.elementAt(i)));
                        }
                        EarUtils.extractEar(eARFile, (String)vector.elementAt(i), true);
                        continue;
                    }
                    catch (Throwable throwable) {
                        this.issueMessage("ADMU2028E", new Object[]{throwable, string, vector.elementAt(i)}, null);
                    }
                }
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                this.issueMessage("ADMU2029E", new Object[]{throwable, string}, null);
                Object var7_8 = null;
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("expandEar: " + string));
                }
                if (eARFile == null) return;
                eARFile.close();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("expandEar: " + string));
            }
            if (eARFile == null) throw throwable;
            eARFile.close();
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("expandEar: " + string));
        }
        if (eARFile == null) return;
        eARFile.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Vector getDeploymentPaths(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getDeploymentPaths: " + string));
        }
        Vector<String> vector = new Vector<String>();
        File file = new File(string);
        if (!file.exists()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getDeploymentPaths: " + string + " does not exist."));
            }
            return vector;
        }
        File[] fileArray = file.listFiles();
        ResourceSet resourceSet = this.createResourceSet(string);
        int i = 0;
        while (true) {
            block17: {
                if (i >= fileArray.length) {
                    return vector;
                }
                if (fileArray[i].isDirectory()) {
                    block18: {
                        Object var14_14;
                        String string2 = fileArray[i].getName() + "/deployment.xml";
                        Resource resource = null;
                        try {
                            block16: {
                                try {
                                    String string3;
                                    URI uRI;
                                    Deployment deployment;
                                    ApplicationDeployment applicationDeployment;
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)("Loading: " + string2));
                                    }
                                    if (!(applicationDeployment = (ApplicationDeployment)(deployment = (Deployment)(resource = resourceSet.getResource(uRI = URI.createURI((String)string2), true)).getContents().get(0)).getDeployedObject()).isEnableDistribution() || vector.contains(string3 = applicationDeployment.getBinariesURL().replace('\\', '/'))) break block16;
                                    vector.addElement(string3);
                                }
                                catch (Throwable throwable) {
                                    this.issueMessage("ADMU2030E", new Object[]{throwable, string + File.pathSeparator + string2}, null);
                                    var14_14 = null;
                                    if (resource != null) {
                                        resource.unload();
                                    }
                                    if (tc.isEntryEnabled()) {
                                        Tr.exit((TraceComponent)tc, (String)("getDeploymentPaths: " + vector));
                                    }
                                    break block17;
                                }
                            }
                            var14_14 = null;
                            if (resource == null) break block18;
                        }
                        catch (Throwable throwable) {
                            var14_14 = null;
                            if (resource != null) {
                                resource.unload();
                            }
                            if (tc.isEntryEnabled()) {
                                Tr.exit((TraceComponent)tc, (String)("getDeploymentPaths: " + vector));
                            }
                            throw throwable;
                        }
                        resource.unload();
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)("getDeploymentPaths: " + vector));
                    }
                }
            }
            ++i;
        }
    }

    protected ResourceSet createResourceSet(final String string) {
        WASResourceSetImpl wASResourceSetImpl = new WASResourceSetImpl();
        URIConverterImpl uRIConverterImpl = new URIConverterImpl(){

            public URI normalize(URI uRI) {
                if (uRI.isRelative()) {
                    return uRI.resolve(URI.createFileURI((String)(string + File.separator)));
                }
                return super.normalize(uRI);
            }
        };
        wASResourceSetImpl.setURIConverter((URIConverter)uRIConverterImpl);
        return wASResourceSetImpl;
    }

    protected void terminateAllServers() throws Exception {
        Vector vector = this.getServers();
        for (int i = 0; i < vector.size(); ++i) {
            String string;
            String string2 = (String)vector.get(i);
            String string3 = this.getVariableMap().expand("${LOG_ROOT}/" + string2);
            File file = new File(string3, string = string2 + ".pid");
            if (!file.exists()) continue;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string4 = bufferedReader.readLine();
            file.delete();
            Process process = ProcessFactory.bindTo((String)string4);
            process.stop();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ShutdownThread
    extends Thread {
        ShutdownThread() {
        }

        public void run() {
            AbstractNodeConfigUtility.this.toolFailed();
        }
    }
}

