/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.tools;

import com.ibm.ejs.ras.ManagerAdmin;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.adminservice.JMXConnector;
import com.ibm.ws.management.tools.LaunchUtils;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.management.ObjectName;

public abstract class AdminTool {
    public static String BUNDLE_NAME = "com.ibm.ws.management.resources.nodeutils";
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$tools$AdminTool == null ? (class$com$ibm$ws$management$tools$AdminTool = AdminTool.class$("com.ibm.ws.management.tools.AdminTool")) : class$com$ibm$ws$management$tools$AdminTool), (String)"Admin", (String)BUNDLE_NAME);
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    public static final String ALL_TRACE = "com.ibm.*=all=enabled";
    public static final String TRACE_PROP = "com.ibm.ws.tools.trace.traceString";
    public static final String TRACE_FILE_PROP = "com.ibm.ws.tools.trace.traceFile";
    public static final String DEBUG_PROP = "com.ibm.ws.tools.trace";
    public static final int STATUS_TIMEOUT = 300000;
    public static final int MAX_MSG_LEN = 79;
    public static final String INDENT = "           ";
    protected static final int BAD_OPTION = -1;
    protected static final int EXPECTED_PARAMETER = -2;
    protected static final int INVALID_PARAMETER = -3;
    protected String configRoot;
    protected String cellName;
    protected String nodeName;
    protected boolean nowait = false;
    protected String userid = null;
    protected String pwd = null;
    protected String logfile = null;
    private boolean replacelog = false;
    private boolean trace = false;
    private boolean quiet = false;
    private boolean help = false;
    private boolean isDoubleByteSystem = false;
    private boolean isDoubleByteTested = false;
    protected Integer statusPort = null;
    protected ServerSocket statusSocket = null;
    protected int statusTimeout = 0;
    static /* synthetic */ Class class$com$ibm$ws$management$tools$AdminTool;

    protected AdminTool() {
    }

    protected abstract String getDefaultTraceString();

    protected abstract String getDefaultTraceFile();

    protected abstract int getMinimumNumArgs();

    protected abstract void issueUsageMessage();

    protected abstract int parseRequiredArgs(String[] var1) throws AdminException;

    protected abstract int runTool() throws Exception;

    protected void toolFailed(Throwable throwable) {
    }

    protected int executeUtility(String[] stringArray) {
        int n;
        block14: {
            n = 0;
            try {
                boolean bl = this.parseArgs(stringArray);
                if (!bl) {
                    if (!this.help) {
                        return -1;
                    }
                    return 0;
                }
                if (!this.setTrace()) {
                    return -1;
                }
                if (tc.isDebugEnabled()) {
                    String string = "";
                    boolean bl2 = false;
                    if (stringArray != null || stringArray.length > 0) {
                        for (int i = 0; i < stringArray.length; ++i) {
                            if (stringArray[i].equals("-password")) {
                                string = string + stringArray[i].toString() + " ";
                                bl2 = true;
                                continue;
                            }
                            if (bl2) {
                                String string2 = "";
                                for (int j = 0; j < stringArray[i].length(); ++j) {
                                    string2 = string2 + "*";
                                }
                                string = string + string2 + " ";
                                bl2 = false;
                                continue;
                            }
                            string = string + stringArray[i].toString() + " ";
                        }
                    }
                    Tr.debug((TraceComponent)tc, (String)("executing utility with arguments: " + string));
                }
                n = this.runTool();
            }
            catch (Throwable throwable) {
                Tr.error((TraceComponent)tc, (String)"ADMU0111E", (Object)throwable);
                this.toolFailed(throwable);
                n = throwable.getCause() != null ? this.issueMessage("ADMU0113E", new Object[]{throwable, throwable.getCause()}, null) : this.issueMessage("ADMU0111E", new Object[]{throwable}, null);
                String string = throwable.getMessage();
                if (string != null && string.startsWith("ADMN0022E")) {
                    this.issueMessage("ADMU4113E", null, null);
                } else if (string != null && (string.startsWith("ADMC0016E") || string.startsWith("ADMC0018E"))) {
                    this.issueMessage("ADMU4123E", null, null);
                }
                this.issueMessage("ADMU0211I", new Object[]{this.logfile}, null);
                if (this.trace) break block14;
                this.issueMessage("ADMU1211I", null, null);
            }
        }
        return n;
    }

    protected boolean parseArgs(String[] stringArray) throws AdminException {
        if (this.isHelpNeeded(stringArray)) {
            return false;
        }
        if (!this.isGivenMinimumNumArgs(stringArray)) {
            return false;
        }
        this.configRoot = stringArray[0];
        this.cellName = stringArray[1];
        this.nodeName = stringArray[2];
        int n = this.parseRequiredArgs(stringArray);
        if (n < 0) {
            this.issueUsageMessage();
            return false;
        }
        for (int i = n; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.equals("-nowait")) {
                this.nowait = true;
                continue;
            }
            if (string.equals("-quiet")) {
                this.quiet = true;
                continue;
            }
            if (string.equals("-trace")) {
                this.trace = true;
                continue;
            }
            if (string.equals("-logfile")) {
                if (this.isValidParameter(stringArray, i + 1)) {
                    this.logfile = stringArray[i + 1];
                    ++i;
                    continue;
                }
                this.issueExpectedParameterMessage(stringArray[i]);
                return false;
            }
            if (string.equals("-replacelog")) {
                this.replacelog = true;
                continue;
            }
            if (string.equals("-username") || string.equals("-user")) {
                if (this.isValidParameter(stringArray, i + 1)) {
                    this.userid = stringArray[i + 1];
                    ++i;
                    continue;
                }
                this.issueExpectedParameterMessage(stringArray[i]);
                return false;
            }
            if (string.equals("-password")) {
                if (this.isValidParameter(stringArray, i + 1)) {
                    this.pwd = stringArray[i + 1];
                    ++i;
                    continue;
                }
                this.issueExpectedParameterMessage(stringArray[i]);
                return false;
            }
            if (string.equals("-statusport")) {
                if (this.isValidParameter(stringArray, i + 1)) {
                    this.statusPort = new Integer(stringArray[i + 1]);
                    ++i;
                    continue;
                }
                this.issueExpectedParameterMessage(stringArray[i]);
                return false;
            }
            int n2 = this.parseUtilitySpecificOption(stringArray, i);
            if (n2 < 0) {
                this.issueBadOptionsMessage(n2, stringArray[i]);
                return false;
            }
            i = n2 - 1;
        }
        return true;
    }

    private void issueBadOptionsMessage(int n, String string) {
        if (n == -1) {
            this.issueUnknownOptionMessage(string);
        } else if (n == -2) {
            this.issueExpectedParameterMessage(string);
        } else if (n == -3) {
            this.issueInvalidParameterMessage(string);
        }
    }

    private void issueUnknownOptionMessage(String string) {
        this.issueMessage("ADMU9991E", new Object[]{string}, null);
        this.issueUsageMessage();
    }

    private void issueExpectedParameterMessage(String string) {
        this.issueMessage("ADMU9992E", new Object[]{string}, null);
        this.issueUsageMessage();
    }

    private void issueInvalidParameterMessage(String string) {
        this.issueMessage("ADMU9992E", new Object[]{string}, null);
        this.issueUsageMessage();
    }

    protected boolean isValidParameter(String[] stringArray, int n) {
        return stringArray.length > n && !stringArray[n].startsWith("-");
    }

    private boolean isHelpNeeded(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-?") && !stringArray[i].equals("-help")) continue;
            this.issueUsageMessage();
            this.help = true;
            return true;
        }
        return false;
    }

    private boolean isGivenMinimumNumArgs(String[] stringArray) {
        int n = 0;
        for (int i = 0; i < stringArray.length && this.isValidMinimumArgument(stringArray[i]); ++i) {
            ++n;
        }
        if (n < this.getMinimumNumArgs()) {
            this.issueUsageMessage();
            return false;
        }
        return true;
    }

    protected boolean isValidMinimumArgument(String string) {
        return !string.startsWith("-");
    }

    protected int parseUtilitySpecificOption(String[] stringArray, int n) {
        return -1;
    }

    protected String[] stopAllServers() throws Exception {
        Vector vector = this.getServers();
        this.issueMessage("ADMU2010I", new Object[]{this.nodeName}, null);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.get(i);
            JMXConnector jMXConnector = LaunchUtils.getJMXConnector(this.configRoot, this.cellName, this.nodeName, string);
            if (jMXConnector == null) continue;
            AdminClient adminClient = null;
            try {
                adminClient = LaunchUtils.getAdminClient(jMXConnector, this.configRoot, this.cellName, this.nodeName, string, this.userid, this.pwd);
            }
            catch (Exception exception) {
                this.issueMessage("ADMU0512I", new Object[]{string}, null);
            }
            if (adminClient == null) continue;
            this.sendStop(adminClient, string);
            arrayList.add(string);
        }
        String[] stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    protected Vector getServers() throws Exception {
        Vector vector = this.getServerList();
        if (vector == null || vector.size() == 0) {
            this.issueMessage("ADMU0507I", new Object[]{this.configRoot + "/cells/" + this.cellName + "/nodes/" + this.nodeName + "/servers"}, null);
        } else {
            this.issueMessage("ADMU0505I", null, null);
            for (int i = 0; i < vector.size(); ++i) {
                this.issueMessage("ADMU0506I", new Object[]{vector.elementAt(i)}, null);
            }
        }
        return vector;
    }

    protected Vector getServerList() throws Exception {
        Vector<String> vector = new Vector<String>();
        String string = this.configRoot + "/cells/" + this.cellName + "/nodes/" + this.nodeName + "/servers";
        File file = new File(string);
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].isDirectory()) continue;
                String string2 = fileArray[i].getName();
                vector.add(string2);
            }
        }
        return vector;
    }

    private void sendStop(AdminClient adminClient, String string) throws Exception {
        boolean bl = true;
        boolean bl2 = false;
        int n = -10;
        ObjectName objectName = this.getServerHandle(adminClient);
        if (this.statusPort == null) {
            this.statusSocket = LaunchUtils.getFreePort(300000);
            this.statusPort = new Integer(this.statusSocket.getLocalPort());
        }
        if (objectName != null) {
            String string2 = "stop";
            String[] stringArray = new String[]{"java.lang.Boolean", "java.lang.Integer"};
            Object[] objectArray = new Object[]{new Boolean(true), this.statusPort};
            try {
                adminClient.invoke(objectName, string2, objectArray, stringArray);
            }
            catch (Exception exception) {
                try {
                    adminClient.isAlive();
                    bl2 = true;
                    throw exception;
                }
                catch (Exception exception2) {
                    if (bl2) {
                        throw exception2;
                    }
                    bl = false;
                    n = 0;
                }
            }
            if (bl) {
                n = LaunchUtils.waitForServer(this.statusSocket);
            }
            if (n == 0) {
                this.issueMessage("ADMU0510I", new Object[]{string, "STOPPED"}, null);
            } else {
                this.issueMessage("ADMU0021E", null, null);
                String string3 = new Integer(this.statusTimeout / 1000).toString();
                throw new AdminException(this.getFormattedMessage("ADMU3060E", new Object[]{string3}, "Timed out waiting for server shutdown."));
            }
        }
    }

    protected Integer getStatusPort() {
        this.initStatusPort();
        return this.statusPort;
    }

    protected ServerSocket getStatusSocket() {
        this.initStatusPort();
        return this.statusSocket;
    }

    private void initStatusPort() {
        if (this.statusSocket != null) {
            return;
        }
        int n = 0;
        if (this.statusPort != null) {
            n = this.statusPort;
        }
        try {
            this.statusSocket = new ServerSocket(n);
            this.statusSocket.setSoTimeout(this.statusTimeout);
            this.statusPort = new Integer(this.statusSocket.getLocalPort());
        }
        catch (IOException iOException) {
            Tr.error((TraceComponent)tc, (String)"ADMU3012E", (Object)iOException);
        }
    }

    protected ObjectName getServerHandle(AdminClient adminClient) throws Exception {
        ObjectName objectName = adminClient.getServerMBean();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Repository handle is ==> " + objectName.getCanonicalName()));
        }
        return objectName;
    }

    private boolean setTrace() {
        String string = null;
        if (this.trace) {
            string = ALL_TRACE;
            this.issueMessage("ADMU0115I", null, null);
        } else {
            string = this.getDefaultTraceString();
        }
        if (this.logfile == null) {
            this.logfile = this.getDefaultTraceFile();
        }
        boolean bl = true;
        if (!ManagerAdmin.isLogFileWriteable((String)this.logfile)) {
            this.issueMessage("ADMU0118E", new Object[]{new File(this.logfile).getAbsolutePath()}, null);
            bl = false;
        }
        if (bl) {
            this.issueMessage("ADMU0116I", new Object[]{new File(this.logfile).getAbsolutePath()}, null);
            ManagerAdmin.configureClientTrace((String)string, (String)"named file", (String)this.logfile, (boolean)this.replacelog, (String)"basic", (boolean)false);
        }
        return true;
    }

    protected int issueMessage(String string, Object[] objectArray, String string2) {
        String string3 = this.getFormattedMessage(string, objectArray, string2);
        if (string3 == null) {
            string3 = this.getFormattedMessage("ADMU0123E", new Object[]{string}, null);
        }
        if (!this.quiet) {
            this.printMessage(string3);
        }
        this.emitNotification(string, string3);
        Tr.audit((TraceComponent)tc, (String)string, (Object)objectArray);
        return this.retcodeFromMessage(string3);
    }

    private void printMessage(String string) {
        int n = 79;
        if (this.isDoubleByteSystem(string)) {
            n /= 2;
        }
        this.printMessage(string, n, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDoubleByteSystem(String string) {
        if (!this.isDoubleByteTested) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            try {
                dataOutputStream.writeUTF(string);
                dataOutputStream.flush();
            }
            catch (IOException iOException) {
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    dataOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            this.isDoubleByteSystem = (double)byArray.length > (double)string.length() + (double)string.length() * 0.1;
        }
        return this.isDoubleByteSystem;
    }

    private void printMessage(String string, int n, boolean bl) {
        int n2 = n;
        if (bl) {
            System.out.print(INDENT);
            n2 -= INDENT.length();
        }
        if (string.length() <= n2) {
            System.out.println(string);
        } else {
            int n3 = string.lastIndexOf(32, n2);
            if (n3 == -1 && (n3 = string.indexOf(32)) == -1) {
                System.out.println(string);
                return;
            }
            this.printMessage(string.substring(0, n3), n, false);
            this.printMessage(string.substring(n3 + 1), n, true);
        }
    }

    protected String getFormattedMessage(String string, Object[] objectArray, String string2) {
        try {
            String string3 = RESOURCE_BUNDLE.getString(string);
            if (string3 == null) {
                return string2;
            }
            return MessageFormat.format(string3, objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            if (string2 == null) {
                return string2;
            }
            return MessageFormat.format(string2, objectArray);
        }
        catch (NullPointerException nullPointerException) {
            return string2;
        }
    }

    protected void emitNotification(String string, String string2) {
    }

    private int retcodeFromMessage(String string) {
        int n = 0;
        if (string == null) {
            return n;
        }
        if (string.startsWith("ADM")) {
            String string2 = string.substring(4, 8);
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
        }
        return n;
    }

    private String toString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i] + " ");
        }
        return stringBuffer.toString();
    }

    public void setQuiet(boolean bl) {
        this.quiet = bl;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

