/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.tools;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.config.ModelMgr;
import com.ibm.ws.management.tools.AdminTool;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class BackupConfigUtility
extends AdminTool {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$tools$NodeFederationUtility == null ? (class$com$ibm$ws$management$tools$NodeFederationUtility = BackupConfigUtility.class$("com.ibm.ws.management.tools.NodeFederationUtility")) : class$com$ibm$ws$management$tools$NodeFederationUtility), (String)"Admin", (String)"com.ibm.ws.management.resources.nodeutils");
    private static final String DEFAULT_TRACE_STRING = "*=all=disabled";
    private static final String DEFAULT_TRACE_FILE = "backupConfig.log";
    public static final int BUFFER_SIZE = 1024;
    public static final String[] DO_NOT_COMPRESS_LIST = new String[]{".zip", ".jar", ".ear", ".war", ".rar"};
    public static final String NAME_PREFIX = "WebSphereConfig_";
    private File backupFile;
    private boolean stopServers = true;
    private byte[] buffer = new byte[1024];
    private int numFilesBackedUp = 0;
    static /* synthetic */ Class class$com$ibm$ws$management$tools$NodeFederationUtility;

    public static void main(String[] stringArray) {
        System.exit(new BackupConfigUtility().executeUtility(stringArray));
    }

    protected String getDefaultTraceString() {
        return DEFAULT_TRACE_STRING;
    }

    protected String getDefaultTraceFile() {
        String string = System.getProperty("user.install.root");
        if (string == null || string.length() <= 0) {
            string = System.getProperty("was.install.root");
        }
        string = string + File.separator + "logs";
        string = string + File.separator + DEFAULT_TRACE_FILE;
        return string;
    }

    protected int getMinimumNumArgs() {
        return 3;
    }

    protected void issueUsageMessage() {
        this.issueMessage("ADMU5000I", null, null);
    }

    protected int parseRequiredArgs(String[] stringArray) {
        int n = 3;
        if (stringArray.length > 3 && !stringArray[3].startsWith("-")) {
            this.backupFile = new File(stringArray[3]);
            n = 4;
        } else {
            this.backupFile = new File(this.generateBackupName());
        }
        return n;
    }

    protected int parseUtilitySpecificOption(String[] stringArray, int n) {
        int n2 = n + 1;
        if (stringArray[n].equals("-nostop")) {
            this.stopServers = false;
        } else {
            n2 = -1;
        }
        return n2;
    }

    protected int runTool() throws Exception {
        if (this.backupFile.getCanonicalPath().startsWith(new File(this.configRoot).getCanonicalPath())) {
            this.issueMessage("xxxx", null, "ADMU5002E: Cannot create backup file in config directory");
            return -1;
        }
        this.issueMessage("ADMU5001I", new Object[]{this.configRoot, this.backupFile.getCanonicalPath()}, null);
        try {
            ModelMgr.initialize((String)"ws-server");
            Object var1_1 = null;
            if (this.stopServers) {
                this.stopAllServers();
            }
            this.compressConfigDir();
            this.issueMessage("ADMU5002I", new Object[]{new Integer(this.numFilesBackedUp)}, null);
            return 0;
        }
        catch (Exception exception) {
            this.backupFile.delete();
            throw exception;
        }
    }

    private String generateBackupName() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(NAME_PREFIX);
        stringBuffer.append(String.valueOf(calendar.get(1)) + "-");
        stringBuffer.append(this.getStringValWithLength2(calendar.get(2) + 1) + "-");
        stringBuffer.append(this.getStringValWithLength2(calendar.get(5)));
        String string = stringBuffer.toString();
        return this.makeNameUnique(string) + ".zip";
    }

    private String getStringValWithLength2(int n) {
        if (n < 10) {
            return "0" + String.valueOf(n);
        }
        return String.valueOf(n);
    }

    private String makeNameUnique(String string) {
        String string2 = string;
        int n = 1;
        while (new File(string2 + ".zip").exists()) {
            string2 = string + "_" + String.valueOf(n++);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compressConfigDir() throws IOException {
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(this.backupFile));
        try {
            File file = new File(this.configRoot);
            this.zipFileRecursive(file, zipOutputStream);
        }
        finally {
            System.out.println();
            zipOutputStream.close();
        }
    }

    private void zipFileRecursive(File file, ZipOutputStream zipOutputStream) throws IOException {
        if (file.isDirectory()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Backing up directory " + file.getCanonicalPath()));
            }
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                this.zipFileRecursive(fileArray[i], zipOutputStream);
            }
        } else {
            this.zipFile(file, zipOutputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zipFile(File file, ZipOutputStream zipOutputStream) throws IOException {
        if (!this.isQuiet()) {
            System.out.print('.');
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Backing up file " + file));
        }
        ZipEntry zipEntry = new ZipEntry(this.getRelativeName(file));
        zipEntry.setSize(file.length());
        zipEntry.setTime(file.lastModified());
        zipEntry.setSize(file.length());
        this.setCompressionMethod(zipEntry);
        zipOutputStream.putNextEntry(zipEntry);
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            int n = 0;
            while ((n = fileInputStream.read(this.buffer)) > -1) {
                zipOutputStream.write(this.buffer, 0, n);
            }
        }
        finally {
            fileInputStream.close();
        }
        zipOutputStream.closeEntry();
        ++this.numFilesBackedUp;
    }

    private String getRelativeName(File file) {
        return file.getPath().substring(this.configRoot.length() + 1);
    }

    private void setCompressionMethod(ZipEntry zipEntry) {
        String string = zipEntry.getName();
        for (int i = 0; i < DO_NOT_COMPRESS_LIST.length; ++i) {
            if (!string.endsWith(DO_NOT_COMPRESS_LIST[i])) continue;
            zipEntry.setMethod(0);
        }
        zipEntry.setMethod(8);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

