/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.tools;

import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.etools.commonarchive.init.ArchiveInit;
import com.ibm.websphere.models.config.adminservice.AdminService;
import com.ibm.websphere.models.config.adminservice.AdminserviceFactory;
import com.ibm.websphere.models.config.adminservice.AdminservicePackage;
import com.ibm.websphere.models.config.adminservice.JMXConnector;
import com.ibm.websphere.models.config.adminservice.RMIConnector;
import com.ibm.websphere.models.config.adminservice.RepositoryService;
import com.ibm.websphere.models.config.adminservice.SOAPConnector;
import com.ibm.websphere.models.config.applicationserver.ApplicationServer;
import com.ibm.websphere.models.config.applicationserver.ApplicationserverFactory;
import com.ibm.websphere.models.config.applicationserver.ApplicationserverPackage;
import com.ibm.websphere.models.config.applicationserver.TransactionService;
import com.ibm.websphere.models.config.applicationserver.ejbcontainer.EJBCache;
import com.ibm.websphere.models.config.applicationserver.ejbcontainer.EJBContainer;
import com.ibm.websphere.models.config.applicationserver.ejbcontainer.EjbcontainerFactory;
import com.ibm.websphere.models.config.applicationserver.ejbcontainer.EjbcontainerPackage;
import com.ibm.websphere.models.config.applicationserver.webcontainer.WebContainer;
import com.ibm.websphere.models.config.applicationserver.webcontainer.WebcontainerFactory;
import com.ibm.websphere.models.config.applicationserver.webcontainer.WebcontainerPackage;
import com.ibm.websphere.models.config.classloader.ClassLoaderPolicy;
import com.ibm.websphere.models.config.init.ConfigInit;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.ipc.IpcFactory;
import com.ibm.websphere.models.config.ipc.IpcPackage;
import com.ibm.websphere.models.config.loggingservice.ras.MessageFilterLevelKind;
import com.ibm.websphere.models.config.loggingservice.ras.RASLoggingService;
import com.ibm.websphere.models.config.loggingservice.ras.RasFactory;
import com.ibm.websphere.models.config.loggingservice.ras.RasPackage;
import com.ibm.websphere.models.config.loggingservice.ras.ServiceLog;
import com.ibm.websphere.models.config.messagingserver.JMSServer;
import com.ibm.websphere.models.config.messagingserver.MessagingserverFactory;
import com.ibm.websphere.models.config.messagingserver.MessagingserverPackage;
import com.ibm.websphere.models.config.namingserver.NameServer;
import com.ibm.websphere.models.config.namingserver.NamingserverFactory;
import com.ibm.websphere.models.config.namingserver.NamingserverPackage;
import com.ibm.websphere.models.config.orb.Interceptor;
import com.ibm.websphere.models.config.orb.ORBPlugin;
import com.ibm.websphere.models.config.orb.ObjectRequestBroker;
import com.ibm.websphere.models.config.orb.OrbFactory;
import com.ibm.websphere.models.config.orb.OrbPackage;
import com.ibm.websphere.models.config.pmiservice.PmiserviceFactory;
import com.ibm.websphere.models.config.pmiservice.PmiservicePackage;
import com.ibm.websphere.models.config.process.ExecutionState;
import com.ibm.websphere.models.config.process.MessageFormatKind;
import com.ibm.websphere.models.config.process.ProcessFactory;
import com.ibm.websphere.models.config.process.ProcessPackage;
import com.ibm.websphere.models.config.process.RolloverType;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.process.StateManageable;
import com.ibm.websphere.models.config.process.StatisticsProvider;
import com.ibm.websphere.models.config.process.StreamRedirect;
import com.ibm.websphere.models.config.process.ThreadPool;
import com.ibm.websphere.models.config.processexec.JavaProcessDef;
import com.ibm.websphere.models.config.processexec.JavaVirtualMachine;
import com.ibm.websphere.models.config.processexec.MonitoringPolicy;
import com.ibm.websphere.models.config.processexec.OutputRedirect;
import com.ibm.websphere.models.config.processexec.ProcessDef;
import com.ibm.websphere.models.config.processexec.ProcessExecution;
import com.ibm.websphere.models.config.processexec.ProcessexecFactory;
import com.ibm.websphere.models.config.processexec.ProcessexecPackage;
import com.ibm.websphere.models.config.processexec.RestartStateKind;
import com.ibm.websphere.models.config.properties.PropertiesFactory;
import com.ibm.websphere.models.config.properties.PropertiesPackage;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.topology.node.NodeFactory;
import com.ibm.websphere.models.config.topology.node.NodePackage;
import com.ibm.websphere.models.config.traceservice.TraceFormatKind;
import com.ibm.websphere.models.config.traceservice.TraceLog;
import com.ibm.websphere.models.config.traceservice.TraceOutputKind;
import com.ibm.websphere.models.config.traceservice.TraceService;
import com.ibm.websphere.models.config.traceservice.TraceserviceFactory;
import com.ibm.websphere.models.config.traceservice.TraceservicePackage;
import com.ibm.websphere.resource.WASResourceSetImpl;
import java.io.File;
import java.util.HashMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;

public class JMSServerConfigBuilder {
    protected ProcessFactory processFactory;
    protected ProcessexecFactory processexecFactory;
    protected IpcFactory ipcFactory;
    protected TraceserviceFactory traceServiceFactory;
    protected PropertiesFactory propFactory;
    protected NodeFactory nodeFactory;
    protected OrbFactory orbFactory;
    protected NamingserverFactory namingFactory;
    protected AdminserviceFactory adminFactory;
    protected RasFactory rasFactory;
    protected PmiserviceFactory pmiFactory;
    protected MessagingserverFactory msgFactory;
    protected EjbcontainerFactory ejbContainerFactory;
    protected WebcontainerFactory webContainerFactory;
    protected ApplicationserverFactory appServerFactory;
    public static final String DEFAULT_PROCESS_NAME = "jmsserver";
    protected String procName;
    protected String configRoot;
    private String nodeName;

    public void setConfigRepositoryRoot(String string) {
        this.configRoot = string;
    }

    public String getConfigRepositoryRoot() {
        if (this.configRoot == null || this.configRoot.equals("")) {
            this.configRoot = "unknown config root";
        }
        return this.configRoot;
    }

    public JMSServerConfigBuilder() {
        this.initializeFactories();
    }

    public EObject buildRootElements() {
        Server server = this.buildSampleProcess();
        return server;
    }

    public WebContainer buildSampleWebContainer(ApplicationServer applicationServer) {
        WebContainer webContainer = this.webContainerFactory.createWebContainer();
        applicationServer.getComponents().add((Object)webContainer);
        StateManageable stateManageable = this.processFactory.createStateManageable();
        stateManageable.setInitialState(ExecutionState.START_LITERAL);
        webContainer.setStateManagement(stateManageable);
        webContainer.setEnableServletCaching(true);
        ThreadPool threadPool = this.processFactory.createThreadPool();
        threadPool.setInactivityTimeout(3500);
        threadPool.setIsGrowable(false);
        threadPool.setMaximumSize(50);
        threadPool.setMinimumSize(10);
        webContainer.setThreadPool(threadPool);
        return webContainer;
    }

    public EJBContainer buildSampleEJBContainer(ApplicationServer applicationServer) {
        EJBContainer eJBContainer = this.ejbContainerFactory.createEJBContainer();
        StateManageable stateManageable = this.processFactory.createStateManageable();
        stateManageable.setInitialState(ExecutionState.START_LITERAL);
        eJBContainer.setStateManagement(stateManageable);
        EJBCache eJBCache = this.ejbContainerFactory.createEJBCache();
        eJBCache.setCacheSize(2053L);
        eJBCache.setCleanupInterval(3000L);
        eJBContainer.setCacheSettings(eJBCache);
        eJBContainer.setPassivationDirectory("${USER_INSTALL_ROOT}/temp");
        eJBContainer.setInactivePoolCleanupInterval(30000L);
        return eJBContainer;
    }

    public void setupSampleApplicationServerServices(ApplicationServer applicationServer) {
        TransactionService transactionService = this.appServerFactory.createTransactionService();
        transactionService.setEnable(true);
        transactionService.setClientInactivityTimeout(60);
        transactionService.setTotalTranLifetimeTimeout(120);
        applicationServer.getServices().add((Object)transactionService);
    }

    public ApplicationServer buildApplicationServer(String string) {
        ApplicationServer applicationServer = this.appServerFactory.createApplicationServer();
        applicationServer.setApplicationClassLoaderPolicy(ClassLoaderPolicy.MULTIPLE_LITERAL);
        return applicationServer;
    }

    public ApplicationServer buildSampleApplicationServer() {
        ApplicationServer applicationServer = this.buildApplicationServer("");
        ProcessPackage processPackage = this.processFactory.getProcessPackage();
        StateManageable stateManageable = this.processFactory.createStateManageable();
        stateManageable.setInitialState(ExecutionState.START_LITERAL);
        applicationServer.setStateManagement(stateManageable);
        this.setupSampleApplicationServerServices(applicationServer);
        EJBContainer eJBContainer = this.buildSampleEJBContainer(applicationServer);
        WebContainer webContainer = this.buildSampleWebContainer(applicationServer);
        applicationServer.getComponents().add((Object)eJBContainer);
        applicationServer.getComponents().add((Object)webContainer);
        return applicationServer;
    }

    public NameServer buildNameServer() {
        NameServer nameServer = this.namingFactory.createNameServer();
        ProcessPackage processPackage = this.processFactory.getProcessPackage();
        StateManageable stateManageable = this.processFactory.createStateManageable();
        stateManageable.setInitialState(ExecutionState.START_LITERAL);
        nameServer.setStateManagement(stateManageable);
        return nameServer;
    }

    public Server buildSampleProcess() {
        Server server = this.processFactory.createServer();
        server.setName(this.getProcessName());
        StreamRedirect streamRedirect = this.processFactory.createStreamRedirect();
        StreamRedirect streamRedirect2 = this.processFactory.createStreamRedirect();
        streamRedirect.setFileName("$(LOG_ROOT)/jmsserver/SystemOut.log");
        streamRedirect.setRolloverSize(1);
        streamRedirect.setRolloverType(RolloverType.SIZE_LITERAL);
        streamRedirect.setMaxNumberOfBackupFiles(1);
        streamRedirect.setBaseHour(24);
        streamRedirect.setRolloverPeriod(24);
        streamRedirect.setSuppressWrites(false);
        streamRedirect.setSuppressStackTrace(false);
        streamRedirect.setFormatWrites(true);
        streamRedirect.setMessageFormatKind(MessageFormatKind.BASIC_LITERAL);
        streamRedirect2.setFileName("$(LOG_ROOT)/jmsserver/SystemErr.log");
        streamRedirect2.setRolloverSize(1);
        streamRedirect2.setRolloverType(RolloverType.SIZE_LITERAL);
        streamRedirect2.setMaxNumberOfBackupFiles(1);
        streamRedirect2.setBaseHour(24);
        streamRedirect2.setRolloverPeriod(24);
        streamRedirect2.setSuppressWrites(false);
        streamRedirect2.setSuppressStackTrace(false);
        streamRedirect2.setFormatWrites(true);
        streamRedirect2.setMessageFormatKind(MessageFormatKind.BASIC_LITERAL);
        server.setOutputStreamRedirect(streamRedirect);
        server.setErrorStreamRedirect(streamRedirect2);
        ProcessPackage processPackage = this.processFactory.getProcessPackage();
        StateManageable stateManageable = this.processFactory.createStateManageable();
        stateManageable.setInitialState(ExecutionState.START_LITERAL);
        server.setStateManagement(stateManageable);
        StatisticsProvider statisticsProvider = this.processFactory.createStatisticsProvider();
        server.setStatisticsProvider(statisticsProvider);
        server.getStatisticsProvider().setSpecification("");
        server.getComponents().add((Object)this.buildJMSServer());
        server.getComponents().add((Object)this.buildNameServer());
        server.getComponents().add((Object)this.buildSampleApplicationServer());
        this.setupSampleServices(server);
        server.setProcessDefinition((ProcessDef)this.buildSampleProcessDef());
        return server;
    }

    public JavaProcessDef buildSampleProcessDef() {
        JavaProcessDef javaProcessDef = this.processexecFactory.createJavaProcessDef();
        javaProcessDef.setWorkingDirectory("${USER_INSTALL_ROOT}");
        javaProcessDef.getExecutableArguments().add((Object)"");
        OutputRedirect outputRedirect = this.processexecFactory.createOutputRedirect();
        outputRedirect.setStdoutFilename("${LOG_ROOT}/jmsserver/native_stdout.log");
        outputRedirect.setStderrFilename("${LOG_ROOT}/jmsserver/native_stderr.log");
        javaProcessDef.setIoRedirect(outputRedirect);
        ProcessExecution processExecution = this.processexecFactory.createProcessExecution();
        if (System.getProperty("os.name").equals("OS/400")) {
            processExecution.setRunAsUser("QEJBSVR");
            processExecution.setRunAsGroup("");
            processExecution.setProcessPriority(25);
        } else {
            processExecution.setRunAsUser("");
            processExecution.setRunAsGroup("");
            processExecution.setProcessPriority(1000);
        }
        javaProcessDef.setExecution(processExecution);
        JavaVirtualMachine javaVirtualMachine = this.processexecFactory.createJavaVirtualMachine();
        javaVirtualMachine.getClasspath().add((Object)"");
        javaVirtualMachine.getBootClasspath().add((Object)"");
        javaVirtualMachine.setVerboseModeClass(false);
        javaVirtualMachine.setVerboseModeGarbageCollection(false);
        javaVirtualMachine.setVerboseModeJNI(false);
        javaVirtualMachine.setDebugMode(false);
        javaVirtualMachine.setDebugArgs("-Djava.compiler=NONE -Xdebug -Xnoagent -Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=7777");
        javaVirtualMachine.setHprofArguments("");
        javaVirtualMachine.setRunHProf(false);
        javaProcessDef.getJvmEntries().add((Object)javaVirtualMachine);
        MonitoringPolicy monitoringPolicy = this.processexecFactory.createMonitoringPolicy();
        monitoringPolicy.setMaximumStartupAttempts(3);
        monitoringPolicy.setPingInterval(60);
        monitoringPolicy.setPingTimeout(300);
        monitoringPolicy.setAutoRestart(false);
        monitoringPolicy.setNodeRestartState(RestartStateKind.PREVIOUS_LITERAL);
        javaProcessDef.setMonitoringPolicy(monitoringPolicy);
        return javaProcessDef;
    }

    public void setProcessName(String string) {
        this.procName = string;
    }

    public void setNodeName(String string) {
        this.nodeName = string;
    }

    public String getProcessName() {
        if (this.procName != null) {
            return this.procName;
        }
        return DEFAULT_PROCESS_NAME;
    }

    public String getDocumentName() {
        return "server.xml";
    }

    public void initializeFactories() {
        CommonarchiveFactoryImpl.getActiveFactory();
        ArchiveInit.init();
        ConfigInit.init();
        PmiservicePackage pmiservicePackage = (PmiservicePackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/pmiservice.xmi");
        this.pmiFactory = pmiservicePackage.getPmiserviceFactory();
        AdminservicePackage adminservicePackage = (AdminservicePackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/adminservice.xmi");
        this.adminFactory = adminservicePackage.getAdminserviceFactory();
        RasPackage rasPackage = (RasPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/loggingservice.ras.xmi");
        this.rasFactory = rasPackage.getRasFactory();
        NodePackage nodePackage = (NodePackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/topology.node.xmi");
        this.nodeFactory = nodePackage.getNodeFactory();
        ProcessexecPackage processexecPackage = (ProcessexecPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/processexec.xmi");
        this.processexecFactory = processexecPackage.getProcessexecFactory();
        ProcessPackage processPackage = (ProcessPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/process.xmi");
        this.processFactory = processPackage.getProcessFactory();
        PropertiesPackage propertiesPackage = (PropertiesPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/properties.xmi");
        this.propFactory = propertiesPackage.getPropertiesFactory();
        IpcPackage ipcPackage = (IpcPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/ipc.xmi");
        this.ipcFactory = ipcPackage.getIpcFactory();
        TraceservicePackage traceservicePackage = (TraceservicePackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/traceservice.xmi");
        this.traceServiceFactory = traceservicePackage.getTraceserviceFactory();
        MessagingserverPackage messagingserverPackage = (MessagingserverPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/messagingserver.xmi");
        this.msgFactory = messagingserverPackage.getMessagingserverFactory();
        OrbPackage orbPackage = (OrbPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/orb.xmi");
        this.orbFactory = orbPackage.getOrbFactory();
        NamingserverPackage namingserverPackage = (NamingserverPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/namingserver.xmi");
        this.namingFactory = namingserverPackage.getNamingserverFactory();
        ApplicationserverPackage applicationserverPackage = (ApplicationserverPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/applicationserver.xmi");
        this.appServerFactory = applicationserverPackage.getApplicationserverFactory();
        EjbcontainerPackage ejbcontainerPackage = (EjbcontainerPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/applicationserver.ejbcontainer.xmi");
        this.ejbContainerFactory = ejbcontainerPackage.getEjbcontainerFactory();
        WebcontainerPackage webcontainerPackage = (WebcontainerPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/applicationserver.webcontainer.xmi");
        this.webContainerFactory = webcontainerPackage.getWebcontainerFactory();
    }

    public ResourceSet getResourceSet() {
        WASResourceSetImpl wASResourceSetImpl = new WASResourceSetImpl();
        URIConverterImpl uRIConverterImpl = new URIConverterImpl(){

            public URI normalize(URI uRI) {
                if (uRI.isRelative()) {
                    return uRI.resolve(URI.createFileURI((String)(JMSServerConfigBuilder.this.getConfigRepositoryRoot() + File.separator)));
                }
                return super.normalize(uRI);
            }
        };
        wASResourceSetImpl.setURIConverter((URIConverter)uRIConverterImpl);
        return wASResourceSetImpl;
    }

    public void write(EObject eObject, String string) throws Exception {
        ResourceSet resourceSet = this.getResourceSet();
        URI uRI = URI.createFileURI((String)string);
        Resource resource = resourceSet.createResource(uRI);
        resource.getContents().add((Object)eObject);
        resource.save(new HashMap());
    }

    public void setupSampleServices(Server server) {
        AdminService adminService = this.adminFactory.createAdminService();
        adminService.setEnable(true);
        adminService.setStandalone(false);
        SOAPConnector sOAPConnector = this.adminFactory.createSOAPConnector();
        RMIConnector rMIConnector = this.adminFactory.createRMIConnector();
        Property property = this.propFactory.createProperty();
        property.setName("sslConfig");
        property.setValue(this.nodeName + "/DefaultSSLSettings");
        sOAPConnector.getProperties().add((Object)property);
        RepositoryService repositoryService = this.adminFactory.createRepositoryService();
        adminService.getConnectors().add((Object)sOAPConnector);
        adminService.getConnectors().add((Object)rMIConnector);
        adminService.setConfigRepository(repositoryService);
        adminService.setPreferredConnector((JMXConnector)sOAPConnector);
        server.getServices().add((Object)adminService);
        TraceService traceService = this.traceServiceFactory.createTraceService();
        traceService.setEnable(true);
        TraceLog traceLog = this.traceServiceFactory.createTraceLog();
        traceLog.setFileName("${LOG_ROOT}/jmsserver/trace.log");
        traceLog.setRolloverSize(20);
        traceLog.setMaxNumberOfBackupFiles(1);
        traceService.setTraceLog(traceLog);
        traceService.setStartupTraceSpecification("com.ibm.*=all=disabled");
        traceService.setTraceFormat(TraceFormatKind.BASIC_LITERAL);
        traceService.setTraceOutputType(TraceOutputKind.SPECIFIED_FILE_LITERAL);
        traceService.setMemoryBufferSize(8);
        server.getServices().add((Object)traceService);
        RASLoggingService rASLoggingService = this.rasFactory.createRASLoggingService();
        rASLoggingService.setEnable(true);
        rASLoggingService.setEnableCorrelationId(true);
        rASLoggingService.setMessageFilterLevel(MessageFilterLevelKind.NONE_LITERAL);
        ServiceLog serviceLog = this.rasFactory.createServiceLog();
        serviceLog.setName("${LOG_ROOT}/activity.log");
        serviceLog.setSize(2);
        serviceLog.setEnabled(true);
        rASLoggingService.setServiceLog(serviceLog);
        server.getServices().add((Object)rASLoggingService);
        ThreadPool threadPool = this.processFactory.createThreadPool();
        threadPool.setInactivityTimeout(3500);
        threadPool.setIsGrowable(false);
        threadPool.setMaximumSize(50);
        threadPool.setMinimumSize(10);
        ObjectRequestBroker objectRequestBroker = this.orbFactory.createObjectRequestBroker();
        objectRequestBroker.setEnable(true);
        objectRequestBroker.setThreadPool(threadPool);
        objectRequestBroker.setCommTraceEnabled(false);
        objectRequestBroker.setConnectionCacheMinimum(100);
        objectRequestBroker.setConnectionCacheMaximum(240);
        objectRequestBroker.setForceTunnel("never");
        objectRequestBroker.setLocateRequestTimeout(180);
        objectRequestBroker.setNoLocalCopies(true);
        objectRequestBroker.setRequestRetriesCount(1);
        objectRequestBroker.setRequestRetriesDelay(0);
        objectRequestBroker.setRequestTimeout(180);
        this.addORBPlugin(objectRequestBroker, "com.ibm.ws.orbimpl.transport.WSTransport");
        this.addORBPlugin(objectRequestBroker, "com.ibm.ISecurityUtilityImpl.SecurityPropertyManager");
        this.addORBPlugin(objectRequestBroker, "com.ibm.ws.orbimpl.WSORBPropertyManager");
        this.addORBInterceptor(objectRequestBroker, "com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityComponentFactory");
        this.addORBInterceptor(objectRequestBroker, "com.ibm.ISecurityLocalObjectBaseL13Impl.ServerRIWrapper");
        this.addORBInterceptor(objectRequestBroker, "com.ibm.ISecurityLocalObjectBaseL13Impl.ClientRIWrapper");
        this.addORBInterceptor(objectRequestBroker, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIClientRI");
        this.addORBInterceptor(objectRequestBroker, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIServerRI");
        this.addORBProperty(objectRequestBroker, "com.ibm.CORBA.enableLocateRequest", "true");
        this.addORBProperty(objectRequestBroker, "com.ibm.CORBA.WSSSLServerSocketFactoryName", "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl");
        this.addORBProperty(objectRequestBroker, "com.ibm.CORBA.WSSSLClientSocketFactoryName", "com.ibm.ws.security.orbssl.WSSSLClientSocketFactoryImpl");
        this.addORBProperty(objectRequestBroker, "com.ibm.CORBA.ConnectionInterceptorName", "com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityConnectionInterceptor");
        server.getServices().add((Object)objectRequestBroker);
    }

    private void addORBProperty(ObjectRequestBroker objectRequestBroker, String string, String string2) {
        Property property = this.propFactory.createProperty();
        property.setName(string);
        property.setValue(string2);
        objectRequestBroker.getProperties().add((Object)property);
    }

    private void addORBPlugin(ObjectRequestBroker objectRequestBroker, String string) {
        ORBPlugin oRBPlugin = this.orbFactory.createORBPlugin();
        oRBPlugin.setName(string);
        objectRequestBroker.getPlugins().add((Object)oRBPlugin);
    }

    private void addORBInterceptor(ObjectRequestBroker objectRequestBroker, String string) {
        Interceptor interceptor = this.orbFactory.createInterceptor();
        interceptor.setName(string);
        objectRequestBroker.getInterceptors().add((Object)interceptor);
    }

    public JMSServer buildJMSServer() {
        JMSServer jMSServer = this.msgFactory.createJMSServer();
        ProcessPackage processPackage = this.processFactory.getProcessPackage();
        StateManageable stateManageable = this.processFactory.createStateManageable();
        stateManageable.setInitialState(ExecutionState.START_LITERAL);
        jMSServer.setStateManagement(stateManageable);
        jMSServer.setDescription("Internal WebSphere JMS Server");
        jMSServer.setName("JMSServer");
        jMSServer.setNumThreads(1);
        EndPoint endPoint = this.ipcFactory.createEndPoint();
        endPoint.setHost("localhost");
        endPoint.setPort(5557);
        jMSServer.setSecurityPort(endPoint);
        return jMSServer;
    }
}

