/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.tools;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.models.config.adminservice.AdminService;
import com.ibm.websphere.models.config.adminservice.JMXConnector;
import com.ibm.websphere.models.config.adminservice.RMIConnector;
import com.ibm.websphere.models.config.adminservice.SOAPConnector;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.process.Service;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.management.tools.AdminTool;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.Repository;
import java.io.DataInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;

public class LaunchUtils {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$tools$LaunchUtils == null ? (class$com$ibm$ws$management$tools$LaunchUtils = LaunchUtils.class$("com.ibm.ws.management.tools.LaunchUtils")) : class$com$ibm$ws$management$tools$LaunchUtils), (String)"Admin", (String)AdminTool.BUNDLE_NAME);
    private static ResourceBundle bundle = ResourceBundle.getBundle(AdminTool.BUNDLE_NAME, Locale.getDefault());
    static /* synthetic */ Class class$com$ibm$ws$management$tools$LaunchUtils;

    public static String getFormattedMessage(String string, Object[] objectArray, String string2) {
        try {
            String string3 = bundle.getString(string);
            if (string3 == null) {
                return string2;
            }
            return MessageFormat.format(string3, objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            if (string2 == null) {
                return string2;
            }
            return MessageFormat.format(string2, objectArray);
        }
        catch (NullPointerException nullPointerException) {
            return string2;
        }
    }

    public static int retcodeFromMessage(String string) {
        int n = 0;
        if (string == null) {
            return n;
        }
        if (string.startsWith("ADMU")) {
            String string2 = string.substring(4, 8);
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
        }
        return n;
    }

    public static int issueMessage(String string, Object[] objectArray, String string2, boolean bl) {
        String string3 = LaunchUtils.getFormattedMessage(string, objectArray, string2);
        if (bl) {
            System.out.println(string3);
        }
        return LaunchUtils.retcodeFromMessage(string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static int getStatus(Socket socket) {
        FilterInputStream filterInputStream;
        InputStream inputStream;
        int n;
        block8: {
            n = -1;
            inputStream = null;
            filterInputStream = null;
            inputStream = socket.getInputStream();
            filterInputStream = new DataInputStream(inputStream);
            n = ((DataInputStream)filterInputStream).readInt();
            Object var7_4 = null;
            try {
                filterInputStream.close();
                inputStream.close();
                break block8;
            }
            catch (IOException iOException) {
                Tr.error((TraceComponent)tc, (String)"ADMU3009E", (Object)iOException);
            }
            {
                break block8;
                catch (IOException iOException) {
                    Tr.error((TraceComponent)tc, (String)"ADMU3009E", (Object)iOException);
                    int n2 = -1;
                    Object var7_5 = null;
                    try {
                        filterInputStream.close();
                        inputStream.close();
                    }
                    catch (IOException iOException2) {
                        Tr.error((TraceComponent)tc, (String)"ADMU3009E", (Object)iOException2);
                    }
                    filterInputStream = null;
                    inputStream = null;
                    return n2;
                }
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                try {
                    filterInputStream.close();
                    inputStream.close();
                }
                catch (IOException iOException) {
                    Tr.error((TraceComponent)tc, (String)"ADMU3009E", (Object)iOException);
                }
                filterInputStream = null;
                inputStream = null;
                throw throwable;
            }
        }
        filterInputStream = null;
        inputStream = null;
        return n;
    }

    public static ServerSocket getFreePort(int n) {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(0);
            serverSocket.setSoTimeout(n);
        }
        catch (IOException iOException) {
            Tr.error((TraceComponent)tc, (String)"ADMU3012E", (Object)iOException);
        }
        return serverSocket;
    }

    public static int waitForServerInit(ServerSocket serverSocket) {
        Socket socket = null;
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (!bl && !bl2) {
            try {
                socket = serverSocket.accept();
            }
            catch (InterruptedIOException interruptedIOException) {
                socket = null;
                bl2 = true;
            }
            catch (IOException iOException) {
                Tr.error((TraceComponent)tc, (String)"ADMU3009E", (Object)iOException);
                socket = null;
                bl = true;
                n = -1;
            }
            if (socket == null || (n = LaunchUtils.getStatus(socket)) != 0) continue;
            bl = true;
        }
        if (!bl) {
            n = -2;
        }
        return n;
    }

    public static int waitForServer(ServerSocket serverSocket) {
        Socket socket = null;
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (!bl && !bl2) {
            try {
                socket = serverSocket.accept();
            }
            catch (InterruptedIOException interruptedIOException) {
                socket = null;
                bl2 = true;
            }
            catch (IOException iOException) {
                Tr.error((TraceComponent)tc, (String)"ADMU3019E", (Object)iOException);
                socket = null;
                bl = true;
                n = -10;
            }
            if (socket == null || (n = LaunchUtils.getStatus(socket)) != 0) continue;
            bl = true;
        }
        if (!bl) {
            n = -11;
        }
        return n;
    }

    private static ResourceSet getResourceSet(final String string) {
        WASResourceSetImpl wASResourceSetImpl = new WASResourceSetImpl();
        URIConverterImpl uRIConverterImpl = new URIConverterImpl(){

            public URI normalize(URI uRI) {
                if (uRI.isRelative()) {
                    return uRI.resolve(URI.createFileURI((String)(string + File.separator)));
                }
                return super.normalize(uRI);
            }
        };
        wASResourceSetImpl.setURIConverter((URIConverter)uRIConverterImpl);
        return wASResourceSetImpl;
    }

    public static AdminClient getAdminClient(JMXConnector jMXConnector, String string, String string2, String string3, String string4, String string5, String string6) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAdminClient", (Object)new Object[]{string, string2, string3, string4, string5});
        }
        String string7 = "cells/" + string2 + "/nodes/" + string3 + "/serverindex.xml";
        ResourceSet resourceSet = LaunchUtils.getResourceSet(string);
        URI uRI = URI.createFileURI((String)string7);
        Resource resource = resourceSet.getResource(uRI, true);
        ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
        string7 = "cells/" + string2 + "/security.xml";
        uRI = URI.createFileURI((String)string7);
        resource = resourceSet.getResource(uRI, true);
        Security security = (Security)resource.getContents().get(0);
        boolean bl = security.isEnabled();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAdminClient");
        }
        return LaunchUtils.getAdminClient(serverIndex, string4, jMXConnector, bl, string5, string6);
    }

    public static AdminClient getAdminClient(Repository repository2, JMXConnector jMXConnector, String string, String string2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAdminClient", (Object)new Object[]{"repository", string});
        }
        String string3 = repository2.getNodeName();
        String string4 = repository2.getServerName();
        ConfigRoot configRoot = repository2.getConfigRoot();
        String string5 = configRoot.getValue(3);
        configRoot.setValue(3, string3);
        Resource resource = configRoot.getResource(3, "serverindex.xml");
        ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
        configRoot.setValue(3, string5);
        boolean bl = LaunchUtils.isSecurityEnabled(repository2);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAdminClient");
        }
        return LaunchUtils.getAdminClient(serverIndex, string4, jMXConnector, bl, string, string2);
    }

    private static AdminClient getAdminClient(ServerIndex serverIndex, String string, JMXConnector jMXConnector, boolean bl, String string2, String string3) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAdminClient", (Object)new Object[]{"serverindex", string});
        }
        AdminClient adminClient = null;
        Properties properties = new Properties();
        if (bl) {
            properties.setProperty("securityEnabled", "true");
        }
        if (string2 != null) {
            properties.setProperty("username", string2);
        }
        if (string3 != null) {
            properties.setProperty("password", string3);
        }
        if (jMXConnector instanceof SOAPConnector) {
            properties.setProperty("type", "SOAP");
            LaunchUtils.loadSOAPConnectorData(serverIndex, string, properties);
        } else if (jMXConnector instanceof RMIConnector) {
            properties.setProperty("type", "RMI");
            LaunchUtils.loadRMIConnectorData(serverIndex, string, properties);
        }
        EList eList = jMXConnector.getProperties();
        for (int i = 0; i < eList.size(); ++i) {
            Property property = (Property)eList.get(i);
            if (property.getName().equals("host")) {
                properties.setProperty("host", property.getValue());
            }
            if (!property.getName().equals("port")) continue;
            properties.setProperty("port", property.getValue());
        }
        if (properties.getProperty("host") == null) {
            properties.setProperty("host", "localhost");
        }
        if (properties.getProperty("type") == null) {
            properties.setProperty("type", "SOAP");
            if (properties.getProperty("port") == null) {
                properties.setProperty("port", "8880");
            }
        }
        adminClient = AdminClientFactory.createAdminClient(properties);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAdminClient");
        }
        return adminClient;
    }

    private static void loadSOAPConnectorData(ServerIndex serverIndex, String string, Properties properties) throws Exception {
        LaunchUtils.loadNamedEndPoint(serverIndex, string, properties, "SOAP_CONNECTOR_ADDRESS");
    }

    private static void loadRMIConnectorData(ServerIndex serverIndex, String string, Properties properties) throws Exception {
        LaunchUtils.loadNamedEndPoint(serverIndex, string, properties, "BOOTSTRAP_ADDRESS");
    }

    private static void loadNamedEndPoint(ServerIndex serverIndex, String string, Properties properties, String string2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"loadNamedEndPoint", (Object)new Object[]{string, string2});
        }
        EList eList = serverIndex.getServerEntries();
        int n = eList.size();
        block0: for (int i = 0; i < n; ++i) {
            ServerEntry serverEntry = (ServerEntry)eList.get(i);
            if (!serverEntry.getServerName().equals(string)) continue;
            EList eList2 = serverEntry.getSpecialEndpoints();
            int n2 = eList2.size();
            for (int j = 0; j < n2; ++j) {
                NamedEndPoint namedEndPoint = (NamedEndPoint)eList2.get(j);
                if (!namedEndPoint.getEndPointName().equals(string2)) continue;
                EndPoint endPoint = namedEndPoint.getEndPoint();
                String string3 = new Integer(endPoint.getPort()).toString();
                String string4 = endPoint.getHost();
                properties.setProperty("host", string4);
                properties.setProperty("port", string3);
                if (!tc.isDebugEnabled()) continue block0;
                Tr.debug((TraceComponent)tc, (String)"{host, port}", (Object)new Object[]{string4, string3});
                continue block0;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"loadNamedEndPoint");
        }
    }

    private static boolean isSecurityEnabled(Repository repository2) throws Exception {
        boolean bl = false;
        Object var2_2 = null;
        Object var3_3 = null;
        try {
            Resource resource = repository2.getConfigRoot().getResource(0, "security.xml");
            Security security = (Security)resource.getContents().get(0);
            bl = security.isEnabled();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public static JMXConnector getJMXConnector(String string, String string2, String string3, String string4) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getJMXConnector", (Object)new Object[]{string, string2, string3, string4});
        }
        String string5 = "cells/" + string2 + "/nodes/" + string3 + "/servers/" + string4 + "/server.xml";
        ResourceSet resourceSet = LaunchUtils.getResourceSet(string);
        URI uRI = URI.createFileURI((String)string5);
        Resource resource = resourceSet.getResource(uRI, true);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getJMXConnector");
        }
        return LaunchUtils.getJMXConnector(resource);
    }

    public static JMXConnector getJMXConnector(Resource resource) throws Exception {
        JMXConnector jMXConnector = null;
        Server server = LaunchUtils.getServer(resource);
        AdminService adminService = null;
        EList eList = server.getServices();
        for (int i = 0; i < eList.size(); ++i) {
            Service service = (Service)eList.get(i);
            if (!(service instanceof AdminService)) continue;
            adminService = (AdminService)service;
            break;
        }
        if ((jMXConnector = adminService.getPreferredConnector()) == null) {
            EList eList2 = adminService.getConnectors();
            for (int i = 0; i < eList2.size() && !((jMXConnector = (JMXConnector)eList2.get(i)) instanceof SOAPConnector) && !(jMXConnector instanceof RMIConnector); ++i) {
            }
        }
        return jMXConnector;
    }

    private static Server getServer(Resource resource) throws Exception {
        Server server = null;
        EList eList = resource.getContents();
        for (int i = 0; i < eList.size(); ++i) {
            Object e = eList.get(i);
            if (!(e instanceof Server)) continue;
            server = (Server)e;
        }
        return server;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

