/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.tools;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.ObjectNameHelper;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.DocumentAlreadyExistsException;
import com.ibm.websphere.management.filetransfer.FileTransferConfig;
import com.ibm.websphere.management.repository.Document;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.management.repository.client.ConfigRepositoryClient;
import com.ibm.websphere.management.repository.client.ConfigRepositoryClientFactory;
import com.ibm.websphere.models.config.adminservice.AdminService;
import com.ibm.websphere.models.config.applicationserver.ApplicationServer;
import com.ibm.websphere.models.config.applicationserver.webcontainer.HTTPTransport;
import com.ibm.websphere.models.config.applicationserver.webcontainer.WebContainer;
import com.ibm.websphere.models.config.host.HostAlias;
import com.ibm.websphere.models.config.host.VirtualHost;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.ipc.IpcFactory;
import com.ibm.websphere.models.config.ipc.IpcPackage;
import com.ibm.websphere.models.config.messagingserver.JMSServer;
import com.ibm.websphere.models.config.process.Component;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.process.Service;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.serverindex.ServerindexFactory;
import com.ibm.websphere.models.config.serverindex.ServerindexPackage;
import com.ibm.websphere.product.WASProduct;
import com.ibm.websphere.product.xml.BaseFactory;
import com.ibm.websphere.product.xml.BaseHandlerException;
import com.ibm.websphere.product.xml.BaseWriter;
import com.ibm.websphere.product.xml.product.ProductWriter;
import com.ibm.websphere.product.xml.product.product;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.config.ModelMgr;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.launcher.LaunchCommand;
import com.ibm.ws.management.launcher.ServerIdentifiers;
import com.ibm.ws.management.sync.NodeSync;
import com.ibm.ws.management.tools.AbstractNodeConfigUtility;
import com.ibm.ws.management.tools.JMSServerConfigBuilder;
import com.ibm.ws.management.tools.NodeAgentConfigBuilder;
import com.ibm.ws.management.util.MQTask;
import com.ibm.ws.management.util.Utils;
import com.ibm.ws.runtime.component.VariableMapImpl;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.RepositoryImpl;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.security.common.util.MergeSecurityConfig;
import java.beans.beancontext.BeanContextServiceProvider;
import java.beans.beancontext.BeanContextServicesSupport;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.Socket;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import javax.management.MBeanException;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;

public class NodeFederationUtility
extends AbstractNodeConfigUtility {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$tools$NodeFederationUtility == null ? (class$com$ibm$ws$management$tools$NodeFederationUtility = NodeFederationUtility.class$("com.ibm.ws.management.tools.NodeFederationUtility")) : class$com$ibm$ws$management$tools$NodeFederationUtility), (String)"Admin", (String)"com.ibm.ws.management.resources.nodeutils");
    private static final String DEFAULT_TRACE_STRING = "com.ibm.ws.management.tools.*=all=enabled";
    private static final String DEFAULT_TRACE_FILE = "addNode.log";
    protected String newCellName = null;
    private boolean setRollback = false;
    private boolean includeapps = false;
    private boolean includesecurity = true;
    private Vector appsIncluded = null;
    private Hashtable apps2path = null;
    private boolean launchNodeAgent = true;
    private Integer startingPort = null;
    private ObjectName repositoryHandle = null;
    private ConfigRepositoryClient repository = null;
    private RepositoryImpl localRepository = null;
    private VariableMapImpl map = null;
    private IpcFactory ipcFactory = null;
    private ServerindexFactory indexFactory = null;
    private String originalDir = null;
    private String backupDir = null;
    private String backupRoot = null;
    private String origTemplatesDir = null;
    private String backupTemplatesDir = null;
    private String toDir = null;
    private boolean invokedFromMBean = false;
    private boolean nodeAddedToDmgr = false;
    static /* synthetic */ Class class$com$ibm$ws$management$tools$NodeFederationUtility;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$Repository;

    public static void main(String[] stringArray) {
        System.exit(new NodeFederationUtility().executeUtility(stringArray));
    }

    protected String getDefaultTraceString() {
        return DEFAULT_TRACE_STRING;
    }

    protected String getDefaultTraceFile() {
        String string = System.getProperty("user.install.root");
        if (string == null || string.length() <= 0) {
            string = System.getProperty("was.install.root");
        }
        string = string + File.separator + "logs";
        string = string + File.separator + DEFAULT_TRACE_FILE;
        return string;
    }

    protected int getMinimumNumArgs() {
        return 4;
    }

    protected void issueUsageMessage() {
        this.issueMessage("ADMU0000I", null, null);
    }

    protected int parseRequiredArgs(String[] stringArray) {
        int n = 4;
        this.connHost = stringArray[3];
        if (stringArray.length > 4 && !stringArray[4].startsWith("-")) {
            this.connPort = stringArray[4];
            ++n;
        } else {
            this.connPort = "8879";
        }
        return n;
    }

    protected int parseUtilitySpecificOption(String[] stringArray, int n) {
        int n2 = n + 1;
        String string = stringArray[n];
        if (string.equals("-includeapps")) {
            this.includeapps = true;
        } else if (string.equals("-conntype")) {
            if (this.isValidParameter(stringArray, n + 1)) {
                this.connType = stringArray[n + 1];
                ++n2;
            } else {
                n2 = -2;
            }
        } else if (string.equals("-startingport")) {
            if (this.isValidParameter(stringArray, n + 1)) {
                this.startingPort = new Integer(stringArray[n + 1]);
                ++n2;
            } else {
                n2 = -2;
            }
        } else if (string.equals("-noagent")) {
            this.launchNodeAgent = false;
        } else if (string.equals("-fromMBean")) {
            this.invokedFromMBean = true;
        } else {
            n2 = -1;
        }
        return n2;
    }

    protected void toolFailed(Throwable throwable) {
        if (this.setRollback) {
            this.rollbackToBase();
        }
        super.toolFailed();
    }

    protected int runTool() throws Exception {
        Comparable<ObjectName> comparable;
        Object object;
        this.checkExpressProduct();
        Properties properties = this.getClientProperties();
        if ("RMI".equals(properties.getProperty("type")) && properties.getProperty("host") != null && properties.getProperty("port") != null) {
            object = System.getProperties();
            ((Properties)object).setProperty("com.ibm.CORBA.securityServerHost", properties.getProperty("host"));
            ((Properties)object).setProperty("com.ibm.CORBA.securityServerPort", properties.getProperty("port"));
            System.setProperties((Properties)object);
        }
        this.adminClient = this.getAdminClient(properties);
        this.notificationService = this.getNotificationServiceMBean();
        this.issueMessage("ADMU0001I", new Object[]{this.nodeName, this.connHost, this.connPort}, null);
        if (this.isMemberOfCell()) {
            this.issueMessage("ADMU0033E", new Object[]{this.nodeName}, null);
            return -1;
        }
        if (!this.isConnectedToDeploymentManager()) {
            throw new AdminException(this.getFormattedMessage("ADMU0025E", null, null));
        }
        if (!this.isDmgrSameOrLaterVersion()) {
            this.issueMessage("ADMU0126E", new String[]{this.getDMgrVersion(), Utils.getProductVersion()}, null);
            return -1;
        }
        if (!this.isClockInSync()) {
            long l = System.currentTimeMillis();
            long l2 = Utils.getRemoteTime(this.adminClient, this.getMBeanByType("JVM"));
            Date date = new Date(l);
            Date date2 = new Date(l2);
            String string = DateFormat.getDateTimeInstance().format(date2);
            String string2 = DateFormat.getDateTimeInstance().format(date);
            this.issueMessage("ADMU0124I", new Object[]{string2, string}, "ADMU0124I: The system clock of the new node {0} is not synchronized with that of the deployment manager {1}.");
            this.issueMessage("ADMU0125E", new Object[]{String.valueOf(5L)}, "ADMU0125E: Change the clock of the new node to be within 5 minutes of the clock of the deployment manager.");
            return -1;
        }
        if (!this.beginAddOrRemoveNode()) {
            this.issueMessage("ADMU0041E", null, null);
            return -1;
        }
        Runtime.getRuntime().addShutdownHook(new AbstractNodeConfigUtility.ShutdownThread());
        this.issueMessage("ADMU0009I", new Object[]{this.connHost, this.connPort}, null);
        this.checkProductExtensions(this.getWASProduct(), this.adminClient);
        if (this.sameNodeAsCellMgr()) {
            throw new AdminException(this.getFormattedMessage("ADMU0032E", new Object[]{this.nodeName}, null));
        }
        this.repository = this.getRepositoryClient(properties);
        this.repositoryHandle = this.getMBeanByType("ConfigRepository");
        object = new ObjectNameHelper();
        this.newCellName = ObjectNameHelper.getCellName(this.repositoryHandle);
        properties.setProperty("cellName", this.newCellName);
        if (this.sameNameAsCell()) {
            throw new AdminException(this.getFormattedMessage("ADMU0034E", new Object[]{this.newCellName}, "ADMU0034E: The node/cell name of the node being federated must have a different name than the cell name of the ND manager node: {0}"));
        }
        ModelMgr.initialize((String)"ws-server");
        String string = this.configRoot + "/cells/" + this.cellName;
        String string3 = this.configRoot + "/cells/" + this.newCellName + "/nodes/" + this.nodeName;
        String string4 = string3 + "/servers/nodeagent/";
        this.toDir = this.configRoot + "/cells/" + this.newCellName;
        String string5 = this.toDir + "/applications";
        this.originalDir = string;
        this.appsIncluded = new Vector();
        this.apps2path = new Hashtable();
        this.localRepository = null;
        this.map = null;
        this.stopAllServers();
        this.makeBackups();
        this.setRollback = true;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setRollback = true");
        }
        this.copyConfigToNewCell();
        this.deleteNamestoreFiles();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"create a new local config directory and server.xml for node agent");
        }
        this.createNodeAgentServerDoc(string4);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setup NodeAgent data");
        }
        this.setupNodeAgentData(this.newCellName);
        if (MQTask.isMQInstalled((VariableMap)this.getVariableMap())) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"create a new local config directory and server.xml for jmsserver");
            }
            this.createJmsServerDoc(string3 + "/servers/jmsserver/");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"fix up local serverindex.xml");
        }
        this.addToServerIndex("nodeagent", string3 + "/servers/");
        try {
            this.createNodeDocumentsOnDmgr(string3, string5);
            this.nodeAddedToDmgr = true;
        }
        catch (Exception exception) {
            this.nodeAddedToDmgr = true;
            Tr.error((TraceComponent)tc, (String)"ADMU0011E", (Object)exception);
            throw exception;
        }
        ObjectName objectName = this.getMBeanByType("PluginCfgGenerator");
        if (objectName != null && (comparable = this.getMBeanByType("JVM")) != null) {
            String string6 = (String)this.adminClient.invoke((ObjectName)comparable, "getProperty", new Object[]{"user.install.root"}, new String[]{"java.lang.String"});
            String string7 = (String)this.adminClient.invoke((ObjectName)comparable, "getProperty", new Object[]{"was.config.root"}, new String[]{"java.lang.String"});
            try {
                this.invokeMBean(objectName, "generate", new Object[]{string6, string7, this.newCellName, null, null, "plugin-cfg.xml"}, new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String"});
            }
            catch (MBeanException mBeanException) {
                this.issueMessage("ADMU0040E", new Object[]{objectName, "generate", mBeanException}, null);
            }
        }
        this.syncNode(properties);
        this.completeAddOrRemoveNode();
        this.throwExceptionIfNodeCannotPingCellMgr();
        comparable = new File(string);
        ((File)comparable).delete();
        this.fixSetupCmdLine(this.newCellName, properties);
        this.setRollback = false;
        Tr.debug((TraceComponent)tc, (String)"setRollback = false");
        this.fixWsadminProps(properties);
        this.createNDProductFile();
        if (this.launchNodeAgent) {
            this.issueMessage("ADMU0018I", new Object[]{this.nodeName}, null);
            this.launchNodeAgent();
        }
        this.runCreateMq("jmsserver");
        this.issueMessage("ADMU9990I", null, null);
        this.issueMessage("ADMU0300I", new Object[]{this.nodeName, this.newCellName}, null);
        this.issueMessage("ADMU9990I", null, null);
        this.showNextTasks();
        return 0;
    }

    private boolean isConnectedToDeploymentManager() throws Exception {
        ObjectName objectName = this.getMBeanByType("DeploymentManager");
        return objectName != null;
    }

    protected boolean isDmgrSameOrLaterVersion() throws Exception {
        String string = Utils.getProductVersion();
        String string2 = this.getDMgrVersion();
        int n = Utils.compareVersions(string2, string);
        return n >= 0;
    }

    protected String getDMgrVersion() throws Exception {
        return Utils.getRemoteProductVersion("ND", this.getMBeanByType("Server"), this.adminClient);
    }

    private boolean isClockInSync() throws Exception {
        return Utils.isClockInSync(this.adminClient, this.getMBeanByType("JVM"));
    }

    private void makeBackups() throws Exception {
        this.backupRoot = this.getBackupRoot(this.getLocalRepository(), this.getVariableMap());
        this.backupDir = this.backupRoot + "/base/cells/" + this.cellName;
        this.backupTemplatesDir = this.backupRoot + "/base/templates";
        this.origTemplatesDir = this.configRoot + "/templates";
        this.deleteBackupDirectory();
        this.issueMessage("ADMU0015I", null, null);
        this.backupConfigDirectory();
        this.backupPluginCfg();
        this.backupTemplates();
    }

    private void deleteBackupDirectory() throws Exception {
        this.issueMessage("ADMU0024I", null, null);
        this.deleteDirs(this.backupDir);
        this.deleteDirs(this.backupTemplatesDir);
    }

    private void backupConfigDirectory() throws Exception {
        File file = new File(this.backupDir);
        File file2 = new File(this.originalDir);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("copying " + this.originalDir + " to " + this.backupDir));
        }
        this.copyDocuments(this.originalDir, this.backupDir);
    }

    private void backupPluginCfg() throws Exception {
        File file = new File(this.configRoot + "/plugin-cfg.xml");
        File file2 = new File(this.backupRoot + "/base/plugin-cfg.xml");
        if (file.exists()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("copying " + file + " to " + file2));
            }
            this.copyDocument(file, file2);
        }
        File file3 = new File(this.configRoot + "/plugin-cfg-service.xmi");
        File file4 = new File(this.backupRoot + "/base/plugin-cfg-service.xmi");
        if (file3.exists()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("copying " + file3 + " to " + file4));
            }
            this.copyDocument(file3, file4);
        }
    }

    private void backupTemplates() throws Exception {
        File file = new File(this.backupTemplatesDir);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("copying " + this.origTemplatesDir + " to " + this.backupTemplatesDir));
        }
        this.copyDocuments(this.origTemplatesDir, this.backupTemplatesDir);
    }

    private void copyConfigToNewCell() throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"copy files into new structure to match new cell");
        }
        this.copyDocuments(this.originalDir, this.toDir);
    }

    private void deleteNamestoreFiles() {
        String string = this.configRoot + "/cells/" + this.cellName + "/nodes/" + this.nodeName + "/servers";
        File file = new File(string);
        File[] fileArray = file.listFiles();
        String[] stringArray = new String[]{"namestore-cell.xml", "namestore-node.xml"};
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].isDirectory()) continue;
                for (int j = 0; j < stringArray.length; ++j) {
                    try {
                        File file2 = new File(fileArray[i], stringArray[j]);
                        if (!file2.exists()) continue;
                        file2.delete();
                        continue;
                    }
                    catch (Exception exception) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)"Error trying to delete exception list", (Object)exception);
                    }
                }
            }
        }
    }

    private void createNodeAgentServerDoc(String string) throws Exception {
        this.issueMessage("ADMU0012I", new Object[]{this.nodeName}, null);
        NodeAgentConfigBuilder nodeAgentConfigBuilder = new NodeAgentConfigBuilder();
        nodeAgentConfigBuilder.setConfigRepositoryRoot(string);
        nodeAgentConfigBuilder.setProcessName("nodeagent");
        nodeAgentConfigBuilder.setNodeName(this.nodeName);
        nodeAgentConfigBuilder.write(nodeAgentConfigBuilder.buildRootElements(), "server.xml");
    }

    private void createJmsServerDoc(String string) throws Exception {
        JMSServerConfigBuilder jMSServerConfigBuilder = new JMSServerConfigBuilder();
        jMSServerConfigBuilder.setConfigRepositoryRoot(string);
        jMSServerConfigBuilder.setProcessName("jmsserver");
        jMSServerConfigBuilder.setNodeName(this.nodeName);
        jMSServerConfigBuilder.write(jMSServerConfigBuilder.buildRootElements(), "server.xml");
    }

    protected void syncNode(Properties properties) throws Exception {
        NodeSync nodeSync = NodeSync.createNodeSync();
        try {
            properties.setProperty("was.repository.root", this.configRoot);
            System.setProperty("com.ibm.ws.management.standalone", "true");
            nodeSync.initialize(properties, null, (VariableMap)this.getVariableMap());
            this.issueMessage("ADMU0016I", null, null);
            Boolean bl = nodeSync.sync();
            if (!bl.booleanValue()) {
                throw new AdminException(this.getFormattedMessage("ADMU0005E", new Object[]{""}, null));
            }
        }
        catch (AdminException adminException) {
            Tr.error((TraceComponent)tc, (String)"ADMU0005E", (Object)((Object)adminException));
            throw adminException;
        }
    }

    private void rollbackToBase() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"rollbackToBase");
        }
        try {
            File file;
            File file2;
            File file3;
            File file4 = new File(this.originalDir);
            if (!file4.exists()) {
                file4.mkdirs();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("copy " + this.backupDir + " to " + this.originalDir));
            }
            if ((file3 = new File(this.backupDir)).exists()) {
                this.copyDocuments(this.backupDir, this.originalDir);
            }
            if (!(file2 = new File(this.origTemplatesDir)).exists()) {
                file2.mkdirs();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("copying " + this.backupTemplatesDir + " to " + this.origTemplatesDir));
            }
            if (file3.exists()) {
                this.copyDocuments(this.backupTemplatesDir, this.origTemplatesDir);
            }
            File file5 = new File(this.configRoot + "/plugin-cfg.xml");
            File file6 = new File(this.backupRoot + "/base/plugin-cfg.xml");
            if (file6.exists()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("copy " + file6 + " to " + file5));
                }
                this.copyDocument(file6, file5);
            }
            File file7 = new File(this.configRoot + "/plugin-cfg-service.xmi");
            File file8 = new File(this.backupRoot + "/base/plugin-cfg-service.xmi");
            if (file8.exists()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("copy " + file8 + " to " + file7));
                }
                this.copyDocument(file8, file7);
            }
            if (this.apps2path.size() > 0) {
                this.rollbackBinaries();
            }
            if ((file = new File(this.toDir)).exists()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("delete " + this.toDir));
                }
                this.deleteDirs(this.toDir);
                file.delete();
            }
            if (this.nodeAddedToDmgr) {
                this.removeFromCell(this.adminClient);
            }
        }
        catch (Exception exception) {
            Tr.error((TraceComponent)tc, (String)"ADMU0007E", (Object)exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"rollbackToBase");
        }
    }

    private void rollbackBinaries() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"rollbackBinaries");
        }
        try {
            VariableMap variableMap = this.getVarMap(this.backupRoot + "/base", this.cellName, this.nodeName);
            VariableMap variableMap2 = this.getVarMap(this.configRoot, this.newCellName, this.nodeName);
            Enumeration enumeration = this.apps2path.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Vector vector = (Vector)this.apps2path.get(string);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Processing: " + string + " for paths: " + vector));
                }
                Vector<String> vector2 = new Vector<String>();
                for (int i = 0; i < vector.size(); ++i) {
                    String string2 = variableMap.expand((String)vector.elementAt(i));
                    if (!this.appsIncluded.contains(string)) {
                        vector2.addElement(string2);
                        continue;
                    }
                    String string3 = variableMap2.expand((String)vector.elementAt(i));
                    if (string2.equals(string3)) continue;
                    vector2.addElement(string2);
                    this.deleteDirs(string3);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Rollback " + string + " to be expanded to: " + vector2));
                }
                this.expandEar(this.originalDir + "/applications/" + string + "/" + string, vector2);
            }
        }
        catch (Throwable throwable) {
            this.issueMessage("ADMU0089E", new Object[]{throwable}, null);
        }
    }

    private boolean sameNodeAsCellMgr() throws Exception {
        String string;
        boolean bl = false;
        ObjectName objectName = this.getMBeanByType("DeploymentManager");
        if (objectName != null && (string = objectName.getKeyProperty("node")).equals(this.nodeName)) {
            bl = true;
        }
        return bl;
    }

    private boolean sameNameAsCell() throws Exception {
        boolean bl = false;
        if (this.cellName.compareToIgnoreCase(this.newCellName.toString()) == 0) {
            bl = true;
        }
        return bl;
    }

    private void getFileTransferConfig(Properties properties) throws Exception {
        ObjectName objectName = this.getMBeanByType("FileTransferServer");
        if (objectName != null) {
            FileTransferConfig fileTransferConfig = (FileTransferConfig)this.invokeMBean(objectName, "getServerConfig", null, null);
            this.testLocalhost(fileTransferConfig);
            properties.put("fileTransferConfig", fileTransferConfig);
        }
    }

    private void testLocalhost(FileTransferConfig fileTransferConfig) throws AdminException {
        try {
            int n = 0;
            String string = null;
            String string2 = (String)fileTransferConfig.getProperties().get("host");
            if (string2.equals("localhost") || string2.equals("127.0.0.1")) {
                Socket socket;
                string = (String)fileTransferConfig.getProperties().get("secure_port");
                if (!fileTransferConfig.isSecurityEnabled() || string == null || string.equals("")) {
                    string = (String)fileTransferConfig.getProperties().get("port");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Testing file transfer socket with host=" + string2 + " and port=" + string));
                }
                if ((socket = new Socket(string2, n = Integer.parseInt(string))) != null) {
                    socket.close();
                }
            }
        }
        catch (Exception exception) {
            throw new AdminException(this.getFormattedMessage("ADMU0038E", null, null));
        }
    }

    private ConfigRepositoryClient getRepositoryClient(Properties properties) throws Exception {
        ConfigRepositoryClient configRepositoryClient = null;
        try {
            this.getFileTransferConfig(properties);
            configRepositoryClient = (ConfigRepositoryClient)ConfigRepositoryClientFactory.getConfigRepositoryClient(properties);
            configRepositoryClient.initialize(properties);
        }
        catch (Exception exception) {
            Tr.error((TraceComponent)tc, (String)"ADMU0010E", (Object)exception);
            throw exception;
        }
        return configRepositoryClient;
    }

    private void createDocuments(String string) throws Exception {
        File file;
        File[] fileArray;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Creating documents in repository for node: " + string));
        }
        if ((fileArray = (file = new File(string)).listFiles()) == null) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                this.createDocuments(string + File.separator + fileArray[i].getName());
                continue;
            }
            byte[] byArray = this.getFileContent(fileArray[i]);
            String string2 = string + File.separator + fileArray[i].getName();
            string2 = string2.substring(string2.indexOf("cells"), string2.length());
            Document document = new Document(string2);
            DocumentContentSource documentContentSource = new DocumentContentSource(document, byArray);
            try {
                this.repository.create(documentContentSource);
                continue;
            }
            catch (DocumentAlreadyExistsException documentAlreadyExistsException) {
                Tr.info((TraceComponent)tc, (String)"ADMU0013I", (Object)documentAlreadyExistsException.getMessage());
                continue;
            }
            catch (Exception exception) {
                Tr.error((TraceComponent)tc, (String)"ADMU0011E", (Object)exception);
                throw exception;
            }
        }
    }

    private void mergeSecurity() throws Exception {
        if (!this.includesecurity) {
            return;
        }
        ConfigRoot configRoot = this.localRepository.getConfigRoot();
        Resource resource = configRoot.getResource(0, "security.xml");
        EList eList = resource.getContents();
        Security security = (Security)resource.getContents().get(0);
        String string = "cells/" + this.newCellName + "/security.xml";
        DocumentContentSource documentContentSource = null;
        try {
            documentContentSource = this.repository.extract(string);
        }
        catch (Exception exception) {
            Tr.error((TraceComponent)tc, (String)this.getFormattedMessage("ADMU0011E", new Object[]{exception}, null));
            throw exception;
        }
        InputStream inputStream = documentContentSource.getSource();
        ResourceSet resourceSet = this.createResourceSet();
        Resource resource2 = resourceSet.createResource(URI.createURI((String)string));
        resource2.load(inputStream, new HashMap());
        Security security2 = (Security)resource2.getContents().get(0);
        MergeSecurityConfig.merge((Security)security2, (Security)security, (String)this.nodeName);
        eList.set(0, security2);
        resource.save(new HashMap());
        String string2 = this.configRoot + File.separator + string;
        documentContentSource.setSource(new File(string2));
        DocumentContentSource[] documentContentSourceArray = new DocumentContentSource[]{documentContentSource};
        DocumentContentSource[] documentContentSourceArray2 = new DocumentContentSource[]{};
        Document[] documentArray = new Document[]{};
        try {
            this.repository.update(documentContentSourceArray2, documentContentSourceArray, documentArray);
        }
        catch (Exception exception) {
            Tr.error((TraceComponent)tc, (String)this.getFormattedMessage("ADMU0011E", new Object[]{exception}, null));
            throw exception;
        }
    }

    protected ResourceSet createResourceSet() {
        WASResourceSetImpl wASResourceSetImpl = new WASResourceSetImpl();
        URIConverterImpl uRIConverterImpl = new URIConverterImpl(){

            public URI normalize(URI uRI) {
                if (uRI.isRelative()) {
                    return uRI.resolve(URI.createFileURI((String)(NodeFederationUtility.this.configRoot + File.separator)));
                }
                return super.normalize(uRI);
            }
        };
        wASResourceSetImpl.setURIConverter((URIConverter)uRIConverterImpl);
        return wASResourceSetImpl;
    }

    private void createAppDocuments(String string) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("apps to be uploaded: " + this.appsIncluded));
        }
        VariableMap variableMap = this.getVarMap(this.backupRoot + "/base", this.cellName, this.nodeName);
        File file = new File(string);
        if (!file.exists()) {
            return;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            String string2 = fileArray[i].getName();
            Vector vector = this.getDeploymentPaths(string + File.separator + string2 + "/deployments");
            this.apps2path.put(string2, vector);
            if (this.appsIncluded.contains(string2)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(".. uploading .." + string2));
                }
                this.createDocuments(string + "/" + string2);
                if (variableMap == null) continue;
                String string3 = null;
                String string4 = null;
                for (int j = 0; j < vector.size(); ++j) {
                    try {
                        string3 = string4 = (String)vector.elementAt(j);
                        string3 = variableMap.expand(string3);
                        string4 = this.getVariableMap().expand(string4);
                        if (string3.equals(string4)) continue;
                        this.copyDocuments(string3, string4);
                        this.deleteDirs(string3);
                        continue;
                    }
                    catch (Throwable throwable) {
                        this.issueMessage("ADMU0122E", new Object[]{throwable, string3, string4}, null);
                    }
                }
                continue;
            }
            this.deleteDirs(string + File.separator + string2);
            if (variableMap == null) continue;
            for (int j = 0; j < vector.size(); ++j) {
                try {
                    this.deleteDirs(variableMap.expand((String)vector.elementAt(j)));
                    continue;
                }
                catch (Throwable throwable) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Could not delete: " + variableMap.expand((String)vector.elementAt(j))));
                }
            }
        }
        variableMap = null;
    }

    /*
     * Loose catch block
     */
    private byte[] getFileContent(File file) throws Exception {
        byte[] byArray;
        block10: {
            byArray = null;
            FileInputStream fileInputStream = null;
            fileInputStream = new FileInputStream(file);
            int n = (int)file.length();
            byArray = new byte[n];
            for (int i = 0; i < n; i += fileInputStream.read(byArray, i, n - i)) {
            }
            Object var7_7 = null;
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                break block10;
            }
            catch (IOException iOException) {
                Tr.warning((TraceComponent)tc, (String)"ADMU0017E", (Object)iOException);
            }
            break block10;
            {
                catch (IOException iOException) {
                    Tr.error((TraceComponent)tc, (String)"ADMU0019E", (Object)iOException);
                    throw iOException;
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    Tr.warning((TraceComponent)tc, (String)"ADMU0017E", (Object)iOException);
                }
                throw throwable;
            }
        }
        return byArray;
    }

    protected void emitNotification(String string, String string2) {
        if (this.notificationService != null) {
            String string3 = null;
            string3 = string.equals("ADMU0001I") && !this.invokedFromMBean ? "websphere.addnode.starting" : (string.equals("ADMU0003I") ? "websphere.addnode.complete" : (string.endsWith("E") ? "websphere.addnode.failed" : "websphere.addnode.message"));
            try {
                this.adminClient.invoke(this.notificationService, "emitNotification", new Object[]{string3, string2, this.notificationUserData}, NTFY_PARAMS);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void setupNodeAgentData(String string) throws Exception {
        this.setupServerRepository(string, "nodeagent");
    }

    protected RepositoryImpl getLocalRepository() throws Exception {
        Vector vector;
        if (this.localRepository == null && (vector = this.getServerList()) != null && vector.size() > 0) {
            this.setupServerRepository(this.cellName, (String)vector.elementAt(0));
        }
        return this.localRepository;
    }

    protected VariableMapImpl getVariableMap() throws Exception {
        Vector vector;
        if (this.map == null && (vector = this.getServerList()) != null && vector.size() > 0) {
            this.setupServerRepository(this.cellName, (String)vector.elementAt(0));
        }
        return this.map;
    }

    private void setupServerRepository(String string, String string2) throws Exception {
        this.localRepository = this.setupServerRepository(string, this.nodeName, string2);
        BeanContextServicesSupport beanContextServicesSupport = new BeanContextServicesSupport();
        beanContextServicesSupport.addService(class$com$ibm$ws$runtime$service$Repository == null ? (class$com$ibm$ws$runtime$service$Repository = NodeFederationUtility.class$("com.ibm.ws.runtime.service.Repository")) : class$com$ibm$ws$runtime$service$Repository, (BeanContextServiceProvider)this.localRepository);
        this.map = new VariableMapImpl();
        beanContextServicesSupport.add(this.map);
        this.map.initialize(null);
    }

    private RepositoryImpl setupServerRepository(String string, String string2, String string3) throws Exception {
        return new RepositoryImpl("ws-server", this.configRoot, string, string2, string3);
    }

    private void createNDProductFile() throws Exception {
        WASProduct wASProduct = this.getWASProduct();
        if (!wASProduct.productPresent("ND")) {
            product product2 = wASProduct.getProductById("BASE");
            product product3 = new product();
            product3.setId("ND");
            product3.setName("IBM WebSphere Application Server for Network Deployment");
            product3.setVersion(product2.getVersion());
            product3.setBuildInfo(product2.getBuildInfo());
            BaseHandlerException baseHandlerException = BaseFactory.saveSingleton((Object)product3, (BaseWriter)new ProductWriter(), (String)(wASProduct.getVersionDirName() + File.separator + product3.getId() + ".product"));
            if (baseHandlerException != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("There was a problem creating " + product3.getId() + ".product" + " file.  The file may not have been created."));
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception is: ", (Object)baseHandlerException);
                }
            }
        }
    }

    protected int launchNodeAgent() throws Exception {
        int n = 0;
        try {
            ServerIdentifiers serverIdentifiers = new ServerIdentifiers();
            serverIdentifiers.setConfigRoot(this.configRoot);
            serverIdentifiers.setCellName(this.newCellName);
            serverIdentifiers.setNodeName(this.nodeName);
            serverIdentifiers.setServerName("nodeagent");
            this.issueMessage("ADMU0020I", new Object[]{serverIdentifiers.getServerName()}, null);
            LaunchCommand launchCommand = new LaunchCommand((Repository)this.getLocalRepository(), (VariableMap)this.getVariableMap(), serverIdentifiers);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Launching a new server process: " + serverIdentifiers.getServerName()));
            }
            n = System.getProperty("os.name").equals("OS/400") ? this.launchNodeAgentOnOS400(launchCommand) : this.launchNodeAgentNotOnOS400(launchCommand);
        }
        catch (Exception exception) {
            Tr.error((TraceComponent)tc, (String)"ADMU0114E", (Object)exception);
            throw exception;
        }
        return n;
    }

    private int launchNodeAgentOnOS400(LaunchCommand launchCommand) throws Exception {
        String string = System.getProperty("user.install.root");
        String string2 = string.substring(string.lastIndexOf(File.separator));
        String string3 = System.getProperty("was.install.root") + File.separator + "bin" + File.separator + "startServer -instance " + string2 + " " + "nodeagent";
        if (this.nowait) {
            string3 = string3 + " -nowait";
        }
        Runtime runtime = Runtime.getRuntime();
        Process process = runtime.exec(string3);
        if (!this.nowait) {
            StringTokenizer stringTokenizer;
            process.waitFor();
            this.issueMessage("ADMU0022I", null, null);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream(), "cp037"));
            BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(process.getErrorStream(), "cp037"));
            boolean bl = false;
            String string4 = null;
            String string5 = null;
            while ((string5 = bufferedReader.readLine()) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)string5);
                }
                if (string5.indexOf("CPC1221") != -1) {
                    stringTokenizer = new StringTokenizer(string5);
                    stringTokenizer.nextElement();
                    stringTokenizer.nextElement();
                    string4 = (String)stringTokenizer.nextElement();
                }
                if (string5.indexOf("EJB6123") == -1) continue;
                bl = true;
                break;
            }
            while (!bl && (string5 = bufferedReader2.readLine()) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)string5);
                }
                if (string5.indexOf("CPC1221") != -1) {
                    stringTokenizer = new StringTokenizer(string5);
                    stringTokenizer.nextElement();
                    stringTokenizer.nextElement();
                    string4 = (String)stringTokenizer.nextElement();
                }
                if (string5.indexOf("EJB6123") == -1) continue;
                bl = true;
                break;
            }
            if (bl) {
                this.issueMessage("ADMU0030I", new Object[]{string4}, null);
            } else {
                this.issueMessage("ADMU0031E", new Object[]{string4}, null);
            }
        }
        return 0;
    }

    private int launchNodeAgentNotOnOS400(LaunchCommand launchCommand) throws Exception {
        int n = 0;
        if (!this.nowait) {
            launchCommand.setStatusSocketPort(this.getStatusPort());
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("status socket = " + this.getStatusPort().toString()));
            }
        }
        com.ibm.ws.process.Process process = launchCommand.launchProcess();
        if (!this.nowait) {
            this.issueMessage("ADMU0022I", null, null);
            new ProcessWatcher(process);
            n = this.waitForServerInit();
            if (n == 0) {
                this.issueMessage("ADMU0030I", new Object[]{process.id()}, null);
            } else {
                this.issueMessage("ADMU0031E", new Object[]{process.id()}, null);
            }
        }
        return n;
    }

    private int waitForServerInit() {
        Socket socket = null;
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (!bl && !bl2) {
            try {
                socket = this.getStatusSocket().accept();
            }
            catch (InterruptedIOException interruptedIOException) {
                socket = null;
                bl2 = true;
            }
            catch (IOException iOException) {
                Tr.error((TraceComponent)tc, (String)"ADMU0023E", (Object)iOException);
                socket = null;
                bl = true;
                n = -1;
            }
            if (socket == null) continue;
            n = this.getStatus(socket);
            if (n == 0 || n == 0) {
                bl = true;
                continue;
            }
            if (n != 2) continue;
            this.issueMessage("ADMU3220I", null, null);
        }
        if (!bl) {
            n = -2;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private int getStatus(Socket socket) {
        FilterInputStream filterInputStream;
        InputStream inputStream;
        int n;
        block8: {
            n = -1;
            inputStream = null;
            filterInputStream = null;
            inputStream = socket.getInputStream();
            filterInputStream = new DataInputStream(inputStream);
            n = ((DataInputStream)filterInputStream).readInt();
            Object var8_5 = null;
            try {
                filterInputStream.close();
                inputStream.close();
                break block8;
            }
            catch (IOException iOException) {
                Tr.error((TraceComponent)tc, (String)"ADMU0023E", (Object)iOException);
            }
            {
                break block8;
                catch (IOException iOException) {
                    Tr.error((TraceComponent)tc, (String)"ADMU0023E", (Object)iOException);
                    int n2 = -1;
                    Object var8_6 = null;
                    try {
                        filterInputStream.close();
                        inputStream.close();
                    }
                    catch (IOException iOException2) {
                        Tr.error((TraceComponent)tc, (String)"ADMU0023E", (Object)iOException2);
                    }
                    filterInputStream = null;
                    inputStream = null;
                    return n2;
                }
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                try {
                    filterInputStream.close();
                    inputStream.close();
                }
                catch (IOException iOException) {
                    Tr.error((TraceComponent)tc, (String)"ADMU0023E", (Object)iOException);
                }
                filterInputStream = null;
                inputStream = null;
                throw throwable;
            }
        }
        filterInputStream = null;
        inputStream = null;
        return n;
    }

    private void addToServerIndex(String string, String string2) throws Exception {
        ConfigRoot configRoot = this.getLocalRepository().getConfigRoot();
        Resource resource = configRoot.getResource(3, "serverindex.xml");
        EList eList = resource.getContents();
        ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
        String string3 = serverIndex.getHostName();
        if (string3 == null || string3.length() < 1) {
            string3 = AdminHelper.getInstance().getHostName();
            serverIndex.setHostName(string3);
        }
        this.throwExceptionIfCellMgrCannotPing(string3);
        ServerindexPackage serverindexPackage = (ServerindexPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/serverindex.xmi");
        this.indexFactory = serverindexPackage.getServerindexFactory();
        IpcPackage ipcPackage = (IpcPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/ipc.xmi");
        this.ipcFactory = ipcPackage.getIpcFactory();
        EList eList2 = serverIndex.getServerEntries();
        ArrayList arrayList = new ArrayList();
        List list = this.getAdminHostPorts();
        for (int i = 0; i < eList2.size(); ++i) {
            ServerEntry serverEntry = (ServerEntry)eList2.get(i);
            String string4 = serverEntry.getServerName();
            this.adjustServerConfig(string4, arrayList, list);
            this.addOrRemoveAppsForServer(serverEntry);
        }
        ServerEntry serverEntry = this.indexFactory.createServerEntry();
        serverEntry.setServerName(string);
        serverEntry.setServerDisplayName(string);
        serverEntry.setServerType("NODE_AGENT");
        this.addNodeAgentEndpoints(serverIndex, serverEntry);
        serverIndex.getServerEntries().add((Object)serverEntry);
        if (MQTask.isMQInstalled((VariableMap)this.getVariableMap())) {
            serverEntry = this.indexFactory.createServerEntry();
            serverEntry.setServerName("jmsserver");
            serverEntry.setServerDisplayName("JMSServer");
            serverEntry.setServerType("MESSAGE_BROKER");
            this.addJMSServerEndpoints(serverIndex, serverEntry);
            serverIndex.getServerEntries().add((Object)serverEntry);
        }
        this.runPortMapper(serverIndex, string);
        resource.save(new HashMap());
        if (MQTask.isMQInstalled((VariableMap)this.getVariableMap())) {
            this.addJMSServerQueues("jmsserver", arrayList);
        }
    }

    private List getAdminHostPorts() throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        Resource resource = this.getLocalRepository().getConfigRoot().getResource(0, "virtualhosts.xml");
        EList eList = resource.getContents();
        for (int i = 0; i < eList.size(); ++i) {
            VirtualHost virtualHost;
            Object e = eList.get(i);
            if (!(eList.get(i) instanceof VirtualHost) || !(virtualHost = (VirtualHost)e).getName().equals("admin_host")) continue;
            Iterator iterator = virtualHost.getAliases().iterator();
            while (iterator.hasNext()) {
                arrayList.add(((HostAlias)iterator.next()).getPort());
            }
        }
        return arrayList;
    }

    private void createNodeDocumentsOnDmgr(String string, String string2) throws Exception {
        this.issueMessage("ADMU0014I", new Object[]{this.nodeName, this.newCellName}, null);
        this.mergeSecurity();
        this.createDocuments(string);
        this.createAppDocuments(string2);
    }

    private void addOrRemoveAppsForServer(ServerEntry serverEntry) {
        EList eList = serverEntry.getDeployedApplications();
        if (!this.includeapps) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"remove all apps");
            }
            while (eList.size() > 0) {
                eList.remove(0);
            }
        } else {
            for (int i = 0; i < eList.size(); ++i) {
                String string = (String)eList.get(i);
                if (string.startsWith("adminconsole.ear")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("... skip .. " + string));
                    }
                    eList.remove(string);
                    --i;
                    continue;
                }
                String string2 = string.substring(0, string.indexOf(47));
                try {
                    String[] stringArray;
                    boolean bl;
                    String string3 = "cells/" + this.newCellName + "/applications/" + string2 + "/" + string2;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Checking for " + string3 + " in " + this.repository));
                    }
                    boolean bl2 = bl = (stringArray = this.repository.listResourceNames(string3, 1, 0)).length == 1;
                    if (bl) {
                        this.issueMessage("ADMU0120I", new Object[]{string2}, null);
                        eList.remove(string);
                        --i;
                        continue;
                    }
                    this.appsIncluded.add(string2);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("... include app: " + string2));
                    continue;
                }
                catch (Throwable throwable) {
                    this.issueMessage("ADMU0121E", new Object[]{throwable, string2}, null);
                }
            }
        }
    }

    private void throwExceptionIfCellMgrCannotPing(String string) throws Exception {
        String string2 = (String)this.adminClient.invoke(this.getMBeanByType("JVM"), "getIPAddress", new Object[]{string}, new String[]{"java.lang.String"});
        if (string2 == null || !string2.equals(InetAddress.getByName(string).getHostAddress())) {
            throw new AdminException(this.getFormattedMessage("ADMU0036E", new Object[]{string, InetAddress.getByName(string).getHostAddress()}, null));
        }
    }

    private void throwExceptionIfNodeCannotPingCellMgr() throws Exception {
        List list = this.getNewNodes();
        String string = null;
        String string2 = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            string2 = this.getDmgrHostName(string);
            if (string2 == null || string2.length() == 0) continue;
            try {
                InetAddress inetAddress = InetAddress.getByName(string2);
                break;
            }
            catch (Exception exception) {
                this.issueMessage("ADMU0037E", new Object[]{string2}, null);
                throw new AdminException(exception);
            }
        }
    }

    private String getDmgrHostName(String string) throws Exception {
        String string2 = null;
        RepositoryImpl repositoryImpl = this.setupServerRepository(this.newCellName, string, null);
        ConfigRoot configRoot = repositoryImpl.getConfigRoot();
        Resource resource = configRoot.getResource(3, "serverindex.xml");
        EList eList = resource.getContents();
        ServerIndex serverIndex = null;
        block0: for (int i = 0; i < eList.size(); ++i) {
            serverIndex = (ServerIndex)resource.getContents().get(i);
            EList eList2 = serverIndex.getServerEntries();
            for (int j = 0; j < eList2.size(); ++j) {
                ServerEntry serverEntry = (ServerEntry)eList2.get(j);
                String string3 = serverEntry.getServerType();
                if (string3.equals("DEPLOYMENT_MANAGER")) break block0;
            }
            serverIndex = null;
        }
        if (serverIndex != null) {
            string2 = serverIndex.getHostName();
        }
        return string2;
    }

    protected List getNewNodes() throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.configRoot + "/cells/" + this.newCellName + "/nodes";
        File file = new File(string);
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                String string2;
                if (!fileArray[i].isDirectory() || (string2 = fileArray[i].getName()).equals(this.nodeName)) continue;
                arrayList.add(string2);
            }
        }
        return arrayList;
    }

    private void showNextTasks() {
        this.issueMessage("ADMU0306I", null, null);
        this.issueMessage("ADMU0302I", new Object[]{this.cellName}, null);
        this.issueMessage("ADMU0307I", null, null);
        this.issueMessage("ADMU0303I", new Object[]{this.newCellName}, null);
        if (!this.includeapps) {
            this.issueMessage("ADMU9990I", null, null);
            this.issueMessage("ADMU0306I", null, null);
            this.issueMessage("ADMU0304I", null, null);
            this.issueMessage("ADMU0307I", null, null);
            this.issueMessage("ADMU0305I", new Object[]{this.newCellName}, null);
        }
        this.issueMessage("ADMU9990I", null, null);
        this.issueMessage("ADMU0003I", new Object[]{this.nodeName}, null);
    }

    private void runPortMapper(ServerIndex serverIndex, String string) throws Exception {
        NamedEndPoint namedEndPoint;
        int n;
        EList eList;
        String string2;
        ServerEntry serverEntry;
        int n2;
        PortMap portMap = new PortMap();
        EList eList2 = serverIndex.getEndPointRefs();
        EList eList3 = serverIndex.getServerEntries();
        for (n2 = 0; n2 < eList3.size(); ++n2) {
            serverEntry = (ServerEntry)eList3.get(n2);
            string2 = serverEntry.getServerName();
            if (string2.equals(string)) {
                eList = serverEntry.getSpecialEndpoints();
                for (n = 0; n < eList.size(); ++n) {
                    namedEndPoint = (NamedEndPoint)eList.get(n);
                    portMap.add(new Integer(namedEndPoint.getEndPoint().getPort()).toString());
                }
                continue;
            }
            if (!string2.equals("jmsserver")) continue;
            eList = serverEntry.getSpecialEndpoints();
            for (n = 0; n < eList.size(); ++n) {
                namedEndPoint = (NamedEndPoint)eList.get(n);
                portMap.add(new Integer(namedEndPoint.getEndPoint().getPort()).toString());
            }
        }
        for (n2 = 0; n2 < eList3.size(); ++n2) {
            serverEntry = (ServerEntry)eList3.get(n2);
            string2 = serverEntry.getServerName();
            if (string2.equals(string) || string2.equals("jmsserver")) continue;
            eList = serverEntry.getSpecialEndpoints();
            for (n = 0; n < eList.size(); ++n) {
                NamedEndPoint namedEndPoint2;
                int n3;
                namedEndPoint = (NamedEndPoint)eList.get(n);
                boolean bl = false;
                if (namedEndPoint.getEndPoint().getPort() == 2809) {
                    namedEndPoint.getEndPoint().setPort(9810);
                }
                if (namedEndPoint.getEndPointName().equals("JMSSERVER_DIRECT_ADDRESS")) {
                    for (n3 = 0; n3 < eList2.size(); ++n3) {
                        namedEndPoint2 = (NamedEndPoint)eList2.get(n3);
                        if (!namedEndPoint2.equals(namedEndPoint)) continue;
                        eList2.remove(n3);
                        break;
                    }
                    eList.remove(n);
                    --n;
                    bl = true;
                } else if (namedEndPoint.getEndPointName().equals("JMSSERVER_QUEUED_ADDRESS")) {
                    for (n3 = 0; n3 < eList2.size(); ++n3) {
                        namedEndPoint2 = (NamedEndPoint)eList2.get(n3);
                        if (!namedEndPoint2.equals(namedEndPoint)) continue;
                        eList2.remove(n3);
                        break;
                    }
                    eList.remove(n);
                    --n;
                    bl = true;
                } else if (namedEndPoint.getEndPoint().getPort() == 0) {
                    bl = true;
                }
                while (!bl) {
                    try {
                        portMap.add(new Integer(namedEndPoint.getEndPoint().getPort()).toString());
                        bl = true;
                    }
                    catch (Exception exception) {
                        int n4 = new Integer(namedEndPoint.getEndPoint().getPort());
                        namedEndPoint.getEndPoint().setPort(++n4);
                    }
                }
            }
        }
    }

    private void addJMSServerQueues(String string, List list) throws Exception {
        Object object;
        if (list == null) {
            return;
        }
        ConfigRoot configRoot = this.getLocalRepository().getConfigRoot();
        String string2 = configRoot.getValue(4);
        configRoot.setValue(4, string);
        Resource resource = configRoot.getResource(4, "server.xml");
        configRoot.setValue(4, string2);
        Server server = null;
        EList eList = resource.getContents();
        for (int i = 0; i < eList.size(); ++i) {
            object = eList.get(i);
            if (!(object instanceof Server)) continue;
            server = (Server)resource.getContents().get(0);
            break;
        }
        if (server != null) {
            EList eList2 = server.getComponents();
            object = eList2.iterator();
            while (object.hasNext()) {
                Component component = (Component)object.next();
                if (!(component instanceof JMSServer)) continue;
                JMSServer jMSServer = (JMSServer)component;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string3 = (String)iterator.next();
                    jMSServer.getQueueNames().add((Object)string3);
                }
                break block1;
            }
        }
        resource.save(new HashMap());
    }

    private void adjustServerConfig(String string, List arrayList, List list) throws Exception {
        if (arrayList == null) {
            arrayList = new ArrayList<String>();
        }
        ConfigRoot configRoot = this.getLocalRepository().getConfigRoot();
        String string2 = configRoot.getValue(4);
        configRoot.setValue(4, string);
        Resource resource = configRoot.getResource(4, "server.xml");
        configRoot.setValue(4, string2);
        Server server = null;
        EList eList = resource.getContents();
        for (int i = 0; i < eList.size(); ++i) {
            Object e = eList.get(i);
            if (!(e instanceof Server)) continue;
            server = (Server)e;
            break;
        }
        if (server != null) {
            AdminService adminService;
            EList eList2 = server.getServices();
            for (int i = 0; i < eList2.size(); ++i) {
                Service service = (Service)eList2.get(i);
                if (!(service instanceof AdminService)) continue;
                adminService = (AdminService)service;
                adminService.setStandalone(false);
            }
            EList eList3 = server.getComponents();
            for (int i = 0; i < eList3.size(); ++i) {
                String string3;
                int n;
                EList eList4;
                JMSServer jMSServer;
                adminService = (Component)eList3.get(i);
                if (adminService instanceof JMSServer) {
                    jMSServer = (JMSServer)adminService;
                    eList4 = jMSServer.getQueueNames();
                    for (n = 0; n < eList4.size(); ++n) {
                        string3 = (String)eList4.get(n);
                        if (arrayList.contains(string3)) continue;
                        arrayList.add(string3);
                    }
                    eList3.remove(adminService);
                    break;
                }
                if (!(adminService instanceof ApplicationServer)) continue;
                jMSServer = (ApplicationServer)adminService;
                eList4 = adminService.getComponents();
                for (n = 0; n < eList4.size(); ++n) {
                    string3 = (Component)eList4.get(n);
                    if (!(string3 instanceof WebContainer)) continue;
                    WebContainer webContainer = (WebContainer)string3;
                    EList eList5 = webContainer.getTransports();
                    for (int j = 0; j < eList5.size(); ++j) {
                        HTTPTransport hTTPTransport = (HTTPTransport)eList5.get(j);
                        if (!this.isInList(new Integer(hTTPTransport.getAddress().getPort()).toString(), list)) continue;
                        eList5.remove(j);
                        --j;
                    }
                }
            }
        }
        resource.save(new HashMap());
    }

    private boolean isInList(String string, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equals(string)) continue;
            return true;
        }
        return false;
    }

    private NamedEndPoint addEndPoint(String string, String string2, int n, ServerEntry serverEntry) throws Exception {
        NamedEndPoint namedEndPoint = null;
        EndPoint endPoint = null;
        namedEndPoint = this.indexFactory.createNamedEndPoint();
        namedEndPoint.setEndPointName(string);
        endPoint = this.ipcFactory.createEndPoint();
        endPoint.setHost(string2);
        endPoint.setPort(n);
        namedEndPoint.setEndPoint(endPoint);
        serverEntry.getSpecialEndpoints().add((Object)namedEndPoint);
        return namedEndPoint;
    }

    private void addJMSServerEndpoints(ServerIndex serverIndex, ServerEntry serverEntry) throws Exception {
        if (this.startingPort != null) {
            this.addJMSServerEndpointsUsingStartingPort(serverIndex, serverEntry);
            return;
        }
        NamedEndPoint namedEndPoint = null;
        String string = serverIndex.getHostName();
        this.addEndPoint("BOOTSTRAP_ADDRESS", string, 2810, serverEntry);
        namedEndPoint = this.addEndPoint("JMSSERVER_DIRECT_ADDRESS", string, 5559, serverEntry);
        serverIndex.getEndPointRefs().add((Object)namedEndPoint);
        namedEndPoint = this.addEndPoint("JMSSERVER_QUEUED_ADDRESS", string, 5558, serverEntry);
        serverIndex.getEndPointRefs().add((Object)namedEndPoint);
        this.addEndPoint("SOAP_CONNECTOR_ADDRESS", string, 8876, serverEntry);
    }

    private void addJMSServerEndpointsUsingStartingPort(ServerIndex serverIndex, ServerEntry serverEntry) throws Exception {
        int n = this.startingPort;
        NamedEndPoint namedEndPoint = null;
        String string = serverIndex.getHostName();
        this.addEndPoint("BOOTSTRAP_ADDRESS", string, n++, serverEntry);
        namedEndPoint = this.addEndPoint("JMSSERVER_DIRECT_ADDRESS", string, n++, serverEntry);
        serverIndex.getEndPointRefs().add((Object)namedEndPoint);
        namedEndPoint = this.addEndPoint("JMSSERVER_QUEUED_ADDRESS", string, n++, serverEntry);
        serverIndex.getEndPointRefs().add((Object)namedEndPoint);
        this.addEndPoint("SOAP_CONNECTOR_ADDRESS", string, n++, serverEntry);
        this.startingPort = new Integer(n);
    }

    private void addNodeAgentEndpoints(ServerIndex serverIndex, ServerEntry serverEntry) throws Exception {
        if (this.startingPort != null) {
            this.addNodeAgentEndpointsUsingStartingPort(serverIndex, serverEntry);
            return;
        }
        NamedEndPoint namedEndPoint = null;
        String string = serverIndex.getHostName();
        this.addEndPoint("BOOTSTRAP_ADDRESS", string, 2809, serverEntry);
        namedEndPoint = this.addEndPoint("ORB_LISTENER_ADDRESS", string, 9900, serverEntry);
        serverIndex.getEndPointRefs().add((Object)namedEndPoint);
        namedEndPoint = this.addEndPoint("SAS_SSL_SERVERAUTH_LISTENER_ADDRESS", string, 9901, serverEntry);
        serverIndex.getEndPointRefs().add((Object)namedEndPoint);
        namedEndPoint = this.addEndPoint("CSIV2_SSL_MUTUALAUTH_LISTENER_ADDRESS", string, 9101, serverEntry);
        serverIndex.getEndPointRefs().add((Object)namedEndPoint);
        namedEndPoint = this.addEndPoint("CSIV2_SSL_SERVERAUTH_LISTENER_ADDRESS", string, 9201, serverEntry);
        serverIndex.getEndPointRefs().add((Object)namedEndPoint);
        namedEndPoint = this.addEndPoint("NODE_DISCOVERY_ADDRESS", string, 7272, serverEntry);
        serverIndex.getEndPointRefs().add((Object)namedEndPoint);
        namedEndPoint = this.addEndPoint("NODE_MULTICAST_DISCOVERY_ADDRESS", "232.133.104.73", 5000, serverEntry);
        serverIndex.getEndPointRefs().add((Object)namedEndPoint);
        this.addEndPoint("DRS_CLIENT_ADDRESS", string, 7888, serverEntry);
        this.addEndPoint("SOAP_CONNECTOR_ADDRESS", string, 8878, serverEntry);
    }

    private void addNodeAgentEndpointsUsingStartingPort(ServerIndex serverIndex, ServerEntry serverEntry) throws Exception {
        int n = this.startingPort;
        NamedEndPoint namedEndPoint = null;
        String string = serverIndex.getHostName();
        this.addEndPoint("BOOTSTRAP_ADDRESS", string, n++, serverEntry);
        namedEndPoint = this.addEndPoint("ORB_LISTENER_ADDRESS", string, n++, serverEntry);
        serverIndex.getEndPointRefs().add((Object)namedEndPoint);
        namedEndPoint = this.addEndPoint("SAS_SSL_SERVERAUTH_LISTENER_ADDRESS", string, n++, serverEntry);
        serverIndex.getEndPointRefs().add((Object)namedEndPoint);
        namedEndPoint = this.addEndPoint("CSIV2_SSL_MUTUALAUTH_LISTENER_ADDRESS", string, n++, serverEntry);
        serverIndex.getEndPointRefs().add((Object)namedEndPoint);
        namedEndPoint = this.addEndPoint("CSIV2_SSL_SERVERAUTH_LISTENER_ADDRESS", string, n++, serverEntry);
        serverIndex.getEndPointRefs().add((Object)namedEndPoint);
        namedEndPoint = this.addEndPoint("NODE_DISCOVERY_ADDRESS", string, n++, serverEntry);
        serverIndex.getEndPointRefs().add((Object)namedEndPoint);
        namedEndPoint = this.addEndPoint("NODE_MULTICAST_DISCOVERY_ADDRESS", "232.133.104.73", n++, serverEntry);
        serverIndex.getEndPointRefs().add((Object)namedEndPoint);
        this.addEndPoint("DRS_CLIENT_ADDRESS", string, n++, serverEntry);
        this.addEndPoint("SOAP_CONNECTOR_ADDRESS", string, n++, serverEntry);
        this.startingPort = new Integer(n);
    }

    private void runCreateMq(String string) throws Exception {
        MQTask mQTask = new MQTask((VariableMap)this.getVariableMap(), this.newCellName, this.nodeName);
        if (mQTask.isMQInstalled()) {
            this.issueMessage("ADMU0523I", new Object[]{this.nodeName, string}, null);
            mQTask.createMQ(string);
            this.issueMessage("ADMU0525I", new Object[]{"createMQ." + this.nodeName + '_' + string + ".log"}, null);
        } else {
            this.issueMessage("ADMU0524I", null, null);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class ProcessWatcher
    extends Thread {
        com.ibm.ws.process.Process process;

        public ProcessWatcher(com.ibm.ws.process.Process process) {
            this.process = process;
            this.setDaemon(true);
            this.start();
        }

        public void run() {
            try {
                if (this.process.isAlive()) {
                    this.process.waitForTermination();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Socket socket = new Socket("localhost", NodeFederationUtility.this.getStatusSocket().getLocalPort());
                DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
                dataOutputStream.writeInt(-1);
                dataOutputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class PortMap {
        private TreeSet portmap = new TreeSet();

        private PortMap() {
        }

        private void add(String string) throws Exception {
            if (this.portmap.contains(string)) {
                throw new Exception();
            }
            this.portmap.add(string);
        }
    }
}

