/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.tools;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.configservice.ConfigServiceProxy;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.ws.config.ModelMgr;
import com.ibm.ws.management.launcher.ServerIdentifiers;
import com.ibm.ws.management.tools.AbstractNodeConfigUtility;
import com.ibm.ws.management.util.MQTask;
import com.ibm.ws.runtime.component.VariableMapImpl;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.RepositoryImpl;
import com.ibm.ws.runtime.service.VariableMap;
import java.beans.beancontext.BeanContextServiceProvider;
import java.beans.beancontext.BeanContextServicesSupport;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.management.AttributeList;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class NodeRemovalUtility
extends AbstractNodeConfigUtility {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$tools$NodeRemovalUtility == null ? (class$com$ibm$ws$management$tools$NodeRemovalUtility = NodeRemovalUtility.class$("com.ibm.ws.management.tools.NodeRemovalUtility")) : class$com$ibm$ws$management$tools$NodeRemovalUtility), (String)"Admin", (String)"com.ibm.ws.management.resources.nodeutils");
    private static final String DEFAULT_TRACE_STRING = "com.ibm.ws.management.tools.*=all=enabled";
    private static final String DEFAULT_TRACE_FILE = "removeNode.log";
    protected String restoredCellName = null;
    protected boolean terminateServers = false;
    private RepositoryImpl localRepository = null;
    private VariableMapImpl map = null;
    private boolean forceRemove = false;
    private String backupRoot = null;
    private Properties clientProps = null;
    private boolean invokedFromMBean = false;
    private boolean removeWasForced = false;
    static /* synthetic */ Class class$com$ibm$ws$management$tools$NodeRemovalUtility;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$Repository;

    public static void main(String[] stringArray) {
        System.exit(new NodeRemovalUtility().executeUtility(stringArray));
    }

    protected String getDefaultTraceString() {
        return DEFAULT_TRACE_STRING;
    }

    protected String getDefaultTraceFile() {
        String string = System.getProperty("user.install.root");
        if (string == null || string.length() <= 0) {
            string = System.getProperty("was.install.root");
        }
        string = string + File.separator + "logs";
        string = string + File.separator + DEFAULT_TRACE_FILE;
        return string;
    }

    protected int getMinimumNumArgs() {
        return 3;
    }

    protected void issueUsageMessage() {
        this.issueMessage("ADMU2002I", null, null);
    }

    protected int parseRequiredArgs(String[] stringArray) {
        return 3;
    }

    protected int parseUtilitySpecificOption(String[] stringArray, int n) {
        int n2 = n + 1;
        String string = stringArray[n];
        if (string.equals("-local") || string.equals("-force")) {
            this.forceRemove = true;
        } else if (string.equals("-fromMBean")) {
            this.invokedFromMBean = true;
        } else {
            n2 = -1;
        }
        return n2;
    }

    protected int runTool() throws Exception {
        this.issueMessage("ADMU2001I", new Object[]{this.nodeName}, null);
        ModelMgr.initialize((String)"ws-server");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"ModelMgr initialized");
        }
        if (!this.isMemberOfCell()) {
            this.issueMessage("ADMU2026E", new Object[]{this.nodeName}, null);
            return -1;
        }
        try {
            this.initAdminClient();
        }
        catch (Exception exception) {
            Tr.error((TraceComponent)tc, (String)"ADMU0006E", (Object)exception);
            this.issueMessage("ADMU0006E", new Object[]{exception}, null);
            if (!this.forceRemove) {
                this.issueMessage("ADMU2015I", null, null);
                throw exception;
            }
            this.removeWasForced = true;
        }
        if (!this.beginAddOrRemoveNode()) {
            this.issueMessage("ADMU0041E", null, null);
            return -1;
        }
        Runtime.getRuntime().addShutdownHook(new AbstractNodeConfigUtility.ShutdownThread());
        if (this.terminateServers) {
            this.terminateAllServers();
        } else {
            this.stopAllServers();
        }
        try {
            this.issueMessage("ADMU2019I", new Object[]{this.nodeName}, null);
            this.removeApplicationsFromNode();
        }
        catch (Exception exception) {
            Tr.error((TraceComponent)tc, (String)"ADMU2020E", (Object)exception);
            this.issueMessage("ADMU2020E", new Object[]{exception}, null);
            if (!this.forceRemove) {
                this.issueMessage("ADMU2015I", null, null);
                throw exception;
            }
            this.removeWasForced = true;
        }
        try {
            if (this.adminClient != null) {
                this.issueMessage("ADMU2021I", null, null);
                this.removeNodeFromClusters();
            }
        }
        catch (Exception exception) {
            Tr.error((TraceComponent)tc, (String)"ADMU2023E", (Object)exception);
            this.issueMessage("ADMU2023E", new Object[]{exception}, null);
            if (!this.forceRemove) {
                this.issueMessage("ADMU2015I", null, null);
                throw exception;
            }
            this.removeWasForced = true;
        }
        try {
            this.removeFromCell(this.adminClient);
        }
        catch (Exception exception) {
            Tr.error((TraceComponent)tc, (String)"ADMU2016E", (Object)exception);
            this.issueMessage("ADMU2016E", new Object[]{this.nodeName}, null);
            if (!this.forceRemove) {
                this.issueMessage("ADMU2015I", null, null);
                throw exception;
            }
            this.removeWasForced = true;
        }
        this.completeAddOrRemoveNode();
        this.runDeleteMq("jmsserver");
        this.deleteAppBins();
        String string = this.configRoot + "/cells/" + this.cellName;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("deleting " + string));
        }
        this.deleteDirs(string);
        this.restoredCellName = this.restoreBaseAppServerConfig();
        this.localRepository = null;
        this.fixWsadminProps(this.getClientProperties());
        this.fixSetupCmdLine(this.restoredCellName, this.getClientProperties());
        this.issueMessage("ADMU2017I", null, null);
        this.showNextTasks();
        return 0;
    }

    private void initAdminClient() throws Exception {
        Properties properties = this.getCellMgrProps();
        if (properties == null) {
            return;
        }
        if (this.userid != null) {
            properties.setProperty("username", this.userid);
        }
        if (this.pwd != null) {
            properties.setProperty("password", this.pwd);
        }
        this.adminClient = this.getAdminClient(properties);
        this.notificationService = this.getNotificationServiceMBean();
        this.emitNotification("ADMU2001I", this.getFormattedMessage("ADMU2001I", new Object[]{this.nodeName}, null));
    }

    protected Properties getClientProperties() throws Exception {
        if (this.clientProps == null) {
            this.clientProps = System.getProperties();
            this.clientProps.setProperty("user.install.root", this.getUserInstallRootIfSetElseGetWasInstallRoot());
            this.clientProps.setProperty("host", "localhost");
            this.clientProps.setProperty("port", this.getBaseSOAPPort().toString());
            this.clientProps.setProperty("type", "SOAP");
        }
        return this.clientProps;
    }

    private Integer getBaseSOAPPort() throws Exception {
        ConfigRoot configRoot = this.getLocalRepository().getConfigRoot();
        Resource resource = configRoot.getResource(3, "serverindex.xml");
        EList eList = resource.getContents();
        ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
        EList eList2 = serverIndex.getServerEntries();
        ServerEntry serverEntry = (ServerEntry)eList2.iterator().next();
        EList eList3 = serverEntry.getSpecialEndpoints();
        Iterator iterator = eList3.iterator();
        while (iterator.hasNext()) {
            NamedEndPoint namedEndPoint = (NamedEndPoint)iterator.next();
            if (!namedEndPoint.getEndPointName().equals("SOAP_CONNECTOR_ADDRESS")) continue;
            EndPoint endPoint = namedEndPoint.getEndPoint();
            return new Integer(endPoint.getPort());
        }
        return new Integer(8880);
    }

    private void removeApplicationsFromNode() throws Exception {
        ObjectName objectName = this.getMBeanByType("AppManagement");
        try {
            this.invokeMBean(objectName, "removeAllAppsFromNode", new Object[]{this.nodeName, this.cellName, null, null}, new String[]{"java.lang.String", "java.lang.String", "java.util.Hashtable", "java.lang.String"});
        }
        catch (Exception exception) {
            this.issueMessage("ADMU0040E", new Object[]{objectName, "removeAllAppsFromNode", exception}, null);
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeNodeFromClusters() throws Exception {
        ConfigServiceProxy configServiceProxy = this.getConfigService(this.adminClient);
        ObjectName objectName = ConfigServiceHelper.createObjectName(null, "ServerCluster", null);
        Session session = new Session("removeNodeFromClusters", false);
        try {
            ObjectName[] objectNameArray = configServiceProxy.queryConfigObjects(session, null, objectName, null);
            for (int i = 0; i < objectNameArray.length; ++i) {
                ArrayList arrayList = (ArrayList)configServiceProxy.getAttribute(session, objectNameArray[i], "members");
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    AttributeList attributeList = (AttributeList)iterator.next();
                    String string = (String)ConfigServiceHelper.getAttributeValue(attributeList, "nodeName");
                    if (string == null || !string.equals(this.nodeName)) continue;
                    this.issueMessage("ADMU2022I", new Object[]{(String)ConfigServiceHelper.getAttributeValue(attributeList, "memberName"), (String)configServiceProxy.getAttribute(session, objectNameArray[i], "name")}, null);
                    ObjectName objectName2 = ConfigServiceHelper.createObjectName(attributeList);
                    configServiceProxy.deleteConfigData(session, objectName2);
                }
            }
            configServiceProxy.save(session, true);
        }
        finally {
            configServiceProxy.discard(session);
        }
    }

    private String restoreBaseAppServerConfig() throws Exception {
        this.issueMessage("ADMU2014I", null, null);
        String string = this.backupRoot + "/base/cells/";
        String string2 = null;
        File[] fileArray = new File(string).listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].isDirectory()) continue;
            string2 = fileArray[i].getName();
            break;
        }
        String string3 = this.configRoot + "/cells/";
        String string4 = this.backupRoot + "/base/templates/";
        String string5 = this.configRoot + "/templates/";
        File file = new File(string3);
        if (!file.exists()) {
            file.mkdirs();
        }
        this.copyDocuments(string, string3);
        File file2 = new File(string5);
        if (!file2.exists()) {
            file2.mkdirs();
        }
        this.copyDocuments(string4, string5);
        File file3 = new File(this.configRoot + "/plugin-cfg.xml");
        File file4 = new File(this.backupRoot + "/base/plugin-cfg.xml");
        if (file4.exists()) {
            this.copyDocument(file4, file3);
        }
        File file5 = new File(this.configRoot + "/plugin-cfg-service.xmi");
        File file6 = new File(this.backupRoot + "/base/plugin-cfg-service.xmi");
        if (file6.exists()) {
            this.copyDocument(file6, file5);
        }
        this.restoreApplications(string2);
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void restoreApplications(String string) {
        block12: {
            block11: {
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)("restoreApplications: " + string));
                }
                VariableMap variableMap = null;
                try {
                    try {
                        File file;
                        variableMap = this.getVarMap(this.configRoot, string, this.nodeName);
                        if (variableMap == null) {
                            if (tc.isEntryEnabled()) {
                                Tr.exit((TraceComponent)tc, (String)"restoreApplications:  null varmap for base cell");
                            }
                            Object var10_3 = null;
                            break block11;
                        }
                        String string2 = this.configRoot + "/cells/" + string + "/applications";
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("apps dir: " + string2));
                        }
                        if ((file = new File(string2)).exists()) {
                            File[] fileArray = file.listFiles();
                            for (int i = 0; i < fileArray.length; ++i) {
                                File file2;
                                if (!fileArray[i].isDirectory() || !(file2 = new File(string2 + "/" + fileArray[i].getName() + "/" + fileArray[i].getName())).exists()) continue;
                                Vector vector = this.getDeploymentPaths(string2 + "/" + fileArray[i].getName() + "/deployments");
                                this.expandEar(file2.getPath(), vector, variableMap);
                            }
                        }
                        break block12;
                    }
                    catch (Throwable throwable) {
                        this.issueMessage("ADMU0529E", new Object[]{throwable}, null);
                        Object var10_5 = null;
                        if (!tc.isEntryEnabled()) return;
                        Tr.exit((TraceComponent)tc, (String)"restoreApplications");
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var10_6 = null;
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"restoreApplications");
                    }
                    variableMap = null;
                    throw throwable;
                }
            }
            if (!tc.isEntryEnabled()) return;
            Tr.exit((TraceComponent)tc, (String)"restoreApplications");
            return;
        }
        Object var10_4 = null;
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"restoreApplications");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deleteAppBins() {
        block11: {
            block10: {
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)"deleteAppBins");
                }
                VariableMap variableMap = null;
                try {
                    try {
                        variableMap = this.getVarMap(this.configRoot, this.cellName, this.nodeName);
                        if (variableMap == null) {
                            if (tc.isEntryEnabled()) {
                                Tr.exit((TraceComponent)tc, (String)"deleteAppBins: no var map was created");
                            }
                            Object var4_2 = null;
                            break block10;
                        }
                        String string = variableMap.expand("$(APP_INSTALL_ROOT)/" + this.cellName);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Deleting: " + string));
                        }
                        this.deleteDirs(string);
                        break block11;
                    }
                    catch (Throwable throwable) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Unexpected exception: " + throwable + " in deleting binaries from ND config for " + this.nodeName));
                        }
                        Object var4_4 = null;
                        if (!tc.isEntryEnabled()) return;
                        Tr.exit((TraceComponent)tc, (String)"deleteAppBins");
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"deleteAppBins");
                    }
                    variableMap = null;
                    throw throwable;
                }
            }
            if (!tc.isEntryEnabled()) return;
            Tr.exit((TraceComponent)tc, (String)"deleteAppBins");
            return;
        }
        Object var4_3 = null;
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"deleteAppBins");
    }

    protected void emitNotification(String string, String string2) {
        if (this.notificationService != null) {
            String string3 = null;
            string3 = string.equals("ADMU2001I") && !this.invokedFromMBean ? "websphere.removenode.starting" : (string.equals("ADMU2024I") || string.equals("ADMU2025I") ? "websphere.removenode.complete" : (string.endsWith("E") ? "websphere.removenode.failed" : "websphere.removenode.message"));
            try {
                this.adminClient.invoke(this.notificationService, "emitNotification", new Object[]{string3, string2, this.notificationUserData}, NTFY_PARAMS);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Properties getCellMgrProps() throws Exception {
        NamedEndPoint namedEndPoint;
        Object object;
        Resource resource;
        ConfigRoot configRoot = this.getLocalRepository().getConfigRoot();
        this.backupRoot = this.getBackupRoot(this.getLocalRepository(), this.getVariableMap());
        String[] stringArray = configRoot.list(3, null);
        ServerEntry serverEntry = null;
        String string = null;
        block0: for (int i = 0; i < stringArray.length; ++i) {
            configRoot.setValue(3, stringArray[i]);
            resource = configRoot.getResource(3, "serverindex.xml");
            object = resource.getContents();
            ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
            namedEndPoint = serverIndex.getServerEntries();
            for (int j = 0; j < namedEndPoint.size(); ++j) {
                ServerEntry serverEntry2 = (ServerEntry)namedEndPoint.get(j);
                String string2 = serverEntry2.getServerType();
                if (!string2.equals("DEPLOYMENT_MANAGER")) continue;
                serverEntry = serverEntry2;
                string = serverEntry2.getServerName();
                continue block0;
            }
        }
        EndPoint endPoint = null;
        resource = null;
        if (serverEntry != null) {
            object = serverEntry.getSpecialEndpoints();
            for (int i = 0; i < object.size(); ++i) {
                namedEndPoint = (NamedEndPoint)object.get(i);
                if (namedEndPoint.getEndPointName().equals("SOAP_CONNECTOR_ADDRESS")) {
                    endPoint = namedEndPoint.getEndPoint();
                }
                if (!namedEndPoint.getEndPointName().equals("BOOTSTRAP_ADDRESS")) continue;
                resource = namedEndPoint.getEndPoint();
            }
        }
        object = null;
        if (endPoint != null) {
            object = new Properties();
            ((Properties)object).setProperty("type", "SOAP");
            ((Properties)object).setProperty("port", new Integer(endPoint.getPort()).toString());
            ((Properties)object).setProperty("host", endPoint.getHost());
        } else if (resource != null) {
            object = new Properties();
            ((Properties)object).setProperty("type", "RMI");
            ((Properties)object).setProperty("port", new Integer(resource.getPort()).toString());
            ((Properties)object).setProperty("host", resource.getHost());
        }
        return object;
    }

    protected RepositoryImpl getLocalRepository() throws Exception {
        if (this.localRepository == null) {
            this.setupLocalRepository();
        }
        return this.localRepository;
    }

    protected VariableMapImpl getVariableMap() throws Exception {
        if (this.map == null) {
            this.setupLocalRepository();
        }
        return this.map;
    }

    private void setupLocalRepository() throws Exception {
        ServerIdentifiers serverIdentifiers = new ServerIdentifiers();
        serverIdentifiers.setConfigRoot(this.configRoot);
        if (this.restoredCellName != null) {
            serverIdentifiers.setCellName(this.restoredCellName);
            serverIdentifiers.setServerName("server1");
        } else {
            serverIdentifiers.setCellName(this.cellName);
            serverIdentifiers.setServerName("nodeagent");
        }
        serverIdentifiers.setNodeName(this.nodeName);
        BeanContextServicesSupport beanContextServicesSupport = new BeanContextServicesSupport();
        this.localRepository = new RepositoryImpl("ws-server", serverIdentifiers.getConfigRoot(), serverIdentifiers.getCellName(), serverIdentifiers.getNodeName(), serverIdentifiers.getServerName());
        beanContextServicesSupport.addService(class$com$ibm$ws$runtime$service$Repository == null ? (class$com$ibm$ws$runtime$service$Repository = NodeRemovalUtility.class$("com.ibm.ws.runtime.service.Repository")) : class$com$ibm$ws$runtime$service$Repository, (BeanContextServiceProvider)this.localRepository);
        this.map = new VariableMapImpl();
        beanContextServicesSupport.add(this.map);
        this.map.initialize(null);
    }

    protected AdminClient getAdminClient(Properties properties) throws Exception {
        AdminClient adminClient = null;
        adminClient = AdminClientFactory.createAdminClient(properties);
        Object[] objectArray = new Object[2];
        objectArray[0] = properties.getProperty("host");
        objectArray[1] = properties.getProperty("port");
        this.issueMessage("ADMU0009I", objectArray, null);
        return adminClient;
    }

    protected void runDeleteMq(String string) throws Exception {
        MQTask mQTask = new MQTask((VariableMap)this.getVariableMap(), this.cellName, this.nodeName);
        if (mQTask.isMQInstalled()) {
            this.issueMessage("ADMU0526I", new Object[]{this.nodeName, string}, null);
            mQTask.deleteMQ(string);
            this.issueMessage("ADMU0528I", new Object[]{"deleteMQ." + this.nodeName + "_" + string + ".log"}, null);
        } else {
            this.issueMessage("ADMU0527I", new Object[]{string}, null);
        }
    }

    public void setForceRemove(boolean bl) {
        this.forceRemove = bl;
    }

    private void showNextTasks() {
        this.issueMessage("ADMU9990I", null, null);
        this.issueMessage("ADMU0306I", null, null);
        this.issueMessage("ADMU2031I", new Object[]{this.cellName}, null);
        this.issueMessage("ADMU0307I", null, null);
        this.issueMessage("ADMU2032I", null, null);
        this.issueMessage("ADMU9990I", null, null);
        if (this.removeWasForced) {
            this.issueMessage("ADMU2025W", new Object[]{this.nodeName}, null);
        } else {
            this.issueMessage("ADMU2024I", new Object[]{this.nodeName}, null);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

