/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.tools;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.nodeagent.ConfigSynchronizationService;
import com.ibm.websphere.models.config.nodeagent.NodeAgent;
import com.ibm.websphere.models.config.process.Component;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.ws.config.ModelMgr;
import com.ibm.ws.management.tools.NodeFederationUtility;
import com.ibm.ws.management.util.Utils;
import com.ibm.ws.runtime.service.ConfigRoot;
import java.io.File;
import java.util.Iterator;
import java.util.Properties;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class NodeSyncUtility
extends NodeFederationUtility {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$tools$NodeSyncUtility == null ? (class$com$ibm$ws$management$tools$NodeSyncUtility = NodeSyncUtility.class$("com.ibm.ws.management.tools.NodeSyncUtility")) : class$com$ibm$ws$management$tools$NodeSyncUtility), (String)"Admin", (String)"com.ibm.ws.management.resources.nodeutils");
    private static final String DEFAULT_TRACE_STRING = "com.ibm.ws.management.tools.*=all=enabled";
    private static final String DEFAULT_TRACE_FILE = "syncNode.log";
    private boolean stopservers = false;
    private boolean restart = false;
    static /* synthetic */ Class class$com$ibm$ws$management$tools$NodeSyncUtility;

    public static void main(String[] stringArray) {
        System.exit(new NodeSyncUtility().executeUtility(stringArray));
    }

    protected String getDefaultTraceString() {
        return DEFAULT_TRACE_STRING;
    }

    protected String getDefaultTraceFile() {
        String string = System.getProperty("user.install.root");
        if (string == null || string.length() <= 0) {
            string = System.getProperty("was.install.root");
        }
        string = string + File.separator + "logs";
        string = string + File.separator + DEFAULT_TRACE_FILE;
        return string;
    }

    protected int getMinimumNumArgs() {
        return 4;
    }

    protected void issueUsageMessage() {
        this.issueMessage("ADMU0400I", null, null);
    }

    protected int parseUtilitySpecificOption(String[] stringArray, int n) {
        int n2 = n + 1;
        String string = stringArray[n];
        if (string.equals("-stopservers")) {
            this.stopservers = true;
        } else if (string.equals("-conntype")) {
            if (this.isValidParameter(stringArray, n + 1)) {
                this.connType = stringArray[n + 1];
                ++n2;
            } else {
                n2 = -2;
            }
        } else if (string.equals("-restart")) {
            this.restart = true;
        } else {
            n2 = -1;
        }
        return n2;
    }

    protected int runTool() throws Exception {
        this.checkExpressProduct();
        if (!this.isMemberOfCell()) {
            this.issueMessage("ADMU2026E", new Object[]{this.nodeName}, null);
            return -1;
        }
        this.adminClient = this.getAdminClient(this.getClientProperties());
        this.notificationService = this.getNotificationServiceMBean();
        this.issueMessage("ADMU0401I", new Object[]{this.nodeName, this.connHost, this.connPort}, null);
        this.checkProductExtensions(this.getWASProduct(), this.adminClient);
        if (this.stopservers) {
            ModelMgr.initialize((String)"ws-server");
            this.stopAllServers();
        }
        if (!this.isDmgrSameOrLaterVersion()) {
            this.issueMessage("ADMU0127E", new String[]{this.getDMgrVersion(), Utils.getProductVersion()}, null);
            return -1;
        }
        if (this.isNodeAgentRunning()) {
            this.issueMessage("ADMU0403E", null, null);
            return -1;
        }
        this.syncNode(this.getSyncProperties());
        if (this.restart) {
            this.setupNodeAgentData(this.cellName);
            this.issueMessage("ADMU0018I", new Object[]{this.nodeName}, null);
            this.newCellName = this.cellName;
            this.launchNodeAgent();
        }
        this.issueMessage("ADMU0402I", new Object[]{this.nodeName, this.connHost, this.connPort}, null);
        return 0;
    }

    private boolean isNodeAgentRunning() throws Exception {
        ObjectName objectName = new ObjectName("WebSphere:*,type=NodeAgent,node=" + this.nodeName);
        return !this.adminClient.queryNames(objectName, null).isEmpty();
    }

    private Properties getSyncProperties() throws Exception {
        Object object;
        Properties properties = this.getClientProperties();
        ConfigRoot configRoot = this.getLocalRepository().getConfigRoot();
        String string = configRoot.getValue(4);
        configRoot.setValue(4, "nodeagent");
        Resource resource = configRoot.getResource(4, "server.xml");
        configRoot.setValue(4, string);
        Server server = null;
        EList eList = resource.getContents();
        for (int i = 0; i < eList.size(); ++i) {
            object = eList.get(i);
            if (!(object instanceof Server)) continue;
            server = (Server)object;
            break;
        }
        if (server != null) {
            EList eList2 = server.getComponents();
            object = eList2.iterator();
            while (object.hasNext()) {
                Component component = (Component)object.next();
                if (!(component instanceof NodeAgent)) continue;
                NodeAgent nodeAgent = (NodeAgent)component;
                ConfigSynchronizationService configSynchronizationService = nodeAgent.getFileSynchronizationService();
                EList eList3 = configSynchronizationService.getProperties();
                Iterator iterator = eList3.iterator();
                while (iterator.hasNext()) {
                    Property property = (Property)iterator.next();
                    properties.setProperty(property.getName(), property.getValue());
                }
                break block1;
            }
        }
        return properties;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

