/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.tools;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.websphere.management.application.EarUtils;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.config.ModelMgr;
import com.ibm.ws.management.tools.AdminTool;
import com.ibm.ws.runtime.component.VariableMapImpl;
import com.ibm.ws.runtime.service.RepositoryImpl;
import com.ibm.ws.runtime.service.VariableMap;
import java.beans.beancontext.BeanContextServiceProvider;
import java.beans.beancontext.BeanContextServicesSupport;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;

public class RestoreConfigUtility
extends AdminTool {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$tools$RestoreConfigUtility == null ? (class$com$ibm$ws$management$tools$RestoreConfigUtility = RestoreConfigUtility.class$("com.ibm.ws.management.tools.RestoreConfigUtility")) : class$com$ibm$ws$management$tools$RestoreConfigUtility), (String)"Admin", (String)"com.ibm.ws.management.resources.nodeutils");
    private static final String DEFAULT_TRACE_STRING = "*=all=disbled";
    private static final String DEFAULT_TRACE_FILE = "restoreConfig.log";
    public static final int BUFFER_SIZE = 1024;
    private File restoreLocation;
    private String backupFileName;
    private boolean stopServers = true;
    private byte[] buffer = new byte[1024];
    private int numFilesRestored;
    private boolean forceOption = false;
    private static final ResourceBundle APP_BUNDLE = ResourceBundle.getBundle("com.ibm.ws.management.resources.AppDeploymentMessages", Locale.getDefault());
    static /* synthetic */ Class class$com$ibm$ws$management$tools$RestoreConfigUtility;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$Repository;

    public static void main(String[] stringArray) {
        System.exit(new RestoreConfigUtility().executeUtility(stringArray));
    }

    protected String getDefaultTraceString() {
        return DEFAULT_TRACE_STRING;
    }

    protected String getDefaultTraceFile() {
        String string = System.getProperty("user.install.root");
        if (string == null || string.length() <= 0) {
            string = System.getProperty("was.install.root");
        }
        string = string + File.separator + "logs";
        string = string + File.separator + DEFAULT_TRACE_FILE;
        return string;
    }

    protected int getMinimumNumArgs() {
        return 4;
    }

    protected void issueUsageMessage() {
        this.issueMessage("ADMU5500I", null, null);
    }

    protected int parseRequiredArgs(String[] stringArray) {
        this.backupFileName = stringArray[3];
        return 4;
    }

    protected int parseUtilitySpecificOption(String[] stringArray, int n) {
        int n2 = n + 1;
        if (stringArray[n].equals("-nostop")) {
            this.stopServers = false;
        } else if (stringArray[n].equals("-force")) {
            this.forceOption = true;
        } else if (stringArray[n].equals("-location")) {
            if (this.isValidParameter(stringArray, n + 1)) {
                this.restoreLocation = new File(stringArray[n + 1]);
                ++n2;
            } else {
                n2 = -2;
            }
        } else {
            n2 = -1;
        }
        return n2;
    }

    protected int runTool() throws Exception {
        if (this.restoreLocation == null) {
            this.restoreLocation = new File(this.configRoot);
        }
        if (!new File(this.backupFileName).exists()) {
            this.issueMessage("ADMU5501E", new Object[]{this.backupFileName}, null);
            return -1;
        }
        ModelMgr.initialize((String)"ws-server");
        Object var1_1 = null;
        if (this.stopServers) {
            this.stopAllServers();
        }
        if (this.restoreLocation.exists()) {
            File file = this.getUniqueDirectory(this.restoreLocation);
            this.issueMessage("ADMU5502I", new Object[]{this.restoreLocation, file}, null);
            boolean bl = this.renameRestoreLocation(file);
            if (!bl) {
                this.issueMessage("ADMU5503E", null, null);
                return -1;
            }
        }
        this.issueMessage("ADMU5505I", new Object[]{this.backupFileName, this.restoreLocation}, null);
        this.ckCellNameAgainstFile();
        this.uncompressConfigDir();
        this.issueMessage("ADMU5506I", new Object[]{new Integer(this.numFilesRestored)}, null);
        this.restoreAppBinaries();
        return 0;
    }

    private File getUniqueDirectory(File file) {
        int n = 1;
        File file2 = new File(file + ".old");
        while (file2.exists()) {
            file2 = new File(file + ".old_" + String.valueOf(n++));
        }
        return file2;
    }

    private boolean renameRestoreLocation(File file) {
        boolean bl = this.restoreLocation.renameTo(file);
        if (bl) {
            this.issueMessage("ADMU5504I", null, null);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ckCellNameAgainstFile() throws IOException {
        block6: {
            ZipFile zipFile = new ZipFile(new File(this.backupFileName));
            String string = "cells" + File.separatorChar + this.cellName + File.separatorChar;
            try {
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                while (enumeration.hasMoreElements()) {
                    ZipEntry zipEntry = enumeration.nextElement();
                    if (!zipEntry.getName().startsWith(string)) continue;
                    return;
                }
                if (!this.forceOption) {
                    this.issueMessage("ADMU7005E", new Object[]{string}, null);
                    System.exit(1);
                    break block6;
                }
                this.issueMessage("ADMU7006W", new Object[]{string}, null);
                return;
            }
            finally {
                zipFile.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uncompressConfigDir() throws IOException {
        ZipFile zipFile = new ZipFile(new File(this.backupFileName));
        try {
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                this.unzipFile(zipEntry, zipFile);
            }
        }
        finally {
            System.out.println();
            zipFile.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unzipFile(ZipEntry zipEntry, ZipFile zipFile) throws IOException {
        if (!this.isQuiet()) {
            System.out.print('.');
        }
        InputStream inputStream = zipFile.getInputStream(zipEntry);
        File file = new File(this.restoreLocation, zipEntry.getName());
        file.getParentFile().mkdirs();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            int n = 0;
            while ((n = inputStream.read(this.buffer)) > -1) {
                fileOutputStream.write(this.buffer, 0, n);
            }
        }
        finally {
            fileOutputStream.close();
            inputStream.close();
        }
        ++this.numFilesRestored;
    }

    public String getBackupFileName() {
        return this.backupFileName;
    }

    public void restoreAppBinaries() {
        this.issueMessage("ADMU6001I", null, "Begin restoring application binaries..");
        try {
            String string;
            Object object;
            Object object2;
            ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.ws.management.resources.AppDeploymentMessages", Locale.getDefault());
            Resource resource = this.getResource("nodes/" + this.nodeName + "/serverindex.xml", "serverindex.xml", resourceBundle);
            if (resource == null) {
                return;
            }
            VariableMap variableMap = this.createVarMap();
            Hashtable hashtable = new Hashtable();
            ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
            EList eList = serverIndex.getServerEntries();
            for (int i = 0; i < eList.size(); ++i) {
                object2 = (ServerEntry)eList.get(i);
                object = object2.getDeployedApplications();
                for (int j = 0; j < object.size(); ++j) {
                    string = (String)object.get(j);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("si: " + string));
                    }
                    if (string.indexOf(47) == -1 || string.indexOf(47) == string.lastIndexOf(47)) continue;
                    String string2 = string.substring(0, string.indexOf(47));
                    Tr.debug((TraceComponent)tc, (String)("ear name: " + string2));
                    Vector<String> vector = (Vector<String>)hashtable.get(string2);
                    if (vector == null) {
                        vector = new Vector<String>();
                        hashtable.put(string2, vector);
                    }
                    try {
                        Resource resource2 = this.getResource("applications/" + string + "/deployment.xml", "deployment.xml", resourceBundle);
                        Deployment deployment = (Deployment)resource2.getContents().get(0);
                        String string3 = this.normalizePath(variableMap, ((ApplicationDeployment)deployment.getDeployedObject()).getBinariesURL());
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("path: " + string3));
                        }
                        if (!vector.contains(string3)) {
                            vector.addElement(string3);
                        }
                        resource2.unload();
                        continue;
                    }
                    catch (Throwable throwable) {
                        this.issueMessage("ADMU7004E", new Object[]{string, string2, throwable}, "ADMU7004E=ADMU7004E: Unexpected exception while building cache entry for " + string + ". Exception is: " + throwable + " All the related binaries may not be deleted/updated.");
                    }
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("table: " + hashtable));
            }
            resource.unload();
            Enumeration enumeration = hashtable.keys();
            object2 = this.configRoot + "/cells/" + this.cellName + "/applications/";
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                Vector vector = (Vector)hashtable.get(object);
                if (vector.size() == 0) continue;
                object = (String)object2 + (String)object + "/" + (String)object;
                string = null;
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Getting ear: " + (String)object));
                    }
                    string = EarUtils.getEarFile((String)object, false, true);
                }
                catch (Throwable throwable) {
                    this.issueMessage("ADMU7008E", new Object[]{object, vector, throwable}, "ADMU7008E=ADMU7008E: Unexpected exception in expandEar. The ear file " + (String)object + " will not be extracted in following " + "paths " + vector + ". Exception: " + throwable);
                }
                if (string == null) continue;
                for (int i = 0; i < vector.size(); ++i) {
                    try {
                        EarUtils.extractEar((EARFile)string, (String)vector.elementAt(i), true);
                        continue;
                    }
                    catch (Throwable throwable) {
                        this.issueMessage("ADMU7008E", new Object[]{object, vector.elementAt(i), throwable}, "ADMU7008E=ADMU7008E: Unexpected exception in expandEar. The ear file " + (String)object + " will not be extracted in following " + "paths " + vector.elementAt(i) + ". Exception: " + throwable);
                    }
                }
                string.close();
            }
        }
        catch (Throwable throwable) {
            this.issueMessage("ADMU6012I", new Object[]{throwable}, "Exception in app restore: " + throwable);
        }
        this.issueMessage("ADMU6009I", null, "ADMU6009I: Processing complete.");
    }

    private VariableMap createVarMap() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createVarMap");
        }
        BeanContextServicesSupport beanContextServicesSupport = new BeanContextServicesSupport();
        RepositoryImpl repositoryImpl = new RepositoryImpl("ws-server", this.configRoot, this.cellName, this.nodeName, null);
        beanContextServicesSupport.addService(class$com$ibm$ws$runtime$service$Repository == null ? (class$com$ibm$ws$runtime$service$Repository = RestoreConfigUtility.class$("com.ibm.ws.runtime.service.Repository")) : class$com$ibm$ws$runtime$service$Repository, (BeanContextServiceProvider)repositoryImpl);
        VariableMapImpl variableMapImpl = new VariableMapImpl();
        beanContextServicesSupport.add(variableMapImpl);
        variableMapImpl.initialize(null);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("createVarMap: " + variableMapImpl));
        }
        return variableMapImpl;
    }

    protected ResourceSet createResourceSet(final String string) {
        WASResourceSetImpl wASResourceSetImpl = new WASResourceSetImpl();
        URIConverterImpl uRIConverterImpl = new URIConverterImpl(){

            public URI normalize(URI uRI) {
                if (uRI.isRelative()) {
                    return uRI.resolve(URI.createFileURI((String)(string + File.separator)));
                }
                return super.normalize(uRI);
            }
        };
        wASResourceSetImpl.setURIConverter((URIConverter)uRIConverterImpl);
        return wASResourceSetImpl;
    }

    private Resource getResource(String string, String string2, ResourceBundle resourceBundle) {
        String string3 = this.configRoot + "/cells/" + this.cellName + "/" + string;
        try {
            ResourceSet resourceSet = this.createResourceSet(this.configRoot);
            URI uRI = URI.createFileURI((String)string3);
            Resource resource = resourceSet.getResource(uRI, true);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("res for: " + string3 + " is: " + resource));
            }
            return resource;
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Unexpected exception loading " + string3 + " as resource: " + throwable));
            }
            return null;
        }
    }

    private String normalizePath(VariableMap variableMap, String string) {
        String string2 = variableMap.expand(string);
        string2 = string2.replace('/', File.separatorChar);
        string2 = string2.replace('\\', File.separatorChar);
        return string2;
    }

    protected String getFormattedMessage(String string, Object[] objectArray, String string2) {
        if (string == null || !string.startsWith("ADMA")) {
            return super.getFormattedMessage(string, objectArray, string2);
        }
        try {
            String string3 = APP_BUNDLE.getString(string);
            if (string3 == null) {
                return string2;
            }
            return MessageFormat.format(string3, objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            if (string2 == null) {
                return string2;
            }
            return MessageFormat.format(string2, objectArray);
        }
        catch (NullPointerException nullPointerException) {
            return string2;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

