/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.tools;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.models.config.adminservice.JMXConnector;
import com.ibm.websphere.models.config.applicationserver.ApplicationServer;
import com.ibm.websphere.models.config.cellmanager.CellManager;
import com.ibm.websphere.models.config.messagingserver.JMSServer;
import com.ibm.websphere.models.config.nodeagent.NodeAgent;
import com.ibm.websphere.models.config.process.Component;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.ws.management.launcher.ServerIdentifiers;
import com.ibm.ws.management.tools.AdminTool;
import com.ibm.ws.management.tools.LaunchUtils;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.RepositoryImpl;
import java.io.File;
import java.util.Iterator;
import java.util.Vector;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class ServerStatus
extends AdminTool {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$tools$ServerStatus == null ? (class$com$ibm$ws$management$tools$ServerStatus = ServerStatus.class$("com.ibm.ws.management.tools.ServerStatus")) : class$com$ibm$ws$management$tools$ServerStatus), (String)"Admin", (String)"com.ibm.ws.management.resources.nodeutils");
    private static final String DEFAULT_TRACE_STRING = "*=all=disabled";
    private static final String DEFAULT_TRACE_FILE = "serverStatus.log";
    private boolean allservers = false;
    private AdminClient adminClient = null;
    private ServerIdentifiers sid = null;
    static /* synthetic */ Class class$com$ibm$ws$management$tools$ServerStatus;

    public static void main(String[] stringArray) {
        System.exit(new ServerStatus().executeUtility(stringArray));
    }

    protected String getDefaultTraceString() {
        return DEFAULT_TRACE_STRING;
    }

    protected String getDefaultTraceFile() {
        String string = System.getProperty("user.install.root");
        if (string == null || string.length() <= 0) {
            string = System.getProperty("was.install.root");
        }
        string = string + File.separator + "logs";
        if (!this.allservers) {
            string = string + File.separator + this.sid.getServerName();
        }
        string = string + File.separator + DEFAULT_TRACE_FILE;
        return string;
    }

    protected int getMinimumNumArgs() {
        return 4;
    }

    protected boolean isValidMinimumArgument(String string) {
        return !string.startsWith("-") || string.equals("-all");
    }

    protected void issueUsageMessage() {
        this.issueMessage("ADMU0502I", null, null);
    }

    protected int parseRequiredArgs(String[] stringArray) {
        this.sid = new ServerIdentifiers();
        this.sid.setConfigRoot(stringArray[0]);
        this.sid.setCellName(stringArray[1]);
        this.sid.setNodeName(stringArray[2]);
        if (stringArray[3].equals("-all")) {
            this.allservers = true;
        } else {
            this.sid.setServerName(stringArray[3]);
        }
        return 4;
    }

    protected int runTool() throws Exception {
        String string = "all servers";
        if (!this.allservers) {
            string = this.sid.getServerName();
            if (!this.serverConfigExists(this.sid)) {
                this.issueMessage("ADMU0522E", new Object[]{this.sid.getServerName()}, null);
                return -1;
            }
        }
        if (!this.allservers) {
            this.issueMessage("ADMU0500I", new Object[]{string}, null);
        } else {
            this.issueMessage("ADMU0503I", null, null);
        }
        Vector<String> vector = null;
        if (this.allservers) {
            vector = this.getServers();
        } else {
            vector = new Vector<String>();
            vector.add(this.sid.getServerName());
        }
        for (int i = 0; i < vector.size(); ++i) {
            String string2 = (String)vector.get(i);
            this.getStatus(string2);
        }
        return 0;
    }

    private void getStatus(String string) throws Exception {
        AdminClient adminClient = null;
        this.sid.setServerName(string);
        try {
            RepositoryImpl repositoryImpl = new RepositoryImpl("ws-server", this.sid.getConfigRoot(), this.sid.getCellName(), this.sid.getNodeName(), this.sid.getServerName());
            Resource resource = repositoryImpl.getConfigRoot().getResource(4, "server.xml");
            String string2 = this.getServerType(resource);
            JMXConnector jMXConnector = LaunchUtils.getJMXConnector(resource);
            if (jMXConnector != null) {
                try {
                    adminClient = LaunchUtils.getAdminClient((Repository)repositoryImpl, jMXConnector, this.userid, this.pwd);
                }
                catch (Exception exception) {
                    this.issueMessage("ADMU0509I", new Object[]{string2, string}, null);
                    return;
                }
            }
            if (adminClient != null) {
                String string3 = this.getServerStatus(adminClient);
                this.issueMessage("ADMU0508I", new Object[]{string2, string, string3}, null);
            }
        }
        catch (Exception exception) {
            Tr.error((TraceComponent)tc, (String)"ADMU0002E", (Object)new Object[]{this.sid.getServerName(), exception});
            throw exception;
        }
    }

    private String getServerType(Resource resource) {
        Server server = (Server)resource.getContents().get(0);
        EList eList = server.getComponents();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            Component component = (Component)iterator.next();
            if (component instanceof CellManager) {
                return "Deployment Manager";
            }
            if (component instanceof NodeAgent) {
                return "Node Agent";
            }
            if (component instanceof ApplicationServer) {
                return "Application Server";
            }
            if (!(component instanceof JMSServer)) continue;
            return "JMS Server";
        }
        return "Server";
    }

    private String getServerStatus(AdminClient adminClient) throws Exception {
        String string = null;
        ObjectName objectName = this.getServerHandle(adminClient);
        if (objectName != null) {
            String string2 = "getState";
            Object object = adminClient.invoke(objectName, string2, null, null);
            string = (String)object;
        } else {
            string = "RUNTIME/CONFIG MISMATCH";
        }
        return string;
    }

    private boolean serverConfigExists(ServerIdentifiers serverIdentifiers) {
        boolean bl = false;
        String string = serverIdentifiers.getConfigRoot() + "/cells/" + serverIdentifiers.getCellName() + "/nodes/" + serverIdentifiers.getNodeName() + "/servers/" + serverIdentifiers.getServerName();
        File file = new File(string);
        if (file.exists()) {
            bl = true;
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

