/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.tools;

import com.ibm.ejs.ras.ManagerAdmin;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.ws.management.launcher.LaunchCommand;
import com.ibm.ws.management.launcher.LaunchScriptCollaboratorFactory;
import com.ibm.ws.management.launcher.LaunchScriptPlatformCollaborator;
import com.ibm.ws.management.tools.WsServerController;
import com.ibm.ws.process.Process;
import com.ibm.ws.runtime.component.VariableMapImpl;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.RepositoryImpl;
import com.ibm.ws.runtime.service.VariableMap;
import java.beans.beancontext.BeanContextServiceProvider;
import java.beans.beancontext.BeanContextServicesSupport;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class WsServerLauncher
extends WsServerController {
    private static final String DEFAULT_TRACE_FILE = "startServer.log";
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$tools$WsServerLauncher == null ? (class$com$ibm$ws$management$tools$WsServerLauncher = WsServerLauncher.class$("com.ibm.ws.management.tools.WsServerLauncher")) : class$com$ibm$ws$management$tools$WsServerLauncher), (String)"Admin", (String)BUNDLE_NAME);
    private String scriptFileName = null;
    private boolean createScript = false;
    private boolean backgroundScript = false;
    private boolean binaryData = false;
    private Vector extraSystemProperties = null;
    private LaunchCommand launcher = null;
    private boolean devOption = false;
    static /* synthetic */ Class class$com$ibm$ws$management$tools$WsServerLauncher;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$Repository;

    protected String getDefaultTraceFile() {
        String string = System.getProperty("user.install.root");
        if (string == null || string.length() <= 0) {
            string = System.getProperty("was.install.root");
        }
        string = string + File.separator + "logs";
        string = string + File.separator + this.serverName;
        string = string + File.separator + DEFAULT_TRACE_FILE;
        return string;
    }

    public static void main(String[] stringArray) {
        System.exit(new WsServerLauncher().executeUtility(stringArray));
    }

    protected int parseUtilitySpecificOption(String[] stringArray, int n) {
        int n2 = n + 1;
        String string = stringArray[n];
        if (string.equals("-developerscript")) {
            this.createScript = true;
            this.devOption = true;
            this.scriptFileName = "start_" + this.serverName;
            String string2 = System.getProperty("os.name").toLowerCase();
            LaunchScriptPlatformCollaborator launchScriptPlatformCollaborator = LaunchScriptCollaboratorFactory.getCollaborator(string2);
            this.scriptFileName = launchScriptPlatformCollaborator.customizeScriptFilename(this.scriptFileName);
        } else if (string.equals("-script")) {
            this.createScript = true;
            if (this.isValidParameter(stringArray, n + 1)) {
                this.scriptFileName = stringArray[n + 1];
                ++n2;
            } else {
                this.scriptFileName = "start_" + this.serverName;
                String string3 = System.getProperty("os.name").toLowerCase();
                LaunchScriptPlatformCollaborator launchScriptPlatformCollaborator = LaunchScriptCollaboratorFactory.getCollaborator(string3);
                this.scriptFileName = launchScriptPlatformCollaborator.customizeScriptFilename(this.scriptFileName);
            }
        } else if (string.equals("-binaryData")) {
            this.binaryData = true;
        } else if (string.equals("-background")) {
            this.backgroundScript = true;
        } else if (string.startsWith("-D")) {
            if (this.extraSystemProperties == null) {
                this.extraSystemProperties = new Vector();
            }
            this.extraSystemProperties.add(string);
        } else if (string.startsWith("-J")) {
            if (this.extraSystemProperties == null) {
                this.extraSystemProperties = new Vector();
            }
            this.extraSystemProperties.add(string.substring(2));
        } else if (!string.equals("-dmgr") && !string.equals("-nodeagent")) {
            n2 = super.parseUtilitySpecificOption(stringArray, n);
        }
        return n2;
    }

    protected void issueUsageMessage() {
        if (this.isNodeAgent) {
            this.issueMessage("ADMU4016I", null, null);
        } else if (this.isDmgr) {
            this.issueMessage("ADMU4017I", null, null);
        } else {
            this.issueMessage("ADMU4001I", null, null);
        }
        this.issueMessage("ADMU4002I", null, null);
        this.issueMessage("ADMU4004I", null, null);
        this.issueMessage("ADMU4010I", null, null);
        this.issueMessage("ADMU4012I", null, null);
        this.issueMessage("ADMU4011I", null, null);
        this.issueMessage("ADMU4005I", null, null);
        this.issueMessage("ADMU4006I", null, null);
        this.issueMessage("ADMU4009I", null, null);
        this.issueMessage("ADMU4025I", null, null);
    }

    /*
     * Loose catch block
     */
    public int runTool() throws Exception {
        int n;
        block28: {
            String string;
            Process process;
            block26: {
                int n2;
                block27: {
                    RepositoryImpl repositoryImpl;
                    block24: {
                        int n3;
                        block25: {
                            block22: {
                                int n4;
                                block23: {
                                    this.issueMessage("ADMU3100I", new Object[]{this.serverName}, null);
                                    repositoryImpl = this.initializeRepositoryAndLauncher();
                                    if (!this.createScript) break block22;
                                    String string2 = System.getProperty("os.name");
                                    if (this.devOption) {
                                        this.launcher.setDevOption(this.devOption);
                                    }
                                    this.launcher.createLaunchScript(string2, this.scriptFileName, this.backgroundScript);
                                    this.issueMessage("ADMU3300I", new Object[]{this.scriptFileName}, null);
                                    n4 = 0;
                                    Object var7_8 = null;
                                    if (this.statusSocket == null) break block23;
                                    try {
                                        this.statusSocket.close();
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                }
                                return n4;
                            }
                            if (!this.binaryData) break block24;
                            this.scriptFileName = this.serverName + "_binary.data";
                            this.launcher.createBinaryData(this.scriptFileName);
                            n3 = 0;
                            Object var7_9 = null;
                            if (this.statusSocket == null) break block25;
                            try {
                                this.statusSocket.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        return n3;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Launching a new server process: " + this.serverName));
                    }
                    if (!this.nowait) {
                        this.statusPort = this.getStatusPort();
                        this.launcher.setStatusSocketPort(this.statusPort);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("status socket = " + this.statusPort.toString()));
                        }
                    }
                    if (this.serverIsRunning((Repository)repositoryImpl)) {
                        this.issueMessage("ADMU3027E", new Object[]{this.serverName}, null);
                        throw new AdminException(this.getFormattedMessage("ADMU3027E", new Object[]{this.serverName}, null));
                    }
                    process = this.launcher.launchProcess();
                    string = process.id();
                    if (!this.nowait) break block26;
                    process.release();
                    this.issueMessage("ADMU3400I", new Object[]{string}, null);
                    n2 = 0;
                    Object var7_10 = null;
                    if (this.statusSocket == null) break block27;
                    try {
                        this.statusSocket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return n2;
            }
            this.issueMessage("ADMU3200I", null, null);
            new ProcessWatcher(process);
            int n5 = this.waitForServerInit();
            if (n5 == 0) {
                this.issueMessage("ADMU3000I", new Object[]{this.serverName, string}, null);
            } else if (n5 == -1 || n5 == 0) {
                this.issueMessage("ADMU3011E", null, null);
            } else {
                String string3 = new Integer(this.statusTimeout / 1000).toString();
                throw new AdminException(this.getFormattedMessage("ADMU3040E", new Object[]{string3}, "Timed out waiting for server initialization."));
            }
            n = n5;
            Object var7_11 = null;
            if (this.statusSocket == null) break block28;
            try {
                this.statusSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return n;
        catch (Exception exception) {
            try {
                Tr.error((TraceComponent)tc, (String)"ADMU3002E", (Object)this.serverName);
                Tr.error((TraceComponent)tc, (String)"ADMU3007E", (Object)exception);
                throw exception;
            }
            catch (Throwable throwable) {
                block29: {
                    Object var7_12 = null;
                    if (this.statusSocket == null) break block29;
                    try {
                        this.statusSocket.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
        }
    }

    protected void toolFailed() {
        String string = null;
        if (this.launcher != null) {
            try {
                string = this.launcher.getLaunchCommand().toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ManagerAdmin.appendTraceString((String)"*=all=enabled");
        Tr.dump((TraceComponent)tc, (String)"LaunchCommand is: ", (Object)string);
    }

    private RepositoryImpl initializeRepositoryAndLauncher() throws Exception {
        BeanContextServicesSupport beanContextServicesSupport = new BeanContextServicesSupport();
        RepositoryImpl repositoryImpl = new RepositoryImpl("ws-server", this.configRoot, this.cellName, this.nodeName, this.serverName);
        beanContextServicesSupport.addService(class$com$ibm$ws$runtime$service$Repository == null ? (class$com$ibm$ws$runtime$service$Repository = WsServerLauncher.class$("com.ibm.ws.runtime.service.Repository")) : class$com$ibm$ws$runtime$service$Repository, (BeanContextServiceProvider)repositoryImpl);
        VariableMapImpl variableMapImpl = new VariableMapImpl();
        beanContextServicesSupport.add(variableMapImpl);
        variableMapImpl.initialize(null);
        this.launcher = new LaunchCommand((Repository)repositoryImpl, (VariableMap)variableMapImpl, this.createServerIdentifiers());
        if (this.extraSystemProperties != null) {
            for (int i = 0; i < this.extraSystemProperties.size(); ++i) {
                this.launcher.addSystemProperty((String)this.extraSystemProperties.get(i));
            }
        }
        return repositoryImpl;
    }

    protected boolean isFinalStatus(int n) {
        if (n == 0 || n == -1 || n == -2 || n == 0) {
            return true;
        }
        if (n == 2) {
            this.issueMessage("ADMU3220I", null, null);
        }
        return false;
    }

    protected int getFailureStatus() {
        return -1;
    }

    protected int getTimeoutStatus() {
        return -2;
    }

    protected void logUnknownException(Exception exception) {
        Tr.error((TraceComponent)tc, (String)"ADMU3009E", (Object)exception);
    }

    protected void printEnhancedErrorMessage(Throwable throwable) {
        if (throwable instanceof AdminException) {
            AdminException adminException = (AdminException)((Object)throwable);
            Throwable throwable2 = adminException.getCause();
        }
    }

    public Vector getLaunchCommand(String[] stringArray) {
        Vector vector = null;
        try {
            this.parseArgs(stringArray);
            this.initializeRepositoryAndLauncher();
            vector = this.launcher.getLaunchCommand();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return vector;
    }

    private boolean serverIsRunning(Repository repository2) throws Exception {
        boolean bl = false;
        Resource resource = repository2.getConfigRoot().getResource(3, "serverindex.xml");
        ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
        EList eList = serverIndex.getServerEntries();
        for (int i = 0; i < eList.size(); ++i) {
            ServerEntry serverEntry = (ServerEntry)eList.get(i);
            if (!serverEntry.getServerName().equals(this.serverName)) continue;
            EList eList2 = serverEntry.getSpecialEndpoints();
            for (int j = 0; j < eList2.size(); ++j) {
                NamedEndPoint namedEndPoint = (NamedEndPoint)eList2.get(j);
                if (!namedEndPoint.getEndPointName().equals("SOAP_CONNECTOR_ADDRESS")) continue;
                int n = namedEndPoint.getEndPoint().getPort();
                String string = namedEndPoint.getEndPoint().getHost();
                try {
                    Socket socket = new Socket(string, n);
                    bl = true;
                    socket.close();
                    String string2 = new Integer(n).toString();
                    this.issueMessage("ADMU3028I", new Object[]{string2, this.serverName}, null);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class ProcessWatcher
    extends Thread {
        Process process;

        public ProcessWatcher(Process process) {
            this.process = process;
            this.setDaemon(true);
            this.start();
        }

        public void run() {
            try {
                if (this.process.isAlive()) {
                    this.process.waitForTermination();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Socket socket = new Socket("localhost", WsServerLauncher.this.statusSocket.getLocalPort());
                DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
                dataOutputStream.writeInt(-1);
                dataOutputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

