/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.repository.ConfigChangeNotifier;
import com.ibm.websphere.management.repository.ConfigRepositoryEvent;
import com.ibm.websphere.management.repository.ConfigRepositoryListener;
import com.ibm.websphere.models.config.messagingserver.JMSServer;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.util.MQTask;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.VariableMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class MQTaskHandler
implements ConfigRepositoryListener {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$util$MQTaskHandler == null ? (class$com$ibm$ws$management$util$MQTaskHandler = MQTaskHandler.class$("com.ibm.ws.management.util.MQTaskHandler")) : class$com$ibm$ws$management$util$MQTaskHandler), (String)"MQTaskHandler", (String)"com.ibm.ws.management.resources.nodeutils");
    private VariableMap variableMap;
    private Repository repository;
    private HashMap pendingJMSServerChanges = new HashMap();
    private String cellName = AdminServiceFactory.getAdminService().getCellName();
    private String nodeName = AdminServiceFactory.getAdminService().getNodeName();
    static /* synthetic */ Class class$com$ibm$ws$management$util$MQTaskHandler;

    public MQTaskHandler(VariableMap variableMap, Repository repository2) {
        this.variableMap = variableMap;
        this.repository = repository2;
    }

    public void onRepositoryLock() {
    }

    public void onRepositoryUnlock() {
    }

    public void onChangeStart(ConfigRepositoryEvent configRepositoryEvent) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"onChangeStart", (Object)configRepositoryEvent);
        }
        this.pendingJMSServerChanges.clear();
        ConfigChangeNotifier[] configChangeNotifierArray = configRepositoryEvent.getChanges();
        block4: for (int i = 0; i < configChangeNotifierArray.length; ++i) {
            ConfigChangeNotifier configChangeNotifier = configChangeNotifierArray[i];
            if (!this.applies(configChangeNotifier.getUri())) continue;
            switch (configChangeNotifier.getChangeType()) {
                case 0: {
                    this.pendingJMSServerChanges.put(configChangeNotifier.getUri(), new Integer(0));
                    continue block4;
                }
                case 1: {
                    int n = this.containsJMSServer(configChangeNotifier.getUri());
                    if (n <= 0) continue block4;
                    this.pendingJMSServerChanges.put(configChangeNotifier.getUri(), new Integer(n));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"onChangeStart");
        }
    }

    public void onChangeCompletion(ConfigRepositoryEvent configRepositoryEvent) {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"onChangeCompletion", (Object)configRepositoryEvent);
        }
        ConfigChangeNotifier[] configChangeNotifierArray = configRepositoryEvent.getChanges();
        block12: for (int i = 0; i < configChangeNotifierArray.length; ++i) {
            object2 = configChangeNotifierArray[i];
            object = (Integer)this.pendingJMSServerChanges.get(((ConfigChangeNotifier)object2).getUri());
            if (object == null) continue;
            switch (((ConfigChangeNotifier)object2).getChangeType()) {
                case 0: {
                    int n = this.containsJMSServer(((ConfigChangeNotifier)object2).getUri());
                    if ((Integer)object == n) continue block12;
                    this.pendingJMSServerChanges.put(((ConfigChangeNotifier)object2).getUri(), new Integer(n - (Integer)object));
                    continue block12;
                }
                case 1: {
                    this.pendingJMSServerChanges.put(((ConfigChangeNotifier)object2).getUri(), new Integer(-1));
                }
            }
        }
        MQTask mQTask = new MQTask(this.variableMap, this.cellName, this.nodeName);
        if (mQTask.isMQInstalled()) {
            object2 = this.pendingJMSServerChanges.entrySet();
            object = object2.iterator();
            while (object.hasNext()) {
                Map.Entry entry = (Map.Entry)object.next();
                int n = (Integer)entry.getValue();
                String string = this.getServerName((String)entry.getKey());
                switch (n) {
                    case 1: {
                        try {
                            Tr.audit((TraceComponent)tc, (String)"ADMU0523I", (Object)new Object[]{this.nodeName, string});
                            mQTask.createMQ(string);
                            Tr.audit((TraceComponent)tc, (String)"ADMU0525I", (Object)new Object[]{"createmq." + this.nodeName + '_' + string + ".log"});
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.util.MQTaskHandler.onChangeCompletion", (String)"124", (Object)this);
                        }
                        break;
                    }
                    case -1: {
                        try {
                            Tr.audit((TraceComponent)tc, (String)"ADMU0526I", (Object)new Object[]{this.nodeName, string});
                            mQTask.deleteMQ(string);
                            Tr.audit((TraceComponent)tc, (String)"ADMU0528I", (Object)new Object[]{"deletemq." + this.nodeName + "_" + string + ".log"});
                            break;
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.util.MQTaskHandler.onChangeCompletion", (String)"133", (Object)this);
                        }
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"onChangeCompletion");
        }
    }

    public void onRepositoryEpochRefresh() {
    }

    private int containsJMSServer(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"containsJMSServer", (Object)string);
        }
        int n = 0;
        try {
            FileInputStream fileInputStream = new FileInputStream(new File(this.repository.getRootURI(), string));
            WASResourceSetImpl wASResourceSetImpl = new WASResourceSetImpl();
            URI uRI = URI.createFileURI((String)(this.repository.getRootURI() + File.separator + string));
            Resource resource = wASResourceSetImpl.createResource(uRI);
            resource.load((InputStream)fileInputStream, new HashMap());
            Server server = (Server)resource.getContents().get(0);
            Iterator iterator = server.getComponents().iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"server component", e);
                }
                if (!(e instanceof JMSServer)) continue;
                ++n;
                break;
            }
            wASResourceSetImpl.getResources().remove((Object)resource);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.util.MQTaskHandler", (String)"107", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("containsJMSServer" + n));
        }
        return n;
    }

    private boolean applies(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"applies", (Object)string);
        }
        boolean bl = false;
        if (!AdminServiceFactory.getAdminService().getProcessType().equals("ManagedProcess") && string.endsWith("/server.xml")) {
            String string2 = null;
            String string3 = null;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                if (string4.equals("cells")) {
                    if (!stringTokenizer.hasMoreTokens()) continue;
                    string2 = stringTokenizer.nextToken();
                    continue;
                }
                if (!string4.equals("nodes") || !stringTokenizer.hasMoreTokens()) continue;
                string3 = stringTokenizer.nextToken();
                break;
            }
            if (this.nodeName.equals(string3) && this.cellName.equals(string3)) {
                bl = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("applies" + bl));
        }
        return bl;
    }

    private String getServerName(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getServerName", (Object)string);
        }
        String string2 = null;
        String string3 = "/servers/";
        int n = string.lastIndexOf(string3);
        if (n != -1) {
            string2 = string.substring(n += string3.length(), string.indexOf(47, n));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getServerName", string2);
        }
        return string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

