/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.WSSecurityContext;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.role.RoleBasedAppException;
import com.ibm.ws.security.role.RoleBasedConfigurator;
import com.ibm.ws.security.role.RoleBasedConfiguratorNullImpl;
import com.ibm.ws.security.service.SecurityService;
import com.ibm.ws.security.service.SecurityServiceEvent;
import com.ibm.ws.security.service.SecurityServiceListener;
import java.security.Permission;
import java.util.Properties;
import javax.security.auth.Subject;

public final class SecurityHelper
implements SecurityServiceListener {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$util$SecurityHelper == null ? (class$com$ibm$ws$management$util$SecurityHelper = SecurityHelper.class$("com.ibm.ws.management.util.SecurityHelper")) : class$com$ibm$ws$management$util$SecurityHelper));
    public static final String isInternal = "isInternal";
    public static final String loginMethod = "LoginMethod";
    public static final String tokenBasedAuth = "TokenBased";
    public static final String basicAuth = "BasicAuth";
    public static final String tokeElement = "token";
    public static final String trustStoreProp = "javax.net.ssl.trustStore";
    public static final String keyStoreProp = "javax.net.ssl.keyStore";
    public static final String trustStorePasswordProp = "javax.net.ssl.trustStorePassword";
    public static final String keyStorePasswordProp = "javax.net.ssl.keyStorePassword";
    public static final String sslHandlerProp = "java.protocol.handler.pkgs";
    public static final String defaultSslHandler = "com.ibm.net.ssl.internal.www.protocol";
    public static final String FIPSProvider = "ssl.SocketFactory.provider";
    public static final String contextProvider = "com.ibm.ssl.contextProvider";
    private boolean securityEnabled = false;
    private boolean securityServiceEnabled = false;
    private RoleBasedConfigurator configurator = new RoleBasedConfiguratorNullImpl();
    private static String realm = null;
    private Properties SOAPSslSetting = null;
    private SecurityService securityService = null;
    private static final WebSphereRuntimePermission perm = new WebSphereRuntimePermission("SecOwnCredentials");
    private static ContextManager contextMgr = null;
    private WSSecurityContext securityContext = null;
    private static SecurityHelper myself = new SecurityHelper();
    static /* synthetic */ Class class$com$ibm$ws$management$util$SecurityHelper;

    private SecurityHelper() {
    }

    public static SecurityHelper getHelper() {
        return myself;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void stateChanged(SecurityServiceEvent var1_1) {
        if (SecurityHelper.tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)SecurityHelper.tc, (String)"stateChanged");
        }
        if ((var2_2 = var1_1.getState()) == 1) {
            block12: {
                this.securityServiceEnabled = true;
                SecurityHelper.realm = this.securityService.getRealm();
                try {
                    this.securityContext = this.securityService.getWSSecurityContext();
                    SecurityHelper.contextMgr = ContextManagerFactory.getInstance();
                }
                catch (Exception var3_3) {
                    if (!SecurityHelper.tc.isDebugEnabled()) break block12;
                    Tr.debug((TraceComponent)SecurityHelper.tc, (String)"Error getting contextManager from security component.");
                }
            }
            try {
                this.configurator = this.securityService.getConfigurator();
            }
            catch (RoleBasedAppException var3_4) {
                if (!SecurityHelper.tc.isDebugEnabled()) ** GOTO lbl26
                Tr.debug((TraceComponent)SecurityHelper.tc, (String)"RoleBasedConfigurator not initialized");
            }
            finally {
                this.securityService = null;
            }
        } else if (SecurityHelper.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)SecurityHelper.tc, (String)("Security service state change to: " + var2_2));
        }
lbl26:
        // 6 sources

        if (SecurityHelper.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)SecurityHelper.tc, (String)"stateChanged");
        }
    }

    public WSSecurityContext getWSSecurityContext() {
        return this.securityContext;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
        this.securityEnabled = this.securityService.isSecurityEnabled();
    }

    public void setSOAPSslSetting(Properties properties) {
        this.SOAPSslSetting = properties;
    }

    public boolean isSecurityEnabled() {
        return this.securityEnabled;
    }

    public boolean isSecurityServiceStarted() {
        return this.securityServiceEnabled;
    }

    public RoleBasedConfigurator getConfigurator() {
        return this.configurator;
    }

    public String getRealm() {
        return realm;
    }

    public Properties getSOAPSslSetting() {
        return this.SOAPSslSetting;
    }

    public static Subject authenticate(String string, String string2) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"authenticate");
        }
        Subject subject = null;
        try {
            subject = SecurityHelper.getContextManager().login(SecurityHelper.getContextManager().getDefaultRealm(), string, string2);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"fail to authenticate", (Object)exception);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"authenticate - failed");
            }
            if (exception instanceof WSLoginFailedException) {
                throw (WSLoginFailedException)exception;
            }
            throw new WSLoginFailedException(exception.getMessage(), (Throwable)exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"authenticate");
        }
        return subject;
    }

    public static Subject validate(byte[] byArray) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"validate");
        }
        Subject subject = null;
        try {
            subject = SecurityHelper.getContextManager().login(SecurityHelper.getContextManager().getDefaultRealm(), byArray);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"fail to validate", (Object)exception);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"validate - failed");
            }
            if (exception instanceof WSLoginFailedException) {
                throw (WSLoginFailedException)exception;
            }
            throw new WSLoginFailedException(exception.getMessage(), (Throwable)exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"validate");
        }
        return subject;
    }

    public static Subject createBasicAuthSubject(String string, String string2) {
        Subject subject;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"createBasicAuthSubject");
            }
            subject = null;
            try {
                subject = SubjectHelper.createBasicAuthSubject((String)SecurityHelper.getContextManager().getDefaultRealm(), (String)string, (String)string2);
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"fail to create basic auth subject", (Object)exception);
                }
                if (!tc.isEntryEnabled()) break block5;
                Tr.exit((TraceComponent)tc, (String)"authenticate - failed");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createBasicAuthSubject");
        }
        return subject;
    }

    public static void removeSubjectFromThreadTable(Subject subject) {
        block2: {
            try {
                SecurityHelper.getContextManager().initializeCallerContext((Subject)null);
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)"Failed to initialize caller context.", (Object)exception);
            }
        }
    }

    public static Subject pushInvocationSubject(Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"pushInvocationSubject");
        }
        Subject subject2 = null;
        try {
            subject2 = SecurityHelper.getContextManager().pushInvocationSubject(subject);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.connector.util.SecurityHelper.pushInvocationSubject", (String)"226");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"pushInvocationSubject");
        }
        return subject2;
    }

    public static void popInvocationSubject(Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"popInvocationSubject");
        }
        try {
            SecurityHelper.getContextManager().popInvocationSubject(subject);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.connector.util.SecurityHelper.popInvocationSubject", (String)"239");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"popInvocationSubject");
        }
    }

    public static Subject getOwnedSubject() {
        return SecurityHelper.getServerSubject();
    }

    public static Subject retrieveSubject() {
        Subject subject;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"retrieveSubject");
        }
        if ((subject = SecurityHelper.getReceivedSubject()) == null) {
            subject = SecurityHelper.getInvocationSubject();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"retrieveSubject");
        }
        return subject;
    }

    public static Subject getInvocationSubject() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getInvocationSubject");
        }
        Subject subject = null;
        WSCredential wSCredential = null;
        boolean bl = false;
        try {
            subject = SecurityHelper.getContextManager().getInvocationSubject();
            wSCredential = SubjectHelper.getWSCredentialFromSubject((Subject)subject);
            if (wSCredential != null) {
                bl = wSCredential.isCurrent();
            }
            if (!bl && subject != null && SecurityHelper.getContextManager().isServerSubject(subject)) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Server subject is expired, logging in to get a new one.");
                    }
                    subject = SecurityHelper.getContextManager().getServerSubject();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.connector.util.SecurityHelper.getInvocationSubject", (String)"450");
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"unable to obtain invocation subject or subject expired", (Object)exception);
                    }
                    subject = null;
                }
            } else if (!bl && subject != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Non-server invocation subject is invalid or expired.");
                }
            } else if (subject == null && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Invocation subject is null.");
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.connector.util.SecurityHelper.getInvocationSubject", (String)"394");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unable to obtain invocation subject from ContextManager.", (Object)exception);
            }
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getInvocationSubject");
        }
        return subject;
    }

    public static void resetContext() {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"resetContext");
            }
            try {
                SecurityHelper.getContextManager().initializeCallerContext((Subject)null);
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)"fail to initialize caller context.", (Object)exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resetContext");
        }
    }

    public static void setInvocationSubject(Subject subject) {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"setInvocationSubject");
            }
            try {
                SecurityHelper.getContextManager().setInvocationSubject(subject);
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)"fail to set invocation subject.", (Object)exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setInvocationSubject");
        }
    }

    public static void setReceivedSubject(Subject subject) {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"setReceivedSubject");
            }
            try {
                SecurityHelper.getContextManager().setCallerSubject(subject);
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)"Failed to set caller subject.", (Object)exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setReceivedSubject");
        }
    }

    public static Subject getReceivedSubject() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getReceivedSubject");
        }
        Subject subject = null;
        WSCredential wSCredential = null;
        boolean bl = false;
        try {
            subject = SecurityHelper.getContextManager().getCallerSubject();
            if (subject != null) {
                wSCredential = SubjectHelper.getWSCredentialFromSubject((Subject)subject);
            }
            if (wSCredential != null) {
                bl = wSCredential.isCurrent();
            }
            if (!bl && subject != null && SecurityHelper.getContextManager().isServerSubject(subject)) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Server subject is expired, logging in to get a new one.");
                    }
                    subject = SecurityHelper.getContextManager().getServerSubject();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.connector.util.SecurityHelper.getReceivedSubject", (String)"557");
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"unable to obtain received subject or subject is expired", (Object)exception);
                    }
                    subject = null;
                }
            } else if (!bl && subject != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Non-server received subject is invalid or expired.");
                }
                subject = null;
            } else if (subject == null && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Received subject is null.");
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unable to obtain received subject from ContextManager.", (Object)exception);
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.connector.util.SecurityHelper.getReceivedSubject", (String)"504");
            bl = false;
        }
        if (bl && subject != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getReceivedSubject");
            }
            return subject;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getReceivedSubject");
        }
        return null;
    }

    public static Subject getActualSubject(Subject subject) {
        WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject((Subject)subject);
        if (wSCredential.isBasicAuth()) {
            Subject subject2 = null;
            try {
                subject2 = SecurityHelper.getContextManager().login(wSCredential);
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"LoginFailed exception getting server cred.", (Object)new Object[]{exception});
                }
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.connector.util.SecurityHelper.getActualSubject", (String)"512");
                subject2 = null;
            }
            return subject2;
        }
        return subject;
    }

    public static Subject getServerSubject() {
        Subject subject = null;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Performing Java 2 Security Permission Check ...Expecting : " + perm.toString()));
            }
            securityManager.checkPermission((Permission)perm);
        }
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Getting server subject.");
            }
            subject = SecurityHelper.getContextManager().getServerSubject();
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"unable to obtain own subject or subject is expired", (Object)exception);
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.connector.util.SecurityHelper.getServerCredential", (String)"1001");
            subject = null;
        }
        return subject;
    }

    public static String getUserName() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUserName");
        }
        String string = null;
        try {
            Subject subject = SecurityHelper.retrieveSubject();
            WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject((Subject)subject);
            if (wSCredential != null) {
                string = wSCredential.getRealmSecurityName();
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception attempting to getUserName from credential.", (Object)new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.connector.util.SecurityHelper.getUserName", (String)"573");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUserName");
        }
        return string;
    }

    public static ContextManager getContextManager() {
        if (contextMgr == null) {
            contextMgr = ContextManagerFactory.getInstance();
        }
        return contextMgr;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

