/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.ObjectNameHelper;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.models.config.process.ProcessFactory;
import com.ibm.websphere.models.config.process.ProcessPackage;
import com.ibm.websphere.product.WASProduct;
import com.ibm.websphere.product.xml.product.product;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.ServantAdminService;
import com.ibm.ws.runtime.service.ThreadPoolMgr;
import com.ibm.ws.util.ThreadPool;
import java.util.StringTokenizer;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.eclipse.emf.ecore.EPackage;

public class Utils {
    public static final long CLOCK_SYNC_TOLERANCE = 300000L;
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$util$Utils == null ? (class$com$ibm$ws$management$util$Utils = Utils.class$("com.ibm.ws.management.util.Utils")) : class$com$ibm$ws$management$util$Utils), (String)"Admin", null);
    private static WASProduct product = null;
    private static ServantAdminService servant = null;
    static /* synthetic */ Class class$com$ibm$ws$management$util$Utils;

    public static String getNodeAgentName() {
        return "nodeagent";
    }

    public static String getNetmgrName(AdminClient adminClient) {
        ObjectName objectName = null;
        String string = "dmgr";
        try {
            objectName = adminClient.getServerMBean();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.util.Utils.getNetmgrName", (String)"32");
        }
        if (objectName != null) {
            string = ObjectNameHelper.getProcessName(objectName);
        }
        return string;
    }

    public static ThreadPool getThreadPool(ThreadPoolMgr threadPoolMgr, String string, int n, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getThreadPool", (Object)string);
        }
        ThreadPool threadPool = null;
        ProcessPackage processPackage = (ProcessPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/process.xmi");
        ProcessFactory processFactory = processPackage.getProcessFactory();
        com.ibm.websphere.models.config.process.ThreadPool threadPool2 = processFactory.createThreadPool();
        threadPool2.setMinimumSize(1);
        threadPool2.setMaximumSize(n);
        threadPool2.setIsGrowable(bl);
        threadPool = threadPoolMgr.getThreadPool(string, threadPool2);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getThreadPool");
        }
        return threadPool;
    }

    public static String getProductName() {
        if (product == null) {
            product = new WASProduct();
        }
        return product.getPlatform().getName();
    }

    public static String getProductVersion() {
        product product2;
        if (product == null) {
            product = new WASProduct();
        }
        if ((product2 = product.getProductById("BASE")) == null) {
            product2 = product.getProductById("ND");
        }
        String string = null;
        if (product2 != null) {
            string = product2.getVersion();
        }
        return string;
    }

    public static String getRemoteProductVersion(String string, ObjectName objectName, AdminClient adminClient) throws InstanceNotFoundException, MBeanException, ConnectorException {
        String string2 = null;
        try {
            if (adminClient != null) {
                string2 = (String)adminClient.invoke(objectName, "getProductVersion", new Object[]{string}, new String[]{"java.lang.String"});
            } else {
                AdminService adminService = AdminServiceFactory.getAdminService();
                string2 = (String)adminService.invoke(objectName, "getProductVersion", new Object[]{string}, new String[]{"java.lang.String"});
            }
        }
        catch (ReflectionException reflectionException) {
            // empty catch block
        }
        if (string2 != null) {
            int n = string2.indexOf("<version>");
            if (n < 0) {
                return null;
            }
            int n2 = string2.indexOf("</version>", n);
            if (n2 < 0) {
                return null;
            }
            string2 = string2.substring(n + 9, n2);
        }
        return string2;
    }

    public static int compareVersions(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ".");
        short s = 0;
        short s2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            s = Short.parseShort(stringTokenizer.nextToken());
            if (!stringTokenizer2.hasMoreTokens()) {
                while (s == 0) {
                    if (stringTokenizer.hasMoreTokens()) {
                        s = Short.parseShort(stringTokenizer.nextToken());
                        continue;
                    }
                    return 0;
                }
                return 1;
            }
            s2 = Short.parseShort(stringTokenizer2.nextToken());
            if (s < s2) {
                return -1;
            }
            if (s <= s2) continue;
            return 1;
        }
        if (stringTokenizer2.hasMoreTokens()) {
            s2 = Short.parseShort(stringTokenizer2.nextToken());
            while (s2 == 0) {
                if (stringTokenizer2.hasMoreTokens()) {
                    s2 = Short.parseShort(stringTokenizer2.nextToken());
                    continue;
                }
                return 0;
            }
            return -1;
        }
        return 0;
    }

    public static boolean isClockInSync(AdminClient adminClient, ObjectName objectName) throws InstanceNotFoundException, MBeanException, ConnectorException {
        long l = System.currentTimeMillis();
        long l2 = Utils.getRemoteTime(adminClient, objectName);
        long l3 = System.currentTimeMillis();
        long l4 = l3 - l;
        return Math.abs(l2 - l3) <= 300000L + l4;
    }

    public static long getRemoteTime(AdminClient adminClient, ObjectName objectName) throws InstanceNotFoundException, MBeanException, ConnectorException {
        long l = 0L;
        try {
            if (adminClient != null) {
                l = (Long)adminClient.invoke(objectName, "getCurrentTimeInMillis", null, null);
            } else {
                AdminService adminService = AdminServiceFactory.getAdminService();
                l = (Long)adminService.invoke(objectName, "getCurrentTimeInMillis", null, null);
            }
        }
        catch (ReflectionException reflectionException) {
            // empty catch block
        }
        return l;
    }

    public static ServantAdminService getServantAdminService() {
        return servant;
    }

    public static void setServantAdminService(ServantAdminService servantAdminService) {
        servant = servantAdminService;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

