/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.awt;

import com.ibm.gsk.ikeyman.Ikeyman;
import com.ibm.gsk.ikeyman.awt.KMAWTUtil;
import com.ibm.gsk.ikeyman.awt.KMButton;
import com.ibm.gsk.ikeyman.awt.KMFilenameFilter;
import com.ibm.gsk.ikeyman.awt.KMFrame;
import com.ibm.gsk.ikeyman.awt.KMHorizontalButtonPanel;
import com.ibm.gsk.ikeyman.awt.LightMultiLineLabel;
import com.ibm.gsk.ikeyman.awt.MultiLineLabel;
import com.ibm.gsk.ikeyman.awt.PasswordDialog;
import com.ibm.gsk.ikeyman.basic.KMException;
import com.ibm.gsk.ikeyman.basic.KMSystem;
import com.ibm.gsk.ikeyman.basic.KMUtil;
import com.ibm.gsk.ikeyman.basic.KeyStoreManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;

public class OpenCryptoTokenDialog
extends JDialog
implements ActionListener,
ItemListener {
    private KeyStoreManager secondaryKeyDbFile = null;
    private String defaultSecondaryKeyDbFileName = null;
    private String defaultSecondaryKeyDbFileDirectory = null;
    private JLabel cryptographicTokenLabelLabel = null;
    private JLabel JSSETokenLabel = null;
    private JComboBox cryptographicTokenLabelComboBox = null;
    private JTextField JSSETokenLabelTextField = null;
    private String cryptographicTokenLabel = null;
    private int JSSETokenSlotNumber = 0;
    private int cryptographicTokenIndex = 0;
    private JLabel cryptographicTokenPasswordLabel = null;
    private JPasswordField cryptographicTokenPasswordField = null;
    private String cryptographicTokenPassword = null;
    static boolean addSecondaryKeyDbFileFields = false;
    private Component secondaryKeyDbFileExplanationLabel = null;
    private JCheckBox openExistingSecondaryKeyDbFileCheckBox = null;
    private boolean openExistingSecondaryKeyDbFile = false;
    private JCheckBox createNewSecondaryKeyDbFileCheckBox = null;
    private boolean createNewSecondaryKeyDbFile = false;
    private JLabel secondaryKeyDbFileTypeLabel = null;
    private int[] secondaryKeyDbFileTypes = null;
    private JComboBox secondaryKeyDbFileTypeComboBox = null;
    private int secondaryKeyDbFileType = 0;
    private JLabel secondaryKeyDbFileNameLabel = null;
    private JTextField secondaryKeyDbFileNameTextField = null;
    private String secondaryKeyDbFileName = null;
    private JLabel secondaryKeyDbFileDirectoryLabel = null;
    private JTextField secondaryKeyDbFileDirectoryTextField = null;
    private String secondaryKeyDbFileDirectory = null;
    private KMButton secondaryKeyDbFileBrowseButton = null;
    private KMButton okButton = null;
    private KMButton cancelButton = null;
    private JLabel fileNameLabel = null;
    private static int cryptoType = 0;
    private String JSSETokenDriverName = null;

    public OpenCryptoTokenDialog(JFrame jFrame, int n, String string) {
        super(jFrame, Ikeyman.getNLSResString("GUI_DIALOG_TITLE_OPEN_CRYPTOGRAPHIC_TOKEN"), true);
        cryptoType = n;
        addSecondaryKeyDbFileFields = cryptoType == 1;
        this.JSSETokenDriverName = string;
        this.initializeDefaultSecondaryKeyDbFile();
        this.populateFields();
        this.performLayout();
        this.initializeReturnValues();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ((Component)OpenCryptoTokenDialog.this).setVisible(false);
            }
        });
        this.setFocus();
        ((Component)this).setVisible(true);
    }

    public void setSecondaryDB(boolean bl) {
        addSecondaryKeyDbFileFields = bl;
    }

    public boolean getSecondaryDB() {
        return addSecondaryKeyDbFileFields;
    }

    private void initializeDefaultSecondaryKeyDbFile() {
        String string = KMSystem.getInitSetting("DEFAULT_CRYPTOGRAPHIC_TOKEN_SECONDARY_KEYDB");
        if (string != null && string.length() > 0) {
            int n = string.lastIndexOf(File.separator);
            if (n >= 0) {
                if (n == string.length() - 1) {
                    this.defaultSecondaryKeyDbFileName = null;
                    this.defaultSecondaryKeyDbFileDirectory = string;
                } else {
                    this.defaultSecondaryKeyDbFileName = string.substring(n + 1);
                    this.defaultSecondaryKeyDbFileDirectory = string.substring(0, n + 1);
                }
            } else {
                this.defaultSecondaryKeyDbFileName = string;
                this.defaultSecondaryKeyDbFileDirectory = null;
            }
        }
    }

    private void populateFields() {
        boolean bl;
        Object object;
        this.cryptographicTokenLabelLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_CRYPTOGRAPHIC_TOKEN_LABEL"));
        this.JSSETokenLabel = new JLabel("Slot number:");
        this.cryptographicTokenLabelComboBox = new JComboBox();
        this.JSSETokenLabelTextField = new JTextField("0", 5);
        this.JSSETokenLabelTextField.addActionListener(this);
        this.fileNameLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_FILENAME") + " " + this.JSSETokenDriverName);
        Vector vector = null;
        try {
            if (cryptoType == 1) {
                vector = KeyStoreManager.getTokenLabelList(cryptoType);
            }
        }
        catch (KMException kMException) {
            KMFrame.errorHandler(KMAWTUtil.getFrame(this), KMSystem.getNLSErrString("GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_ERROR"));
        }
        if (cryptoType == 1) {
            if (vector != null && vector.size() > 0) {
                int n = 0;
                while (n < vector.size()) {
                    if (vector.elementAt(n) != "") {
                        this.cryptographicTokenLabelComboBox.addItem(vector.elementAt(n));
                    } else {
                        this.cryptographicTokenLabelComboBox.addItem("no label");
                    }
                    ++n;
                }
                this.cryptographicTokenLabelComboBox.setSelectedIndex(0);
            }
            this.cryptographicTokenLabelComboBox.addItemListener(this);
            this.cryptographicTokenPasswordLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_CRYPTOGRAPHIC_TOKEN_PASSWORD"));
            this.cryptographicTokenPasswordField = new JPasswordField(12);
            this.cryptographicTokenPasswordField.setEchoChar('*');
        }
        try {
            if (cryptoType == 1) {
                this.cryptographicTokenLabel = (String)this.cryptographicTokenLabelComboBox.getSelectedItem();
                object = new KeyStoreManager(this.cryptographicTokenLabel, this.cryptographicTokenLabelComboBox.getSelectedIndex(), cryptoType);
                if (!((KeyStoreManager)object).isPasswordNeeded()) {
                    this.cryptographicTokenPasswordLabel.setEnabled(false);
                    this.cryptographicTokenPasswordField.setEnabled(false);
                    this.cryptographicTokenPasswordField.setEditable(false);
                    this.cryptographicTokenPasswordField.setBackground(this.cryptographicTokenPasswordField.getBackground().brighter());
                }
            }
        }
        catch (KMException kMException) {
            // empty catch block
        }
        this.secondaryKeyDbFileTypes = new int[1];
        this.secondaryKeyDbFileTypes[0] = 1;
        if (!KMSystem.isJNIEnabled()) {
            object = new Vector();
            bl = false;
            while (bl < this.secondaryKeyDbFileTypes.length) {
                if (this.secondaryKeyDbFileTypes[bl] != 1) {
                    ((Vector)object).addElement(new Integer(this.secondaryKeyDbFileTypes[bl]));
                }
                bl += 1;
            }
            if (((Vector)object).isEmpty()) {
                this.secondaryKeyDbFileTypes = new int[0];
            } else {
                this.secondaryKeyDbFileTypes = new int[((Vector)object).size()];
                int n = 0;
                while (n < ((Vector)object).size()) {
                    this.secondaryKeyDbFileTypes[n] = (Integer)((Vector)object).elementAt(n);
                    ++n;
                }
            }
        }
        if (this.secondaryKeyDbFileTypes.length > 0) {
            object = Ikeyman.getNLSResString("GUI_LABEL_SECONDARY_KEYDB_EXPLANATION");
            this.secondaryKeyDbFileExplanationLabel = KMFrame.isWindowSystem() ? new MultiLineLabel((String)object) : (((String)object).indexOf(10) < 0 ? new JLabel((String)object) : new LightMultiLineLabel((String)object));
            bl = true;
            String string = KMSystem.getInitSetting("DEFAULT_CRYPTOGRAPHIC_TOKEN_OPEN_EXISTING_SECONDARY_KEYDB");
            bl = string == null || string.length() <= 0 || !string.equalsIgnoreCase("false");
            this.openExistingSecondaryKeyDbFileCheckBox = new JCheckBox(Ikeyman.getNLSResString("GUI_LABEL_OPEN_EXISTING_SECONDARY_KEYDB_FILE"), bl);
            this.openExistingSecondaryKeyDbFileCheckBox.setActionCommand("Open Existing Secondary");
            this.openExistingSecondaryKeyDbFileCheckBox.addItemListener(this);
            this.createNewSecondaryKeyDbFileCheckBox = new JCheckBox(Ikeyman.getNLSResString("GUI_LABEL_CREATE_NEW_SECONDARY_KEYDB_FILE"), false);
            this.createNewSecondaryKeyDbFileCheckBox.setActionCommand("Create New Secondary");
            this.createNewSecondaryKeyDbFileCheckBox.addItemListener(this);
            this.secondaryKeyDbFileTypeLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_DBTYPE"));
            this.secondaryKeyDbFileTypeComboBox = new JComboBox();
            int n = 0;
            while (n < this.secondaryKeyDbFileTypes.length) {
                this.secondaryKeyDbFileTypeComboBox.addItem("CMS");
                ++n;
            }
            this.secondaryKeyDbFileTypeComboBox.setSelectedIndex(0);
            this.secondaryKeyDbFileTypeComboBox.addItemListener(this);
            if (!this.createNewSecondaryKeyDbFileCheckBox.isSelected()) {
                this.secondaryKeyDbFileTypeLabel.setEnabled(false);
                this.secondaryKeyDbFileTypeComboBox.setEnabled(false);
            }
            int n2 = 30;
            String string2 = Locale.getDefault().getLanguage();
            if (string2.equals("ja")) {
                n2 *= 2;
            }
            this.secondaryKeyDbFileNameLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_FILENAME"));
            String string3 = null;
            string3 = this.defaultSecondaryKeyDbFileName != null && this.defaultSecondaryKeyDbFileName.length() > 0 ? this.defaultSecondaryKeyDbFileName : KeyStoreManager.getDefaultKeyDbFileName(this.secondaryKeyDbFileTypeComboBox.getSelectedItem().toString());
            String string4 = null;
            string4 = this.defaultSecondaryKeyDbFileDirectory != null && this.defaultSecondaryKeyDbFileDirectory.length() > 0 ? this.defaultSecondaryKeyDbFileDirectory : KeyStoreManager.getDefaultKeyDbFileLocation(this.secondaryKeyDbFileTypes[this.secondaryKeyDbFileTypeComboBox.getSelectedIndex()]);
            this.secondaryKeyDbFileNameTextField = new JTextField(string3, n2);
            this.secondaryKeyDbFileDirectoryLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_LOCATION"));
            this.secondaryKeyDbFileDirectoryTextField = new JTextField(string4, n2);
            this.secondaryKeyDbFileBrowseButton = new KMButton(this, Ikeyman.getNLSResString("GUI_BUTTON_LABEL_BROWSE"));
            this.secondaryKeyDbFileBrowseButton.setActionCommand("Browse");
            this.secondaryKeyDbFileBrowseButton.addActionListener(this);
            if (!this.openExistingSecondaryKeyDbFileCheckBox.isSelected() && !this.createNewSecondaryKeyDbFileCheckBox.isSelected()) {
                this.secondaryKeyDbFileNameLabel.setEnabled(false);
                this.secondaryKeyDbFileNameTextField.setEnabled(false);
                this.secondaryKeyDbFileDirectoryLabel.setEnabled(false);
                this.secondaryKeyDbFileDirectoryTextField.setEnabled(false);
                this.secondaryKeyDbFileBrowseButton.setEnabled(false);
            }
        }
        this.okButton = new KMButton(this, Ikeyman.getNLSResString("GUI_BUTTON_LABEL_OK"));
        this.okButton.setActionCommand("OK");
        this.okButton.addActionListener(this);
        this.cancelButton = new KMButton(this, Ikeyman.getNLSResString("GUI_BUTTON_LABEL_CANCEL"));
        this.cancelButton.setActionCommand("Cancel");
        this.cancelButton.addActionListener(this);
    }

    private void performLayout() {
        Cloneable cloneable;
        Serializable serializable;
        Serializable serializable2;
        JPanel jPanel;
        JPanel jPanel2 = new JPanel();
        BevelBorder bevelBorder = new BevelBorder(0);
        jPanel2.setBorder(bevelBorder);
        jPanel2.setLayout(new BorderLayout());
        JPanel jPanel3 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel3.setLayout(gridBagLayout);
        if (cryptoType == 2) {
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(10, 5, 5, 5);
            gridBagLayout.setConstraints(this.fileNameLabel, gridBagConstraints);
            jPanel3.add(this.fileNameLabel);
        }
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        if (cryptoType == 1) {
            gridBagLayout.setConstraints(this.cryptographicTokenLabelLabel, gridBagConstraints);
            jPanel3.add(this.cryptographicTokenLabelLabel);
        } else {
            gridBagLayout.setConstraints(this.JSSETokenLabel, gridBagConstraints);
            jPanel3.add(this.JSSETokenLabel);
        }
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        if (cryptoType == 1) {
            gridBagLayout.setConstraints(this.cryptographicTokenLabelComboBox, gridBagConstraints);
            jPanel3.add(this.cryptographicTokenLabelComboBox);
        } else {
            gridBagLayout.setConstraints(this.JSSETokenLabelTextField, gridBagConstraints);
            jPanel3.add(this.JSSETokenLabelTextField);
        }
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        if (cryptoType == 1) {
            gridBagLayout.setConstraints(this.cryptographicTokenPasswordLabel, gridBagConstraints);
            jPanel3.add(this.cryptographicTokenPasswordLabel);
        }
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        if (cryptoType == 1) {
            gridBagLayout.setConstraints(this.cryptographicTokenPasswordField, gridBagConstraints);
            jPanel3.add(this.cryptographicTokenPasswordField);
        }
        jPanel2.add((Component)jPanel3, "North");
        if (addSecondaryKeyDbFileFields) {
            jPanel = new JPanel();
            serializable2 = new BevelBorder(1);
            jPanel.setBorder((Border)((Object)serializable2));
            serializable = new GridBagLayout();
            cloneable = new GridBagConstraints();
            cloneable.weightx = 1.0;
            cloneable.weighty = 1.0;
            jPanel.setLayout((LayoutManager)((Object)serializable));
            cloneable.anchor = 17;
            cloneable.gridwidth = 0;
            cloneable.fill = 2;
            cloneable.insets = new Insets(5, 5, 5, 5);
            ((GridBagLayout)serializable).setConstraints(this.secondaryKeyDbFileExplanationLabel, (GridBagConstraints)cloneable);
            jPanel.add(this.secondaryKeyDbFileExplanationLabel);
            Font font = this.secondaryKeyDbFileExplanationLabel.getFont();
            Font font2 = new Font(font.getName(), font.getStyle(), font.getSize() - 2);
            this.secondaryKeyDbFileExplanationLabel.setFont(font2);
            cloneable.anchor = 17;
            cloneable.gridwidth = 0;
            cloneable.fill = 2;
            cloneable.insets = new Insets(5, 5, 5, 5);
            ((GridBagLayout)serializable).setConstraints(this.openExistingSecondaryKeyDbFileCheckBox, (GridBagConstraints)cloneable);
            jPanel.add(this.openExistingSecondaryKeyDbFileCheckBox);
            cloneable.anchor = 17;
            cloneable.gridwidth = 0;
            cloneable.fill = 2;
            cloneable.insets = new Insets(0, 5, 5, 5);
            ((GridBagLayout)serializable).setConstraints(this.createNewSecondaryKeyDbFileCheckBox, (GridBagConstraints)cloneable);
            jPanel.add(this.createNewSecondaryKeyDbFileCheckBox);
            cloneable.anchor = 17;
            cloneable.gridwidth = 1;
            cloneable.fill = 0;
            cloneable.insets = new Insets(10, 5, 5, 5);
            ((GridBagLayout)serializable).setConstraints(this.secondaryKeyDbFileTypeLabel, (GridBagConstraints)cloneable);
            jPanel.add(this.secondaryKeyDbFileTypeLabel);
            cloneable.anchor = 17;
            cloneable.gridwidth = 0;
            cloneable.fill = 0;
            cloneable.insets = new Insets(10, 5, 5, 5);
            ((GridBagLayout)serializable).setConstraints(this.secondaryKeyDbFileTypeComboBox, (GridBagConstraints)cloneable);
            jPanel.add(this.secondaryKeyDbFileTypeComboBox);
            cloneable.anchor = 17;
            cloneable.gridwidth = 1;
            cloneable.fill = 0;
            cloneable.insets = new Insets(5, 5, 5, 5);
            ((GridBagLayout)serializable).setConstraints(this.secondaryKeyDbFileNameLabel, (GridBagConstraints)cloneable);
            jPanel.add(this.secondaryKeyDbFileNameLabel);
            cloneable.anchor = 17;
            cloneable.gridwidth = 1;
            cloneable.fill = 2;
            cloneable.insets = new Insets(5, 5, 5, 5);
            ((GridBagLayout)serializable).setConstraints(this.secondaryKeyDbFileNameTextField, (GridBagConstraints)cloneable);
            jPanel.add(this.secondaryKeyDbFileNameTextField);
            cloneable.anchor = 13;
            cloneable.gridwidth = 0;
            cloneable.fill = 0;
            cloneable.insets = new Insets(5, 0, 5, 5);
            ((GridBagLayout)serializable).setConstraints(this.secondaryKeyDbFileBrowseButton, (GridBagConstraints)cloneable);
            jPanel.add(this.secondaryKeyDbFileBrowseButton);
            cloneable.anchor = 17;
            cloneable.gridwidth = 1;
            cloneable.fill = 0;
            cloneable.insets = new Insets(5, 5, 5, 5);
            ((GridBagLayout)serializable).setConstraints(this.secondaryKeyDbFileDirectoryLabel, (GridBagConstraints)cloneable);
            jPanel.add(this.secondaryKeyDbFileDirectoryLabel);
            cloneable.anchor = 17;
            cloneable.gridwidth = 0;
            cloneable.fill = 2;
            cloneable.insets = new Insets(5, 5, 10, 5);
            ((GridBagLayout)serializable).setConstraints(this.secondaryKeyDbFileDirectoryTextField, (GridBagConstraints)cloneable);
            jPanel.add(this.secondaryKeyDbFileDirectoryTextField);
            jPanel2.add((Component)jPanel, "Center");
        }
        jPanel = new KMHorizontalButtonPanel();
        ((KMHorizontalButtonPanel)jPanel).add(this.okButton);
        ((KMHorizontalButtonPanel)jPanel).add(this.cancelButton);
        ((KMHorizontalButtonPanel)jPanel).equalizeButtons();
        jPanel2.add((Component)jPanel, "South");
        serializable2 = this.getContentPane();
        ((Container)serializable2).setLayout(new BorderLayout());
        ((Container)serializable2).add(jPanel2, "Center");
        this.pack();
        this.setResizable(false);
        serializable = this.getSize();
        cloneable = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation((((Dimension)cloneable).width - ((Dimension)serializable).width) / 2, (((Dimension)cloneable).height - ((Dimension)serializable).height) / 2);
    }

    private void initializeReturnValues() {
        this.cryptographicTokenLabel = null;
        this.cryptographicTokenPassword = null;
        this.secondaryKeyDbFileType = 0;
        this.secondaryKeyDbFileName = null;
        this.secondaryKeyDbFileDirectory = null;
    }

    public String getCryptographicTokenLabel() {
        if (cryptoType == 1) {
            return this.cryptographicTokenLabel;
        }
        return Integer.toString(this.JSSETokenSlotNumber);
    }

    public int getCryptographicTokenIndex() {
        if (cryptoType == 1) {
            return this.cryptographicTokenIndex;
        }
        return this.JSSETokenSlotNumber;
    }

    public String getCryptographicTokenPassword() {
        String string = "";
        if (cryptoType == 2) {
            PasswordDialog passwordDialog = new PasswordDialog(KMFrame.mFrame, Ikeyman.getNLSResString("GUI_DIALOG_TITLE_PASSWORD_PROMPT"), false);
            Dimension dimension = passwordDialog.getSize();
            ((Component)passwordDialog).setLocation((Ikeyman.screenSize.width - dimension.width) / 2, (Ikeyman.screenSize.height - dimension.height) / 2);
            passwordDialog.setResizable(false);
            ((Component)passwordDialog).setVisible(true);
            string = passwordDialog.getPassword();
            passwordDialog.dispose();
            return string;
        }
        return this.cryptographicTokenPassword;
    }

    public boolean getOpenExistingSecondaryKeyDbFile() {
        if (cryptoType == 1) {
            return this.openExistingSecondaryKeyDbFile;
        }
        return false;
    }

    public boolean getCreateNewSecondaryKeyDbFile() {
        return this.createNewSecondaryKeyDbFile;
    }

    public int getSecondaryKeyDbFileType() {
        return this.secondaryKeyDbFileType;
    }

    public String getSecondaryKeyDbFileName() {
        return this.secondaryKeyDbFileName;
    }

    public String getSecondaryKeyDbFileDirectory() {
        return this.secondaryKeyDbFileDirectory;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        KMUtil.debugMsg("OpenCryptoTokenDialog::actionPerformed() 0000");
        Object object = actionEvent.getSource();
        if (object == this.secondaryKeyDbFileBrowseButton) {
            KMUtil.debugMsg("OpenCryptoTokenDialog::actionPerformed() 0010, source is secondaryKeyDbFileBrowseButton");
            String string = null;
            if (this.openExistingSecondaryKeyDbFileCheckBox.isSelected()) {
                string = "OPEN";
            } else if (this.createNewSecondaryKeyDbFileCheckBox.isSelected()) {
                string = "SAVE";
            }
            JFileChooser jFileChooser = new JFileChooser(KMSystem.getWorkingDirName());
            jFileChooser.setFileHidingEnabled(KMFrame.hideHiddenFiles);
            if (KMFrame.isWindowLookAndFeel()) {
                jFileChooser.setPreferredSize(new Dimension(((JComponent)object).getWidth() * 6, ((JComponent)object).getHeight() * 10));
            }
            KMFilenameFilter kMFilenameFilter = new KMFilenameFilter(".kdb", Ikeyman.getNLSResString("GUI_LABEL_DBTYPE"));
            jFileChooser.addChoosableFileFilter(kMFilenameFilter);
            jFileChooser.setSelectedFile(new File("*.kdb"));
            jFileChooser.setCurrentDirectory(new File(this.secondaryKeyDbFileDirectoryTextField.getText()));
            jFileChooser.setDialogTitle(Ikeyman.getNLSResString("GUI_DIALOG_TITLE_OPEN"));
            Dimension dimension = jFileChooser.getSize();
            jFileChooser.setLocation((Ikeyman.screenSize.width - dimension.width) / 2, (Ikeyman.screenSize.height - dimension.height) / 2);
            int n = jFileChooser.showOpenDialog(null);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                this.secondaryKeyDbFileNameTextField.setText(file.getName());
                String string2 = jFileChooser.getCurrentDirectory().toString();
                if (!string2.endsWith(File.separator)) {
                    string2 = string2 + File.separator;
                }
                this.secondaryKeyDbFileDirectoryTextField.setText(string2);
                KMSystem.setCurrentWorkingDirName(this.secondaryKeyDbFileDirectoryTextField.getText());
            } else if (n != 1 && n == -1) {
                KMFrame.errorHandler(KMAWTUtil.getFrame(this), KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_NOT_OPENED"));
            }
        } else if (object == this.okButton) {
            KMUtil.debugMsg("OpenCryptoTokenDialog::actionPerformed() 0300, source is okButton");
            if (this.isInputValid()) {
                try {
                    if (cryptoType == 1) {
                        this.cryptographicTokenLabel = (String)this.cryptographicTokenLabelComboBox.getSelectedItem();
                    } else {
                        this.JSSETokenSlotNumber = Integer.parseInt(this.JSSETokenLabelTextField.getText());
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    KMUtil.debugMsg("OpenCryptoTokenDialog::actionPerformed() 0400 Number format exception");
                    this.JSSETokenLabelTextField.setText("");
                    this.JSSETokenLabelTextField.requestFocus();
                    return;
                }
                this.cryptographicTokenIndex = this.cryptographicTokenLabelComboBox.getSelectedIndex();
                if (cryptoType == 1 && this.cryptographicTokenPasswordField.isEnabled()) {
                    this.cryptographicTokenPassword = new String(this.cryptographicTokenPasswordField.getPassword());
                }
                if (this.openExistingSecondaryKeyDbFileCheckBox != null) {
                    this.openExistingSecondaryKeyDbFile = cryptoType == 1 ? this.openExistingSecondaryKeyDbFileCheckBox.isSelected() : false;
                }
                if (this.createNewSecondaryKeyDbFileCheckBox != null) {
                    this.createNewSecondaryKeyDbFile = cryptoType == 1 ? this.createNewSecondaryKeyDbFileCheckBox.isSelected() : false;
                }
                if (this.secondaryKeyDbFileTypeComboBox != null && this.secondaryKeyDbFileTypeComboBox.isEnabled()) {
                    this.secondaryKeyDbFileType = this.secondaryKeyDbFileTypes[this.secondaryKeyDbFileTypeComboBox.getSelectedIndex()];
                }
                if (this.secondaryKeyDbFileNameTextField != null && this.secondaryKeyDbFileNameTextField.isEnabled()) {
                    this.secondaryKeyDbFileName = cryptoType == 1 ? KMUtil.trimBlankSpace(this.secondaryKeyDbFileNameTextField.getText()) : null;
                }
                if (this.secondaryKeyDbFileDirectoryTextField != null && this.secondaryKeyDbFileDirectoryTextField.isEnabled()) {
                    this.secondaryKeyDbFileDirectory = cryptoType == 1 ? this.getAdjustedSecondaryKeyDbFileDirectory() : null;
                }
                ((Component)this).setVisible(false);
            }
        } else if (object == this.cancelButton) {
            KMUtil.debugMsg("OpenCryptoTokenDialog::actionPerformed() 1000, source is cancelButton");
            this.JSSETokenSlotNumber = -1;
            ((Component)this).setVisible(false);
        }
        KMUtil.debugMsg("OpenCryptoTokenDialog::actionPerformed() 9999");
    }

    private boolean isInputValid() {
        KMUtil.debugMsg("OpenCryptoTokenDialog::isInputValid() 0000");
        if (cryptoType == 1) {
            String string;
            if (this.cryptographicTokenPasswordField.isEnabled() && (string = new String(this.cryptographicTokenPasswordField.getPassword())).equals("")) {
                KMFrame.errorHandler(KMAWTUtil.getFrame(this), KMSystem.getNLSErrString("GSKKM_ERR_CMN_PASSWORD_NULL"));
                ((JTextComponent)this.cryptographicTokenPasswordField).setText("");
                this.cryptographicTokenPasswordField.requestFocus();
                KMUtil.debugMsg("OpenCryptoTokenDialog::isInputValid() 9999-1");
                return false;
            }
            boolean bl = false;
            if (this.createNewSecondaryKeyDbFileCheckBox != null && cryptoType == 1) {
                bl = this.createNewSecondaryKeyDbFileCheckBox.isSelected();
            }
            if (!bl && this.secondaryKeyDbFileNameTextField != null && this.secondaryKeyDbFileNameTextField.isEnabled()) {
                String string2 = KMUtil.trimBlankSpace(this.secondaryKeyDbFileNameTextField.getText());
                if (string2 == null || string2.equals("") || string2.indexOf(42) >= 0) {
                    KMFrame.errorHandler(KMAWTUtil.getFrame(this), KMSystem.getNLSErrString("GSKKM_ERR_CMN_INVALID_FILE_NAME"));
                    this.secondaryKeyDbFileNameTextField.requestFocus();
                    KMUtil.debugMsg("OpenCryptoTokenDialog::isInputValid() 9999-2");
                    return false;
                }
                String string3 = this.getAdjustedSecondaryKeyDbFileDirectory();
                File file = new File(string3 + string2);
                if (!file.canRead() || !file.canWrite()) {
                    KMFrame.errorHandler(KMAWTUtil.getFrame(this), KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_PERMISSION_DENIED"));
                    KMUtil.debugMsg("OpenCryptoTokenDialog::isInputValid() 9999-3");
                    return false;
                }
                try {
                    String string4 = file.getCanonicalPath();
                }
                catch (IOException iOException) {
                    KMFrame.errorHandler(KMAWTUtil.getFrame(this), KMSystem.getNLSErrString("GSKKM_ERR_CMN_INVALID_FILE_NAME"));
                    this.secondaryKeyDbFileNameTextField.requestFocus();
                    KMUtil.debugMsg("OpenCryptoTokenDialog::isInputValid() 9999-4");
                    return false;
                }
                if (this.openExistingSecondaryKeyDbFileCheckBox.isSelected() && cryptoType == 1 && !file.exists()) {
                    KMFrame.errorHandler(KMAWTUtil.getFrame(this), KMSystem.getNLSErrString("GSKKM_ERR_CMN_FILE_NOT_FOUND"));
                    this.secondaryKeyDbFileNameTextField.requestFocus();
                    KMUtil.debugMsg("OpenCryptoTokenDialog::isInputValid() 9999-5");
                    return false;
                }
            }
        }
        KMUtil.debugMsg("OpenCryptoTokenDialog::isInputValid() 9999");
        return true;
    }

    private String getAdjustedSecondaryKeyDbFileDirectory() {
        String string = KMUtil.trimBlankSpace(this.secondaryKeyDbFileDirectoryTextField.getText());
        if (string == null) {
            string = this.defaultSecondaryKeyDbFileDirectory != null && this.defaultSecondaryKeyDbFileDirectory.length() > 0 ? this.defaultSecondaryKeyDbFileDirectory : KeyStoreManager.getDefaultKeyDbFileLocation(this.secondaryKeyDbFileTypes[this.secondaryKeyDbFileTypeComboBox.getSelectedIndex()]);
        }
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        return string;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        block12: {
            Object object = itemEvent.getSource();
            if (object == this.cryptographicTokenLabelComboBox) {
                try {
                    if (cryptoType == 1) {
                        this.cryptographicTokenLabel = (String)this.cryptographicTokenLabelComboBox.getSelectedItem();
                        KeyStoreManager keyStoreManager = new KeyStoreManager(this.cryptographicTokenLabel, this.cryptographicTokenLabelComboBox.getSelectedIndex(), cryptoType);
                        boolean bl = keyStoreManager.isPasswordNeeded();
                        this.cryptographicTokenPasswordLabel.setEnabled(bl);
                        this.cryptographicTokenPasswordField.setEnabled(bl);
                        this.cryptographicTokenPasswordField.setEditable(bl);
                        this.setFocus();
                        break block12;
                    }
                    this.JSSETokenLabelTextField.setEnabled(true);
                    this.JSSETokenLabel.setEnabled(true);
                    this.JSSETokenLabelTextField.requestFocus();
                    this.JSSETokenLabelTextField.repaint();
                    this.JSSETokenLabel.repaint();
                }
                catch (KMException kMException) {}
            } else if (object == this.openExistingSecondaryKeyDbFileCheckBox) {
                boolean bl = this.openExistingSecondaryKeyDbFileCheckBox.isSelected();
                if (bl && this.createNewSecondaryKeyDbFileCheckBox.isSelected()) {
                    this.createNewSecondaryKeyDbFileCheckBox.setSelected(false);
                }
                this.enableSecondaryKeyDbFileFields(false, bl);
            } else if (object == this.createNewSecondaryKeyDbFileCheckBox) {
                boolean bl = this.createNewSecondaryKeyDbFileCheckBox.isSelected();
                if (bl && this.openExistingSecondaryKeyDbFileCheckBox.isSelected()) {
                    this.openExistingSecondaryKeyDbFileCheckBox.setSelected(false);
                }
                this.enableSecondaryKeyDbFileFields(bl, bl);
            } else if (object == this.secondaryKeyDbFileTypeComboBox) {
                this.secondaryKeyDbFileNameTextField.setText(KeyStoreManager.getDefaultKeyDbFileName(this.secondaryKeyDbFileTypeComboBox.getSelectedItem().toString()));
                this.secondaryKeyDbFileDirectoryTextField.setText(KeyStoreManager.getDefaultKeyDbFileLocation(this.secondaryKeyDbFileType));
            }
        }
    }

    private void enableSecondaryKeyDbFileFields(boolean bl, boolean bl2) {
        this.secondaryKeyDbFileTypeLabel.setEnabled(bl);
        this.secondaryKeyDbFileTypeComboBox.setEnabled(bl);
        this.secondaryKeyDbFileNameLabel.setEnabled(bl2);
        this.secondaryKeyDbFileNameTextField.setEnabled(bl2);
        this.secondaryKeyDbFileBrowseButton.setEnabled(bl2);
        this.secondaryKeyDbFileDirectoryLabel.setEnabled(bl2);
        this.secondaryKeyDbFileDirectoryTextField.setEnabled(bl2);
    }

    public void processFocusEvent(FocusEvent focusEvent) {
        this.setFocus();
    }

    private void setFocus() {
        if (cryptoType == 1) {
            if (this.cryptographicTokenPasswordField.isEnabled()) {
                this.cryptographicTokenPasswordField.requestFocus();
            } else {
                this.okButton.requestFocus();
            }
        }
    }
}

