/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.basic;

import com.ibm.crypto.pkcs11.provider.PKCS11DSAKeyPairParameterSpec;
import com.ibm.crypto.pkcs11.provider.PKCS11RSAKeyPairParameterSpec;
import com.ibm.gsk.ikeyman.basic.KeyStoreManagerException;
import com.ibm.security.pkcs10.CertificationRequest;
import com.ibm.security.pkcs10.CertificationRequestInfo;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.CertificateAlgorithmId;
import com.ibm.security.x509.CertificateExtensions;
import com.ibm.security.x509.CertificateIssuerName;
import com.ibm.security.x509.CertificateSerialNumber;
import com.ibm.security.x509.CertificateSubjectName;
import com.ibm.security.x509.CertificateValidity;
import com.ibm.security.x509.CertificateVersion;
import com.ibm.security.x509.CertificateX509Key;
import com.ibm.security.x509.SubjectKeyIdentifierExtension;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CertImpl;
import com.ibm.security.x509.X509CertInfo;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Date;

public final class SelfSignedCert {
    private static final String DSA_SIGNING = "PKCS11SHA1withDSA";
    private static final String RSA_SIGNING = "PKCS11MD5withRSA";
    private byte[] keyidentifier = null;
    private boolean isDSA = false;
    private SecureRandom prng;
    private String sigAlg;
    private KeyPairGenerator keyGen;
    private PublicKey publicKey;
    private PrivateKey privateKey;
    private KeyStore keystore;
    private X500Name issuer;

    public SelfSignedCert(String string, String string2, KeyStore keyStore) throws NoSuchAlgorithmException {
        if (string.equalsIgnoreCase("DSA")) {
            this.keyGen = KeyPairGenerator.getInstance("PKCS11DSA");
            this.sigAlg = DSA_SIGNING;
            this.isDSA = true;
        } else if (string.equalsIgnoreCase("RSA")) {
            this.keyGen = KeyPairGenerator.getInstance("PKCS11RSA");
            this.sigAlg = RSA_SIGNING;
            this.isDSA = false;
        }
        this.keystore = keyStore;
        try {
            this.keyidentifier = "IkeymanCertificateRequest".getBytes("8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.keyidentifier = "IkeymanCertificateRequest".getBytes();
        }
    }

    public void setRandom(SecureRandom secureRandom) {
        this.prng = secureRandom;
    }

    public void generate(int n, String string) throws InvalidKeyException {
        KeyPair keyPair;
        try {
            if (this.prng == null) {
                this.prng = new SecureRandom();
            }
            Object object = null;
            object = this.sigAlg.equals(DSA_SIGNING) ? new PKCS11DSAKeyPairParameterSpec(this.keystore, n, null) : new PKCS11RSAKeyPairParameterSpec(this.keystore, n, string);
            this.keyGen.initialize((AlgorithmParameterSpec)object, this.prng);
            keyPair = this.keyGen.generateKeyPair();
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception.getMessage());
        }
        this.publicKey = keyPair.getPublic();
        this.privateKey = keyPair.getPrivate();
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public KeyPairGenerator getKeyPairGenerator() {
        return this.keyGen;
    }

    public X509Certificate getSelfCertificate(X500Name x500Name, long l) throws CertificateException, InvalidKeyException, SignatureException, NoSuchAlgorithmException, NoSuchProviderException {
        try {
            X500Name x500Name2 = x500Name;
            Date date = new Date();
            Date date2 = new Date();
            date2.setTime(date2.getTime() + l * 1000L);
            CertificateValidity certificateValidity = new CertificateValidity(date, date2);
            X509CertInfo x509CertInfo = new X509CertInfo();
            x509CertInfo.set("version", (Object)new CertificateVersion(2));
            x509CertInfo.set("serialNumber", (Object)new CertificateSerialNumber((int)(date.getTime() / 1000L)));
            AlgorithmId algorithmId = null;
            algorithmId = this.isDSA ? AlgorithmId.getAlgorithmId((String)"SHA1/DSA") : AlgorithmId.getAlgorithmId((String)"MD5/RSA");
            x509CertInfo.set("algorithmID", (Object)new CertificateAlgorithmId(algorithmId));
            x509CertInfo.set("subject", (Object)new CertificateSubjectName(x500Name));
            x509CertInfo.set("key", (Object)new CertificateX509Key(this.publicKey));
            x509CertInfo.set("validity", (Object)certificateValidity);
            x509CertInfo.set("issuer", (Object)new CertificateIssuerName(x500Name2));
            X509CertImpl x509CertImpl = new X509CertImpl(x509CertInfo);
            x509CertImpl.sign(this.privateKey, this.sigAlg);
            return x509CertImpl;
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException("getSelfCert: " + iOException.getMessage());
        }
    }

    public X509Certificate getSelfCertificate(X500Name x500Name, long l, int n) throws CertificateException, InvalidKeyException, SignatureException, NoSuchAlgorithmException, NoSuchProviderException {
        return this.getSelfCertificate(x500Name, l, n, false);
    }

    private X509Certificate getSelfCertificate(X500Name x500Name, long l, int n, boolean bl) throws CertificateException, InvalidKeyException, SignatureException, NoSuchAlgorithmException, NoSuchProviderException {
        try {
            X500Name x500Name2 = x500Name;
            Date date = new Date();
            Date date2 = new Date();
            date2.setTime(date2.getTime() + l * 1000L);
            CertificateValidity certificateValidity = new CertificateValidity(date, date2);
            X509CertInfo x509CertInfo = new X509CertInfo();
            if (n != 0 && n != 1 && n != 2) {
                x509CertInfo.set("version", (Object)new CertificateVersion(2));
            } else {
                x509CertInfo.set("version", (Object)new CertificateVersion(n));
            }
            x509CertInfo.set("serialNumber", (Object)new CertificateSerialNumber((int)(date.getTime() / 1000L)));
            AlgorithmId algorithmId = null;
            algorithmId = this.isDSA ? AlgorithmId.getAlgorithmId((String)"SHA1/DSA") : AlgorithmId.getAlgorithmId((String)"MD5/RSA");
            x509CertInfo.set("algorithmID", (Object)new CertificateAlgorithmId(algorithmId));
            x509CertInfo.set("subject", (Object)new CertificateSubjectName(x500Name));
            x509CertInfo.set("key", (Object)new CertificateX509Key(this.publicKey));
            x509CertInfo.set("validity", (Object)certificateValidity);
            x509CertInfo.set("issuer", (Object)new CertificateIssuerName(x500Name2));
            if (bl) {
                SubjectKeyIdentifierExtension subjectKeyIdentifierExtension = new SubjectKeyIdentifierExtension(this.keyidentifier);
                CertificateExtensions certificateExtensions = new CertificateExtensions();
                certificateExtensions.set(subjectKeyIdentifierExtension.getName(), (Object)subjectKeyIdentifierExtension);
                x509CertInfo.set("extensions", (Object)certificateExtensions);
            }
            X509CertImpl x509CertImpl = new X509CertImpl(x509CertInfo);
            x509CertImpl.sign(this.privateKey, this.sigAlg);
            return x509CertImpl;
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException("getSelfCert: " + iOException.getMessage());
        }
    }

    public CertificationRequest getCertRequest(X500Name x500Name) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        CertificationRequest certificationRequest;
        CertificationRequestInfo certificationRequestInfo = new CertificationRequestInfo(x500Name, this.publicKey, null);
        CertificationRequest certificationRequest2 = new CertificationRequest(certificationRequestInfo);
        try {
            certificationRequest = certificationRequest2.sign(this.sigAlg, this.privateKey);
        }
        catch (PKCSException pKCSException) {
            throw new SignatureException(this.sigAlg + " PKCSException");
        }
        return certificationRequest;
    }

    public CertificationRequest getCertRequest(X500Name x500Name, String string, KeyStore keyStore, char[] cArray) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, KeyStoreManagerException {
        CertificationRequest certificationRequest;
        CertificationRequestInfo certificationRequestInfo = new CertificationRequestInfo(x500Name, this.publicKey, null);
        CertificationRequest certificationRequest2 = new CertificationRequest(certificationRequestInfo);
        try {
            certificationRequest = certificationRequest2.sign(this.sigAlg, this.privateKey);
        }
        catch (PKCSException pKCSException) {
            throw new SignatureException(this.sigAlg + " PKCSException");
        }
        X509Certificate x509Certificate = null;
        try {
            x509Certificate = this.getSelfCertificate(x500Name, 1L, 3, true);
        }
        catch (Exception exception) {
            throw new KeyStoreManagerException("Cannot generate key info for certification request");
        }
        Certificate[] certificateArray = new Certificate[]{x509Certificate};
        try {
            keyStore.setKeyEntry(string, this.privateKey, cArray, certificateArray);
        }
        catch (KeyStoreException keyStoreException) {
            throw new KeyStoreManagerException("Cannot generate key info for certification request");
        }
        return certificationRequest;
    }
}

