/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.web;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.misc.BASE64Decoder;
import com.ibm.websphere.security.WebSphereBaseTrustAssociationInterceptor;
import com.ibm.websphere.security.WebTrustAssociationException;
import com.ibm.websphere.security.WebTrustAssociationFailedException;
import com.ibm.websphere.security.WebTrustAssociationUserException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.BasicAuthData;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.util.Base64Coder;
import com.ibm.ws.security.web.AuthenticationResult;
import com.ibm.ws.security.web.WebAuthenticator;
import com.ibm.ws.webcontainer.srt.IPrivateRequestAttributes;
import com.ibm.wsspi.security.tai.NegotiateTrustAssociationInterceptor;
import com.tivoli.pd.as.util.MaskString;
import com.tivoli.pd.as.util.RWLock;
import com.tivoli.pd.jasn1.PDPointer;
import com.tivoli.pd.jasn1.PDUTF8String;
import com.tivoli.pd.jasn1.PDVector;
import com.tivoli.pd.jasn1.attr_t;
import com.tivoli.pd.jasn1.attrlist_t;
import com.tivoli.pd.jasn1.ivprincipal_chain_t;
import com.tivoli.pd.jasn1.ivprincipal_t;
import com.tivoli.pd.jasn1.value_t;
import com.tivoli.pd.jazn.PDAuthorizationContext;
import com.tivoli.pd.jazn.PDPrincipal;
import com.tivoli.pd.jutil.PDException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TAMTrustAssociationInterceptorPlus
extends WebSphereBaseTrustAssociationInterceptor
implements NegotiateTrustAssociationInterceptor {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$security$web$TAMTrustAssociationInterceptorPlus == null ? (class$com$ibm$ws$security$web$TAMTrustAssociationInterceptorPlus = TAMTrustAssociationInterceptorPlus.class$("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlus")) : class$com$ibm$ws$security$web$TAMTrustAssociationInterceptorPlus), null, (String)"com.ibm.ejs.resources.security");
    protected WebAuthenticator webAuth = null;
    protected String[] ServerSources = null;
    protected String[] ID = null;
    protected String WebSealLoginID;
    protected boolean ignoreProxy = false;
    private static int sourceCnt = 0;
    public String realm = "default";
    public boolean PDAlreadyAuthenticated = false;
    protected String WebSealUserID = null;
    protected boolean UsingLocallySpecifiedWebSealUser = false;
    protected PDAuthorizationContext _pdctx = null;
    protected Hashtable requests = new Hashtable();
    protected int _viaDepth = 1;
    private static MaskString _trustPasswd;
    private static RWLock _trustPasswdLock;
    private long _ssoPwdExpiryTime = -1L;
    private long DEFAULT_PWD_EXPIRY = 600000L;
    static /* synthetic */ Class class$com$ibm$ws$security$web$TAMTrustAssociationInterceptorPlus;

    public boolean isTargetInterceptor(HttpServletRequest httpServletRequest) throws WebTrustAssociationException {
        String string = null;
        Object var3_3 = null;
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        boolean bl2 = true;
        int n = 0;
        if (this.ID != null) {
            n = this.ID.length;
        }
        for (int i = 0; i < n; ++i) {
            if (WebAuthenticator.getHeader((HttpServletRequest)httpServletRequest, (String)this.ID[i]) != null || WebAuthenticator.getHeader((HttpServletRequest)httpServletRequest, (String)(this.ID[i] + "-segments")) != null) continue;
            bl2 = false;
            if (!tc.isDebugEnabled()) break;
            Tr.debug((TraceComponent)tc, (String)("isTargetInterceptor(HttpServletRequest) The ID header " + this.ID[i] + " was not present in the HttpServletRequest. Hence, it is not via WebSeal."));
            break;
        }
        if (n <= 0 || !bl2) {
            if (n <= 0 && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"isTargetInterceptor(HttpServletRequest) There were no WebSeal ID property values. Hence, it is not via WebSeal.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"isTargetInterceptor(HttpServletRequest)");
            }
            return false;
        }
        string = WebAuthenticator.getHeader((HttpServletRequest)httpServletRequest, (String)"via");
        if (string != null) {
            bl = true;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("isTargetInterceptor: VIA=" + string));
            }
            if (string != null && string.trim().length() > 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                int n2 = stringTokenizer.countTokens();
                String[] stringArray = new String[n2];
                int n3 = n2 - 1;
                while (stringTokenizer.hasMoreTokens()) {
                    stringArray[n3] = stringTokenizer.nextToken();
                    --n3;
                }
                int n4 = 0;
                n4 = this._viaDepth == 0 ? n2 : this._viaDepth;
                for (int i = 0; i < n4 && i < n2; ++i) {
                    String string4 = stringArray[i];
                    if (string4.trim().length() <= 0) continue;
                    string4 = string4.trim();
                    if (this.ignoreProxy && string4.indexOf("roxy") != -1) continue;
                    int n5 = string4.indexOf(32);
                    if (n5 > -1) {
                        int n6;
                        String string5 = string4.substring(n5 + 1);
                        int n7 = string5.indexOf(32);
                        if (n7 > -1) {
                            string5 = string5.substring(0, n7);
                        }
                        if ((n6 = (string5 = string5.trim()).indexOf(58)) > -1) {
                            string2 = string5.substring(0, n6);
                            string3 = string5.substring(n6 + 1);
                        } else {
                            string2 = string5;
                            string3 = "0";
                        }
                        if (this.checkVia(string2, string3) == -1) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Host and port: " + string5 + " is not trusted."));
                            }
                            return false;
                        }
                        bl = true;
                        continue;
                    }
                    Tr.error((TraceComponent)tc, (String)"security.web.ta.srcpatherr");
                    throw new WebTrustAssociationException();
                }
            }
        }
        if (this.ServerSources == null || this.ServerSources.length == 0) {
            bl = true;
        }
        if (!bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No, it is not via WebSeal.");
            }
            return false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Yes, it is via WebSeal.");
        }
        return true;
    }

    public int negotiateAndValidateEstablishedTrust(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws WebTrustAssociationFailedException {
        this.validateEstablishedTrust(httpServletRequest);
        String string = Thread.currentThread().getName();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Putting request object in Hashtable using key: " + string));
        }
        this.requests.put(string, httpServletRequest);
        return 200;
    }

    public void validateEstablishedTrust(HttpServletRequest httpServletRequest) throws WebTrustAssociationFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"Entering validateEstablishedTrust...");
        }
        BasicAuthData basicAuthData = null;
        if (this.PDAlreadyAuthenticated) {
            return;
        }
        String string = WebAuthenticator.getHeader((HttpServletRequest)httpServletRequest, (String)"Authorization");
        if (string == null || !string.startsWith("Basic ")) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"Exiting validateEstablishedTrust..Basic Auth not found in HTTP request.");
            }
            throw new WebTrustAssociationFailedException("Basic Auth is expected in Trust Association mode.");
        }
        int n = (string = Base64Coder.base64Decode((String)string.substring(6))).indexOf(58);
        if (n < 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"Exiting validateEstablishedTrust -- No basic auth username/password found.");
            }
            throw new WebTrustAssociationFailedException("Basic Auth username/password field is missing.");
        }
        String string2 = this.WebSealLoginID;
        if (string2 == null) {
            string2 = string.substring(0, n);
        }
        String string3 = string.substring(n + 1);
        if (this._ssoPwdExpiryTime != 0L) {
            this.expireSSOPassword();
        }
        if (_trustPasswd == null) {
            AuthenticationResult authenticationResult;
            int n2;
            if (this.webAuth == null) {
                this.webAuth = WebAuthenticator.getInstance();
                if (this.webAuth == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"Exiting validateEstablishedTrust -- No WebAuthenticator found.");
                    }
                    throw new WebTrustAssociationFailedException("There is currently no web authenticator.");
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Going to authenticate " + string2 + "."));
            }
            if ((n2 = (authenticationResult = this.webAuth.basicAuthenticate(this.realm, string2, string3)).getStatus()) == 3 || n2 == 2) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"validateEstablishedTrust authentication failure.");
                }
                throw new WebTrustAssociationFailedException("Basic Authentication failed.");
            }
            this.setSSOPassword(string3.toCharArray());
        } else if (!this.isSSOPassword(string3.toCharArray())) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"validateEstablishedTrust authentication failure.");
            }
            throw new WebTrustAssociationFailedException("Basic Authentication failed.");
        }
        basicAuthData = new BasicAuthData(string2, string3);
        ((IPrivateRequestAttributes)httpServletRequest).setPrivateAttribute("AUTH_TYPE", (Object)"Basic");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Successful authentication for validateEstablishedTrust.");
        }
    }

    public String getAuthenticatedUsername(HttpServletRequest httpServletRequest) throws WebTrustAssociationUserException {
        String string = null;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAuthenticatedUsername");
        }
        Enumeration enumeration = httpServletRequest.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.equals("iv-user")) continue;
            string = WebAuthenticator.getHeader((HttpServletRequest)httpServletRequest, (String)string2);
            if (string != null) break;
            throw new WebTrustAssociationUserException("Null value provided as username.");
        }
        if (string == null) {
            throw new WebTrustAssociationUserException("No iv-user was found in request header.");
        }
        if (string.trim().length() == 0) {
            string = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("Exiting getAuthenticatedUsername: " + (string != null ? string : "no username found")));
        }
        return string;
    }

    public Subject getSubject() throws WebTrustAssociationFailedException {
        Subject subject;
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getSubject");
            }
            String string = Thread.currentThread().getName();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Getting request object from Hashtable using key: " + string));
            }
            HttpServletRequest httpServletRequest = (HttpServletRequest)this.requests.get(string);
            this.requests.remove(string);
            subject = null;
            try {
                String string2 = this.extractCred(httpServletRequest);
                if (string2 == null) {
                    return subject;
                }
                PDPrincipal pDPrincipal = this.createPDPrincipal(string2);
                subject = this.buildSubject(pDPrincipal);
            }
            catch (PDException pDException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception encountered while constructing subject: " + pDException.toString()));
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug((TraceComponent)tc, (String)("Exception encountered while constructing subject: " + classNotFoundException.getMessage()));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("Exiting getSubject: " + (subject != null ? subject.toString() : "returning null subject")));
        }
        return subject;
    }

    public Subject buildSubject(PDPrincipal pDPrincipal) throws PDException, ClassNotFoundException {
        Object object;
        Object object2;
        Object object3;
        value_t value_t2;
        String[] stringArray;
        String string;
        Object object4;
        ContextManager contextManager;
        ByteArrayInputStream byteArrayInputStream;
        byte[] byArray;
        block19: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("buildSubject using PDPrincipal: " + pDPrincipal.getName()));
            }
            byte[] byArray2 = pDPrincipal.getPAC(this._pdctx);
            byArray = null;
            BASE64Decoder bASE64Decoder = new BASE64Decoder();
            byteArrayInputStream = new ByteArrayInputStream(byArray2);
            try {
                byArray = bASE64Decoder.decodeBuffer((InputStream)byteArrayInputStream);
            }
            catch (IOException iOException) {
                if (!tc.isDebugEnabled()) break block19;
                Tr.debug((TraceComponent)tc, (String)("Exception encountered while decoding princpal chain: " + iOException.getMessage()));
            }
        }
        byteArrayInputStream = new ByteArrayInputStream(byArray);
        ivprincipal_chain_t ivprincipal_chain_t2 = new ivprincipal_chain_t();
        ivprincipal_chain_t2.decode((InputStream)byteArrayInputStream);
        PDVector pDVector = ivprincipal_chain_t2.principal_list();
        ivprincipal_t ivprincipal_t2 = (ivprincipal_t)pDVector.get(0);
        PDPointer pDPointer = ivprincipal_t2.attrs();
        attrlist_t attrlist_t2 = (attrlist_t)pDPointer.getObj();
        PDVector pDVector2 = attrlist_t2.attr_list();
        Hashtable<String, value_t> hashtable = new Hashtable<String, value_t>();
        for (int i = 0; i < pDVector2.length(); ++i) {
            contextManager = (attr_t)pDVector2.get(i);
            object4 = contextManager.attr_name();
            string = object4.getVal();
            stringArray = contextManager.value_list();
            int n = stringArray.length();
            if (n == 1 && string != null && !string.equals("AZN_CRED_GROUP_REGISTRY_IDS") && !string.equals("AZN_CRED_GROUPS_NAMES")) {
                value_t2 = (value_t)stringArray.get(0);
                object3 = value_t2.utf8val();
                object2 = object3.getVal();
                hashtable.put(string, (value_t)object2);
                continue;
            }
            if (string == null) continue;
            value_t2 = new String[n];
            for (int j = 0; j < n; ++j) {
                object2 = (value_t)stringArray.get(j);
                PDUTF8String pDUTF8String = object2.utf8val();
                object = pDUTF8String.getVal();
                value_t2[j] = object;
            }
            hashtable.put(string, value_t2);
        }
        String string2 = null;
        contextManager = ContextManagerFactory.getInstance();
        string2 = contextManager.getDefaultRealm();
        object4 = (String)hashtable.get("AZN_CRED_PRINCIPAL_NAME");
        string = (String)hashtable.get("AZN_CRED_REGISTRY_ID");
        if (string == null) {
            string = (String)hashtable.get("AZN_CRED_AUTHZN_ID");
        }
        if ((stringArray = (String[])hashtable.get("AZN_CRED_GROUP_REGISTRY_IDS")) == null) {
            stringArray = (String[])hashtable.get("AZN_CRED_GROUPS_NAMES");
        }
        String string3 = "user:" + string2 + "/" + string;
        value_t2 = object4;
        object3 = string;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("realm: " + string2));
            Tr.debug((TraceComponent)tc, (String)("uniqueId: " + string3));
            Tr.debug((TraceComponent)tc, (String)("securityName: " + (String)value_t2));
            Tr.debug((TraceComponent)tc, (String)("longSecurityName: " + (String)object3));
        }
        object2 = null;
        if (stringArray != null) {
            object2 = new ArrayList(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Group #" + i + ": group:" + string2 + "/" + stringArray[i]));
                }
                ((ArrayList)object2).add("group:" + string2 + "/" + stringArray[i]);
            }
        } else {
            object2 = new ArrayList();
        }
        Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
        if (string3 != null) {
            hashtable2.put("com.ibm.wsspi.security.cred.uniqueId", string3);
        }
        if (string2 != null) {
            hashtable2.put("com.ibm.wsspi.security.cred.realm", string2);
        }
        if (value_t2 != null) {
            hashtable2.put("com.ibm.wsspi.security.cred.securityName", value_t2);
        }
        if (object3 != null) {
            hashtable2.put("com.ibm.wsspi.security.cred.longSecurityName", object3);
        }
        if (object2 != null) {
            hashtable2.put("com.ibm.wsspi.security.cred.groups", object2);
        }
        object = new HashSet();
        HashSet<Hashtable<String, Object>> hashSet = new HashSet<Hashtable<String, Object>>();
        HashSet hashSet2 = new HashSet();
        ((HashSet)object).add(pDPrincipal);
        hashSet.add(hashtable2);
        Subject subject = new Subject(false, (Set<? extends Principal>)object, hashSet, hashSet2);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("Exiting buildSubject: " + (subject != null ? subject.toString() : "returning null subject")));
        }
        return subject;
    }

    public String extractCred(HttpServletRequest httpServletRequest) {
        String string;
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"extractCred");
        }
        if ((string2 = WebAuthenticator.getHeader((HttpServletRequest)httpServletRequest, (String)"iv-creds")) == null && (string = WebAuthenticator.getHeader((HttpServletRequest)httpServletRequest, (String)"iv-creds-segments")) != null) {
            int n = Integer.parseInt(string);
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = true;
            for (int i = 1; i <= n; ++i) {
                String string3 = WebAuthenticator.getHeader((HttpServletRequest)httpServletRequest, (String)("iv-creds-" + i));
                if (string3 == null) {
                    Tr.debug((TraceComponent)tc, (String)("iv-creds-" + i + " header required but was not found in request"));
                    string2 = null;
                    bl = false;
                    break;
                }
                stringBuffer.append(string3);
            }
            if (bl) {
                string2 = stringBuffer.toString();
            }
        }
        if (tc.isDebugEnabled()) {
            if (string2 == null) {
                Tr.debug((TraceComponent)tc, (String)"iv-creds header not found");
            } else if (string2.equals("")) {
                Tr.debug((TraceComponent)tc, (String)"iv-creds header found but is empty");
            } else {
                Tr.debug((TraceComponent)tc, (String)"iv-creds header found");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"extractCred");
        }
        return string2;
    }

    public PDAuthorizationContext createPDContext(String string) throws PDException, MalformedURLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createPDContext");
        }
        PDAuthorizationContext pDAuthorizationContext = null;
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            string = "file:///" + string;
            uRL = new URL(string);
        }
        pDAuthorizationContext = new PDAuthorizationContext(uRL);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createPDContext");
        }
        return pDAuthorizationContext;
    }

    public PDPrincipal createPDPrincipal(String string) throws PDException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createPDPrincipal");
        }
        PDPrincipal pDPrincipal = null;
        pDPrincipal = new PDPrincipal(this._pdctx, string.getBytes());
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("Exiting createPDPrincipal: " + pDPrincipal.getName()));
        }
        return pDPrincipal;
    }

    public int init(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init : init from property file not supported");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init");
        }
        return -1;
    }

    public int init(Properties properties) {
        String[] stringArray;
        block54: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"Initializing TAMTrustAssociationInterceptorPlus...");
            }
            if (properties == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Null properties passed to TA init()");
                }
                return -1;
            }
            try {
                stringArray = (String[])properties.get("com.ibm.websphere.security.webseal.ssoPwdExpiry");
                this._ssoPwdExpiryTime = Long.parseLong((String)stringArray) * 1000L;
                if (this._ssoPwdExpiryTime < 0L) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"initialize(Properties) webseal.ssoPwdExpiry is a negative value. Initialization has failed.");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"initialize(Properties) retVal = -1");
                    }
                    return -1;
                }
                if (this._ssoPwdExpiryTime == 0L && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"initialize(Properties) webseal.ssoPwdExpiry value is 0. Cached SSO password will never expire.");
                }
            }
            catch (Exception exception) {
                this._ssoPwdExpiryTime = this.DEFAULT_PWD_EXPIRY;
                if (!tc.isDebugEnabled()) break block54;
                Tr.debug((TraceComponent)tc, (String)("initialize(Properties) Exception encountered when retrieving webseal.ssoPwdExpiry. Expiry time has been set to default " + this.DEFAULT_PWD_EXPIRY / 1000L + " seconds : " + exception.toString()));
            }
        }
        try {
            String string;
            String[] stringArray2;
            block57: {
                block56: {
                    block55: {
                        stringArray = null;
                        stringArray2 = null;
                        this.setVersion("WebSeal Interceptor Version 1.1");
                        try {
                            string = (String)properties.get("com.ibm.websphere.security.webseal.id");
                            this.ID = this.getElements(string);
                            if (this.ID == null) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Could not retrieve mandatory webseal.id property. Initialization has failed.");
                                }
                                return -1;
                            }
                        }
                        catch (Exception exception) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Exception encountered when retrieving mandatory webseal.id property. Initialization has failed : " + exception.getMessage()));
                            }
                            return -1;
                        }
                        try {
                            string = (String)properties.get("com.ibm.websphere.security.webseal.hostnames");
                            stringArray = this.getElements(string);
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlus.init", (String)"330", (Object)((Object)this));
                            if (!tc.isDebugEnabled()) break block55;
                            Tr.debug((TraceComponent)tc, (String)("Exception encountered when retrieving webseal.hostname: " + exception.getMessage()));
                        }
                    }
                    try {
                        string = (String)properties.get("com.ibm.websphere.security.webseal.ports");
                        stringArray2 = this.getElements(string);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlus.init", (String)"339", (Object)((Object)this));
                        if (!tc.isDebugEnabled()) break block56;
                        Tr.debug((TraceComponent)tc, (String)("Exception encountered when retrieving webseal.ports: " + exception.getMessage()));
                    }
                }
                try {
                    string = (String)properties.get("com.ibm.websphere.security.webseal.viaDepth");
                    this._viaDepth = Integer.parseInt(string);
                    if (this._viaDepth < 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"initialize(Properties) webseal.viaDepth is a negative value. Initialization has failed.");
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"initialize(Properties) retVal = -1");
                        }
                        return -1;
                    }
                }
                catch (Exception exception) {
                    this._viaDepth = 0;
                    if (!tc.isDebugEnabled()) break block57;
                    Tr.debug((TraceComponent)tc, (String)("Exception encountered when retrieving webseal.viaDepth property. Via depth defaulting to " + this._viaDepth + " : " + exception.getMessage()));
                }
            }
            try {
                this.WebSealLoginID = (String)properties.get("com.ibm.websphere.security.webseal.loginId");
                if (this.WebSealLoginID == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Could not retrieve mandatory webseal.loginId property. Initialization has failed.");
                    }
                    return -1;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("WebSeal Login ID = " + this.WebSealLoginID));
                }
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception encountered while attempting to retrieve mandatory webseal.loginId property. Initialization has failed : " + exception.toString()));
                }
                return -1;
            }
            try {
                string = (String)properties.get("com.ibm.websphere.security.webseal.mutualSSL");
                if (string.equals("true")) {
                    this.PDAlreadyAuthenticated = true;
                    Tr.warning((TraceComponent)tc, (String)"security.webseal.nopdauth");
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlus.init", (String)"362", (Object)((Object)this));
            }
            try {
                string = (String)properties.get("com.ibm.websphere.security.webseal.configURL");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("PDJRTE config URL = " + string));
                }
                if (string == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Could not retrieve mandatory webseal.configURL property. Initialization has failed.");
                    }
                    return -1;
                }
                this._pdctx = this.createPDContext(string);
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception encountered while creating PDAuthorizationContext: " + exception.getMessage()));
                }
                return -1;
            }
            if (stringArray != null && stringArray.length > 0 && stringArray2 != null && stringArray2.length > 0) {
                this.ServerSources = new String[stringArray2.length * stringArray.length];
            } else if (stringArray != null && stringArray.length > 0) {
                this.ServerSources = new String[stringArray.length];
            }
            if (stringArray != null) {
                int n = 0;
                int n2 = 0;
                for (n = 0; n < stringArray.length; ++n) {
                    String string2 = stringArray[n];
                    if (stringArray2 != null) {
                        for (n2 = 0; n2 < stringArray2.length; ++n2) {
                            String string3 = stringArray2[n2];
                            this.addASource(string2, string3);
                        }
                        continue;
                    }
                    this.addASource(string2, "0");
                }
            }
            try {
                String string4 = (String)properties.get("com.ibm.websphere.security.webseal.ignoreProxy");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Ignore the proxy = " + string4));
                }
                this.ignoreProxy = string4.equalsIgnoreCase("true") || string4.equalsIgnoreCase("yes");
            }
            catch (NullPointerException nullPointerException) {
                this.ignoreProxy = false;
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Ignore proxy not defined, defaulting to false");
                }
                this.ignoreProxy = false;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"Exiting initialization: SUCCESS");
            }
            return 0;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlus.init", (String)"389", (Object)((Object)this));
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception encountered during initialization: " + exception.getMessage()));
            }
            return -1;
        }
    }

    protected void addASource(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addASource");
        }
        if (string != null && string.length() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"WebTAInterceptor: Adding an invalid hostname. ");
            }
            return;
        }
        try {
            Integer.decode(string2);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlus.addASource", (String)"413", (Object)((Object)this));
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"WebTAInterceptor: Adding an invalid port. ");
            }
            return;
        }
        this.ServerSources[TAMTrustAssociationInterceptorPlus.sourceCnt++] = string + ":" + string2;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("WebTAInterceptor: Added source = " + string + ":" + string2));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"Exiting addASource");
        }
    }

    protected Vector getCheckID() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getCheckID");
        }
        Vector<String> vector = new Vector<String>();
        if (this.ID != null) {
            for (int i = 0; i < this.ID.length; ++i) {
                vector.addElement(this.ID[i]);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getCheckID");
        }
        return vector;
    }

    public void cleanup() {
    }

    private String[] getElements(String string) {
        int n = 0;
        Vector<String> vector = new Vector<String>();
        int n2 = 0;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getElements");
        }
        if (string != null && string.trim().length() > 0) {
            while ((n = string.indexOf(44)) != -1) {
                String string2 = string.substring(0, n);
                vector.addElement(string2.trim());
                ++n2;
                string = string.substring(n + 1);
            }
            if (string.trim().length() > 0) {
                ++n2;
                vector.addElement(string.trim());
            }
            String[] stringArray = new String[n2];
            Enumeration enumeration = vector.elements();
            for (int i = 0; i < n2; ++i) {
                stringArray[i] = (String)enumeration.nextElement();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getElements");
            }
            return stringArray;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getElements: returning NULL");
        }
        return null;
    }

    private int checkVia(String string, String string2) {
        int n = 0;
        String string3 = string + ":0";
        String string4 = string + ":" + string2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("checkVia for " + string + ":" + string2));
        }
        if (this.ServerSources == null || this.ServerSources.length == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getCheckID:  0");
            }
            return 0;
        }
        for (n = 0; n < this.ServerSources.length; ++n) {
            String string5 = this.ServerSources[n];
            if (!string5.equals(string3) && !string5.equals(string4)) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getCheckID:  0");
            }
            return 0;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getCheckID:  -1");
        }
        return -1;
    }

    private boolean isSSOPassword(char[] cArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isSSOPassword(char[])");
        }
        boolean bl = false;
        boolean bl2 = _trustPasswdLock.getReaderLock();
        if (bl2) {
            if (_trustPasswd != null) {
                String string = new String(cArray);
                String string2 = _trustPasswd.getClearString();
                if (string2 != null && string2.equals(string)) {
                    bl = true;
                }
            }
            _trustPasswdLock.releaseLock();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("isSSOPassword(char[]) retVal = " + bl));
        }
        return bl;
    }

    private void setSSOPassword(char[] cArray) {
        long l;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setSSOPassword(char[])");
        }
        String string = null;
        boolean bl = _trustPasswdLock.getWriterLock();
        if (bl) {
            l = System.currentTimeMillis() + this._ssoPwdExpiryTime;
            _trustPasswd = new MaskString(cArray, l);
            _trustPasswdLock.releaseLock();
        }
        string = (l = _trustPasswd.getExpiry()) > 0L ? new String("Expiry of cached WebSEAL SSO password set: " + l) : new String("Cached WebSEAL SSO password does not expire");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("negotiateValidateandEstablishTrust(HttpServletRequest, HttpServletResponse) " + string));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setSSOPassword(char[])");
        }
    }

    private void expireSSOPassword() {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"expireSSOPassword()");
        }
        if (bl = _trustPasswdLock.getReaderLock()) {
            if (_trustPasswd != null) {
                long l = _trustPasswd.getExpiry();
                long l2 = System.currentTimeMillis();
                if (l2 > l) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"expireSSOPassword() Cached password has expired.");
                    }
                    _trustPasswdLock.releaseLock();
                    _trustPasswdLock.getWriterLock();
                    if (bl) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"expireSSOPassword() Password has been removed from cache.");
                        }
                        _trustPasswd = null;
                        _trustPasswdLock.releaseLock();
                    }
                } else {
                    _trustPasswdLock.releaseLock();
                }
            } else {
                _trustPasswdLock.releaseLock();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"expireSSOPassword()");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        _trustPasswdLock = new RWLock();
    }
}

