/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.jsr109;

import com.ibm.etools.commonarchive.Archive;
import com.ibm.etools.java.ArrayType;
import com.ibm.etools.java.Field;
import com.ibm.etools.java.JavaClass;
import com.ibm.etools.java.JavaHelpers;
import com.ibm.etools.java.JavaParameter;
import com.ibm.etools.java.JavaVisibilityKind;
import com.ibm.etools.java.Method;
import com.ibm.etools.java.impl.FieldImpl;
import com.ibm.etools.java.impl.JavaClassImpl;
import com.ibm.websphere.validation.jsr109.JSR109CommonValidator;
import com.ibm.websphere.validation.jsr109.JSR109ValidatorContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class JAXRPCParamValidator
extends JSR109CommonValidator {
    JavaClass seiClass;
    Method seiMethod;
    private JSR109ValidatorContext vc;
    private Archive modFile;
    private static final String holderInterfaceName = "javax.xml.rpc.holders.Holder";
    private static final String collectionInterfaceName = "java.util.Collection";
    private static final String mapInterfaceName = "java.util.Map";
    private static final String accessorPrefix = "get";
    private static final String charTypeName = "char";
    private static final String intTypeName = "int";
    private static final String fromValueName = "fromValue";
    private static final String valueFieldName = "value";
    private static final String ibmTypeMappingClassName = "com.ibm.ws.webservices.engine.encoding.DefaultTypeMappingImpl";
    private static Set alreadyTested = new HashSet();
    private static JavaClass holderInterface;
    private static JavaClass mapInterface;
    private static JavaClass collectionInterface;
    static List methodExcludeList;
    static Set standardJavaClasses;
    static Object ibmTypeMappingRegistry;
    static java.lang.reflect.Method getRegisteredQName;
    private static final byte IS_IBM_SUPPORTED_CLASS = 1;
    private static final byte NOT_IBM_SUPPORTED_CLASS = 0;
    private static final byte EXCEPTION_IN_IBM_SUPPORT_TEST = -1;
    static /* synthetic */ Class class$java$lang$String;

    protected static void resetAlreadyTested() {
        alreadyTested = new HashSet();
    }

    public JAXRPCParamValidator(JavaClass javaClass, Method method, JSR109ValidatorContext jSR109ValidatorContext, Archive archive) {
        this.seiClass = javaClass;
        this.seiMethod = method;
        this.vc = jSR109ValidatorContext;
        this.modFile = archive;
    }

    private JAXRPCParamValidator() {
    }

    protected void validateMethodParameters() {
        JavaParameter javaParameter;
        EList eList = this.seiMethod.getParameters();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            javaParameter = (JavaParameter)iterator.next();
            this.validateParameter(javaParameter.getJavaType());
        }
        if (!this.seiMethod.isVoid()) {
            javaParameter = this.seiMethod.getReturnType();
            this.validateParameter((JavaHelpers)javaParameter);
        }
    }

    private void validateParameter(JavaHelpers javaHelpers) {
        this.testParameterType(javaHelpers, javaHelpers);
    }

    private void testParameterType(JavaHelpers javaHelpers, JavaHelpers javaHelpers2) {
        String string;
        if (javaHelpers == null) {
            return;
        }
        if (javaHelpers.isArray()) {
            javaHelpers = ((ArrayType)javaHelpers).getFinalComponentType();
        }
        if (alreadyTested.contains(string = javaHelpers.getJavaName())) {
            return;
        }
        alreadyTested.add(string);
        if (standardJavaClasses.contains(string)) {
            return;
        }
        if (string.equals(charTypeName)) {
            this.reportIBMExtension(string, javaHelpers2.getJavaName());
            return;
        }
        if (!javaHelpers.isPrimitive()) {
            this.testValidParameterClass(javaHelpers, javaHelpers2);
        }
    }

    private void testValidParameterClass(JavaHelpers javaHelpers, JavaHelpers javaHelpers2) {
        if (javaHelpers instanceof JavaClass) {
            JavaClass javaClass = (JavaClass)javaHelpers;
            if (javaClass.implementsInterface(this.getRemoteInterface(this.modFile))) {
                this.reportRemoteInterface(javaClass.getJavaName(), javaHelpers2.getJavaName());
                return;
            }
            if (javaClass.implementsInterface(this.getHolderInterface())) {
                Field field = javaClass.getFieldNamed(valueFieldName);
                if (field == null) {
                    this.reportHolder(javaClass.getJavaName(), javaHelpers2.getJavaName());
                    return;
                }
                if (field instanceof FieldImpl) {
                    FieldImpl fieldImpl = (FieldImpl)field;
                    this.testParameterType(fieldImpl.getJavaType(), javaHelpers2);
                    return;
                }
            }
            if (this.isEnumerationType(javaClass)) {
                return;
            }
            byte by = this.isIBMExtension(javaClass);
            if (by == 1 || javaClass.implementsInterface(this.getMapInterface()) || javaClass.implementsInterface(this.getCollectionInterface())) {
                this.reportIBMExtension(javaClass.getJavaName(), javaHelpers2.getJavaName());
                return;
            }
            if (by == -1) {
                return;
            }
            if (javaClass.isInterface()) {
                this.reportNoConstructor(javaClass.getJavaName(), javaHelpers2.getJavaName());
                return;
            }
            this.testValueType(javaClass, javaHelpers2);
        }
    }

    private void testValueType(JavaClass javaClass, JavaHelpers javaHelpers) {
        if (!this.hasDefaultPublicConstructor(javaClass)) {
            this.reportNoConstructor(javaClass.getJavaName(), javaHelpers.getJavaName());
            return;
        }
        this.testPublicFields(javaClass, javaHelpers);
        this.testBeanProperties(javaClass, javaHelpers);
    }

    private void testPublicFields(JavaClass javaClass, JavaHelpers javaHelpers) {
        List list = javaClass.getFieldsExtended();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            FieldImpl fieldImpl = (FieldImpl)iterator.next();
            if (fieldImpl.isStatic() || fieldImpl.isTransient() || fieldImpl.getJavaVisibility() != JavaVisibilityKind.PUBLIC_LITERAL) continue;
            this.testParameterType(fieldImpl.getJavaType(), javaHelpers);
        }
    }

    private void testBeanProperties(JavaClass javaClass, JavaHelpers javaHelpers) {
        List list = javaClass.getOnlySpecificMethods(accessorPrefix, methodExcludeList);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            EList eList;
            Method method = (Method)iterator.next();
            if (method.getJavaVisibility() != JavaVisibilityKind.PUBLIC_LITERAL || method.isVoid() || !(eList = method.getParameters()).isEmpty() && (eList.size() != 1 || !((JavaParameter)eList.get(0)).getJavaType().getJavaName().equals(intTypeName))) continue;
            JavaHelpers javaHelpers2 = method.getReturnType();
            String string = method.getName();
            this.testParameterType(javaHelpers2, javaHelpers);
        }
    }

    private byte isIBMExtension(JavaClass javaClass) {
        if (getRegisteredQName != null && ibmTypeMappingRegistry != null) {
            try {
                Object object = getRegisteredQName.invoke(ibmTypeMappingRegistry, javaClass.getJavaName());
                if (object == null) {
                    return 0;
                }
                return 1;
            }
            catch (Exception exception) {
                return -1;
            }
        }
        return -1;
    }

    private void reportIBMExtension(String string, String string2) {
        if (string.equals(string2)) {
            this.vc.addInfo("IBM_EXTENSION_TYPE", new String[]{string, this.seiMethod.getMethodElementSignature(), this.seiClass.getJavaName()});
        } else {
            this.vc.addInfo("IBM_EXTENSION_TYPE_IND", new String[]{string2, this.seiMethod.getMethodElementSignature(), this.seiClass.getJavaName(), string});
        }
    }

    private void reportRemoteInterface(String string, String string2) {
        if (string.equals(string2)) {
            this.vc.addError("UNSUPPORTED_TYPE_REMOTE", new String[]{string, this.seiMethod.getMethodElementSignature(), this.seiClass.getJavaName()});
        } else {
            this.vc.addError("UNSUPPORTED_TYPE_REMOTE_IND", new String[]{string2, this.seiMethod.getMethodElementSignature(), this.seiClass.getJavaName(), string});
        }
    }

    private void reportNoConstructor(String string, String string2) {
        if (string.equals(string2)) {
            this.vc.addError("VALUETYPE_NO_CONSTRUCTOR", new String[]{string, this.seiMethod.getMethodElementSignature(), this.seiClass.getJavaName()});
        } else {
            this.vc.addError("VALUETYPE_NO_CONSTRUCTOR_IND", new String[]{string2, this.seiMethod.getMethodElementSignature(), this.seiClass.getJavaName(), string});
        }
    }

    private void reportHolder(String string, String string2) {
        this.vc.addError("BAD_HOLDER_FIELD", new String[]{string, this.seiMethod.getMethodElementSignature(), this.seiClass.getJavaName()});
    }

    private boolean isEnumerationType(JavaClass javaClass) {
        List list = javaClass.getOnlySpecificMethods(fromValueName, methodExcludeList);
        if (list.size() != 1) {
            return false;
        }
        Method method = (Method)list.get(0);
        return method.isStatic() && !method.isVoid() && method.getReturnType().getJavaName().equals(javaClass.getJavaName());
    }

    private JavaClass getHolderInterface() {
        if (holderInterface == null) {
            holderInterface = (JavaClass)JavaClassImpl.reflect((String)holderInterfaceName, (ResourceSet)this.modFile.getResourceSet());
        }
        return holderInterface;
    }

    private JavaClass getMapInterface() {
        if (mapInterface == null) {
            mapInterface = (JavaClass)JavaClassImpl.reflect((String)mapInterfaceName, (ResourceSet)this.modFile.getResourceSet());
        }
        return mapInterface;
    }

    private JavaClass getCollectionInterface() {
        if (collectionInterface == null) {
            collectionInterface = (JavaClass)JavaClassImpl.reflect((String)collectionInterfaceName, (ResourceSet)this.modFile.getResourceSet());
        }
        return collectionInterface;
    }

    private static Object getTypeMappingRegistry() {
        try {
            if (System.getSecurityManager() == null) {
                return JAXRPCParamValidator.reflectRegistryAndMethod();
            }
            Object t = AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return JAXRPCParamValidator.reflectRegistryAndMethod();
                }
            });
        }
        catch (Exception exception) {
            return null;
        }
        return null;
    }

    private static Object reflectRegistryAndMethod() {
        try {
            Class<?> clazz = Class.forName(ibmTypeMappingClassName);
            java.lang.reflect.Method method = clazz.getMethod("getSingleton", new Class[0]);
            getRegisteredQName = clazz.getMethod("getRegisteredQName", class$java$lang$String == null ? (class$java$lang$String = JAXRPCParamValidator.class$("java.lang.String")) : class$java$lang$String);
            return method.invoke(clazz, new Object[0]);
        }
        catch (Exception exception) {
            getRegisteredQName = null;
            ibmTypeMappingRegistry = null;
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        methodExcludeList = new ArrayList();
        methodExcludeList.add("getClass");
        standardJavaClasses = new HashSet();
        standardJavaClasses.add("java.lang.String");
        standardJavaClasses.add("java.math.BigInteger");
        standardJavaClasses.add("java.math.BigDecimal");
        standardJavaClasses.add("java.util.Calendar");
        standardJavaClasses.add("java.util.Date");
        standardJavaClasses.add("java.lang.Boolean");
        standardJavaClasses.add("java.lang.Byte");
        standardJavaClasses.add("java.lang.Short");
        standardJavaClasses.add("java.lang.Integer");
        standardJavaClasses.add("java.lang.Long");
        standardJavaClasses.add("java.lang.Float");
        standardJavaClasses.add("java.lang.Double");
        standardJavaClasses.add("javax.xml.namespace.QName");
        standardJavaClasses.add("javax.xml.soap.SOAPElement");
        standardJavaClasses.add("java.awt.Image");
        standardJavaClasses.add("javax.mail.internet.MimeMultipart");
        standardJavaClasses.add("javax.xml.transform.Source");
        standardJavaClasses.add("javax.activation.DataHandler");
        standardJavaClasses.add("java.lang.Object");
        ibmTypeMappingRegistry = JAXRPCParamValidator.getTypeMappingRegistry();
    }
}

