/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.jsr109;

import com.ibm.etools.archive.impl.ArchiveURIConverterImpl;
import com.ibm.etools.commonarchive.Archive;
import com.ibm.etools.commonarchive.Container;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.ejb.EJBJar;
import com.ibm.etools.ejb.EnterpriseBean;
import com.ibm.etools.j2ee.common.impl.J2EEResourceFactoryRegistry;
import com.ibm.etools.j2ee.exception.WrappedRuntimeException;
import com.ibm.etools.webservice.wscbnd.ClientBinding;
import com.ibm.etools.webservice.wscbnd.ComponentScopedRefs;
import com.ibm.etools.webservice.wscbnd.ServiceRef;
import com.ibm.etools.webservice.wscdd.PortComponentRef;
import com.ibm.etools.webservice.wscdd.WebServicesClient;
import com.ibm.etools.webservice.wscdd.WscddResource;
import com.ibm.websphere.validation.jsr109.JSR109CommonValidator;
import com.ibm.websphere.validation.jsr109.JSR109SEIValidator;
import com.ibm.websphere.validation.jsr109.JSR109ValidatorContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.xml.sax.SAXParseException;

public class JSR109ClientValidator
extends JSR109CommonValidator {
    private final String WEBSERVICECLIENT_FILENAME = "webservicesclient.xml";
    private final String WSCLIENTBINDING_FILENAME = "ibm-webservicesclient-bnd.xmi";
    private JSR109ValidatorContext vc;
    private Archive modFile;
    private WebServicesClient wscdd;
    private ClientBinding wscbnd;
    private ArrayList serviceRefNameList = new ArrayList();
    private ArrayList componentNameList = new ArrayList();

    public JSR109ClientValidator(JSR109ValidatorContext jSR109ValidatorContext, Archive archive) {
        this.vc = jSR109ValidatorContext;
        this.modFile = archive;
    }

    private JSR109ClientValidator() {
    }

    private com.ibm.etools.webservice.wscdd.ServiceRef[] getServiceRefs() {
        if (this.wscdd == null) {
            return null;
        }
        EList eList = this.wscdd.getServiceRefs();
        EList eList2 = this.wscdd.getComponentScopedRefs();
        com.ibm.etools.webservice.wscdd.ServiceRef[] serviceRefArray = null;
        if (eList.size() == 0 && eList2.size() == 0) {
            this.vc.addError("REQ_A_SERVICE_REF");
            return null;
        }
        if (eList2.size() == 0 && this.modFile.isEJBJarFile()) {
            this.vc.addError("EJB_REQ_COMP_SCOPED_REFS");
        }
        if (eList.size() != 0) {
            serviceRefArray = new com.ibm.etools.webservice.wscdd.ServiceRef[eList.size()];
            int n = 0;
            while (n < serviceRefArray.length) {
                com.ibm.etools.webservice.wscdd.ServiceRef serviceRef;
                serviceRefArray[n] = serviceRef = (com.ibm.etools.webservice.wscdd.ServiceRef)eList.get(n);
                ++n;
            }
        } else {
            EList eList3;
            Vector<Object> vector = new Vector<Object>();
            int n = 0;
            while (n < eList2.size()) {
                com.ibm.etools.webservice.wscdd.ComponentScopedRefs componentScopedRefs = (com.ibm.etools.webservice.wscdd.ComponentScopedRefs)eList2.get(n);
                eList3 = componentScopedRefs.getServiceRefs();
                this.validateComponentName(componentScopedRefs.getComponentName());
                int n2 = 0;
                while (n2 < eList3.size()) {
                    vector.add(eList3.get(n2));
                    ++n2;
                }
                ++n;
            }
            serviceRefArray = new com.ibm.etools.webservice.wscdd.ServiceRef[vector.size()];
            int n3 = 0;
            while (n3 < serviceRefArray.length) {
                eList3 = (com.ibm.etools.webservice.wscdd.ServiceRef)vector.get(n3);
                serviceRefArray[n3] = eList3;
                ++n3;
            }
        }
        return serviceRefArray;
    }

    private void validateComponentName(String string) {
        if (string == null) {
            this.vc.addError("REQ_COMPONENT_NAME");
            return;
        }
        if (this.modFile.isEJBJarFile()) {
            EJBJar eJBJar = ((EJBJarFile)this.modFile).getDeploymentDescriptor();
            EnterpriseBean enterpriseBean = eJBJar.getEnterpriseBeanNamed(string);
            if (enterpriseBean == null) {
                this.vc.addError("COMPONENT_SCOPED_REFS_NOT_SPECIFIED", new String[]{string});
            } else {
                this.componentNameList.add(string);
            }
        }
    }

    private WebServicesClient getClientModule() {
        String string = JSR109CommonValidator.getModulePath(this.modFile, "webservicesclient.xml");
        if (this.modFile.containsFile(string)) {
            try {
                ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
                ArchiveURIConverterImpl archiveURIConverterImpl = new ArchiveURIConverterImpl(this.modFile, null);
                resourceSetImpl.setResourceFactoryRegistry((Resource.Factory.Registry)J2EEResourceFactoryRegistry.INSTANCE);
                resourceSetImpl.setURIConverter((URIConverter)archiveURIConverterImpl);
                WscddResource wscddResource = (WscddResource)resourceSetImpl.getResource(URI.createURI((String)string), true);
                this.wscdd = wscddResource.getWebServicesClient();
                return this.wscdd;
            }
            catch (WrappedRuntimeException wrappedRuntimeException) {
                if (wrappedRuntimeException.getNestedException() instanceof SAXParseException) {
                    this.vc.addError("PARSE_ERROR", new String[]{"webservicesclient.xml", wrappedRuntimeException.getMessage(), wrappedRuntimeException.getNestedException().getMessage()});
                } else {
                    this.vc.addError("WRAPPED_EXCEPTION", new String[]{"webservicesclient.xml", wrappedRuntimeException.getMessage(), wrappedRuntimeException.getNestedException().getClass().getName() + ": " + wrappedRuntimeException.getNestedException().getMessage()});
                }
                this.wscdd = null;
            }
        }
        return null;
    }

    public void validateClient() {
        this.getClientModule();
        if (this.wscdd != null) {
            this.validateClientDescriptor();
        }
        this.getClientBinding();
        if (this.wscbnd != null) {
            this.validateClientBinding();
        }
    }

    private void validateClientDescriptor() {
        HashMap hashMap = new HashMap();
        com.ibm.etools.webservice.wscdd.ServiceRef[] serviceRefArray = this.getServiceRefs();
        if (serviceRefArray == null) {
            return;
        }
        if (serviceRefArray == null || serviceRefArray != null && serviceRefArray.length == 0) {
            this.vc.addError("REQ_SERVICE_REF");
            return;
        }
        int n = 0;
        while (n < serviceRefArray.length) {
            com.ibm.etools.webservice.wscdd.ServiceRef serviceRef = serviceRefArray[n];
            this.validateServiceRef(hashMap, serviceRef);
            ++n;
        }
    }

    private void validateServiceRef(HashMap hashMap, com.ibm.etools.webservice.wscdd.ServiceRef serviceRef) {
        EList eList;
        String string;
        String string2 = serviceRef.getServiceRefName();
        if (string2 == null) {
            this.vc.addError("REQ_SERVICE_REF_NAME");
            return;
        }
        this.serviceRefNameList.add(string2);
        String string3 = serviceRef.getWsdlFile();
        if (string3 != null && !this.modFile.containsFile(string3)) {
            this.vc.addError("MISSING_WSDL", new String[]{string3});
        }
        if ((string = serviceRef.getJaxrpcMappingFile()) != null && !this.modFile.containsFile(string)) {
            this.vc.addError("MISSING_MAPPING", new String[]{string});
        }
        JSR109CommonValidator.validateWSDLandMappingFiles(this.vc, string3, string, hashMap);
        String string4 = serviceRef.getServiceInterface();
        if (string4 == null || "".equals(string4)) {
            this.vc.addError("MISSING_CLIENT_SERVICE_INTERFACE", new String[]{string2});
        }
        if ((eList = serviceRef.getPortComponentRefs()) != null) {
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                PortComponentRef portComponentRef = (PortComponentRef)iterator.next();
                this.validatePortComponentRef(serviceRef, portComponentRef);
            }
        }
    }

    private void validatePortComponentRef(com.ibm.etools.webservice.wscdd.ServiceRef serviceRef, PortComponentRef portComponentRef) {
        String string = portComponentRef.getServiceEndpointInterface();
        if (string == null || "".equals(string)) {
            this.vc.addError("MISSING_CLIENT_SEI", new String[]{serviceRef.getServiceRefName()});
        } else {
            new JSR109SEIValidator(this.vc, this.modFile).validateSEI(string, "webservicesclient.xml");
        }
        this.validatePortComponentLink(serviceRef, portComponentRef);
    }

    private void validatePortComponentLink(com.ibm.etools.webservice.wscdd.ServiceRef serviceRef, PortComponentRef portComponentRef) {
        int n;
        String string = portComponentRef.getPortComponentLink();
        if (string != null && !string.equals("") && (n = string.indexOf(35)) != -1) {
            String string2 = string.substring(0, n).trim();
            Container container = this.modFile.getContainer();
            if (container == null || !(container instanceof EARFile)) {
                return;
            }
            if (!container.containsFile(string2)) {
                this.vc.addError("PORT_COMPONENT_NOT_FOUND", new String[]{string, serviceRef.getServiceRefName()});
            }
        }
    }

    private ClientBinding getClientBinding() {
        block5: {
            String string = JSR109CommonValidator.getModulePath(this.modFile, "ibm-webservicesclient-bnd.xmi");
            if (!this.modFile.containsFile(string)) break block5;
            try {
                ResourceSet resourceSet = this.modFile.getLoadStrategy().getResourceSet();
                Resource resource = resourceSet.getResource(URI.createURI((String)string), true);
                if (resource != null) {
                    this.wscbnd = (ClientBinding)resource.getContents().get(0);
                    return this.wscbnd;
                }
            }
            catch (WrappedException wrappedException) {
                if (wrappedException.exception() instanceof SAXParseException) {
                    this.vc.addError("BND_PARSE_ERROR", new String[]{"ibm-webservicesclient-bnd.xmi", wrappedException.getMessage(), wrappedException.exception().getMessage()});
                } else {
                    this.vc.addError("WRAPPED_EXCEPTION", new String[]{"ibm-webservicesclient-bnd.xmi", wrappedException.getMessage(), wrappedException.exception().getClass().getName() + ": " + wrappedException.exception().getMessage()});
                }
                this.wscbnd = null;
            }
        }
        return null;
    }

    private void validateClientBinding() {
        ServiceRef[] serviceRefArray = this.getBindingServiceRefs();
        int n = 0;
        while (n < serviceRefArray.length) {
            this.validateServiceRef(serviceRefArray[n]);
            ++n;
        }
    }

    private void validateServiceRef(ServiceRef serviceRef) {
        String string;
        String string2 = serviceRef.getDeployedWSDLFile();
        if (string2 != null && !this.modFile.containsFile(string2)) {
            this.vc.addError("INVALID_DEPLOYED_WSDL_FILE", new String[]{string2});
        }
        if ((string = serviceRef.getServiceRefLink()) == null) {
            this.vc.addError("REQ_SERVICE_REF_LINK");
        } else if (!this.serviceRefNameList.contains(string)) {
            this.vc.addError("INVALID_SERVICE_REF_LINK", new String[]{string});
        }
    }

    private ServiceRef[] getBindingServiceRefs() {
        if (this.wscbnd == null) {
            return null;
        }
        EList eList = this.wscbnd.getServiceRefs();
        EList eList2 = this.wscbnd.getComponentScopedRefs();
        ServiceRef[] serviceRefArray = null;
        if (eList.size() != 0) {
            serviceRefArray = new ServiceRef[eList.size()];
            int n = 0;
            while (n < serviceRefArray.length) {
                ServiceRef serviceRef;
                serviceRefArray[n] = serviceRef = (ServiceRef)eList.get(n);
                ++n;
            }
        } else {
            EList eList3;
            Vector<Object> vector = new Vector<Object>();
            int n = 0;
            while (n < eList2.size()) {
                ComponentScopedRefs componentScopedRefs = (ComponentScopedRefs)eList2.get(n);
                this.validateComponentNameLink(componentScopedRefs.getComponentNameLink());
                eList3 = componentScopedRefs.getServiceRefs();
                int n2 = 0;
                while (n2 < eList3.size()) {
                    vector.add(eList3.get(n2));
                    ++n2;
                }
                ++n;
            }
            serviceRefArray = new ServiceRef[vector.size()];
            int n3 = 0;
            while (n3 < serviceRefArray.length) {
                eList3 = (ServiceRef)vector.get(n3);
                serviceRefArray[n3] = eList3;
                ++n3;
            }
        }
        return serviceRefArray;
    }

    private void validateComponentNameLink(String string) {
        if (string == null) {
            this.vc.addError("REQ_COMPONENT_NAME_LINK");
            return;
        }
        if (!this.componentNameList.contains(string)) {
            this.vc.addError("INVALID_COMPONENTNAME_LINK", new String[]{string});
        }
    }
}

