/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.jsr109;

import com.ibm.etools.commonarchive.Archive;
import com.ibm.etools.commonarchive.File;
import com.ibm.etools.java.JavaClass;
import com.ibm.etools.java.Method;
import com.ibm.etools.java.impl.JavaClassImpl;
import com.ibm.etools.webservice.jaxrpcmap.impl.JaxrpcmapPackageImpl;
import com.ibm.etools.webservice.wsbnd.impl.WsbndPackageImpl;
import com.ibm.etools.webservice.wscbnd.impl.WscbndPackageImpl;
import com.ibm.etools.webservice.wscdd.WscddResourceFactory;
import com.ibm.etools.webservice.wscext.impl.WscextPackageImpl;
import com.ibm.etools.webservice.wscommon.impl.WscommonPackageImpl;
import com.ibm.etools.webservice.wscommonbnd.impl.WscommonbndPackageImpl;
import com.ibm.etools.webservice.wscommonext.impl.WscommonextPackageImpl;
import com.ibm.etools.webservice.wsdd.WsddResourceFactory;
import com.ibm.etools.webservice.wsext.impl.WsextPackageImpl;
import com.ibm.etools.webservice.xml.WebServiceXmlDtDEntityResolver;
import com.ibm.websphere.validation.jsr109.JSR109ValidatorContext;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.impl.EcorePackageImpl;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class JSR109CommonValidator {
    protected static final String remoteInterfaceName = "java.rmi.Remote";
    private JavaClass remoteInterface;

    public static void registerXML() {
        EcorePackageImpl.init();
        WsddResourceFactory.register();
        WscddResourceFactory.register();
        WebServiceXmlDtDEntityResolver.registerDtD((String)"http://www.ibm.com/webservices/dtd/j2ee_web_services_1_0.dtd", (String)"j2ee_web_services_1_0.dtd");
        WebServiceXmlDtDEntityResolver.registerDtD((String)"http://www.ibm.com/webservices/dtd/j2ee_web_services_client_1_0.dtd", (String)"j2ee_web_services_client_1_0.dtd");
        WebServiceXmlDtDEntityResolver.registerDtD((String)"http://www.ibm.com/webservices/dtd/j2ee_jaxrpc_mapping_1_0.dtd", (String)"j2ee_jaxrpc_mapping_1_0.dtd");
        WscommonPackageImpl.init();
        WscommonextPackageImpl.init();
        WscommonbndPackageImpl.init();
        JaxrpcmapPackageImpl.init();
        WsbndPackageImpl.init();
        WscbndPackageImpl.init();
        WsextPackageImpl.init();
        WscextPackageImpl.init();
    }

    public static String getModulePath(Archive archive, String string) {
        String string2 = "";
        string2 = archive.isWARFile() ? "WEB-INF/" + string : "META-INF/" + string;
        return string2;
    }

    static File getFile(Archive archive, String string) {
        File file = null;
        try {
            file = archive.getFile(string);
        }
        catch (Exception exception) {}
        return file;
    }

    static void validateWSDLandMappingFiles(JSR109ValidatorContext jSR109ValidatorContext, String string, String string2, HashMap hashMap) {
        if (string != null && string2 == null) {
            jSR109ValidatorContext.addError("WSDL_WITHOUT_MAPPING");
        }
        if (string2 != null && string == null) {
            jSR109ValidatorContext.addError("ILLEGAL_MAPPING", new String[]{string2});
        }
        if (hashMap.containsKey(string)) {
            String string3 = (String)hashMap.get(string);
            if (!string2.equals(string3)) {
                jSR109ValidatorContext.addError("NONUNIQUE_MAPPING_FILE", new String[]{string, string3, string2});
            }
        } else if (string != null && string2 != null) {
            hashMap.put(string, string2);
        }
    }

    public static JavaClass forName(Archive archive, String string) throws ClassNotFoundException {
        JavaClass javaClass = null;
        try {
            javaClass = (JavaClass)JavaClassImpl.reflect((String)string, (ResourceSet)archive.getResourceSet());
            if (javaClass == null) {
                return null;
            }
            if (!javaClass.isExistingType()) {
                return null;
            }
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
        return javaClass;
    }

    protected boolean hasDefaultPublicConstructor(JavaClass javaClass) {
        List list = javaClass.getPublicMethodsNamed(javaClass.getName());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Method method = (Method)iterator.next();
            if (!method.getParameters().isEmpty()) continue;
            return true;
        }
        return false;
    }

    protected JavaClass getRemoteInterface(Archive archive) {
        if (this.remoteInterface == null) {
            this.remoteInterface = (JavaClass)JavaClassImpl.reflect((String)remoteInterfaceName, (ResourceSet)archive.getResourceSet());
        }
        return this.remoteInterface;
    }
}

