/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.jsr109;

import com.ibm.etools.archive.exception.DeploymentDescriptorLoadException;
import com.ibm.etools.archive.impl.ArchiveURIConverterImpl;
import com.ibm.etools.commonarchive.Archive;
import com.ibm.etools.commonarchive.Container;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.commonarchive.WARFile;
import com.ibm.etools.ejb.AssemblyDescriptor;
import com.ibm.etools.ejb.EJBJar;
import com.ibm.etools.ejb.EnterpriseBean;
import com.ibm.etools.ejb.MethodElement;
import com.ibm.etools.ejb.MethodTransaction;
import com.ibm.etools.ejb.Session;
import com.ibm.etools.ejb.SessionType;
import com.ibm.etools.ejb.TransactionAttributeType;
import com.ibm.etools.j2ee.common.impl.J2EEResourceFactoryRegistry;
import com.ibm.etools.j2ee.exception.WrappedRuntimeException;
import com.ibm.etools.java.JavaClass;
import com.ibm.etools.java.JavaHelpers;
import com.ibm.etools.java.JavaParameter;
import com.ibm.etools.java.JavaVisibilityKind;
import com.ibm.etools.java.Method;
import com.ibm.etools.webapplication.Servlet;
import com.ibm.etools.webapplication.ServletMapping;
import com.ibm.etools.webservice.wsbnd.PCBinding;
import com.ibm.etools.webservice.wsbnd.RouterModule;
import com.ibm.etools.webservice.wsbnd.WSBinding;
import com.ibm.etools.webservice.wsbnd.WSDescBinding;
import com.ibm.etools.webservice.wsdd.EJBLink;
import com.ibm.etools.webservice.wsdd.PortComponent;
import com.ibm.etools.webservice.wsdd.ServiceImplBean;
import com.ibm.etools.webservice.wsdd.ServletLink;
import com.ibm.etools.webservice.wsdd.WebServiceDescription;
import com.ibm.etools.webservice.wsdd.WebServices;
import com.ibm.etools.webservice.wsdd.WsddResource;
import com.ibm.websphere.validation.jsr109.JSR109CommonValidator;
import com.ibm.websphere.validation.jsr109.JSR109SEIValidator;
import com.ibm.websphere.validation.jsr109.JSR109ValidatorContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.xml.sax.SAXParseException;

public class JSR109ServerValidator
extends JSR109CommonValidator {
    private static final String WEBSERVICE_FILENAME = "webservices.xml";
    private static final String WSBINDING_FILENAME = "ibm-webservices-bnd.xmi";
    private static final String WEB_FILENAME = "web.xml";
    private JSR109ValidatorContext vc;
    private Archive modFile;
    private WebServices wsdd = null;
    private WSBinding wsbnd = null;
    private ArrayList wsDescNameList = new ArrayList();
    private ArrayList pcNameList = new ArrayList();

    public JSR109ServerValidator(JSR109ValidatorContext jSR109ValidatorContext, Archive archive) {
        this.vc = jSR109ValidatorContext;
        this.modFile = archive;
    }

    private JSR109ServerValidator() {
    }

    private WebServices getServerModel() {
        String string = JSR109CommonValidator.getModulePath(this.modFile, WEBSERVICE_FILENAME);
        if (this.modFile.containsFile(string)) {
            try {
                ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
                ArchiveURIConverterImpl archiveURIConverterImpl = new ArchiveURIConverterImpl(this.modFile, null);
                resourceSetImpl.setResourceFactoryRegistry((Resource.Factory.Registry)J2EEResourceFactoryRegistry.INSTANCE);
                resourceSetImpl.setURIConverter((URIConverter)archiveURIConverterImpl);
                WsddResource wsddResource = (WsddResource)resourceSetImpl.getResource(URI.createURI((String)string), true);
                this.wsdd = wsddResource.getWebServices();
            }
            catch (WrappedRuntimeException wrappedRuntimeException) {
                if (wrappedRuntimeException.getNestedException() instanceof SAXParseException) {
                    this.vc.addError("PARSE_ERROR", new String[]{WEBSERVICE_FILENAME, wrappedRuntimeException.getMessage(), wrappedRuntimeException.getNestedException().getMessage()});
                } else {
                    this.vc.addError("WRAPPED_EXCEPTION", new String[]{WEBSERVICE_FILENAME, wrappedRuntimeException.getMessage(), wrappedRuntimeException.getNestedException().getClass().getName() + ": " + wrappedRuntimeException.getNestedException().getMessage()});
                }
                this.wsdd = null;
            }
            return this.wsdd;
        }
        return null;
    }

    private WSBinding getServerBinding() {
        block5: {
            String string = JSR109CommonValidator.getModulePath(this.modFile, WSBINDING_FILENAME);
            if (!this.modFile.containsFile(string)) break block5;
            try {
                ResourceSet resourceSet = this.modFile.getLoadStrategy().getResourceSet();
                Resource resource = resourceSet.getResource(URI.createURI((String)string), true);
                if (resource != null) {
                    this.wsbnd = (WSBinding)resource.getContents().get(0);
                    return this.wsbnd;
                }
            }
            catch (WrappedException wrappedException) {
                if (wrappedException.exception() instanceof SAXParseException) {
                    this.vc.addError("BND_PARSE_ERROR", new String[]{WSBINDING_FILENAME, wrappedException.getMessage(), wrappedException.exception().getMessage()});
                } else {
                    this.vc.addError("WRAPPED_EXCEPTION", new String[]{WSBINDING_FILENAME, wrappedException.getMessage(), wrappedException.exception().getClass().getName() + ": " + wrappedException.exception().getMessage()});
                }
                this.wsbnd = null;
            }
        }
        return null;
    }

    public void validateServer() {
        this.getServerModel();
        if (this.wsdd != null) {
            this.validateServerDescriptor();
        }
        this.getServerBinding();
        if (this.wsbnd != null) {
            this.validateServerBinding();
        }
    }

    private void validateServerBinding() {
        this.validateBindingRouterModule();
        this.validateWsDescBindings();
    }

    private void validateWsDescBindings() {
        EList eList = this.wsbnd.getWsdescBindings();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            WSDescBinding wSDescBinding = (WSDescBinding)iterator.next();
            String string = wSDescBinding.getWsDescNameLink();
            if (string == null) {
                this.vc.addError("REQ_WSDESCNAMELINK");
                return;
            }
            if (!this.wsDescNameList.contains(string)) {
                this.vc.addError("INVALID_WSDESC_NAME_LINK", new String[]{string});
            }
            this.validatePcBindings(wSDescBinding);
        }
    }

    private void validatePcBindings(WSDescBinding wSDescBinding) {
        EList eList = wSDescBinding.getPcBindings();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            String string;
            PCBinding pCBinding = (PCBinding)iterator.next();
            String string2 = pCBinding.getPcNameLink();
            if (string2 != null) {
                if (!this.pcNameList.contains(string2)) {
                    this.vc.addError("INVALID_PC_NAME_LINK", new String[]{string2, wSDescBinding.getWsDescNameLink()});
                }
            } else {
                this.vc.addError("REQ_PC_NAME_LINK");
            }
            if ((string = pCBinding.getScope()) == null || string.equalsIgnoreCase("Session") || string.equalsIgnoreCase("Request") || string.equalsIgnoreCase("Application")) continue;
            this.vc.addError("INVALID_SCOPE", new String[]{string, string2 != null ? string2 : ""});
        }
    }

    private void validateBindingRouterModule() {
        EList eList = this.wsbnd.getRouterModules();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            RouterModule routerModule = (RouterModule)iterator.next();
            String string = routerModule.getName();
            Container container = this.modFile.getContainer();
            if (container == null || !(container instanceof EARFile)) {
                return;
            }
            if (container.containsFile(string)) continue;
            this.vc.addError("INVALID_ROUTER_MODULE", new String[]{string});
        }
    }

    private void validateServerDescriptor() {
        HashMap hashMap = new HashMap();
        EList eList = this.wsdd.getWebServiceDescriptions();
        if (eList.size() == 0) {
            this.vc.addError("REQ_WEBSERVICE_DESCRIPTION");
        }
        int n = 0;
        while (n < eList.size()) {
            WebServiceDescription webServiceDescription = (WebServiceDescription)eList.get(n);
            String string = webServiceDescription.getWebServiceDescriptionName();
            if (string == null) {
                this.vc.addError("REQ_WEBSERVICE_DESCRIPTION_NAME");
            } else {
                this.wsDescNameList.add(string);
            }
            String string2 = webServiceDescription.getWsdlFile();
            if (string2 == null) {
                this.vc.addError("REQ_WSDL_FILE", new String[]{string != null ? string : ""});
            } else if (!this.modFile.containsFile(string2)) {
                this.vc.addError("MISSING_WSDL", new String[]{string2});
            }
            String string3 = webServiceDescription.getJaxrpcMappingFile();
            if (string3 == null) {
                this.vc.addError("REQ_MAPPING_FILE", new String[]{string != null ? string : ""});
            } else if (!this.modFile.containsFile(string3)) {
                this.vc.addError("MISSING_MAPPING", new String[]{string3});
            }
            if (string2 != null && string3 != null) {
                JSR109CommonValidator.validateWSDLandMappingFiles(this.vc, string2, string3, hashMap);
            }
            this.validatePortComponents(webServiceDescription);
            ++n;
        }
    }

    private void validatePortComponents(WebServiceDescription webServiceDescription) {
        EList eList = null;
        EList eList2 = webServiceDescription.getPortComponents();
        if (eList2.size() == 0) {
            this.vc.addError("REQ_PORT_COMPONENT", new String[]{webServiceDescription.getWebServiceDescriptionName()});
            return;
        }
        HashMap hashMap = new HashMap();
        int n = 0;
        while (n < eList2.size()) {
            JSR109SEIValidator jSR109SEIValidator;
            PortComponent portComponent = (PortComponent)eList2.get(n);
            String string = portComponent.getPortComponentName();
            if (string == null) {
                this.vc.addError("REQ_PORT_COMPONENT_NAME", new String[]{webServiceDescription.getWebServiceDescriptionName()});
            } else {
                this.pcNameList.add(string);
            }
            String string2 = portComponent.getServiceEndpointInterface();
            if (string2 != null) {
                if (string2.equals("")) {
                    this.vc.addError("MISSING_SEI_CLASS", new String[]{string2});
                } else {
                    jSR109SEIValidator = new JSR109SEIValidator(this.vc, this.modFile);
                    eList = jSR109SEIValidator.validateSEI(string2, WEBSERVICE_FILENAME);
                }
            } else {
                this.vc.addError("REQ_SEI_SERVER", new String[]{string != null ? string : ""});
            }
            jSR109SEIValidator = portComponent.getServiceImplBean();
            if (jSR109SEIValidator == null) {
                this.vc.addError("REQ_SERVICE_IMPL_BEAN", new String[]{string != null ? string : ""});
                return;
            }
            this.validateNoMultipleImpls(hashMap, portComponent, (ServiceImplBean)jSR109SEIValidator);
            this.validateServiceImplBean(eList, (ServiceImplBean)jSR109SEIValidator, string != null ? string : "");
            ++n;
        }
    }

    private void validateNoMultipleImpls(HashMap hashMap, PortComponent portComponent, ServiceImplBean serviceImplBean) {
        String string;
        if (portComponent == null || serviceImplBean == null) {
            return;
        }
        if (this.modFile.isWARFile()) {
            ServletLink servletLink = serviceImplBean.getEServletLink();
            if (servletLink == null) {
                return;
            }
            string = servletLink.getServletLink();
        } else {
            EJBLink eJBLink = serviceImplBean.getEEJBLink();
            if (eJBLink == null) {
                return;
            }
            string = eJBLink.getEjbLink();
        }
        if (hashMap.containsKey(string)) {
            this.vc.addError("MULTIPLE_IMPLS_DETECTED", new String[]{string, portComponent.getPortComponentName(), (String)hashMap.get(string)});
        }
        hashMap.put(string, portComponent.getPortComponentName());
    }

    private void validateServiceImplBean(EList eList, ServiceImplBean serviceImplBean, String string) {
        if (this.modFile.isWARFile()) {
            this.validateServletImpl(eList, serviceImplBean, string);
        } else if (this.modFile.isEJBJarFile()) {
            this.validateEJBImpl(eList, serviceImplBean, string);
        }
    }

    private void validateEJBImpl(EList eList, ServiceImplBean serviceImplBean, String string) {
        EJBLink eJBLink = serviceImplBean.getEEJBLink();
        if (eJBLink == null) {
            ServletLink servletLink = serviceImplBean.getEServletLink();
            if (servletLink != null) {
                this.vc.addError("WRONG_LINK_SERVLET", new String[]{servletLink.getServletLink(), string});
                return;
            }
            this.vc.addError("MISSING_EJB_LINK", new String[]{string});
            return;
        }
        String string2 = eJBLink.getEjbLink();
        EJBJar eJBJar = ((EJBJarFile)this.modFile).getDeploymentDescriptor();
        EnterpriseBean enterpriseBean = eJBJar.getEnterpriseBeanNamed(string2);
        if (enterpriseBean == null) {
            this.vc.addError("INVALID_EJB_LINK", new String[]{string2});
            return;
        }
        if (!enterpriseBean.isSession()) {
            this.vc.addError("NOT_A_SESSION_BEAN", new String[]{string2});
            return;
        }
        Session session = (Session)enterpriseBean;
        if (session.getSessionType() != SessionType.STATELESS_LITERAL) {
            this.vc.addError("ILLEGAL_STATEFUL_SESSION_BEAN", new String[]{string2});
        }
        this.validateImplementationClass(enterpriseBean.getEjbClass(), eList);
        this.validateNoMandatoryTransactions(eList, eJBJar, enterpriseBean);
    }

    private void validateNoMandatoryTransactions(EList eList, EJBJar eJBJar, EnterpriseBean enterpriseBean) {
        AssemblyDescriptor assemblyDescriptor = eJBJar.getAssemblyDescriptor();
        if (assemblyDescriptor == null) {
            return;
        }
        EList eList2 = assemblyDescriptor.getMethodTransactions();
        if (eList2 == null) {
            return;
        }
        Iterator iterator = eList2.iterator();
        while (iterator.hasNext()) {
            MethodTransaction methodTransaction = (MethodTransaction)iterator.next();
            TransactionAttributeType transactionAttributeType = methodTransaction.getTransactionAttribute();
            if (transactionAttributeType != TransactionAttributeType.MANDATORY_LITERAL) continue;
            EList eList3 = methodTransaction.getMethodElements();
            Iterator iterator2 = eList3.iterator();
            while (iterator2.hasNext()) {
                MethodElement methodElement = (MethodElement)iterator2.next();
                Iterator iterator3 = eList.iterator();
                while (iterator3.hasNext()) {
                    Method method = (Method)iterator3.next();
                    if (!methodElement.nameAndParamsEquals(method) && (methodElement.hasMethodParams() || !methodElement.getName().trim().equals(method.getName())) && !methodElement.getName().equals("*")) continue;
                    this.vc.addError("ILLEGAL_MANDATORY_TRANSACTION", new String[]{method.getMethodElementSignature(), enterpriseBean.getEjbClass().getJavaName()});
                }
            }
        }
    }

    private void validateServletImpl(EList eList, ServiceImplBean serviceImplBean, String string) {
        Object object;
        if (serviceImplBean == null) {
            return;
        }
        ServletLink servletLink = serviceImplBean.getEServletLink();
        if (servletLink == null) {
            EJBLink eJBLink = serviceImplBean.getEEJBLink();
            if (eJBLink != null) {
                this.vc.addError("WRONG_LINK_EJB", new String[]{eJBLink.getEjbLink(), string});
                return;
            }
            this.vc.addError("MISSING_SERVLET_LINK", new String[]{string});
            return;
        }
        String string2 = servletLink.getServletLink();
        Servlet servlet = null;
        try {
            object = ((WARFile)this.modFile).getDeploymentDescriptor();
            servlet = object.getServletNamed(string2);
        }
        catch (DeploymentDescriptorLoadException deploymentDescriptorLoadException) {
            this.vc.addError("WRAPPED_EXCEPTION", new String[]{WEB_FILENAME, deploymentDescriptorLoadException.getMessage(), deploymentDescriptorLoadException.getNestedException().getClass().getName() + ": " + deploymentDescriptorLoadException.getNestedException().getMessage()});
        }
        if (servlet == null) {
            this.vc.addError("INVALID_SERVLET_LINK", new String[]{string2});
        } else {
            this.validateServletMapping(string2, servlet);
            object = servlet.getServletName();
            try {
                JavaClass javaClass = JSR109CommonValidator.forName(this.modFile, (String)object);
                this.validateImplementationClass(javaClass, eList);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.vc.addError("MISSING_SIB_CLASS", new String[]{object});
            }
        }
    }

    private void validateServletMapping(String string, Servlet servlet) {
        List list = servlet.getMappings();
        int n = 0;
        while (n < list.size()) {
            ServletMapping servletMapping = (ServletMapping)list.get(n);
            if (servletMapping != null && servletMapping.getUrlPattern().indexOf(42) != -1) {
                this.vc.addError("ILLEGAL_SERVLET_MAPPING", new String[]{string});
            }
            ++n;
        }
        if (list.size() > 1) {
            this.vc.addError("MULTIPLE_SERVLET_MAPPINGS_DETECTED", new String[]{string});
        }
    }

    private void validateImplementationClass(JavaClass javaClass, EList eList) {
        if (javaClass == null) {
            return;
        }
        this.validateHasDefaultPublicConstructor(javaClass);
        this.validateIsPublicClass(javaClass);
        this.validateIsNonFinalClass(javaClass);
        this.validateIsNotAbstractClass(javaClass);
        this.validateHasNoFinalize(javaClass);
        this.validateMethods(javaClass, eList);
    }

    private void validateMethods(JavaClass javaClass, EList eList) {
        if (eList == null) {
            return;
        }
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            Method method = (Method)iterator.next();
            Method method2 = this.hasCorrespondingImplMethod(javaClass, method);
            if (method2 == null) continue;
            this.validateIsPublicMethod(method2, javaClass);
            this.validateIsNonFinalMethod(method2, javaClass);
            this.validateIsNonStaticMethod(method2, javaClass);
        }
    }

    private void validateIsNonStaticMethod(Method method, JavaClass javaClass) {
        if (method.isStatic()) {
            this.vc.addError("ILLEGAL_STATIC_METHOD", new String[]{method.getMethodElementSignature(), javaClass.getJavaName()});
        }
    }

    private void validateIsNonFinalMethod(Method method, JavaClass javaClass) {
        if (method.isFinal()) {
            this.vc.addError("ILLEGAL_FINAL_METHOD", new String[]{method.getMethodElementSignature(), javaClass.getJavaName()});
        }
    }

    private void validateIsPublicMethod(Method method, JavaClass javaClass) {
        if (method.getJavaVisibility() != JavaVisibilityKind.PUBLIC_LITERAL) {
            this.vc.addError("NONPUBLIC_METHOD", new String[]{method.getMethodElementSignature(), javaClass.getJavaName()});
        }
    }

    private Method hasCorrespondingImplMethod(JavaClass javaClass, Method method) {
        Method method2;
        String string = method.getName();
        JavaParameter[] javaParameterArray = method.listParametersWithoutReturn();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < javaParameterArray.length) {
            method2 = (JavaHelpers)javaParameterArray[n].getEType();
            arrayList.add(method2.getQualifiedName());
            ++n;
        }
        method2 = javaClass.getMethod(string, arrayList);
        if (method2 == null) {
            this.vc.addError("MISSING_METHOD", new String[]{javaClass.getJavaName(), method.getMethodElementSignature(), method.getJavaClass().getJavaName()});
        }
        return method2;
    }

    private void validateHasNoFinalize(JavaClass javaClass) {
        Method method = javaClass.getMethod("finalize", new ArrayList());
        if (method != null) {
            this.vc.addError("ILLEGAL_FINALIZE", new String[]{javaClass.getJavaName()});
        }
    }

    private void validateIsNotAbstractClass(JavaClass javaClass) {
        if (javaClass.isAbstract()) {
            this.vc.addError("ILLEGAL_ABSTRACT_CLASS", new String[]{javaClass.getJavaName()});
        }
    }

    private void validateIsNonFinalClass(JavaClass javaClass) {
        if (javaClass.isFinal()) {
            this.vc.addError("ILLEGAL_FINAL_CLASS", new String[]{javaClass.getJavaName()});
        }
    }

    private void validateIsPublicClass(JavaClass javaClass) {
        if (!javaClass.isPublic()) {
            this.vc.addError("NONPUBLIC_CLASS", new String[]{javaClass.getJavaName()});
        }
    }

    private void validateHasDefaultPublicConstructor(JavaClass javaClass) {
        if (this.hasDefaultPublicConstructor(javaClass)) {
            return;
        }
        this.vc.addError("NO_PUBLIC_CONSTRUCTOR", new String[]{javaClass.getJavaName()});
    }
}

