/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.util;

import com.ibm.etools.ejb.CMPAttribute;
import com.ibm.etools.ejb.CommonRelationship;
import com.ibm.etools.ejb.CommonRelationshipRole;
import com.ibm.etools.ejb.ContainerManagedEntity;
import com.ibm.etools.ejb.EjbPackage;
import com.ibm.etools.ejb.impl.EjbFactoryImpl;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public abstract class CommonRelationshipAttributeMaintenanceAdapter
extends AdapterImpl {
    protected static EjbPackage EJB_PACK = EjbFactoryImpl.getPackage();

    public void notifyChanged(Notification notification) {
        switch (notification.getEventType()) {
            case 3: {
                this.addedNotification(notification);
                break;
            }
            case 4: {
                this.removedNotification(notification);
            }
        }
    }

    protected void addedNotification(Notification notification) {
        if ((EStructuralFeature)notification.getFeature() == EJB_PACK.getContainerManagedEntity_KeyAttributes()) {
            this.addedKeyAttribute((ContainerManagedEntity)notification.getNotifier(), (CMPAttribute)notification.getNewValue());
        } else if (this.isRelationshipsSF((EObject)((EStructuralFeature)notification.getFeature()))) {
            this.added();
        } else if (this.isRelationshipRolesSF((EObject)((EStructuralFeature)notification.getFeature()))) {
            this.addedRole((CommonRelationshipRole)notification.getNewValue());
        }
    }

    protected void removedNotification(Notification notification) {
        if ((EStructuralFeature)notification.getFeature() == EJB_PACK.getContainerManagedEntity_KeyAttributes()) {
            this.removedKeyAttribute((ContainerManagedEntity)notification.getNotifier(), (CMPAttribute)notification.getOldValue());
        } else if (this.isRelationshipsSF((EObject)((EStructuralFeature)notification.getFeature()))) {
            this.removed();
        } else if (this.isRelationshipRolesSF((EObject)((EStructuralFeature)notification.getFeature()))) {
            this.removedRole((CommonRelationshipRole)notification.getOldValue());
        }
    }

    protected abstract boolean isRelationshipRolesSF(EObject var1);

    protected abstract boolean isRelationshipsSF(EObject var1);

    private void removedKeyAttribute(ContainerManagedEntity containerManagedEntity, CMPAttribute cMPAttribute) {
        this.addedKeyAttribute(containerManagedEntity, cMPAttribute);
    }

    protected void addedKeyAttribute(ContainerManagedEntity containerManagedEntity, CMPAttribute cMPAttribute) {
        CommonRelationshipRole commonRelationshipRole;
        CommonRelationshipRole commonRelationshipRole2 = this.getRole(containerManagedEntity);
        if (commonRelationshipRole2 != null && !commonRelationshipRole2.isForward() && (commonRelationshipRole = commonRelationshipRole2.getOppositeAsCommonRole()) != null) {
            commonRelationshipRole.reconcileAttributes();
        }
    }

    protected CommonRelationshipRole getRole(ContainerManagedEntity containerManagedEntity) {
        EList eList = this.getRelationship().getCommonRoles();
        if (eList.isEmpty()) {
            return null;
        }
        CommonRelationshipRole commonRelationshipRole = null;
        int n = 0;
        while (n < eList.size()) {
            commonRelationshipRole = (CommonRelationshipRole)eList.get(n);
            if (commonRelationshipRole.getSourceEntity() == containerManagedEntity) {
                return commonRelationshipRole;
            }
            ++n;
        }
        return commonRelationshipRole;
    }

    protected CommonRelationship getRelationship() {
        return (CommonRelationship)this.getTarget();
    }

    protected void reconcileRoleAttributes() {
        EList eList = this.getRelationship().getCommonRoles();
        if (eList.isEmpty()) {
            return;
        }
        CommonRelationshipRole commonRelationshipRole = null;
        int n = 0;
        while (n < eList.size()) {
            commonRelationshipRole = (CommonRelationshipRole)eList.get(n);
            commonRelationshipRole.reconcileAttributes();
            ++n;
        }
    }

    protected void added() {
        this.reconcileRoleAttributes();
    }

    protected void removed() {
        if (this.getRelationship().getCommonRoles().size() > 1) {
            this.getRelationship().getCommonRoles().remove(0);
        }
    }

    protected void addAdaptors(CommonRelationshipRole commonRelationshipRole) {
        this.removeAdaptors(commonRelationshipRole);
        commonRelationshipRole.eAdapters().add((Object)this);
        ContainerManagedEntity containerManagedEntity = commonRelationshipRole.getSourceEntity();
        if (containerManagedEntity != null) {
            containerManagedEntity.eAdapters().add((Object)this);
        }
    }

    protected void removeAdaptors(CommonRelationshipRole commonRelationshipRole) {
        commonRelationshipRole.eAdapters().remove((Object)this);
        ContainerManagedEntity containerManagedEntity = commonRelationshipRole.getSourceEntity();
        if (containerManagedEntity != null) {
            containerManagedEntity.eAdapters().remove((Object)this);
        }
    }

    protected void addedRole(CommonRelationshipRole commonRelationshipRole) {
        this.addAdaptors(commonRelationshipRole);
        if (this.getRelationship().eContainer() != null && this.rolesFullyReflected()) {
            this.reconcileRoleAttributes();
        }
    }

    protected boolean rolesFullyReflected() {
        EList eList = this.getRelationship().getCommonRoles();
        if (eList.isEmpty()) {
            return false;
        }
        CommonRelationshipRole commonRelationshipRole = null;
        int n = 0;
        while (n < eList.size()) {
            commonRelationshipRole = (CommonRelationshipRole)eList.get(n);
            if (commonRelationshipRole.getSourceEntity() == null) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected void removedRole(CommonRelationshipRole commonRelationshipRole) {
        this.removeAdaptors(commonRelationshipRole);
        if (this.getRelationship().eContainer() != null) {
            commonRelationshipRole.reconcileAttributes();
            this.reconcileRoleAttributes();
        }
    }

    public void setTarget(Notifier notifier) {
        if (notifier == null || notifier instanceof CommonRelationship) {
            super.setTarget(notifier);
        }
    }
}

