/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.common.impl;

import com.ibm.etools.application.Application;
import com.ibm.etools.j2ee.common.XMLResource;
import com.ibm.etools.xmi.helpers.CompatibilityXMIResourceImpl;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;

public abstract class XMLResourceImpl
extends CompatibilityXMIResourceImpl
implements XMLResource {
    protected static final String DEFAULT_VERSION = "1.0";
    protected static final String TO_STRING = "XMLResource, file = ";
    protected static final String READ_COUNT_TO_STRING = " R= ";
    protected static final String WRITE_COUNT_TO_STRING = " W= ";
    protected boolean isAlt = false;
    protected Application application;
    protected int readReferenceCount = 1;
    protected int editReferenceCount = 0;
    protected boolean isNew = true;
    protected String publicId;
    protected String systemId;
    protected String xmlVersion;

    public XMLResourceImpl(URI uRI) {
        super(uRI);
    }

    public XMLResourceImpl() {
    }

    public void access() {
        this.accessForWrite();
    }

    public void accessForRead() {
        this.checkDeleted();
        if (!this.isNew()) {
            ++this.readReferenceCount;
        }
        this.isNew = false;
    }

    public void accessForWrite() {
        this.checkDeleted();
        ++this.editReferenceCount;
        if (this.isNew) {
            --this.readReferenceCount;
        }
        this.isNew = false;
        if (!this.isTrackingModification()) {
            this.setTrackingModification(true);
        }
    }

    protected void checkDeleted() {
        if (this.getResourceSet() == null) {
            throw new RuntimeException("This resource has been deleted and can no longer be used.");
        }
    }

    protected void unloadIfNecessary() {
        if (this.getTotalReferenceCount() <= 0 || this.editReferenceCount <= 0 && this.isModified()) {
            this.unload();
        }
    }

    public Application getApplication() {
        return this.application;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public EObject getRootObject() {
        return (EObject)this.getContents().get(0);
    }

    public String getSystemId() {
        return this.systemId;
    }

    protected int getTotalReferenceCount() {
        return this.editReferenceCount + this.readReferenceCount;
    }

    public boolean isAlt() {
        return this.isAlt;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public boolean isReadOnly() {
        return this.editReferenceCount <= 0;
    }

    public boolean isShared() {
        return this.getTotalReferenceCount() > 1;
    }

    public boolean isSharedForWrite() {
        return this.editReferenceCount > 1;
    }

    public void preDelete() {
    }

    public void release() {
        this.releaseFromWrite();
    }

    public final void releaseFromRead() {
        this.doReleaseFromRead();
        this.unloadIfNecessary();
    }

    protected void doReleaseFromRead() {
        --this.readReferenceCount;
    }

    public final void releaseFromWrite() {
        this.doReleaseFromWrite();
        this.unloadIfNecessary();
    }

    protected void doReleaseFromWrite() {
        --this.editReferenceCount;
    }

    public void saveIfNecessary() throws Exception {
        if (!this.isSharedForWrite()) {
            this.save(Collections.EMPTY_MAP);
        }
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public void setIsAlt(boolean bl) {
        this.isAlt = bl;
    }

    public void setPublicId(String string) {
        String string2 = this.publicId;
        this.publicId = string;
        this.eNotify((Notification)new NotificationImpl(1, string2, string){

            public Object getFeature() {
                return XMLResource.META_PUBLIC_ID;
            }

            public Object getNotifier() {
                return XMLResourceImpl.this;
            }
        });
    }

    public void setSystemId(String string) {
        String string2 = this.systemId;
        this.systemId = string;
        this.eNotify((Notification)new NotificationImpl(1, string2, string){

            public Object getFeature() {
                return XMLResource.META_SYSTEM_ID;
            }

            public Object getNotifier() {
                return XMLResourceImpl.this;
            }
        });
    }

    public String toString() {
        return TO_STRING + this.getURI().toString() + READ_COUNT_TO_STRING + new Integer(this.readReferenceCount) + WRITE_COUNT_TO_STRING + new Integer(this.editReferenceCount);
    }

    public String getXMLVersion() {
        return this.xmlVersion;
    }

    public void setXMLVersion(String string) {
        this.xmlVersion = string;
    }

    public NotificationChain basicSetResourceSet(ResourceSet resourceSet, NotificationChain notificationChain) {
        if (resourceSet == null && this.resourceSet != null) {
            this.preDelete();
        }
        return super.basicSetResourceSet(resourceSet, notificationChain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void basicDoLoad(InputStream inputStream, Map map) throws IOException {
        boolean bl = this.isTrackingModification();
        try {
            if (bl) {
                this.setTrackingModification(false);
            }
            super.basicDoLoad(inputStream, map);
            Object var5_4 = null;
            if (!bl) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!bl) throw throwable;
            this.setTrackingModification(true);
            throw throwable;
        }
        this.setTrackingModification(true);
    }

    protected void doUnload() {
        if (this.isTrackingModification()) {
            this.setTrackingModification(false);
        }
        super.doUnload();
    }
}

