/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.xml;

import com.ibm.etools.j2ee.exception.WrappedRuntimeException;
import com.ibm.etools.j2ee.xml.bridge.XmlDocumentReader;
import com.ibm.etools.j2ee.xml.common.readers.MofXmlReadAdapter;
import com.ibm.etools.j2ee.xml.common.writers.MofXmlWriter;
import com.ibm.etools.j2ee.xml.nls.ResourceHandler;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Map;
import java.util.Vector;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.XMLSave;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public abstract class DeploymentDescriptorImportExport
implements XMLLoad,
XMLSave {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    protected Vector writeErrors;
    protected String xmlEncoding = "UTF-8";
    protected String xmlVersion = "1.0";

    protected EObject createRootObject(Element element, Resource resource) {
        EObject eObject = this.primCreateRootObject();
        resource.getContents().add((Object)eObject);
        this.createRootReadAdapter(eObject, element);
        return eObject;
    }

    protected abstract MofXmlReadAdapter createRootReadAdapter(EObject var1, Element var2);

    protected abstract MofXmlWriter createRootXmlWriter(EObject var1, Writer var2, int var3);

    public void export(String string, EObject eObject) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
        }
        catch (IOException iOException) {
            throw new RuntimeException(ResourceHandler.getString("could_not_create_file_EXC_", new Object[]{string}));
        }
        this.export(fileOutputStream, eObject);
        try {
            ((OutputStream)fileOutputStream).close();
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
        }
    }

    public byte[] exportToBytes(EObject eObject) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.export(byteArrayOutputStream, eObject);
        return byteArrayOutputStream.toByteArray();
    }

    public Vector getWriteErrors() {
        if (this.writeErrors == null) {
            this.writeErrors = new Vector();
        }
        return this.writeErrors;
    }

    public String getXmlEncoding() {
        return this.xmlEncoding;
    }

    public String getXmlVersion() {
        return this.xmlVersion;
    }

    public void handleIOException(IOException iOException) {
        throw new WrappedRuntimeException(ResourceHandler.getString("An_IO_Exception_occurred_w_EXC_"), iOException);
    }

    public boolean hasWriteErrors() {
        return this.writeErrors != null && !this.writeErrors.isEmpty();
    }

    public abstract EObject primCreateRootObject();

    public void export(OutputStream outputStream, EObject eObject) {
        OutputStreamWriter outputStreamWriter = null;
        String string = this.getXmlEncoding();
        if (string == null) {
            string = "UTF-8";
        }
        try {
            outputStreamWriter = new OutputStreamWriter(outputStream, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new WrappedRuntimeException(ResourceHandler.getString("unsupported_encoding_EXC_", new Object[]{string}));
        }
        MofXmlWriter mofXmlWriter = this.createRootXmlWriter(eObject, outputStreamWriter, 1);
        mofXmlWriter.setXmlEncoding(string);
        mofXmlWriter.setXmlVersion(this.getXmlVersion());
        mofXmlWriter.toXml(null);
        try {
            outputStreamWriter.flush();
            outputStream.flush();
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
        }
        if (mofXmlWriter.hasErrors()) {
            this.setWriteErrors(mofXmlWriter.getErrors());
        }
    }

    public EObject importFrom(InputStream inputStream, XMLResource xMLResource) {
        return this.importFrom(new InputSource(inputStream), xMLResource);
    }

    public EObject importFrom(InputSource inputSource, XMLResource xMLResource) {
        XmlDocumentReader xmlDocumentReader = this.createDocumentReader(inputSource);
        Document document = xmlDocumentReader.parseDocument();
        EObject eObject = this.createRootObject(document.getDocumentElement(), (Resource)xMLResource);
        return eObject;
    }

    protected XmlDocumentReader createDocumentReader(InputSource inputSource) {
        return new XmlDocumentReader(inputSource);
    }

    public void setWriteErrors(Vector vector) {
        this.writeErrors = vector;
    }

    public void setXmlEncoding(String string) {
        this.xmlEncoding = string;
    }

    public void setXmlVersion(String string) {
        this.xmlVersion = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(XMLResource xMLResource, InputStream inputStream, Map map) throws IOException {
        try {
            MofXmlReadAdapter.setCurrentResource(xMLResource);
            this.importFrom(inputStream, xMLResource);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            MofXmlReadAdapter.setCurrentResource(null);
            throw throwable;
        }
        MofXmlReadAdapter.setCurrentResource(null);
    }

    public void save(XMLResource xMLResource, OutputStream outputStream, Map map) throws IOException {
        this.setXmlEncoding(xMLResource.getEncoding());
        this.export(outputStream, ((com.ibm.etools.j2ee.common.XMLResource)xMLResource).getRootObject());
        xMLResource.setModified(false);
    }
}

