/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.xml.bridge;

import com.ibm.etools.j2ee.xml.bridge.nls.ResourceHandler;
import com.ibm.etools.logger.proxy.Logger;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class GeneralXmlDocumentReader {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    protected InputSource inputSource;
    protected EntityResolver entityResolver;
    protected ErrorHandler errorHandler;
    protected boolean doValidate = false;
    protected boolean doAllowJavaEncodings = false;

    public GeneralXmlDocumentReader() {
    }

    public GeneralXmlDocumentReader(InputSource inputSource) {
        this.setInputSource(inputSource);
    }

    public GeneralXmlDocumentReader(InputSource inputSource, EntityResolver entityResolver, ErrorHandler errorHandler) {
        this.setInputSource(inputSource);
        this.setEntityResolver(entityResolver);
        this.setErrorHandler(errorHandler);
    }

    protected EntityResolver createDefaultEntityResolver() {
        return null;
    }

    protected ErrorHandler createDefaultErrorHandler() {
        return new ErrorHandler(){

            public void error(SAXParseException sAXParseException) throws SAXException {
                throw sAXParseException;
            }

            public void fatalError(SAXParseException sAXParseException) throws SAXException {
                throw sAXParseException;
            }

            public void warning(SAXParseException sAXParseException) throws SAXException {
                Logger.getLogger().logWarning((Throwable)sAXParseException);
            }
        };
    }

    protected DocumentBuilder createNewDOMParser() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            this.setFeatures(documentBuilderFactory);
            return documentBuilderFactory.newDocumentBuilder();
        }
        catch (Exception exception) {
            this.handleException(ResourceHandler.getString("failed_instantiating_EXC_", new Object[]{"Failed to instantiate parser"}), exception);
            return null;
        }
    }

    public boolean doAllowJavaEncodings() {
        return this.doAllowJavaEncodings;
    }

    public boolean doValidate() {
        return this.doValidate;
    }

    public ClassLoader getClassLoader() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    public Document getDocument() {
        return this.parseDocument();
    }

    protected Document getDocument(DocumentBuilder documentBuilder) {
        return documentBuilder.newDocument();
    }

    public EntityResolver getEntityResolver() {
        if (this.entityResolver == null) {
            this.entityResolver = this.createDefaultEntityResolver();
        }
        return this.entityResolver;
    }

    public ErrorHandler getErrorHandler() {
        if (this.errorHandler == null) {
            this.errorHandler = this.createDefaultErrorHandler();
        }
        return this.errorHandler;
    }

    public InputSource getInputSource() {
        return this.inputSource;
    }

    protected void handleException(String string, Throwable throwable) {
        if (throwable instanceof InvocationTargetException) {
            InvocationTargetException invocationTargetException = (InvocationTargetException)throwable;
            if (invocationTargetException.getTargetException() != null) {
                this.handleException(string, invocationTargetException.getTargetException());
            }
        } else {
            this.primHandleException(string, throwable);
        }
    }

    protected Document parse(DocumentBuilder documentBuilder, InputSource inputSource) {
        try {
            return documentBuilder.parse(inputSource);
        }
        catch (SAXException sAXException) {
            this.handleException(ResourceHandler.getString("failed_instantiating_EXC_", new Object[]{"SAX Parser error"}), sAXException);
        }
        catch (IOException iOException) {
            this.handleException(ResourceHandler.getString("failed_instantiating_EXC_", new Object[]{"IO Exception on input stream"}), iOException);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document parseDocument() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            DocumentBuilder documentBuilder = this.createNewDOMParser();
            this.setEntityResolver(documentBuilder);
            this.setErrorHandler(documentBuilder);
            Document document = this.parse(documentBuilder, this.getInputSource());
            Object var5_4 = null;
            Thread.currentThread().setContextClassLoader(classLoader);
            return document;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            Thread.currentThread().setContextClassLoader(classLoader);
            throw throwable;
        }
    }

    protected void primHandleException(String string, Throwable throwable) {
        Logger.getLogger().logError(throwable);
        throw new RuntimeException(string);
    }

    public void setAllowJavaEncodings(boolean bl) {
        this.doAllowJavaEncodings = bl;
    }

    protected void setEntityResolver(DocumentBuilder documentBuilder) {
        if (this.getEntityResolver() != null) {
            documentBuilder.setEntityResolver(this.getEntityResolver());
        }
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    protected void setErrorHandler(DocumentBuilder documentBuilder) {
        if (this.getErrorHandler() != null) {
            documentBuilder.setErrorHandler(this.getErrorHandler());
        }
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    protected void setFeatures(DocumentBuilderFactory documentBuilderFactory) {
        try {
            documentBuilderFactory.setValidating(this.doValidate());
            documentBuilderFactory.setAttribute("http://apache.org/xml/features/allow-java-encodings", new Boolean(this.doAllowJavaEncodings()));
            documentBuilderFactory.setExpandEntityReferences(true);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void setInputSource(InputSource inputSource) {
        this.inputSource = inputSource;
    }

    public void setValidate(boolean bl) {
        this.doValidate = bl;
    }
}

