/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.xml.client.writers;

import com.ibm.etools.client.ApplicationClient;
import com.ibm.etools.j2ee.exception.WrappedRuntimeException;
import com.ibm.etools.j2ee.xml.client.writers.IconXmlWriter;
import com.ibm.etools.j2ee.xml.common.writers.EjbRefXmlWriter;
import com.ibm.etools.j2ee.xml.common.writers.EnvEntryXmlWriter;
import com.ibm.etools.j2ee.xml.common.writers.MofXmlWriter;
import com.ibm.etools.j2ee.xml.common.writers.MofXmlWriterFactory;
import com.ibm.etools.j2ee.xml.common.writers.MofXmlWriterImpl;
import com.ibm.etools.j2ee.xml.common.writers.ResourceEnvRefXmlWriter;
import com.ibm.etools.j2ee.xml.common.writers.ResourceRefXmlWriter;
import com.ibm.etools.j2ee.xml.nls.ResourceHandler;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.eclipse.emf.ecore.EObject;

public class ApplicationClientXmlWriter
extends MofXmlWriterImpl {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    public static final String CALLBACK_HANDLER = "callback-handler";

    public ApplicationClientXmlWriter() {
    }

    public ApplicationClientXmlWriter(EObject eObject, Writer writer, int n) {
        super(eObject, writer, n);
    }

    public ApplicationClient getApplicationClient() {
        return (ApplicationClient)this.getObject();
    }

    public String getDefaultDocumentTypeName() {
        return "application-client";
    }

    public MofXmlWriterFactory getEjbRefXmlWriterFactory() {
        return new MofXmlWriterFactory(){

            public MofXmlWriter create(EObject eObject) {
                return new EjbRefXmlWriter(eObject, ApplicationClientXmlWriter.this.getWriter(), ApplicationClientXmlWriter.this.getNestLevel() + 1);
            }
        };
    }

    public MofXmlWriterFactory getEnvEntryXmlWriterFactory() {
        return new MofXmlWriterFactory(){

            public MofXmlWriter create(EObject eObject) {
                return new EnvEntryXmlWriter(eObject, ApplicationClientXmlWriter.this.getWriter(), ApplicationClientXmlWriter.this.getNestLevel() + 1, false);
            }
        };
    }

    public MofXmlWriterFactory getResourceEnvRefXmlWriterFactory() {
        return new MofXmlWriterFactory(){

            public MofXmlWriter create(EObject eObject) {
                return new ResourceEnvRefXmlWriter(eObject, ApplicationClientXmlWriter.this.getWriter(), ApplicationClientXmlWriter.this.getNestLevel() + 1);
            }
        };
    }

    public MofXmlWriterFactory getResourceRefXmlWriterFactory() {
        return new MofXmlWriterFactory(){

            public MofXmlWriter create(EObject eObject) {
                return new ResourceRefXmlWriter(eObject, ApplicationClientXmlWriter.this.getWriter(), ApplicationClientXmlWriter.this.getNestLevel() + 1, 2);
            }
        };
    }

    public String getTagName() {
        return "application-client";
    }

    public void toXml(MofXmlWriter mofXmlWriter) {
        this.writeHeader();
        super.toXml(mofXmlWriter);
        try {
            this.getWriter().flush();
        }
        catch (IOException iOException) {
            throw new WrappedRuntimeException(ResourceHandler.getString("An_Exception_occurred_whil_EXC_"), iOException);
        }
    }

    public void writeData() {
        ApplicationClient applicationClient = this.getApplicationClient();
        this.writeIcon();
        this.writeRequiredAttribute("display-name", applicationClient.getDisplayName());
        this.writeDescription(applicationClient.getDescription());
        this.writeEnvEntries();
        this.writeEjbRefs();
        this.writeResourceRefs();
        this.writeResourceEnvRefs();
        this.writeOptionalAttribute(CALLBACK_HANDLER, applicationClient.getCallbackHandlerClassName());
    }

    public void writeDefaultDocumentType() {
        this.writeDocumentType(this.getDefaultDocumentTypeName(), "-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.3//EN", "http://java.sun.com/dtd/application-client_1_3.dtd");
    }

    public void writeEjbRefs() {
        this.writeList((List)this.getApplicationClient().getEjbReferences(), this.getEjbRefXmlWriterFactory());
    }

    public void writeEnvEntries() {
        this.writeList((List)this.getApplicationClient().getEnvironmentProps(), this.getEnvEntryXmlWriterFactory());
    }

    public void writeIcon() {
        if (this.getApplicationClient().getLargeIcon() != null && this.getApplicationClient().getSmallIcon() != null) {
            new IconXmlWriter(this.getObject(), this.getWriter(), this.getNestLevel() + 1).toXml(this);
        }
    }

    public void writeResourceEnvRefs() {
        this.writeList((List)this.getApplicationClient().getResourceEnvRefs(), this.getResourceEnvRefXmlWriterFactory());
    }

    public void writeResourceRefs() {
        this.writeList((List)this.getApplicationClient().getResourceRefs(), this.getResourceRefXmlWriterFactory());
    }
}

