/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.xml.common.readers;

import com.ibm.etools.j2ee.common.CommonPackage;
import com.ibm.etools.j2ee.common.ResAuthTypeBase;
import com.ibm.etools.j2ee.common.ResourceRef;
import com.ibm.etools.j2ee.xml.common.readers.MofXmlReadAdapter;
import java.util.ArrayList;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.w3c.dom.Element;

public class ResourceRefXmlReadAdapter
extends MofXmlReadAdapter {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    public static final int WEB = 0;
    public static final int EJB = 1;
    public static final int CLIENT = 2;
    protected int context;

    public ResourceRefXmlReadAdapter(Notifier notifier, Element element, int n) {
        super(notifier, element);
        this.context = n;
    }

    public ResourceRef getResourceRef() {
        return (ResourceRef)this.getTarget();
    }

    public void reflectElement(Element element) {
        String string = element.getTagName();
        ResourceRef resourceRef = this.getResourceRef();
        if (string.equals("description")) {
            resourceRef.setDescription(this.getText(element));
        } else if (string.equals("res-ref-name")) {
            resourceRef.setName(this.getText(element));
        } else if (string.equals("res-type")) {
            resourceRef.setType(this.getText(element));
        } else if (string.equals("res-auth")) {
            this.setAuth(this.getText(element));
        } else if (string.equals("res-sharing-scope")) {
            this.setResSharingScope(this.getText(element));
        } else {
            super.reflectElement(element);
        }
    }

    public void setAuth(String string) {
        try {
            CommonPackage commonPackage = this.getCommonPackage();
            this.setDefaultEnumValue(this.getResourceRef(), (EStructuralFeature)commonPackage.getResourceRef_Auth(), commonPackage.getResAuthTypeBase(), string);
        }
        catch (RuntimeException runtimeException) {
            ArrayList<String> arrayList = new ArrayList<String>();
            switch (this.context) {
                case 0: {
                    arrayList.add(ResAuthTypeBase.CONTAINER_LITERAL.toString());
                    arrayList.add(ResAuthTypeBase.SERVLET_LITERAL.toString());
                }
            }
            arrayList.add(ResAuthTypeBase.APPLICATION_LITERAL.toString());
            arrayList.add(ResAuthTypeBase.CONTAINER_LITERAL.toString());
            this.handleEnumerationException("res-auth", arrayList, string);
        }
    }

    public void setResSharingScope(String string) {
        try {
            CommonPackage commonPackage = this.getCommonPackage();
            this.setDefaultEnumValue(this.getResourceRef(), (EStructuralFeature)commonPackage.getResourceRef_ResSharingScope(), commonPackage.getResSharingScopeType(), string);
        }
        catch (RuntimeException runtimeException) {
            this.handleEnumerationException("res-sharing-scope", this.getCommonPackage().getResSharingScopeType(), string);
        }
    }
}

