/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.xml.common.writers;

import com.ibm.etools.emf.ecore.utilities.IDUtil;
import com.ibm.etools.encoders.XMLValueEncoderDecoder;
import com.ibm.etools.j2ee.xml.DeploymentDescriptorXmlMapperI;
import com.ibm.etools.j2ee.xml.MissingRequiredDataException;
import com.ibm.etools.j2ee.xml.common.writers.MofXmlWriter;
import com.ibm.etools.j2ee.xml.common.writers.MofXmlWriterFactory;
import com.ibm.etools.j2ee.xml.nls.ResourceHandler;
import com.ibm.etools.wft.util.Revisit;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;

public abstract class MofXmlWriterImpl
implements MofXmlWriter,
DeploymentDescriptorXmlMapperI {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private Writer writer;
    private EObject object;
    private static String pad = "   ";
    private int nestLevel;
    private Vector errors;
    private static String lineSeparator = System.getProperty("line.separator");
    private String xmlEncoding = "UTF-8";
    private String xmlVersion = "1.0";

    public MofXmlWriterImpl() {
    }

    public MofXmlWriterImpl(EObject eObject, Writer writer, int n) {
        this.setObject(eObject);
        this.setWriter(writer);
        this.setNestLevel(n);
    }

    public void addError(Throwable throwable) {
        this.getErrors().addElement(throwable);
    }

    public void addErrorMissingRequiredElement(String string) {
        String string2 = '<' + string + '>';
        String string3 = ResourceHandler.getString("empty_collection_EXC_", new Object[]{string2, this.getObject()});
        this.addError(new MissingRequiredDataException(string3));
    }

    public void addErrorMissingRequiredField(String string) {
        String string2 = '<' + string + '>';
        String string3 = ResourceHandler.getString("missing_req_field_EXC_", new Object[]{string2, this.getObject()});
        this.addError(new MissingRequiredDataException(string3));
    }

    public void addErrors(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.addError((Throwable)enumeration.nextElement());
        }
    }

    public void basicWriteBeginTag(String string) {
        this.write(60);
        this.write(string);
        this.write(62);
    }

    public abstract String getDefaultDocumentTypeName();

    public Vector getErrors() {
        if (this.errors == null) {
            this.setErrors(new Vector());
        }
        return this.errors;
    }

    public String getID() {
        EObject eObject = this.getObject();
        com.ibm.etools.j2ee.common.XMLResource xMLResource = (com.ibm.etools.j2ee.common.XMLResource)eObject.eResource();
        IDUtil.getOrAssignID((EObject)eObject, (XMLResource)xMLResource);
        String string = xMLResource.getID(eObject);
        if (string == null || string.length() == 0) {
            return null;
        }
        return string;
    }

    public int getNestLevel() {
        return this.nestLevel;
    }

    public EObject getObject() {
        return this.object;
    }

    public static String getPad() {
        return pad;
    }

    public abstract String getTagName();

    public Writer getWriter() {
        return this.writer;
    }

    public String getXmlEncoding() {
        return this.xmlEncoding;
    }

    public String getXmlVersion() {
        return this.xmlVersion;
    }

    public void handleException(Exception exception) {
        Revisit.revisit();
        this.addError(exception);
    }

    public boolean hasErrors() {
        return this.errors != null && !this.errors.isEmpty();
    }

    public void newline() {
        this.write(lineSeparator);
    }

    public void setErrors(Vector vector) {
        this.errors = vector;
    }

    public void setNestLevel(int n) {
        this.nestLevel = n;
    }

    public void setObject(EObject eObject) {
        this.object = eObject;
    }

    public static void setPad(String string) {
        pad = string;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public void setXmlEncoding(String string) {
        this.xmlEncoding = string;
    }

    public void setXmlVersion(String string) {
        this.xmlVersion = string;
    }

    public void toXml(MofXmlWriter mofXmlWriter) {
        this.writeBeginTag();
        try {
            this.writeData();
        }
        catch (MissingRequiredDataException missingRequiredDataException) {
            Revisit.revisit();
            this.addError(missingRequiredDataException);
        }
        this.writeEndTag();
        if (this.hasErrors() && mofXmlWriter != null) {
            mofXmlWriter.addErrors(this.getErrors());
        }
    }

    public String toXmlString(EObject eObject) {
        this.setObject(eObject);
        this.setNestLevel(0);
        StringWriter stringWriter = new StringWriter();
        this.setWriter(stringWriter);
        this.toXml(null);
        return this.writer.toString();
    }

    public void write(int n) {
        try {
            this.writer.write(n);
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
    }

    public void write(String string) {
        try {
            this.writer.write(string);
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
    }

    public void writeArray(EObject[] eObjectArray, MofXmlWriterFactory mofXmlWriterFactory) {
        int n = 0;
        while (n < eObjectArray.length) {
            mofXmlWriterFactory.create(eObjectArray[n]).toXml(this);
            ++n;
        }
    }

    public void writeAttribute(String string, String string2) {
        this.writeBeginTagAttribute(string);
        this.write(XMLValueEncoderDecoder.escape((String)string2));
        this.writeEndTag(string);
    }

    public void writeAttribute(String string, boolean bl) {
        String string2 = bl ? "True" : "False";
        this.writeAttribute(string, string2);
    }

    public void writeBeginTag() {
        String string = this.getID();
        String string2 = this.getTagName();
        String string3 = null;
        this.writePad();
        string3 = string == null ? string2 : string2 + " id=\"" + string + "\"";
        this.basicWriteBeginTag(string3);
        this.newline();
    }

    public void writeBeginTag(String string) {
        this.writePad();
        this.basicWriteBeginTag(string);
    }

    public void writeBeginTagAttribute(String string) {
        this.writePadAttribute();
        this.basicWriteBeginTag(string);
    }

    public void writeBeginTagAttributeNewLine(String string) {
        this.writePadAttribute();
        this.basicWriteBeginTag(string);
        this.newline();
    }

    public abstract void writeData();

    public abstract void writeDefaultDocumentType();

    public void writeDescription(String string) {
        this.writeOptionalAttribute("description", string);
    }

    public void writeDocumentHeader() {
        this.write("<?xml version=\"" + this.getXmlVersion() + "\" encoding=\"" + this.getXmlEncoding() + "\"?>");
        this.newline();
        this.writeDocumentType();
        this.newline();
    }

    public void writeDocumentType() {
        Resource resource = this.getObject().eResource();
        com.ibm.etools.j2ee.common.XMLResource xMLResource = (com.ibm.etools.j2ee.common.XMLResource)resource;
        String string = xMLResource.getPublicId();
        String string2 = xMLResource.getSystemId();
        if (string != null && string2 != null) {
            this.writeDocumentType(this.getDefaultDocumentTypeName(), string, string2);
        } else {
            this.writeDefaultDocumentType();
        }
    }

    public void writeDocumentType(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<!DOCTYPE ");
        stringBuffer.append(string);
        stringBuffer.append(" PUBLIC \"");
        stringBuffer.append(string2);
        stringBuffer.append("\" \"");
        stringBuffer.append(string3);
        stringBuffer.append("\">");
        this.write(stringBuffer.toString());
        this.newline();
    }

    public void writeEmptyAttribute(String string) {
        this.writeBeginTagAttribute(string);
        this.writeEndTag(string);
    }

    public void writeEmptyAttribute(String string, boolean bl) {
        if (bl) {
            this.writeEmptyAttribute(string);
        }
    }

    public void writeEndTag() {
        this.writePad();
        this.writeEndTag(this.getTagName());
    }

    public void writeEndTag(String string) {
        this.write("</");
        this.write(string);
        this.write(62);
        this.newline();
    }

    public void writeEndTagAttribute(String string) {
        this.writePadAttribute();
        this.writeEndTag(string);
    }

    public void writeEndTagAttributeNewLine(String string) {
        this.newline();
        this.writePadAttribute();
        this.writeEndTag(string);
    }

    public void writeEndTagNewLine(String string) {
        this.newline();
        this.writePad();
        this.writeEndTag(string);
    }

    public void writeHeader() {
        this.writeDocumentHeader();
    }

    public void writeList(List list, MofXmlWriterFactory mofXmlWriterFactory) {
        int n = 0;
        while (n < list.size()) {
            mofXmlWriterFactory.create((EObject)list.get(n)).toXml(this);
            ++n;
        }
    }

    public void writeMultipleAttributes(String string, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            this.writeAttribute(string, stringArray[n]);
            ++n;
        }
    }

    public void writeMultipleAttributes(String string, List list) {
        if (list == null || list.size() == 0) {
            return;
        }
        int n = 0;
        while (n < list.size()) {
            this.writeAttribute(string, (String)list.get(n));
            ++n;
        }
    }

    public void writeOptionalAttribute(String string, Object object) {
        if (object == null) {
            return;
        }
        this.writeAttribute(string, object.toString());
    }

    public void writeOptionalAttribute(String string, String string2) {
        if (string2 == null) {
            return;
        }
        this.writeAttribute(string, string2);
    }

    public void writePad() {
        this.writePad(this.getNestLevel());
    }

    public void writePad(int n) {
        try {
            int n2 = 0;
            while (n2 < n) {
                this.writer.write(MofXmlWriterImpl.getPad());
                ++n2;
            }
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
    }

    public void writePadAttribute() {
        this.writePad(this.getNestLevel() + 1);
    }

    public void writeRequiredArray(String string, EObject[] eObjectArray, MofXmlWriterFactory mofXmlWriterFactory) {
        if (eObjectArray == null || eObjectArray.length == 0) {
            this.addErrorMissingRequiredElement(string);
            return;
        }
        this.writeArray(eObjectArray, mofXmlWriterFactory);
    }

    public void writeRequiredAttribute(String string, Object object) {
        if (object == null) {
            Revisit.revisit();
            this.addErrorMissingRequiredField(string);
            return;
        }
        this.writeRequiredAttribute(string, object.toString());
    }

    public void writeRequiredAttribute(String string, String string2) {
        if (string2 == null) {
            Revisit.revisit();
            this.addErrorMissingRequiredField(string);
            return;
        }
        this.writeAttribute(string, string2);
    }

    public void writeRequiredList(String string, List list, MofXmlWriterFactory mofXmlWriterFactory) {
        if (list == null || list.size() == 0) {
            this.addErrorMissingRequiredElement(string);
            return;
        }
        this.writeList(list, mofXmlWriterFactory);
    }

    public void writeRequiredMultipleAttributes(String string, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            this.addErrorMissingRequiredElement(string);
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            this.writeAttribute(string, stringArray[n]);
            ++n;
        }
    }

    public void writeRequiredValue(String string) {
        if (string == null) {
            Revisit.revisit();
            this.addErrorMissingRequiredField(this.getTagName());
            return;
        }
        this.write(XMLValueEncoderDecoder.escape((String)string));
    }
}

