/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.xml.ear.readers;

import com.ibm.etools.application.Application;
import com.ibm.etools.application.Module;
import com.ibm.etools.j2ee.common.SecurityRole;
import com.ibm.etools.j2ee.xml.common.readers.SecurityRoleXmlReadAdapter;
import com.ibm.etools.j2ee.xml.ear.readers.ConnectorModuleXmlReadAdapter;
import com.ibm.etools.j2ee.xml.ear.readers.EarDeploymentDescriptorReadAdapter;
import com.ibm.etools.j2ee.xml.ear.readers.EjbModuleXmlReadAdapter;
import com.ibm.etools.j2ee.xml.ear.readers.JavaModuleXmlReadAdapter;
import com.ibm.etools.j2ee.xml.ear.readers.WebModuleXmlReadAdapter;
import java.util.Enumeration;
import org.eclipse.emf.common.notify.Notifier;
import org.w3c.dom.Element;

public class ApplXmlReadAdapter
extends EarDeploymentDescriptorReadAdapter {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";

    public ApplXmlReadAdapter(Notifier notifier, Element element) {
        super(notifier, element);
    }

    public Application getAppl() {
        return (Application)this.getTarget();
    }

    public void reflectElement(Element element) {
        String string = element.getTagName();
        if (string.equals("icon")) {
            this.reflectIcon(element);
        } else if (string.equals("display-name")) {
            this.getAppl().setDisplayName(this.getText(element));
        } else if (string.equals("description")) {
            this.getAppl().setDescription(this.getText(element));
        } else if (string.equals("module")) {
            this.reflectModule(element);
        } else if (string.equals("security-role")) {
            this.reflectSecurityRole(element);
        } else {
            super.reflectElement(element);
        }
    }

    public void reflectIcon(Element element) {
        Enumeration enumeration = this.getChildElementsFrom(element);
        while (enumeration.hasMoreElements()) {
            this.reflectIconElement((Element)enumeration.nextElement());
        }
    }

    public void reflectIconElement(Element element) {
        String string = element.getTagName();
        if (string.equals("small-icon")) {
            this.getAppl().setSmallIcon(this.getText(element));
        } else if (string.equals("large-icon")) {
            this.getAppl().setLargeIcon(this.getText(element));
        }
    }

    public void reflectModule(Element element) {
        Module module = null;
        if (this.getChild("ejb", element) != null) {
            module = this.getApplFactory().createEjbModule();
            new EjbModuleXmlReadAdapter((Notifier)module, element);
        } else if (this.getChild("java", element) != null) {
            module = this.getApplFactory().createJavaClientModule();
            new JavaModuleXmlReadAdapter((Notifier)module, element);
        } else if (this.getChild("web", element) != null) {
            module = this.getApplFactory().createWebModule();
            new WebModuleXmlReadAdapter((Notifier)module, element);
        } else if (this.getChild("connector", element) != null) {
            module = this.getApplFactory().createConnectorModule();
            new ConnectorModuleXmlReadAdapter((Notifier)module, element);
        }
        this.getAppl().getModules().add((Object)module);
        this.assignID(module);
    }

    public void reflectSecurityRole(Element element) {
        SecurityRole securityRole = this.getCommonFactory().createSecurityRole();
        this.getAppl().getSecurityRoles().add((Object)securityRole);
        new SecurityRoleXmlReadAdapter((Notifier)securityRole, element);
    }

    public String getDefaultID() {
        return "Application_ID";
    }

    protected boolean isRoot() {
        return true;
    }
}

