/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.xml.ear.writers;

import com.ibm.etools.application.Application;
import com.ibm.etools.j2ee.exception.WrappedRuntimeException;
import com.ibm.etools.j2ee.xml.common.writers.IconXmlWriter;
import com.ibm.etools.j2ee.xml.common.writers.MofXmlWriter;
import com.ibm.etools.j2ee.xml.common.writers.MofXmlWriterFactory;
import com.ibm.etools.j2ee.xml.common.writers.SecurityRoleXmlWriter;
import com.ibm.etools.j2ee.xml.ear.writers.EarDeploymentDescriptorXmlWriter;
import com.ibm.etools.j2ee.xml.ear.writers.ModuleXmlWriter;
import com.ibm.etools.j2ee.xml.nls.ResourceHandler;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class ApplXmlWriter
extends EarDeploymentDescriptorXmlWriter {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";

    public ApplXmlWriter() {
    }

    public ApplXmlWriter(EObject eObject, Writer writer, int n) {
        super(eObject, writer, n);
    }

    public Application getAppl() {
        return (Application)this.getObject();
    }

    public MofXmlWriterFactory getSecurityRoleXmlWriterFactory() {
        return new MofXmlWriterFactory(){

            public MofXmlWriter create(EObject eObject) {
                return new SecurityRoleXmlWriter(eObject, ApplXmlWriter.this.getWriter(), ApplXmlWriter.this.getNestLevel() + 1);
            }
        };
    }

    public String getTagName() {
        return "application";
    }

    public void toXml(MofXmlWriter mofXmlWriter) {
        this.writeHeader();
        super.toXml(mofXmlWriter);
        try {
            this.getWriter().flush();
        }
        catch (IOException iOException) {
            throw new WrappedRuntimeException(ResourceHandler.getString("An_Exception_occurred_whil_EXC_"), iOException);
        }
    }

    public void writeData() {
        Application application = this.getAppl();
        this.writeIcon();
        String string = application.getDisplayName() == null ? "" : application.getDisplayName();
        this.writeRequiredAttribute("display-name", string);
        this.writeDescription(application.getDescription());
        this.writeModules();
        this.writeSecurityRoles();
    }

    public void writeHeader() {
        super.writeDocumentHeader();
    }

    public void writeIcon() {
        if (this.getAppl().getLargeIcon() != null || this.getAppl().getSmallIcon() != null) {
            new IconXmlWriter(this.getObject(), this.getWriter(), this.getNestLevel() + 1).toXml(this);
        }
    }

    public void writeModules() {
        EList eList = this.getAppl().getModules();
        int n = 0;
        while (n < eList.size()) {
            new ModuleXmlWriter((EObject)eList.get(n), this.getWriter(), this.getNestLevel() + 1).toXml(this);
            ++n;
        }
    }

    public void writeSecurityRoles() {
        this.writeList((List)this.getAppl().getSecurityRoles(), this.getSecurityRoleXmlWriterFactory());
    }
}

