/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.xml.ejb.readers;

import com.ibm.etools.ejb.CMPAttribute;
import com.ibm.etools.ejb.ContainerManagedEntity;
import com.ibm.etools.ejb.EjbPackage;
import com.ibm.etools.ejb.Query;
import com.ibm.etools.ejb.util.CMPSpecAdapter;
import com.ibm.etools.j2ee.xml.ejb.readers.EntityXmlReadAdapter;
import com.ibm.etools.j2ee.xml.ejb.readers.QueryXmlReadAdapter;
import com.ibm.etools.java.JavaClass;
import com.ibm.etools.java.JavaRefPackage;
import com.ibm.etools.java.JavaURL;
import com.ibm.etools.wft.util.Revisit;
import java.util.Enumeration;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class ContainerManagedEntityXmlReadAdapter
extends EntityXmlReadAdapter {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";

    public ContainerManagedEntityXmlReadAdapter(Notifier notifier, Element element) {
        super(notifier, element);
    }

    protected JavaClass createJavaClassRef(String string) {
        JavaClass javaClass = ((JavaRefPackage)EPackage.Registry.INSTANCE.getEPackage("java.xmi")).getJavaRefFactory().createJavaClass();
        JavaURL javaURL = new JavaURL(string);
        ((InternalEObject)javaClass).eSetProxyURI(URI.createURI((String)javaURL.getFullString()));
        return javaClass;
    }

    public ContainerManagedEntity getCMPEntity() {
        return (ContainerManagedEntity)this.getEntity();
    }

    public void reflectCmpField(Element element) {
        ContainerManagedEntity containerManagedEntity = (ContainerManagedEntity)this.getTarget();
        Enumeration enumeration = this.getChildElementsFrom(element);
        while (enumeration.hasMoreElements()) {
            Element element2 = (Element)enumeration.nextElement();
            String string = element2.getTagName();
            if (string.equals("field-name")) {
                CMPAttribute cMPAttribute = containerManagedEntity.addPersistentAttributeName(this.getText(element2));
                Attr attr = element.getAttributeNode("id");
                if (attr != null) {
                    ((XMIResource)cMPAttribute.eResource()).setID((EObject)cMPAttribute, attr.getValue());
                }
                if (!this.getText(element2).equals("wasGenUnknownkeyValue")) continue;
                this.updateGeneratedKeyField();
                continue;
            }
            if (!string.equals("description")) continue;
            Revisit.revisit();
        }
    }

    public void reflectElement(Element element) {
        String string = element.getTagName();
        ContainerManagedEntity containerManagedEntity = this.getCMPEntity();
        if (string.equals("cmp-field")) {
            this.reflectCmpField(element);
        } else if (string.equals("primkey-field")) {
            this.reflectPrimaryKeyField(element);
        } else if (string.equals("cmp-version")) {
            containerManagedEntity.setVersion(this.getText(element));
        } else if (string.equals("abstract-schema-name")) {
            containerManagedEntity.setAbstractSchemaName(this.getText(element));
        } else if (string.equals("query")) {
            this.reflectQuery(element);
        } else {
            super.reflectElement(element);
        }
    }

    public void reflectPrimaryKeyField(Element element) {
        String string = this.getText(element);
        CMPAttribute cMPAttribute = this.getCMPEntity().addKeyAttributeName(string, false);
        EReference eReference = EjbPackage.eINSTANCE.getEntity_PrimaryKey();
        JavaClass javaClass = (JavaClass)((InternalEObject)this.getCMPEntity()).eGet((EStructuralFeature)eReference, false);
        cMPAttribute.setEType((EClassifier)javaClass);
        CMPSpecAdapter.setPrimKeyFieldFromXml(string, this.getCMPEntity());
    }

    public void reflectPrimaryKeyName(Element element) {
        ContainerManagedEntity containerManagedEntity = (ContainerManagedEntity)this.getEntity();
        String string = this.getText(element);
        if (string.equals("java.lang.Object")) {
            string = "com.ibm.ws.ejbpersistence.dataaccess.GeneratedStringPK";
            containerManagedEntity.setPrimaryKeyName(string);
            this.updateGeneratedKeyField();
        } else {
            containerManagedEntity.setPrimaryKeyName(string);
        }
    }

    public void reflectQuery(Element element) {
        Query query = this.getEjbFactory().createQuery();
        new QueryXmlReadAdapter((Notifier)query, element);
        this.getCMPEntity().getQueries().add((Object)query);
    }

    public void updateGeneratedKeyField() {
        ContainerManagedEntity containerManagedEntity = (ContainerManagedEntity)this.getEntity();
        Iterator iterator = containerManagedEntity.getPersistentAttributes().iterator();
        CMPAttribute cMPAttribute = null;
        String string = "wasGenUnknownkeyValue";
        while (iterator.hasNext()) {
            CMPAttribute cMPAttribute2 = (CMPAttribute)iterator.next();
            if (!cMPAttribute2.getName().equals(string)) continue;
            cMPAttribute = cMPAttribute2;
            break;
        }
        if (cMPAttribute == null) {
            cMPAttribute = containerManagedEntity.addPersistentAttributeName(string);
        }
        cMPAttribute.setEType((EClassifier)this.createJavaClassRef("java.lang.String"));
        containerManagedEntity.getKeyAttributes().add((Object)cMPAttribute);
    }
}

