/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.xml.ejb.readers;

import com.ibm.etools.ejb.AssemblyDescriptor;
import com.ibm.etools.ejb.EJBJar;
import com.ibm.etools.ejb.EjbPackage;
import com.ibm.etools.ejb.EnterpriseBean;
import com.ibm.etools.ejb.MethodElement;
import com.ibm.etools.ejb.MethodPermission;
import com.ibm.etools.ejb.MethodTransaction;
import com.ibm.etools.ejb.util.MethodElementHelper;
import com.ibm.etools.j2ee.xml.ejb.readers.EjbDeploymentDescriptorReadAdapter;
import java.util.Enumeration;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.w3c.dom.Element;

public class MethodElementXmlReadAdapter
extends EjbDeploymentDescriptorReadAdapter {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";

    public MethodElementXmlReadAdapter(Notifier notifier, Element element) {
        super(notifier, element);
    }

    public AssemblyDescriptor getAssemblyDescriptor() {
        MethodElement methodElement = this.getMethodElement();
        int n = MethodElementHelper.getContainedType(methodElement);
        switch (n) {
            case 1: {
                return ((MethodPermission)methodElement.eContainer()).getAssemblyDescriptor();
            }
            case 2: {
                return ((MethodTransaction)methodElement.eContainer()).getAssemblyDescriptor();
            }
            case 3: {
                return (AssemblyDescriptor)methodElement.eContainer().eContainer();
            }
        }
        return null;
    }

    public EJBJar getEjbJar() {
        return this.getAssemblyDescriptor().getEjbJar();
    }

    public MethodElement getMethodElement() {
        return (MethodElement)this.getTarget();
    }

    public void reflectElement(Element element) {
        String string = element.getTagName();
        MethodElement methodElement = this.getMethodElement();
        if (string.equals("description")) {
            methodElement.setDescription(this.getText(element));
        } else if (string.equals("ejb-name")) {
            EnterpriseBean enterpriseBean = this.getEjbJar().getEnterpriseBeanNamed(this.getText(element));
            if (enterpriseBean == null) {
                String string2 = "MethodElement references non-existent bean: " + this.getText(element) + " Method name:" + this.getText((Element)this.getElement().getElementsByTagName("method-name").item(0));
                throw new RuntimeException(string2);
            }
            methodElement.setEnterpriseBean(enterpriseBean);
        } else if (string.equals("method-intf")) {
            this.setType(this.getText(element));
        } else if (string.equals("method-name")) {
            methodElement.setName(this.getText(element));
        } else if (string.equals("method-params")) {
            this.reflectMethodParams(element);
        } else {
            super.reflectElement(element);
        }
    }

    public void reflectMethodParams(Element element) {
        Enumeration enumeration = this.getChildElementsFrom(element);
        if (!enumeration.hasMoreElements()) {
            this.getMethodElement().applyZeroParams();
        }
        while (enumeration.hasMoreElements()) {
            Element element2 = (Element)enumeration.nextElement();
            if (!element2.getTagName().equals("method-param")) continue;
            this.getMethodElement().addMethodParams(this.getText(element2));
        }
    }

    public void setType(String string) {
        try {
            EjbPackage ejbPackage = this.getEjbPackage();
            this.setDefaultEnumValue(this.getMethodElement(), (EStructuralFeature)ejbPackage.getMethodElement_Type(), ejbPackage.getMethodElementKind(), string);
        }
        catch (RuntimeException runtimeException) {
            this.handleEnumerationException("method-intf", this.getEjbPackage().getMethodElementKind(), string);
        }
    }
}

