/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.xml.ejb.writers;

import com.ibm.etools.ejb.AssemblyDescriptor;
import com.ibm.etools.ejb.ContainerManagedEntity;
import com.ibm.etools.ejb.EJBJar;
import com.ibm.etools.ejb.EnterpriseBean;
import com.ibm.etools.ejb.Entity;
import com.ibm.etools.ejb.MessageDriven;
import com.ibm.etools.ejb.Relationships;
import com.ibm.etools.ejb.Session;
import com.ibm.etools.j2ee.exception.WrappedRuntimeException;
import com.ibm.etools.j2ee.xml.common.writers.MofXmlWriter;
import com.ibm.etools.j2ee.xml.ejb.writers.AssemblyDescriptorXmlWriter;
import com.ibm.etools.j2ee.xml.ejb.writers.ContainerManagedEntityXmlWriter;
import com.ibm.etools.j2ee.xml.ejb.writers.EjbDeploymentDescriptorXmlWriter;
import com.ibm.etools.j2ee.xml.ejb.writers.EnterpriseBeanXmlWriter;
import com.ibm.etools.j2ee.xml.ejb.writers.EntityXmlWriter;
import com.ibm.etools.j2ee.xml.ejb.writers.MessageDrivenXmlWriter;
import com.ibm.etools.j2ee.xml.ejb.writers.RelationshipsXmlWriter;
import com.ibm.etools.j2ee.xml.ejb.writers.SessionXmlWriter;
import java.io.IOException;
import java.io.Writer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class EjbJarXmlWriter
extends EjbDeploymentDescriptorXmlWriter {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";

    public EjbJarXmlWriter() {
    }

    public EjbJarXmlWriter(EObject eObject, Writer writer, int n) {
        super(eObject, writer, n);
    }

    public EJBJar getEJBJar() {
        return (EJBJar)this.getObject();
    }

    public String getTagName() {
        return "ejb-jar";
    }

    public EnterpriseBeanXmlWriter getWriterFor(EnterpriseBean enterpriseBean) {
        Writer writer = this.getWriter();
        int n = this.getNestLevel() + 2;
        if (enterpriseBean instanceof MessageDriven) {
            return new MessageDrivenXmlWriter((EObject)enterpriseBean, writer, n);
        }
        if (enterpriseBean instanceof ContainerManagedEntity) {
            return new ContainerManagedEntityXmlWriter((EObject)enterpriseBean, writer, n);
        }
        if (enterpriseBean instanceof Entity) {
            return new EntityXmlWriter((EObject)enterpriseBean, writer, n);
        }
        if (enterpriseBean instanceof Session) {
            return new SessionXmlWriter((EObject)enterpriseBean, writer, n);
        }
        return null;
    }

    public void toXml(MofXmlWriter mofXmlWriter) {
        this.writeHeader();
        super.toXml(mofXmlWriter);
        try {
            this.getWriter().flush();
        }
        catch (IOException iOException) {
            throw new WrappedRuntimeException("An Exception occurred while writing xml", iOException);
        }
    }

    public void writeAssemblyDescriptor() {
        AssemblyDescriptor assemblyDescriptor = this.getEJBJar().getAssemblyDescriptor();
        if (assemblyDescriptor == null) {
            return;
        }
        new AssemblyDescriptorXmlWriter(assemblyDescriptor, this.getWriter(), this.getNestLevel() + 1).toXml(this);
    }

    public void writeData() {
        EJBJar eJBJar = this.getEJBJar();
        this.writeDescription(eJBJar.getDescription());
        this.writeOptionalAttribute("display-name", eJBJar.getDisplayName());
        this.writeOptionalAttribute("small-icon", eJBJar.getSmallIcon());
        this.writeOptionalAttribute("large-icon", eJBJar.getLargeIcon());
        this.writeEnterpriseBeans();
        this.writeRelationships();
        this.writeAssemblyDescriptor();
        this.writeOptionalAttribute("ejb-client-jar", eJBJar.getEjbClientJar());
    }

    public void writeEnterpriseBeans() {
        this.writeBeginTagAttributeNewLine("enterprise-beans");
        EList eList = this.getEJBJar().getEnterpriseBeans();
        int n = 0;
        while (n < eList.size()) {
            this.getWriterFor((EnterpriseBean)eList.get(n)).toXml(this);
            ++n;
        }
        this.writeEndTagAttribute("enterprise-beans");
    }

    public void writeHeader() {
        super.writeDocumentHeader();
    }

    public void writeRelationships() {
        Relationships relationships = this.getEJBJar().getRelationshipList();
        if (relationships == null || relationships.getEjbRelations().isEmpty()) {
            return;
        }
        new RelationshipsXmlWriter(relationships, this.getWriter(), this.getNestLevel() + 1).toXml(this);
    }
}

