/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.xml.rar.writers;

import com.ibm.etools.j2ee.exception.WrappedRuntimeException;
import com.ibm.etools.j2ee.xml.common.writers.MofXmlWriter;
import com.ibm.etools.j2ee.xml.nls.ResourceHandler;
import com.ibm.etools.j2ee.xml.rar.writers.IconXmlWriter;
import com.ibm.etools.j2ee.xml.rar.writers.LicenseXmlWriter;
import com.ibm.etools.j2ee.xml.rar.writers.RarDeploymentDescriptorXmlWriter;
import com.ibm.etools.j2ee.xml.rar.writers.ResourceAdapterXmlWriter;
import com.ibm.etools.jca.Connector;
import java.io.IOException;
import java.io.Writer;
import org.eclipse.emf.ecore.EObject;

public class ConnectorXmlWriter
extends RarDeploymentDescriptorXmlWriter {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";

    public ConnectorXmlWriter() {
    }

    public ConnectorXmlWriter(EObject eObject, Writer writer, int n) {
        super(eObject, writer, n);
    }

    public String getID() {
        return "Connector_ID";
    }

    public Connector getConnector() {
        return (Connector)this.getObject();
    }

    public String getTagName() {
        return "connector";
    }

    public void toXml(MofXmlWriter mofXmlWriter) {
        this.writeHeader();
        super.toXml(mofXmlWriter);
        try {
            this.getWriter().flush();
        }
        catch (IOException iOException) {
            throw new WrappedRuntimeException(ResourceHandler.getString("An_Exception_occurred_whil_EXC_"), iOException);
        }
    }

    public void writeData() {
        Connector connector = this.getConnector();
        this.writeRequiredAttribute("display-name", connector.getDisplayName());
        this.writeDescription(connector.getDescription());
        this.writeIcon();
        this.writeRequiredAttribute("vendor-name", connector.getVendorName());
        this.writeRequiredAttribute("spec-version", connector.getSpecVersion());
        this.writeRequiredAttribute("eis-type", connector.getEisType());
        this.writeRequiredAttribute("version", connector.getVersion());
        this.writeLicense();
        this.writeResourceAdapter();
    }

    public void writeHeader() {
        super.writeDocumentHeader();
    }

    public void writeIcon() {
        if (this.getConnector().getLargeIcon() != null || this.getConnector().getSmallIcon() != null) {
            new IconXmlWriter(this.getConnector(), this.getWriter(), this.getNestLevel() + 1).toXml(this);
        }
    }

    public void writeLicense() {
        new LicenseXmlWriter(this.getConnector(), this.getWriter(), this.getNestLevel() + 1).toXml(this);
    }

    public void writeResourceAdapter() {
        if (this.getConnector().getResourceAdapter() != null) {
            new ResourceAdapterXmlWriter(this.getConnector().getResourceAdapter(), this.getWriter(), this.getNestLevel() + 1).toXml(this);
        }
    }
}

