/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.xml.war.readers;

import com.ibm.etools.j2ee.common.RunAsSpecifiedIdentity;
import com.ibm.etools.j2ee.common.SecurityRoleRef;
import com.ibm.etools.j2ee.exception.WrappedRuntimeException;
import com.ibm.etools.j2ee.xml.common.readers.RunAsSpecifiedIdentityXmlReadAdapter;
import com.ibm.etools.j2ee.xml.common.readers.SecurityRoleRefXmlReadAdapter;
import com.ibm.etools.j2ee.xml.nls.ResourceHandler;
import com.ibm.etools.j2ee.xml.war.readers.InitParamXmlReadAdapter;
import com.ibm.etools.j2ee.xml.war.readers.WarDeploymentDescriptorReadAdapter;
import com.ibm.etools.webapplication.InitParam;
import com.ibm.etools.webapplication.JSPType;
import com.ibm.etools.webapplication.Servlet;
import com.ibm.etools.webapplication.ServletType;
import java.util.Enumeration;
import org.eclipse.emf.common.notify.Notifier;
import org.w3c.dom.Element;

public class ServletXmlReadAdapter
extends WarDeploymentDescriptorReadAdapter {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";

    public ServletXmlReadAdapter(Notifier notifier, Element element) {
        super(notifier, element);
    }

    public Servlet getServlet() {
        return (Servlet)this.getTarget();
    }

    public void reflectElement(Element element) {
        String string = element.getTagName();
        if (string.equals("icon")) {
            this.reflectIcon(element);
        } else if (string.equals("servlet-name")) {
            this.getServlet().setServletName(this.getText(element));
        } else if (string.equals("display-name")) {
            this.getServlet().setDisplayName(this.getText(element));
        } else if (string.equals("description")) {
            this.getServlet().setDescription(this.getText(element));
        } else if (string.equals("servlet-class")) {
            ServletType servletType = this.getWebAppFactory().createServletType();
            servletType.setClassName(this.getText(element));
            this.getServlet().setWebType(servletType);
        } else if (string.equals("jsp-file")) {
            JSPType jSPType = this.getWebAppFactory().createJSPType();
            jSPType.setJspFile(this.getText(element));
            this.getServlet().setWebType(jSPType);
        } else if (string.equals("init-param")) {
            this.reflectInitParam(element);
        } else if (string.equals("load-on-startup")) {
            this.reflectLoadOnStartup(element);
        } else if (string.equals("run-as")) {
            this.reflectRunAsSpecifiedIdentity(element);
        } else if (string.equals("security-role-ref")) {
            this.reflectSecurityRoleRef(element);
        } else {
            super.reflectElement(element);
        }
    }

    public void reflectIcon(Element element) {
        Enumeration enumeration = this.getChildElementsFrom(element);
        while (enumeration.hasMoreElements()) {
            this.reflectIconElement((Element)enumeration.nextElement());
        }
    }

    public void reflectIconElement(Element element) {
        String string = element.getTagName();
        if (string.equals("small-icon")) {
            this.getServlet().setSmallIcon(this.getText(element));
        } else if (string.equals("large-icon")) {
            this.getServlet().setLargeIcon(this.getText(element));
        }
    }

    public void reflectInitParam(Element element) {
        InitParam initParam = this.getWebAppFactory().createInitParam();
        this.getServlet().getParams().add((Object)initParam);
        new InitParamXmlReadAdapter((Notifier)initParam, element);
    }

    public void reflectLoadOnStartup(Element element) {
        String string = this.getText(element);
        if (string.length() == 0) {
            this.getServlet().setLoadOnStartup(null);
            return;
        }
        try {
            int n = Integer.parseInt(string);
            this.getServlet().setLoadOnStartup(new Integer(n));
        }
        catch (Exception exception) {
            throw new WrappedRuntimeException(ResourceHandler.getString("must_be_int_EXC_", new Object[]{"load-on-startup", string}));
        }
    }

    public void reflectRunAsSpecifiedIdentity(Element element) {
        RunAsSpecifiedIdentity runAsSpecifiedIdentity = this.getCommonFactory().createRunAsSpecifiedIdentity();
        this.getServlet().setRunAs(runAsSpecifiedIdentity);
        new RunAsSpecifiedIdentityXmlReadAdapter((Notifier)runAsSpecifiedIdentity, element);
    }

    public void reflectSecurityRoleRef(Element element) {
        SecurityRoleRef securityRoleRef = this.getCommonFactory().createSecurityRoleRef();
        this.getServlet().getSecurityRoleRefs().add((Object)securityRoleRef);
        new SecurityRoleRefXmlReadAdapter((Notifier)securityRoleRef, element);
    }
}

